/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.view.View;
import android.widget.ImageView;
import io.adaptivecards.renderer.FluentIconUtils;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.http.HttpRequestResult;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\u0001B-\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ)\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00042\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0017\"\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0004H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0004H\u0014J\u001a\u0010\u001d\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u000bH\u0016R\u000e\u0010\t\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lio/adaptivecards/renderer/FluentIconImageLoaderAsync;", "Landroid/os/AsyncTask;", "", "Ljava/lang/Void;", "Lio/adaptivecards/renderer/http/HttpRequestResult;", "renderedCard", "Lio/adaptivecards/renderer/RenderedAdaptiveCard;", "targetIconSize", "", "iconColor", "isFilledStyle", "", "view", "Landroid/view/View;", "(Lio/adaptivecards/renderer/RenderedAdaptiveCard;JLjava/lang/String;ZLandroid/view/View;)V", "getRenderedCard", "()Lio/adaptivecards/renderer/RenderedAdaptiveCard;", "viewReference", "Ljava/lang/ref/WeakReference;", "getViewReference", "()Ljava/lang/ref/WeakReference;", "doInBackground", "args", "", "([Ljava/lang/String;)Lio/adaptivecards/renderer/http/HttpRequestResult;", "fetchUnavailableIconInfo", "onPostExecute", "", "result", "renderFluentIcon", "drawable", "Landroid/graphics/drawable/Drawable;", "flipInRtl", "adaptivecards_release"})
public class FluentIconImageLoaderAsync
extends AsyncTask<String, Void, HttpRequestResult<String>> {
    @NotNull
    private final RenderedAdaptiveCard renderedCard;
    private final long targetIconSize;
    @NotNull
    private final String iconColor;
    private boolean isFilledStyle;
    @NotNull
    private final WeakReference<View> viewReference;

    public FluentIconImageLoaderAsync(@NotNull RenderedAdaptiveCard renderedCard, long targetIconSize, @NotNull String iconColor, boolean isFilledStyle, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)renderedCard, (String)"renderedCard");
        Intrinsics.checkNotNullParameter((Object)iconColor, (String)"iconColor");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.renderedCard = renderedCard;
        this.targetIconSize = targetIconSize;
        this.iconColor = iconColor;
        this.isFilledStyle = isFilledStyle;
        this.viewReference = new WeakReference<View>(view);
    }

    @NotNull
    public final RenderedAdaptiveCard getRenderedCard() {
        return this.renderedCard;
    }

    @NotNull
    public final WeakReference<View> getViewReference() {
        return this.viewReference;
    }

    @Nullable
    protected HttpRequestResult<String> doInBackground(String ... args) {
        HttpRequestResult<String> httpRequestResult;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (args.length == 0) {
            httpRequestResult = null;
        } else {
            HttpRequestResult<String> response = FluentIconUtils.INSTANCE.fetchIconInfo$adaptivecards_release(args[0]);
            if (response != null) {
                HttpRequestResult<String> it = response;
                boolean bl = false;
                return response;
            }
            httpRequestResult = this.fetchUnavailableIconInfo();
        }
        return httpRequestResult;
    }

    private final HttpRequestResult<String> fetchUnavailableIconInfo() {
        this.isFilledStyle = true;
        String unavailableIconURL = Util.getUnavailableIconSvgInfoUrl();
        Intrinsics.checkNotNullExpressionValue((Object)unavailableIconURL, (String)"unavailableIconURL");
        return FluentIconUtils.INSTANCE.fetchIconInfo$adaptivecards_release(unavailableIconURL);
    }

    protected void onPostExecute(@Nullable HttpRequestResult<String> result) {
        View view = (View)this.viewReference.get();
        Context context = view != null ? view.getContext() : null;
        FluentIconUtils.IconResponse response = FluentIconUtils.INSTANCE.processResponseAndGetIconDrawable$adaptivecards_release(result, context, this.iconColor, this.targetIconSize, this.isFilledStyle);
        this.renderFluentIcon(response.getDrawable(), response.getFlipInRtl());
    }

    public void renderFluentIcon(@Nullable Drawable drawable, boolean flipInRtl) {
        View view = (View)this.viewReference.get();
        if (view != null && view instanceof ImageView) {
            ((ImageView)view).setImageDrawable(drawable);
            if (FluentIconUtils.INSTANCE.shouldFlipIcon(this.renderedCard.getAdaptiveCard().GetRtl(), flipInRtl)) {
                ((ImageView)view).setScaleX(-1.0f);
            }
        }
    }
}

