/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import io.adaptivecards.renderer.GenericImageLoaderAsync;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.http.HttpRequestResult;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\u0018\u00002\u00020\u0001BN\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012#\u0010\n\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u000b\u00a2\u0006\u0002\u0010\u0011J)\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0017\"\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u0015H\u0016R+\u0010\n\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/adaptivecards/renderer/GetImageAsync;", "Lio/adaptivecards/renderer/GenericImageLoaderAsync;", "imageBaseUrl", "", "context", "Landroid/content/Context;", "maxWidth", "", "iconSize", "", "callback", "Lkotlin/Function1;", "Landroid/graphics/drawable/Drawable;", "Lkotlin/ParameterName;", "name", "drawable", "", "(Ljava/lang/String;Landroid/content/Context;IJLkotlin/jvm/functions/Function1;)V", "Ljava/lang/ref/WeakReference;", "doInBackground", "Lio/adaptivecards/renderer/http/HttpRequestResult;", "Landroid/graphics/Bitmap;", "args", "", "([Ljava/lang/String;)Lio/adaptivecards/renderer/http/HttpRequestResult;", "onSuccessfulPostExecute", "bitmap", "styleBitmap", "adaptivecards_release"})
public final class GetImageAsync
extends GenericImageLoaderAsync {
    @NotNull
    private final WeakReference<Context> context;
    private final long iconSize;
    @NotNull
    private final Function1<Drawable, Unit> callback;

    public GetImageAsync(@Nullable String imageBaseUrl, @NotNull Context context, int maxWidth, long iconSize, @NotNull Function1<? super Drawable, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        super(null, imageBaseUrl, maxWidth);
        this.context = new WeakReference<Context>(context);
        this.iconSize = iconSize;
        this.callback = callback;
    }

    public /* synthetic */ GetImageAsync(String string2, Context context, int n, long l, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = -1;
        }
        this(string2, context, n, l, (Function1<? super Drawable, Unit>)function1);
    }

    @Nullable
    protected HttpRequestResult<Bitmap> doInBackground(String ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Context context = (Context)this.context.get();
        if (args.length == 0 || context == null) {
            return null;
        }
        return this.loadImage(args[0], context);
    }

    @Override
    public void onSuccessfulPostExecute(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Drawable drawableIcon = (Drawable)new BitmapDrawable(null, bitmap);
        this.callback.invoke((Object)drawableIcon);
    }

    @Override
    @Nullable
    public Bitmap styleBitmap(@Nullable Bitmap bitmap) {
        Context context = (Context)this.context.get();
        if (context != null) {
            float imageSizeInPixel = Util.dpToPixels(context, this.iconSize);
            return Util.scaleBitmapToSize(imageSizeInPixel, bitmap);
        }
        return bitmap;
    }
}

