/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.inputhandler;

import android.view.View;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.objectmodel.ChoiceInput;
import io.adaptivecards.objectmodel.ChoiceInputVector;
import io.adaptivecards.objectmodel.ChoiceSetInput;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.inputhandler.BaseInputHandler;

public class RadioGroupInputHandler
extends BaseInputHandler {
    public RadioGroupInputHandler(BaseInputElement baseInputElement, RenderedAdaptiveCard renderedAdaptiveCard, long cardId) {
        super(baseInputElement, renderedAdaptiveCard, cardId);
    }

    protected RadioGroup getRadioGroup() {
        return (RadioGroup)this.m_view;
    }

    @Override
    public String getInput() {
        ChoiceSetInput choiceSetInput = (ChoiceSetInput)this.m_baseInputElement;
        int index = this.getRadioGroup().getCheckedRadioButtonId();
        if (index >= 0) {
            return choiceSetInput.GetChoices().get(index).GetValue();
        }
        return "";
    }

    @Override
    public void setInput(String choice) {
        ChoiceSetInput choiceSetInput = (ChoiceSetInput)this.m_baseInputElement;
        RadioGroup radioGroup = this.getRadioGroup();
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        if (!choice.isEmpty()) {
            for (int i = 0; i < choiceInputVector.size(); ++i) {
                ChoiceInput choiceInput = choiceInputVector.get(i);
                if (!choice.equals(choiceInput.GetValue())) continue;
                radioGroup.check(i);
                break;
            }
        } else {
            radioGroup.check(-1);
        }
    }

    @Override
    public void registerInputObserver() {
        this.getRadioGroup().setOnCheckedChangeListener((group, checkedId) -> this.notifyAllInputWatchers());
        this.addValueChangedActionInputWatcher();
    }

    @Override
    public String getDefaultValue() {
        if (Util.isOfType(this.m_baseInputElement, ChoiceSetInput.class)) {
            return Util.castTo(this.m_baseInputElement, ChoiceSetInput.class).GetValue();
        }
        return super.getDefaultValue();
    }

    @Override
    public void setFocusToView() {
        RadioGroup radioGroup = (RadioGroup)this.m_view;
        if (radioGroup.getChildCount() > 0) {
            RadioButton radioButton = (RadioButton)radioGroup.getChildAt(0);
            Util.forceFocus((View)radioButton);
            radioButton.sendAccessibilityEvent(32768);
        }
    }
}

