/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import androidx.fragment.app.FragmentManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;
import com.google.android.flexbox.FlexboxLayout;
import io.adaptivecards.R;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.Carousel;
import io.adaptivecards.objectmodel.CarouselPageVector;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.PageAnimation;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.layout.carousel.CarouselPageAdapter;
import io.adaptivecards.renderer.layout.carousel.CrossFadePageTransformer;
import io.adaptivecards.renderer.layout.carousel.NoAnimationPageTransformer;
import io.adaptivecards.renderer.layout.scrollingpage.ScrollingPageControlView;
import io.adaptivecards.renderer.layout.scrollingpage.ScrollingPageControlViewConfiguration;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J*\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002JB\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002JL\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\f\u0010$\u001a\u00020%*\u00020 H\u0002J\u0018\u0010&\u001a\u00020%*\u00020 2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(H\u0002\u00a8\u0006)"}, d2={"Lio/adaptivecards/renderer/readonly/CarouselRenderer;", "Lio/adaptivecards/renderer/BaseCardElementRenderer;", "()V", "createCarouselView", "Landroid/view/ViewGroup;", "context", "Landroid/content/Context;", "carousel", "Lio/adaptivecards/objectmodel/Carousel;", "createContainerLayout", "Lcom/google/android/flexbox/FlexboxLayout;", "createScrollingPageControlView", "pages", "Lio/adaptivecards/objectmodel/CarouselPageVector;", "hostConfig", "Lio/adaptivecards/objectmodel/HostConfig;", "viewPager2", "Landroidx/viewpager2/widget/ViewPager2;", "createViewPager", "renderedCard", "Lio/adaptivecards/renderer/RenderedAdaptiveCard;", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "cardActionHandler", "Lio/adaptivecards/renderer/actionhandler/ICardActionHandler;", "renderArgs", "Lio/adaptivecards/renderer/RenderArgs;", "getViewPagerPageTransformer", "Landroidx/viewpager2/widget/ViewPager2$PageTransformer;", "pageAnimation", "Lio/adaptivecards/objectmodel/PageAnimation;", "render", "Landroid/view/View;", "viewGroup", "baseCardElement", "Lio/adaptivecards/objectmodel/BaseCardElement;", "markFocusable", "", "markImportantForAccessibility", "contentDescription", "", "adaptivecards_release"})
public final class CarouselRenderer
extends BaseCardElementRenderer {
    @NotNull
    public static final CarouselRenderer INSTANCE = new CarouselRenderer();

    private CarouselRenderer() {
    }

    @Override
    @Nullable
    public View render(@NotNull RenderedAdaptiveCard renderedCard, @NotNull Context context, @NotNull FragmentManager fragmentManager, @NotNull ViewGroup viewGroup, @NotNull BaseCardElement baseCardElement, @Nullable ICardActionHandler cardActionHandler, @NotNull HostConfig hostConfig, @NotNull RenderArgs renderArgs) {
        Intrinsics.checkNotNullParameter((Object)renderedCard, (String)"renderedCard");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
        Intrinsics.checkNotNullParameter((Object)baseCardElement, (String)"baseCardElement");
        Intrinsics.checkNotNullParameter((Object)hostConfig, (String)"hostConfig");
        Intrinsics.checkNotNullParameter((Object)renderArgs, (String)"renderArgs");
        Carousel carousel = Util.castTo(baseCardElement, Carousel.class);
        CarouselPageVector pages = carousel.GetPages();
        if (pages.isEmpty()) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)carousel, (String)"carousel");
        ViewGroup carouselView = this.createCarouselView(context, carousel);
        ViewPager2 viewPager = this.createViewPager(context, carousel, renderedCard, fragmentManager, cardActionHandler, hostConfig, renderArgs);
        Intrinsics.checkNotNullExpressionValue((Object)pages, (String)"pages");
        ViewGroup scrollingIndicator = this.createScrollingPageControlView(context, pages, hostConfig, viewPager);
        carouselView.addView((View)viewPager);
        this.markFocusable((View)carouselView);
        CarouselRenderer.markImportantForAccessibility$default(this, (View)carouselView, null, 1, null);
        ViewGroup viewGroup2 = scrollingIndicator;
        if (viewGroup2 != null) {
            ViewGroup it = viewGroup2;
            boolean bl = false;
            carouselView.addView((View)it);
        }
        viewGroup.addView((View)carouselView);
        return (View)carouselView;
    }

    private final ViewGroup createCarouselView(Context context, Carousel carousel) {
        FlexboxLayout carouselView = this.createContainerLayout(context);
        carouselView.setTag((Object)new TagContent(carousel));
        return (ViewGroup)carouselView;
    }

    private final ViewPager2 createViewPager(Context context, Carousel carousel, RenderedAdaptiveCard renderedCard, FragmentManager fragmentManager, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) {
        ViewPager2 viewPager = new ViewPager2(context);
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -2);
        viewPager.setLayoutParams(layoutParams);
        viewPager.setOffscreenPageLimit(carousel.GetPages().size());
        CarouselPageVector carouselPageVector = carousel.GetPages();
        Intrinsics.checkNotNullExpressionValue((Object)carouselPageVector, (String)"carousel.GetPages()");
        viewPager.setAdapter((RecyclerView.Adapter)new CarouselPageAdapter(carouselPageVector, renderedCard, cardActionHandler, hostConfig, renderArgs, fragmentManager));
        PageAnimation pageAnimation = carousel.getPageAnimation();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)pageAnimation), (String)"carousel.pageAnimation");
        ViewPager2.PageTransformer pageTransformer = this.getViewPagerPageTransformer(pageAnimation);
        if (pageTransformer != null) {
            ViewPager2.PageTransformer pageTransformer2;
            ViewPager2.PageTransformer $this$createViewPager_u24lambda_u2d1 = pageTransformer2 = pageTransformer;
            boolean bl = false;
            viewPager.setPageTransformer($this$createViewPager_u24lambda_u2d1);
        }
        this.markFocusable((View)viewPager);
        this.markImportantForAccessibility((View)viewPager, context.getString(R.string.carousel_talkback_announcement));
        return viewPager;
    }

    private final ViewGroup createScrollingPageControlView(Context context, CarouselPageVector pages, HostConfig hostConfig, ViewPager2 viewPager2) {
        ScrollingPageControlView scrollingPageControlView;
        if (pages.size() <= 1) {
            return null;
        }
        int dotColor = Color.parseColor((String)hostConfig.GetPageControlConfig().getUnselectedTintColor());
        int dotSelectedColor = Color.parseColor((String)hostConfig.GetPageControlConfig().getSelectedTintColor());
        ScrollingPageControlViewConfiguration configuration = new ScrollingPageControlViewConfiguration(null, null, null, dotColor, dotSelectedColor, null, null, null, false, null, 999, null);
        ScrollingPageControlView $this$createScrollingPageControlView_u24lambda_u2d2 = scrollingPageControlView = new ScrollingPageControlView(context, null, 0, configuration, 6, null);
        boolean bl = false;
        $this$createScrollingPageControlView_u24lambda_u2d2.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        $this$createScrollingPageControlView_u24lambda_u2d2.attachToPager(viewPager2);
        ScrollingPageControlView scrollingPageControlView2 = scrollingPageControlView;
        ScrollingPageControlView $this$createScrollingPageControlView_u24lambda_u2d3 = scrollingPageControlView = this.createContainerLayout(context);
        boolean bl2 = false;
        int padding = context.getResources().getDimensionPixelSize(R.dimen.scrollingpagecontrolview_padding_top_bottom);
        $this$createScrollingPageControlView_u24lambda_u2d3.setPadding(0, padding, 0, padding);
        $this$createScrollingPageControlView_u24lambda_u2d3.addView(scrollingPageControlView2);
        INSTANCE.markImportantForAccessibility($this$createScrollingPageControlView_u24lambda_u2d3, context.getString(R.string.carousel_talkback_announcement));
        return (ViewGroup)scrollingPageControlView;
    }

    private final FlexboxLayout createContainerLayout(Context context) {
        FlexboxLayout flexboxLayout;
        FlexboxLayout $this$createContainerLayout_u24lambda_u2d4 = flexboxLayout = new FlexboxLayout(context);
        boolean bl = false;
        $this$createContainerLayout_u24lambda_u2d4.setLayoutParams((ViewGroup.LayoutParams)new FlexboxLayout.LayoutParams(-1, -2));
        $this$createContainerLayout_u24lambda_u2d4.setFlexDirection(2);
        $this$createContainerLayout_u24lambda_u2d4.setAlignItems(2);
        return flexboxLayout;
    }

    private final ViewPager2.PageTransformer getViewPagerPageTransformer(PageAnimation pageAnimation) {
        ViewPager2.PageTransformer pageTransformer;
        switch (WhenMappings.$EnumSwitchMapping$0[pageAnimation.ordinal()]) {
            case 1: {
                pageTransformer = new NoAnimationPageTransformer();
                break;
            }
            case 2: {
                pageTransformer = new CrossFadePageTransformer();
                break;
            }
            case 3: {
                pageTransformer = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return pageTransformer;
    }

    private final void markFocusable(View $this$markFocusable) {
        $this$markFocusable.setFocusable(true);
        $this$markFocusable.setFocusableInTouchMode(true);
    }

    private final void markImportantForAccessibility(View $this$markImportantForAccessibility, String contentDescription) {
        block0: {
            $this$markImportantForAccessibility.setImportantForAccessibility(1);
            String string2 = contentDescription;
            if (string2 == null) break block0;
            String it = string2;
            boolean bl = false;
            $this$markImportantForAccessibility.setContentDescription((CharSequence)it);
        }
    }

    static /* synthetic */ void markImportantForAccessibility$default(CarouselRenderer carouselRenderer, View view, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        carouselRenderer.markImportantForAccessibility(view, string2);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PageAnimation.values().length];
            nArray[PageAnimation.None.ordinal()] = 1;
            nArray[PageAnimation.CrossFade.ordinal()] = 2;
            nArray[PageAnimation.Slide.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

