/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.objectmodel;

import io.adaptivecards.objectmodel.AdaptiveCardObjectModelJNI;
import io.adaptivecards.objectmodel.Layout;
import java.util.AbstractList;
import java.util.RandomAccess;

public class LayoutVector
extends AbstractList<Layout>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected LayoutVector(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(LayoutVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                AdaptiveCardObjectModelJNI.delete_LayoutVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public LayoutVector(Layout[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (Layout element : initialElements) {
            this.add(element);
        }
    }

    public LayoutVector(Iterable<Layout> initialElements) {
        this();
        for (Layout element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public Layout get(int index) {
        return this.doGet(index);
    }

    @Override
    public Layout set(int index, Layout e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(Layout e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, Layout e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public Layout remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public LayoutVector() {
        this(AdaptiveCardObjectModelJNI.new_LayoutVector__SWIG_0(), true);
    }

    public LayoutVector(LayoutVector other) {
        this(AdaptiveCardObjectModelJNI.new_LayoutVector__SWIG_1(LayoutVector.getCPtr(other), other), true);
    }

    public long capacity() {
        return AdaptiveCardObjectModelJNI.LayoutVector_capacity(this.swigCPtr, this);
    }

    public void reserve(long n) {
        AdaptiveCardObjectModelJNI.LayoutVector_reserve(this.swigCPtr, this, n);
    }

    @Override
    public boolean isEmpty() {
        return AdaptiveCardObjectModelJNI.LayoutVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        AdaptiveCardObjectModelJNI.LayoutVector_clear(this.swigCPtr, this);
    }

    public LayoutVector(int count, Layout value) {
        this(AdaptiveCardObjectModelJNI.new_LayoutVector__SWIG_2(count, Layout.getCPtr(value), value), true);
    }

    private int doSize() {
        return AdaptiveCardObjectModelJNI.LayoutVector_doSize(this.swigCPtr, this);
    }

    private void doAdd(Layout x) {
        AdaptiveCardObjectModelJNI.LayoutVector_doAdd__SWIG_0(this.swigCPtr, this, Layout.getCPtr(x), x);
    }

    private void doAdd(int index, Layout x) {
        AdaptiveCardObjectModelJNI.LayoutVector_doAdd__SWIG_1(this.swigCPtr, this, index, Layout.getCPtr(x), x);
    }

    private Layout doRemove(int index) {
        long cPtr = AdaptiveCardObjectModelJNI.LayoutVector_doRemove(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new Layout(cPtr, true);
    }

    private Layout doGet(int index) {
        long cPtr = AdaptiveCardObjectModelJNI.LayoutVector_doGet(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new Layout(cPtr, true);
    }

    private Layout doSet(int index, Layout val) {
        long cPtr = AdaptiveCardObjectModelJNI.LayoutVector_doSet(this.swigCPtr, this, index, Layout.getCPtr(val), val);
        return cPtr == 0L ? null : new Layout(cPtr, true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        AdaptiveCardObjectModelJNI.LayoutVector_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

