/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Picture;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.WorkerThread;
import com.caverock.androidsvg.SVG;
import io.adaptivecards.renderer.FluentIconUtils;
import io.adaptivecards.renderer.IconUtils;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.http.HttpRequestHelper;
import io.adaptivecards.renderer.http.HttpRequestResult;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001-B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J]\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2#\u0010\u001c\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\f\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00170\u001dH\u0007J \u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J \u0010#\u001a\u00020$2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J?\u0010%\u001a\u00020&2\u000e\u0010'\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b(J\u001d\u0010)\u001a\u00020\u001a2\b\u0010*\u001a\u0004\u0018\u00010\u001a2\u0006\u0010+\u001a\u00020\u001a\u00a2\u0006\u0002\u0010,R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lio/adaptivecards/renderer/FluentIconUtils;", "", "()V", "FILLED_STYLE", "", "FLIP_IN_RTL_PROPERTY", "REGULAR_STYLE", "fetchIconInfo", "Lio/adaptivecards/renderer/http/HttpRequestResult;", "svgURL", "fetchIconInfo$adaptivecards_release", "flipDrawableHorizontally", "Landroid/graphics/drawable/Drawable;", "drawable", "context", "Landroid/content/Context;", "getDrawableFromSVG", "Landroid/graphics/drawable/BitmapDrawable;", "svgString", "iconColor", "iconSize", "", "getFluentIcon", "", "targetIconSize", "isFilledStyle", "", "isRTL", "callback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "getSvgString", "svgPath", "size", "parseSvgString", "Lcom/caverock/androidsvg/SVG;", "processResponseAndGetIconDrawable", "Lio/adaptivecards/renderer/FluentIconUtils$IconResponse;", "result", "processResponseAndGetIconDrawable$adaptivecards_release", "shouldFlipIcon", "isRtl", "flipInRtl", "(Ljava/lang/Boolean;Z)Z", "IconResponse", "adaptivecards_release"})
public final class FluentIconUtils {
    @NotNull
    public static final FluentIconUtils INSTANCE = new FluentIconUtils();
    @NotNull
    private static final String FILLED_STYLE = "filled";
    @NotNull
    private static final String REGULAR_STYLE = "regular";
    @NotNull
    private static final String FLIP_IN_RTL_PROPERTY = "flipInRtl";

    private FluentIconUtils() {
    }

    @WorkerThread
    public final void getFluentIcon(@NotNull Context context, @NotNull String svgURL, @NotNull String iconColor, long targetIconSize, boolean isFilledStyle, boolean isRTL, @NotNull Function1<? super Drawable, Unit> callback) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)svgURL, (String)"svgURL");
            Intrinsics.checkNotNullParameter((Object)iconColor, (String)"iconColor");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            HttpRequestResult<String> requestResult = this.fetchIconInfo$adaptivecards_release(svgURL);
            IconResponse iconResponse = this.processResponseAndGetIconDrawable$adaptivecards_release(requestResult, context, iconColor, targetIconSize, isFilledStyle);
            Drawable drawable = iconResponse.getDrawable();
            if (drawable == null) break block0;
            Drawable it = drawable;
            boolean bl = false;
            callback.invoke((Object)(INSTANCE.shouldFlipIcon(isRTL, iconResponse.getFlipInRtl()) ? FluentIconUtils.flipDrawableHorizontally(it, context) : it));
        }
    }

    @Nullable
    public final HttpRequestResult<String> fetchIconInfo$adaptivecards_release(@NotNull String svgURL) {
        HttpRequestResult<String> httpRequestResult;
        Intrinsics.checkNotNullParameter((Object)svgURL, (String)"svgURL");
        try {
            byte[] byArray = HttpRequestHelper.get(svgURL);
            if (byArray == null) {
                throw new Exception("Failed to fetch icon info");
            }
            byte[] responseBytes = byArray;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            httpRequestResult = new HttpRequestResult<String>(new String(responseBytes, charset2));
        }
        catch (Exception e) {
            httpRequestResult = null;
        }
        return httpRequestResult;
    }

    @NotNull
    public final IconResponse processResponseAndGetIconDrawable$adaptivecards_release(@Nullable HttpRequestResult<String> result, @Nullable Context context, @NotNull String iconColor, long targetIconSize, boolean isFilledStyle) {
        Intrinsics.checkNotNullParameter((Object)iconColor, (String)"iconColor");
        if (context != null) {
            HttpRequestResult<String> httpRequestResult = result;
            boolean bl = httpRequestResult != null ? httpRequestResult.isSuccessful() : false;
            if (bl) {
                String string2 = result.getResult();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"result.result");
                if (((CharSequence)string2).length() > 0) {
                    String response = result.getResult();
                    try {
                        JSONObject responseJsonObject = new JSONObject(response);
                        String style = isFilledStyle ? FILLED_STYLE : REGULAR_STYLE;
                        boolean flipInRtl = responseJsonObject.optBoolean(FLIP_IN_RTL_PROPERTY, false);
                        JSONObject styleJsonObject = responseJsonObject.getJSONObject(style);
                        Iterator iterator = styleJsonObject.keys();
                        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"styleJsonObject.keys()");
                        List availableFluentIconSizes2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)processResponseAndGetIconDrawable.availableFluentIconSizes.1.INSTANCE));
                        long availableIconSizeClosestToGivenSize = Util.getSizeClosestToGivenSize(availableFluentIconSizes2, targetIconSize);
                        Object object = styleJsonObject.getJSONArray(String.valueOf(availableIconSizeClosestToGivenSize)).get(0);
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        String svgPath = (String)object;
                        String svgPathString = this.getSvgString(svgPath, availableIconSizeClosestToGivenSize, targetIconSize);
                        BitmapDrawable drawable = this.getDrawableFromSVG(context, svgPathString, iconColor, targetIconSize);
                        return new IconResponse((Drawable)drawable, flipInRtl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return new IconResponse(null, false);
    }

    private final String getSvgString(String svgPath, long size, long targetIconSize) {
        return "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"" + targetIconSize + "\" height=\"" + targetIconSize + "\" viewBox=\"0 0 " + size + ' ' + size + "\"> <path d=\"" + svgPath + "\"/></svg>";
    }

    private final BitmapDrawable getDrawableFromSVG(Context context, String svgString, String iconColor, long iconSize) {
        BitmapDrawable bitmapDrawable;
        SVG svg = this.parseSvgString(context, svgString, iconSize);
        Picture picture = svg.renderToPicture();
        Bitmap bitmap = Bitmap.createBitmap((int)picture.getWidth(), (int)picture.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        picture.draw(canvas);
        BitmapDrawable $this$getDrawableFromSVG_u24lambda_u2d1 = bitmapDrawable = new BitmapDrawable(context.getResources(), bitmap);
        boolean bl = false;
        IconUtils.applyIconColor$default((Drawable)$this$getDrawableFromSVG_u24lambda_u2d1, iconColor, 0, 2, null);
        BitmapDrawable drawable = bitmapDrawable;
        return drawable;
    }

    private final SVG parseSvgString(Context context, String svgString, long iconSize) {
        SVG svg = SVG.getFromString((String)svgString);
        svg.setDocumentWidth((float)Util.dpToPixels(context, iconSize));
        svg.setDocumentHeight((float)Util.dpToPixels(context, iconSize));
        Intrinsics.checkNotNullExpressionValue((Object)svg, (String)"svg");
        return svg;
    }

    @JvmStatic
    @NotNull
    public static final Drawable flipDrawableHorizontally(@NotNull Drawable drawable, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        Matrix matrix = new Matrix();
        matrix.preScale(-1.0f, 1.0f);
        Bitmap flippedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return (Drawable)new BitmapDrawable(context.getResources(), flippedBitmap);
    }

    public final boolean shouldFlipIcon(@Nullable Boolean isRtl, boolean flipInRtl) {
        Boolean bl = isRtl;
        return (bl != null ? bl : false) && flipInRtl;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/adaptivecards/renderer/FluentIconUtils$IconResponse;", "", "drawable", "Landroid/graphics/drawable/Drawable;", "flipInRtl", "", "(Landroid/graphics/drawable/Drawable;Z)V", "getDrawable", "()Landroid/graphics/drawable/Drawable;", "getFlipInRtl", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "adaptivecards_release"})
    public static final class IconResponse {
        @Nullable
        private final Drawable drawable;
        private final boolean flipInRtl;

        public IconResponse(@Nullable Drawable drawable, boolean flipInRtl) {
            this.drawable = drawable;
            this.flipInRtl = flipInRtl;
        }

        @Nullable
        public final Drawable getDrawable() {
            return this.drawable;
        }

        public final boolean getFlipInRtl() {
            return this.flipInRtl;
        }

        @Nullable
        public final Drawable component1() {
            return this.drawable;
        }

        public final boolean component2() {
            return this.flipInRtl;
        }

        @NotNull
        public final IconResponse copy(@Nullable Drawable drawable, boolean flipInRtl) {
            return new IconResponse(drawable, flipInRtl);
        }

        public static /* synthetic */ IconResponse copy$default(IconResponse iconResponse, Drawable drawable, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                drawable = iconResponse.drawable;
            }
            if ((n & 2) != 0) {
                bl = iconResponse.flipInRtl;
            }
            return iconResponse.copy(drawable, bl);
        }

        @NotNull
        public String toString() {
            return "IconResponse(drawable=" + this.drawable + ", flipInRtl=" + this.flipInRtl + ')';
        }

        public int hashCode() {
            int result = this.drawable == null ? 0 : this.drawable.hashCode();
            int n = this.flipInRtl ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IconResponse)) {
                return false;
            }
            IconResponse iconResponse = (IconResponse)other;
            if (!Intrinsics.areEqual((Object)this.drawable, (Object)iconResponse.drawable)) {
                return false;
            }
            return this.flipInRtl == iconResponse.flipInRtl;
        }
    }
}

