/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.input;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.TooltipCompat;
import androidx.fragment.app.FragmentManager;
import io.adaptivecards.R;
import io.adaptivecards.objectmodel.ActionMode;
import io.adaptivecards.objectmodel.ActionType;
import io.adaptivecards.objectmodel.BaseActionElement;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.ExecuteAction;
import io.adaptivecards.objectmodel.ForegroundColor;
import io.adaptivecards.objectmodel.HeightType;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.SubmitAction;
import io.adaptivecards.objectmodel.TextInput;
import io.adaptivecards.objectmodel.TextInputStyle;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.BaseActionElementRenderer;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.InnerImageLoaderAsync;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.input.customcontrols.ValidatedEditText;
import io.adaptivecards.renderer.inputhandler.IInputHandler;
import io.adaptivecards.renderer.inputhandler.InputUtils;
import io.adaptivecards.renderer.inputhandler.TextInputHandler;
import io.adaptivecards.renderer.readonly.ContainerRenderer;

public class TextInputRenderer
extends BaseCardElementRenderer {
    private static TextInputRenderer s_instance = null;

    protected TextInputRenderer() {
    }

    public static TextInputRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new TextInputRenderer();
        }
        return s_instance;
    }

    protected void setTextInputStyle(EditText editText, TextInputStyle textInputStyle) {
        if (textInputStyle != TextInputStyle.Text) {
            if (textInputStyle == TextInputStyle.Tel) {
                editText.setInputType(3);
            } else if (textInputStyle == TextInputStyle.Url) {
                editText.setInputType(16);
            } else if (textInputStyle == TextInputStyle.Email) {
                editText.setInputType(32);
            } else if (textInputStyle == TextInputStyle.Password) {
                editText.setInputType(128);
                editText.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
            } else {
                throw new IllegalArgumentException("Unknown TextInputStyle: " + textInputStyle.toString());
            }
        }
    }

    protected EditText renderInternal(RenderedAdaptiveCard renderedCard, Context context, ViewGroup viewGroup, BaseInputElement baseInputElement, String value, String placeHolder, TextInputHandler textInputHandler, HostConfig hostConfig, TagContent tagContent, RenderArgs renderArgs, boolean hasSpecificValidation) {
        BaseActionElement action;
        EditText editText = null;
        TextInput textInput = Util.tryCastTo(baseInputElement, TextInput.class);
        if (baseInputElement.GetIsRequired() || hasSpecificValidation) {
            editText = new ValidatedEditText(context, TextInputRenderer.getColor(hostConfig.GetForegroundColor(ContainerStyle.Default, ForegroundColor.Attention, false)));
        } else {
            editText = new EditText(context);
            int editTextHeight = textInput != null && baseInputElement.GetHeight() == HeightType.Stretch && textInput.GetIsMultiline() ? -1 : -2;
            editText.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, editTextHeight));
        }
        editText.setFocusable(true);
        textInputHandler.setView((View)editText);
        renderedCard.registerInputHandler((IInputHandler)textInputHandler, renderArgs.getContainerCardId());
        if (!TextUtils.isEmpty((CharSequence)value)) {
            editText.setText((CharSequence)value);
        }
        if (!TextUtils.isEmpty((CharSequence)placeHolder)) {
            editText.setHint((CharSequence)placeHolder);
        }
        InputUtils.updateInputHandlerInputWatcher(textInputHandler);
        LinearLayout textInputViewGroup = null;
        if (textInput != null && (action = textInput.GetInlineAction()) != null) {
            if (hostConfig.GetActions().getShowCard().getActionMode() == ActionMode.Inline && action.GetElementType() == ActionType.ShowCard) {
                renderedCard.addWarning(new AdaptiveWarning(3, "Inline ShowCard not supported for InlineAction"));
            } else {
                textInputViewGroup = new LinearLayout(context);
                textInputViewGroup.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
                editText.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 1.0f));
                textInputViewGroup.addView((View)editText);
                Resources.Theme theme = context.getTheme();
                TypedValue buttonStyle = new TypedValue();
                String url = action.GetIconUrl(renderedCard.getTheme());
                if (url != null && !url.isEmpty()) {
                    ImageButton inlineButton = null;
                    if (theme.resolveAttribute(R.attr.adaptiveInlineActionImage, buttonStyle, true)) {
                        ContextThemeWrapper themedContext = new ContextThemeWrapper(context, R.style.adaptiveInlineActionImage);
                        inlineButton = new ImageButton((Context)themedContext, null, 0);
                    } else {
                        inlineButton = new ImageButton(context);
                        inlineButton.setBackgroundColor(0);
                        inlineButton.setPadding(16, 0, 0, 8);
                    }
                    inlineButton.setEnabled(action.GetIsEnabled());
                    ContainerRenderer.applyTitleAndTooltip(action, (View)inlineButton);
                    InlineActionIconImageLoaderAsync imageLoader = new InlineActionIconImageLoaderAsync(renderedCard, (View)inlineButton, url, editText);
                    imageLoader.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[]{url});
                    if (Util.isOfType(action, ExecuteAction.class) || Util.isOfType(action, SubmitAction.class) || action.GetElementType() == ActionType.Custom) {
                        renderedCard.setCardForSubmitAction(Util.getViewId((View)inlineButton), renderArgs.getContainerCardId());
                    }
                    if (action.GetElementType() == ActionType.OpenUrl) {
                        inlineButton.setContentDescription((CharSequence)Util.getOpenUrlAnnouncement(context, action.GetTitle()));
                    }
                    textInputViewGroup.addView((View)inlineButton, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2, 0.0f));
                } else {
                    String title = action.GetTitle();
                    Button inlineButton = null;
                    if (theme.resolveAttribute(R.attr.adaptiveInlineAction, buttonStyle, true)) {
                        ContextThemeWrapper themedContext = new ContextThemeWrapper(context, R.style.adaptiveInlineAction);
                        inlineButton = new Button((Context)themedContext, null, 0);
                    } else {
                        inlineButton = new Button(context);
                        inlineButton.setBackgroundColor(0);
                        inlineButton.setTextColor(-16777216);
                        inlineButton.setPadding(16, 0, 0, 8);
                    }
                    inlineButton.setText((CharSequence)title);
                    inlineButton.setEnabled(action.GetIsEnabled());
                    if (!TextUtils.isEmpty((CharSequence)action.GetTooltip())) {
                        TooltipCompat.setTooltipText((View)inlineButton, (CharSequence)action.GetTooltip());
                    }
                    if (Util.isOfType(action, ExecuteAction.class) || Util.isOfType(action, SubmitAction.class) || action.GetElementType() == ActionType.Custom) {
                        renderedCard.setCardForSubmitAction(Util.getViewId((View)inlineButton), renderArgs.getContainerCardId());
                    }
                    if (action.GetElementType() == ActionType.OpenUrl) {
                        inlineButton.setContentDescription((CharSequence)Util.getOpenUrlAnnouncement(context, action.GetTitle()));
                    }
                    textInputViewGroup.addView((View)inlineButton, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2, 0.0f));
                }
                textInputViewGroup.setGravity(17);
            }
        }
        EditText returnableView = editText;
        if (textInputViewGroup != null) {
            returnableView = textInputViewGroup;
        }
        viewGroup.addView((View)returnableView);
        return editText;
    }

    @Override
    @Nullable
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) throws Exception {
        View subView;
        if (!hostConfig.GetSupportsInteractivity()) {
            renderedCard.addWarning(new AdaptiveWarning(3, "Input.Text is not allowed"));
            return null;
        }
        TextInput textInput = Util.castTo(baseCardElement, TextInput.class);
        TextInputHandler textInputHandler = new TextInputHandler((BaseInputElement)textInput, renderedCard, (Long)renderArgs.getContainerCardId());
        TagContent tagContent = new TagContent((BaseCardElement)textInput, textInputHandler);
        EditText editText = this.renderInternal(renderedCard, context, viewGroup, textInput, textInput.GetValue(), textInput.GetPlaceholder(), textInputHandler, hostConfig, tagContent, renderArgs, !textInput.GetRegex().isEmpty());
        editText.setSingleLine(!textInput.GetIsMultiline());
        editText.setTag((Object)tagContent);
        TextInputRenderer.setVisibility(baseCardElement.GetIsVisible(), (View)editText);
        BaseActionElement action = textInput.GetInlineAction();
        if (textInput.GetIsMultiline() && textInput.GetTextInputStyle() != TextInputStyle.Password) {
            if (textInput.GetHeight() == HeightType.Stretch) {
                editText.setMinLines(3);
            } else {
                editText.setLines(3);
            }
            editText.setOnTouchListener((View.OnTouchListener)new EditTextTouchListener(editText));
        } else if (action != null) {
            editText.setOnKeyListener((View.OnKeyListener)new EditTextKeyListener(textInput, cardActionHandler, renderedCard, action));
        }
        this.setTextInputStyle(editText, textInput.GetTextInputStyle());
        int maxLength = (int)Math.min(textInput.GetMaxLength(), Integer.MAX_VALUE);
        if (maxLength > 0) {
            editText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxLength)});
        }
        if (action != null && (subView = viewGroup.getChildAt(viewGroup.getChildCount() - 1)) instanceof ViewGroup) {
            ViewGroup subViewGroup = (ViewGroup)subView;
            for (int index = 0; index < subViewGroup.getChildCount(); ++index) {
                View view = subViewGroup.getChildAt(index);
                if (!(view instanceof Button) && !(view instanceof ImageButton)) continue;
                view.setOnClickListener((View.OnClickListener)new BaseActionElementRenderer.SelectActionOnClickListener(renderedCard, action, cardActionHandler));
            }
        }
        return editText;
    }

    private class InlineActionIconImageLoaderAsync
    extends InnerImageLoaderAsync {
        private EditText m_editText;

        protected InlineActionIconImageLoaderAsync(RenderedAdaptiveCard renderedCard, View containerView, String url, EditText editText) {
            super(renderedCard, containerView, url, containerView.getResources().getDisplayMetrics().widthPixels);
            this.m_editText = editText;
        }

        @Override
        protected void renderBitmap(Bitmap bitmap) {
            ImageButton button = (ImageButton)this.m_view;
            float editTextHeight = (float)this.m_editText.getLineHeight() * this.m_editText.getLineSpacingMultiplier() + this.m_editText.getLineSpacingExtra() + (float)this.m_editText.getPaddingBottom() + (float)this.m_editText.getPaddingTop();
            button.setImageDrawable((Drawable)new BitmapDrawable(null, Util.scaleBitmapToHeight(editTextHeight, bitmap)));
        }
    }

    private class EditTextKeyListener
    implements View.OnKeyListener {
        private Object m_tag = null;
        private ICardActionHandler m_cardActionHandler;
        private RenderedAdaptiveCard m_renderedAdaptiveCard = null;
        private BaseActionElement m_action = null;

        EditTextKeyListener(Object tag, ICardActionHandler actionHandler, RenderedAdaptiveCard renderedCard, BaseActionElement action) {
            this.m_tag = tag;
            this.m_cardActionHandler = actionHandler;
            this.m_renderedAdaptiveCard = renderedCard;
            this.m_action = action;
        }

        public boolean onKey(View view, int i, KeyEvent keyEvent) {
            if (view.getTag() == this.m_tag && (keyEvent.getAction() == 0 && i == 66 && this.m_action.GetElementType() == ActionType.Execute || this.m_action.GetElementType() == ActionType.Submit)) {
                this.m_cardActionHandler.onAction(this.m_action, this.m_renderedAdaptiveCard);
                return true;
            }
            return false;
        }
    }

    private class EditTextTouchListener
    implements View.OnTouchListener {
        private EditText m_editText = null;

        EditTextTouchListener(EditText editText) {
            this.m_editText = editText;
        }

        public boolean onTouch(View v, MotionEvent event) {
            if (this.m_editText.hasFocus()) {
                v.getParent().requestDisallowInterceptTouchEvent(true);
                switch (event.getAction() & 0xFF) {
                    case 8: {
                        v.getParent().requestDisallowInterceptTouchEvent(false);
                    }
                }
            }
            return false;
        }
    }
}

