/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.inputhandler;

import android.widget.EditText;
import androidx.fragment.app.FragmentManager;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.objectmodel.DateInput;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.inputhandler.TextInputHandler;
import io.adaptivecards.renderer.readonly.RendererUtil;
import java.lang.ref.WeakReference;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateInputHandler
extends TextInputHandler {
    private WeakReference<FragmentManager> m_fragmentManager;
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static DateFormat s_simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public DateInputHandler(BaseInputElement baseInputElement, WeakReference<FragmentManager> fragmentManager, RenderedAdaptiveCard renderedAdaptiveCard, long cardId) {
        super(baseInputElement, renderedAdaptiveCard, (Long)cardId);
        this.m_fragmentManager = fragmentManager;
        s_simpleDateFormat.setLenient(false);
    }

    public FragmentManager getFragmentManager() {
        return (FragmentManager)this.m_fragmentManager.get();
    }

    @Override
    public String getInput() {
        EditText editText = this.getEditText();
        try {
            Date date = DateFormat.getDateInstance().parse(editText.getText().toString());
            return s_simpleDateFormat.format(date);
        }
        catch (ParseException e) {
            return editText.getText().toString();
        }
    }

    @Override
    public boolean isValidOnSpecifics(String inputValue) {
        Date max;
        Date min;
        DateInput dateInput = Util.tryCastTo(this.m_baseInputElement, DateInput.class);
        if (dateInput == null) {
            return false;
        }
        if (!dateInput.GetIsRequired() && inputValue.isEmpty()) {
            return true;
        }
        if (!RendererUtil.isValidDate(inputValue)) {
            return false;
        }
        Date currentDate = RendererUtil.getDate(inputValue).getTime();
        String minDate = dateInput.GetMin();
        if (!minDate.isEmpty() && !this.beforeOrSame(min = RendererUtil.getDate(minDate).getTime(), currentDate)) {
            return false;
        }
        String maxTime = dateInput.GetMax();
        return maxTime.isEmpty() || this.beforeOrSame(currentDate, max = RendererUtil.getDate(maxTime).getTime());
    }

    private boolean beforeOrSame(Date before, Date after) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(before);
        int beforeYear = calendar.get(1);
        int beforeMonth = calendar.get(2);
        int beforeDay = calendar.get(5);
        calendar.setTime(after);
        int afterYear = calendar.get(1);
        int afterMonth = calendar.get(2);
        int afterDay = calendar.get(5);
        boolean beforeOrSameDayOfTheSameMonth = beforeMonth == afterMonth && beforeDay <= afterDay;
        boolean beforeOrSameMonthOfTheSameYear = beforeYear == afterYear && (beforeMonth < afterMonth || beforeOrSameDayOfTheSameMonth);
        return beforeYear < afterYear || beforeOrSameMonthOfTheSameYear;
    }

    @Override
    public String getDefaultValue() {
        if (Util.isOfType(this.m_baseInputElement, DateInput.class)) {
            return Util.castTo(this.m_baseInputElement, DateInput.class).GetValue();
        }
        return super.getDefaultValue();
    }
}

