/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.layout;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.res.ResourcesCompat;
import com.google.android.flexbox.FlexboxLayout;
import io.adaptivecards.R;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.RatingColor;
import io.adaptivecards.objectmodel.RatingLabel;
import io.adaptivecards.objectmodel.RatingSize;
import io.adaptivecards.objectmodel.RatingStyle;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.readonly.RatingElementRendererUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 02\u00020\u0001:\u00010B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0012H\u0002J\u0018\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\rH\u0002J\b\u0010&\u001a\u00020\u001fH\u0002J \u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010\u001a\u001a\u00020\rH\u0002J\b\u0010,\u001a\u00020\u001fH\u0002J\n\u0010-\u001a\u0004\u0018\u00010.H\u0002J\b\u0010/\u001a\u00020\u001fH\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lio/adaptivecards/renderer/layout/RatingStarDisplayView;", "Lcom/google/android/flexbox/FlexboxLayout;", "context", "Landroid/content/Context;", "ratingLabel", "Lio/adaptivecards/objectmodel/RatingLabel;", "hostConfig", "Lio/adaptivecards/objectmodel/HostConfig;", "(Landroid/content/Context;Lio/adaptivecards/objectmodel/RatingLabel;Lio/adaptivecards/objectmodel/HostConfig;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "color", "Lio/adaptivecards/objectmodel/RatingColor;", "count", "", "Ljava/lang/Long;", "maxStarsCount", "ratingStars", "", "Landroid/widget/ImageView;", "size", "Lio/adaptivecards/objectmodel/RatingSize;", "style", "Lio/adaptivecards/objectmodel/RatingStyle;", "value", "", "addRatingAndCount", "", "addUsersCountTextView", "countValue", "addViewWithMargin", "view", "Landroid/view/View;", "rightMargin", "compactStyle", "createTextView", "Landroid/widget/TextView;", "text", "", "textColor", "defaultStyle", "getStarDrawable", "Landroid/graphics/drawable/Drawable;", "initStars", "Companion", "adaptivecards_release"})
public final class RatingStarDisplayView
extends FlexboxLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double value;
    private int maxStarsCount;
    @NotNull
    private RatingSize size;
    @NotNull
    private RatingStyle style;
    @Nullable
    private Long count;
    private RatingColor color;
    @NotNull
    private final List<ImageView> ratingStars;
    private HostConfig hostConfig;
    private static final int MARGIN_BETWEEN_STARS = 4;
    private static final int MARGIN_BETWEEN_STARS_AND_RATING_TEXT = 8;
    private static final int MARGIN_BETWEEN_RATING_TEXT_AND_DOT_COUNT = 4;

    public RatingStarDisplayView(@NotNull Context context, @NotNull RatingLabel ratingLabel, @NotNull HostConfig hostConfig) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)ratingLabel, (String)"ratingLabel");
        Intrinsics.checkNotNullParameter((Object)hostConfig, (String)"hostConfig");
        super(context);
        this.maxStarsCount = 5;
        this.size = RatingSize.Medium;
        this.style = RatingStyle.Default;
        this.ratingStars = new ArrayList();
        this.maxStarsCount = RangesKt.coerceAtMost((int)((int)ratingLabel.GetMax()), (int)5);
        this.value = ratingLabel.GetValue();
        this.hostConfig = hostConfig;
        RatingSize ratingSize = ratingLabel.GetRatingSize();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ratingSize), (String)"ratingLabel.GetRatingSize()");
        this.size = ratingSize;
        RatingStyle ratingStyle = ratingLabel.GetRatingStyle();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ratingStyle), (String)"ratingLabel.GetRatingStyle()");
        this.style = ratingStyle;
        this.count = ratingLabel.GetCount();
        RatingColor ratingColor = ratingLabel.GetRatingColor();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ratingColor), (String)"ratingLabel.GetRatingColor()");
        this.color = ratingColor;
        this.initStars();
    }

    public RatingStarDisplayView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.maxStarsCount = 5;
        this.size = RatingSize.Medium;
        this.style = RatingStyle.Default;
        this.ratingStars = new ArrayList();
        this.initStars();
    }

    public RatingStarDisplayView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.maxStarsCount = 5;
        this.size = RatingSize.Medium;
        this.style = RatingStyle.Default;
        this.ratingStars = new ArrayList();
        this.initStars();
    }

    private final void initStars() {
        this.setFlexWrap(1);
        this.setAlignItems(2);
        this.setLayoutParams((ViewGroup.LayoutParams)new FlexboxLayout.LayoutParams(-1, -2));
        if (WhenMappings.$EnumSwitchMapping$0[this.style.ordinal()] == 1) {
            this.compactStyle();
        } else {
            this.defaultStyle();
        }
    }

    private final void defaultStyle() {
        int n = this.maxStarsCount;
        for (int i = 0; i < n; ++i) {
            ImageView star;
            ImageView imageView;
            ImageView $this$defaultStyle_u24lambda_u2d0 = imageView = (star = new ImageView(this.getContext()));
            boolean bl = false;
            $this$defaultStyle_u24lambda_u2d0.setImageDrawable(this.getStarDrawable());
            $this$defaultStyle_u24lambda_u2d0.setActivated(true);
            RatingColor ratingColor = this.color;
            if (ratingColor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"color");
                ratingColor = null;
            }
            boolean bl2 = i < (int)this.value;
            HostConfig hostConfig = this.hostConfig;
            if (hostConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"hostConfig");
                hostConfig = null;
            }
            $this$defaultStyle_u24lambda_u2d0.setColorFilter(RatingElementRendererUtil.INSTANCE.getReadOnlyStarColor(ratingColor, bl2, hostConfig));
            $this$defaultStyle_u24lambda_u2d0.setLayoutParams((ViewGroup.LayoutParams)new FlexboxLayout.LayoutParams(-2, -2));
            this.ratingStars.add(star);
            int rightMargin = i < this.maxStarsCount - 1 ? 4 : 8;
            this.addViewWithMargin((View)star, rightMargin);
        }
        this.addRatingAndCount();
    }

    private final void compactStyle() {
        HostConfig hostConfig;
        ImageView star;
        ImageView imageView;
        ImageView $this$compactStyle_u24lambda_u2d1 = imageView = (star = new ImageView(this.getContext()));
        boolean bl = false;
        $this$compactStyle_u24lambda_u2d1.setImageDrawable(this.getStarDrawable());
        $this$compactStyle_u24lambda_u2d1.setActivated(true);
        RatingColor ratingColor = this.color;
        if (ratingColor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"color");
            ratingColor = null;
        }
        if ((hostConfig = this.hostConfig) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostConfig");
            hostConfig = null;
        }
        $this$compactStyle_u24lambda_u2d1.setColorFilter(RatingElementRendererUtil.INSTANCE.getReadOnlyStarColor(ratingColor, true, hostConfig));
        $this$compactStyle_u24lambda_u2d1.setLayoutParams((ViewGroup.LayoutParams)new FlexboxLayout.LayoutParams(-2, -2));
        this.ratingStars.add(star);
        this.addViewWithMargin((View)star, 8);
        this.addRatingAndCount();
    }

    private final void addUsersCountTextView(long countValue) {
        HostConfig hostConfig = this.hostConfig;
        if (hostConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostConfig");
            hostConfig = null;
        }
        String string2 = hostConfig.GetRatingLabelConfig().getRatingTextColor();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"hostConfig.GetRatingLabelConfig().ratingTextColor");
        TextView dotTextView = this.createTextView("\u00b7", string2, 1);
        this.addViewWithMargin((View)dotTextView, 4);
        String formattedCount = RatingElementRendererUtil.INSTANCE.formatNumberWithCommas(countValue);
        HostConfig hostConfig2 = this.hostConfig;
        if (hostConfig2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostConfig");
            hostConfig2 = null;
        }
        String string3 = hostConfig2.GetRatingLabelConfig().getCountTextColor();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"hostConfig.GetRatingLabelConfig().countTextColor");
        TextView countTextView = this.createTextView(formattedCount, string3, 0);
        this.addView((View)countTextView);
    }

    private final void addRatingAndCount() {
        block5: {
            Unit unit;
            Number rating = this.value % 1.0 == 0.0 ? (Number)((int)this.value) : (Number)this.value;
            String string2 = ((Number)rating).toString();
            HostConfig hostConfig = this.hostConfig;
            if (hostConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"hostConfig");
                hostConfig = null;
            }
            String string3 = hostConfig.GetRatingLabelConfig().getRatingTextColor();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"hostConfig.GetRatingLabelConfig().ratingTextColor");
            TextView ratingTextView = this.createTextView(string2, string3, 1);
            Long l = this.count;
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                if (it == 0L) {
                    this.addView((View)ratingTextView);
                } else {
                    this.addViewWithMargin((View)ratingTextView, 4);
                    this.addUsersCountTextView(it);
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block5;
            this.addView((View)ratingTextView);
        }
    }

    private final TextView createTextView(String text, String textColor, int style) {
        TextView textView;
        TextView textView2;
        int color = RatingElementRendererUtil.INSTANCE.getColorFromHexCode(textColor);
        TextView $this$createTextView_u24lambda_u2d3 = textView2 = (textView = new TextView(this.getContext()));
        boolean bl = false;
        $this$createTextView_u24lambda_u2d3.setText((CharSequence)text);
        $this$createTextView_u24lambda_u2d3.setTextColor(color);
        $this$createTextView_u24lambda_u2d3.setTextSize(16.0f);
        $this$createTextView_u24lambda_u2d3.setTypeface(null, style);
        $this$createTextView_u24lambda_u2d3.setLayoutParams((ViewGroup.LayoutParams)new FlexboxLayout.LayoutParams(-2, -1));
        $this$createTextView_u24lambda_u2d3.setGravity(16);
        return textView;
    }

    private final void addViewWithMargin(View view, int rightMargin) {
        int rightMarginInPixels = Util.dpToPixels(this.getContext(), rightMargin);
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.google.android.flexbox.FlexboxLayout.LayoutParams");
        }
        FlexboxLayout.LayoutParams params = (FlexboxLayout.LayoutParams)layoutParams;
        params.rightMargin = rightMarginInPixels;
        this.addView(view, (ViewGroup.LayoutParams)params);
    }

    private final Drawable getStarDrawable() {
        return WhenMappings.$EnumSwitchMapping$1[this.size.ordinal()] == 1 ? ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.rating_star_selector_medium, null) : ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.rating_star_selector_small, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/adaptivecards/renderer/layout/RatingStarDisplayView$Companion;", "", "()V", "MARGIN_BETWEEN_RATING_TEXT_AND_DOT_COUNT", "", "MARGIN_BETWEEN_STARS", "MARGIN_BETWEEN_STARS_AND_RATING_TEXT", "adaptivecards_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RatingStyle.values().length];
            nArray[RatingStyle.Compact.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RatingSize.values().length];
            nArray[RatingSize.Large.ordinal()] = 1;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

