/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.layout;

import android.content.Context;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.flexbox.FlexboxLayout;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.input.customcontrols.IValidatedInputView;
import io.adaptivecards.renderer.input.customcontrols.ValidatedCheckBoxLayout;
import io.adaptivecards.renderer.input.customcontrols.ValidatedRadioGroup;
import io.adaptivecards.renderer.input.customcontrols.ValidatedSpinnerLayout;
import io.adaptivecards.renderer.layout.RatingStarDisplayView;
import io.adaptivecards.renderer.layout.RatingStarInputView;
import io.adaptivecards.renderer.layout.StretchableElementLayout;

public class StretchableInputLayout
extends StretchableElementLayout {
    private TextView m_label = null;
    private View m_inputView = null;
    private TextView m_errorMessage = null;
    private View m_viewWithVisualCues = null;

    public StretchableInputLayout(Context context, boolean mustStretch) {
        super(context, mustStretch);
    }

    public View getLabel() {
        return this.m_label;
    }

    public void setLabel(TextView label) {
        this.addView((View)label);
        this.m_label = label;
    }

    public View getInputView() {
        return this.m_inputView;
    }

    public void setInputView(View input) {
        LinearLayout layout2;
        this.addView(input);
        if (input instanceof ValidatedSpinnerLayout || input instanceof ValidatedRadioGroup || input instanceof ValidatedCheckBoxLayout) {
            layout2 = (LinearLayout)input;
            this.m_inputView = layout2.getChildAt(0);
            this.m_viewWithVisualCues = input;
        } else if (input instanceof RatingStarInputView || input instanceof RatingStarDisplayView) {
            layout2 = (FlexboxLayout)input;
            this.m_inputView = layout2;
            this.m_viewWithVisualCues = layout2;
        } else if (input instanceof LinearLayout) {
            LinearLayout textInputWithActionLayout = (LinearLayout)input;
            this.m_viewWithVisualCues = this.m_inputView = textInputWithActionLayout.getChildAt(0);
        } else {
            this.m_inputView = input;
            this.m_viewWithVisualCues = input;
        }
        int viewId = (int)Util.getViewId(this.m_inputView);
        if (this.m_label != null) {
            this.m_label.setLabelFor(viewId);
        }
    }

    public View getErrorMessage() {
        return this.m_errorMessage;
    }

    public void setErrorMessage(TextView errorMessage) {
        this.addView((View)errorMessage);
        this.m_errorMessage = errorMessage;
        this.m_errorMessage.setImportantForAccessibility(2);
    }

    public void setValidationResult(boolean isValid) {
        BaseCardElementRenderer.setVisibility(!isValid, (View)this.m_errorMessage);
        if (this.m_viewWithVisualCues instanceof IValidatedInputView) {
            ((IValidatedInputView)this.m_viewWithVisualCues).setValidationResult(isValid);
        }
        if (this.m_label != null) {
            if (isValid) {
                this.m_label.setContentDescription(null);
            } else {
                this.m_label.setContentDescription((CharSequence)(this.m_label.getText() + " " + this.m_errorMessage.getText()));
            }
        }
    }
}

