/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentFactory;
import androidx.fragment.app.FragmentManager;
import io.adaptivecards.objectmodel.ActionMode;
import io.adaptivecards.objectmodel.ActionType;
import io.adaptivecards.objectmodel.AssociatedInputs;
import io.adaptivecards.objectmodel.BaseActionElement;
import io.adaptivecards.objectmodel.ExecuteAction;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.IsVisible;
import io.adaptivecards.objectmodel.PopoverAction;
import io.adaptivecards.objectmodel.ShowCardAction;
import io.adaptivecards.objectmodel.SubmitAction;
import io.adaptivecards.objectmodel.ToggleVisibilityAction;
import io.adaptivecards.objectmodel.ToggleVisibilityTarget;
import io.adaptivecards.objectmodel.ToggleVisibilityTargetVector;
import io.adaptivecards.renderer.AdaptiveCardRenderer;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.IBaseActionElementRenderer;
import io.adaptivecards.renderer.PopoverBottomSheetDailogFragment;
import io.adaptivecards.renderer.PopoverBottomSheetDailogFragmentFactory;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.action.ActionElementUtils;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import java.util.HashMap;
import java.util.HashSet;

public abstract class BaseActionElementRenderer
implements IBaseActionElementRenderer {
    public static final int PARENT_DROPDOWN_TAG = -1;

    protected static int getColor(String colorCode) {
        return Color.parseColor((String)colorCode);
    }

    public static class ActionOnClickListener
    implements View.OnClickListener {
        @Nullable
        protected FragmentManager m_fragmentManager;
        @Nullable
        protected HostConfig m_hostConfig;
        @Nullable
        protected RenderArgs m_renderArgs;
        protected BaseActionElement m_action;
        protected RenderedAdaptiveCard m_renderedAdaptiveCard;
        protected ICardActionHandler m_cardActionHandler;
        private View m_invisibleCard = null;
        private ViewGroup m_hiddenCardsLayout = null;
        private boolean m_isInlineShowCardAction = false;
        private HashMap<String, View> m_viewDictionary = null;
        private ToggleVisibilityAction m_toggleVisibilityAction = null;
        private final boolean m_isMenuAction;

        public static ActionOnClickListener newInstance(RenderedAdaptiveCard renderedCard, BaseActionElement baseActionElement, ICardActionHandler cardActionHandler, FragmentManager fragmentManager, HostConfig hostConfig, RenderArgs renderArgs) {
            return new ActionOnClickListener(renderedCard, baseActionElement, cardActionHandler, fragmentManager, hostConfig, renderArgs, false);
        }

        public static ActionOnClickListener newInstance(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseActionElement baseActionElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) {
            return ActionOnClickListener.newInstance(renderedCard, context, fragmentManager, viewGroup, baseActionElement, cardActionHandler, hostConfig, renderArgs, false);
        }

        public static ActionOnClickListener newInstance(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseActionElement baseActionElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs, boolean isMenuAction) {
            return new ActionOnClickListener(renderedCard, context, fragmentManager, viewGroup, baseActionElement, cardActionHandler, hostConfig, renderArgs, isMenuAction);
        }

        protected ActionOnClickListener(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseActionElement baseActionElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs, boolean isMenuAction) {
            this(renderedCard, baseActionElement, cardActionHandler, isMenuAction);
            this.m_isInlineShowCardAction = baseActionElement.GetElementType() == ActionType.ShowCard && hostConfig.GetActions().getShowCard().getActionMode() == ActionMode.Inline;
            this.m_fragmentManager = fragmentManager;
            this.m_renderArgs = renderArgs;
            this.m_hostConfig = hostConfig;
            if (this.m_isInlineShowCardAction) {
                this.renderHiddenCard(context, fragmentManager, viewGroup, hostConfig, renderArgs);
            }
        }

        protected ActionOnClickListener(RenderedAdaptiveCard renderedCard, BaseActionElement baseActionElement, ICardActionHandler cardActionHandler, FragmentManager fragmentManager, HostConfig hostConfig, RenderArgs renderArgs, boolean isMenuAction) {
            this(renderedCard, baseActionElement, cardActionHandler, isMenuAction);
            this.m_renderArgs = renderArgs;
            this.m_fragmentManager = fragmentManager;
            this.m_hostConfig = hostConfig;
        }

        private ActionOnClickListener(RenderedAdaptiveCard renderedCard, BaseActionElement baseActionElement, ICardActionHandler cardActionHandler, boolean isMenuAction) {
            this.m_action = baseActionElement;
            this.m_renderedAdaptiveCard = renderedCard;
            this.m_cardActionHandler = cardActionHandler;
            this.m_isMenuAction = isMenuAction;
            if (this.m_action.GetElementType() == ActionType.ToggleVisibility) {
                this.m_toggleVisibilityAction = null;
                if (this.m_action instanceof ToggleVisibilityAction) {
                    this.m_toggleVisibilityAction = (ToggleVisibilityAction)this.m_action;
                } else {
                    this.m_toggleVisibilityAction = ToggleVisibilityAction.dynamic_cast(this.m_action);
                    if (this.m_toggleVisibilityAction == null) {
                        throw new InternalError("Unable to convert BaseActionElement to ToggleVisibilityAction object model.");
                    }
                }
            }
        }

        private void resetSeparatorVisibilities(ViewGroup viewGroup) {
            boolean isFirstElement = true;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View element = viewGroup.getChildAt(i);
                TagContent tagContent = BaseCardElementRenderer.getTagContent(element);
                if (tagContent == null || tagContent.IsSeparator() || element.getVisibility() != 0) continue;
                View separator = tagContent.GetSeparator();
                if (separator != null) {
                    if (isFirstElement) {
                        separator.setVisibility(8);
                    } else {
                        separator.setVisibility(0);
                    }
                }
                isFirstElement = false;
            }
        }

        private void renderHiddenCard(Context context, FragmentManager fragmentManager, ViewGroup viewGroup, HostConfig hostConfig, RenderArgs renderArgs) {
            ShowCardAction showCardAction = Util.castTo(this.m_action, ShowCardAction.class);
            this.m_invisibleCard = AdaptiveCardRenderer.getInstance().internalRender(this.m_renderedAdaptiveCard, context, fragmentManager, showCardAction.GetCard(), this.m_cardActionHandler, hostConfig, true, renderArgs.getContainerCardId());
            this.m_invisibleCard.setVisibility(8);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
            layoutParams.setMargins(0, Util.dpToPixels(context, hostConfig.GetActions().getShowCard().getInlineTopMargin()), 0, 0);
            this.m_invisibleCard.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            ViewGroup parent = (ViewGroup)viewGroup.getParent();
            parent = parent instanceof HorizontalScrollView ? (ViewGroup)parent.getParent().getParent() : (ViewGroup)parent.getParent();
            this.m_hiddenCardsLayout = (ViewGroup)parent.getChildAt(1);
            this.m_hiddenCardsLayout.addView(this.m_invisibleCard);
        }

        @Nullable
        private Activity getActivity(Context context) {
            while (context instanceof ContextWrapper) {
                if (context instanceof Activity) {
                    return (Activity)context;
                }
                context = ((ContextWrapper)context).getBaseContext();
            }
            return null;
        }

        private void populateViewsDictionary() {
            this.m_viewDictionary = new HashMap();
            ToggleVisibilityTargetVector toggleVisibilityTargetVector = this.m_toggleVisibilityAction.GetTargetElements();
            View rootView = this.m_renderedAdaptiveCard.getView();
            for (int i = 0; i < toggleVisibilityTargetVector.size(); ++i) {
                ToggleVisibilityTarget target = toggleVisibilityTargetVector.get(i);
                String elementId = target.GetElementId();
                View foundView = rootView.findViewWithTag((Object)new TagContent(elementId));
                if (foundView == null) continue;
                this.m_viewDictionary.put(elementId, foundView);
            }
        }

        private void handleInlineShowCardAction(View v) {
            int i;
            View currentFocusedView;
            Activity hostingActivity = this.getActivity(v.getContext());
            if (hostingActivity != null && (currentFocusedView = hostingActivity.getCurrentFocus()) != null) {
                currentFocusedView.clearFocus();
            }
            v.setSelected(this.m_invisibleCard.getVisibility() != 0);
            ViewGroup parentContainer = v.getTag(-1) != null ? (ViewGroup)v.getTag(-1) : (ViewGroup)v.getParent();
            for (i = 0; i < parentContainer.getChildCount(); ++i) {
                View actionInActionSet = parentContainer.getChildAt(i);
                if (v == actionInActionSet) continue;
                actionInActionSet.setSelected(false);
            }
            for (i = 0; i < this.m_hiddenCardsLayout.getChildCount(); ++i) {
                View child = this.m_hiddenCardsLayout.getChildAt(i);
                if (child == this.m_invisibleCard) continue;
                child.setVisibility(8);
            }
            this.m_invisibleCard.setVisibility(this.m_invisibleCard.getVisibility() == 0 ? 8 : 0);
            View mainCardView = ((ViewGroup)this.m_hiddenCardsLayout.getParent()).getChildAt(0);
            int padding = mainCardView.getPaddingTop();
            if (this.m_invisibleCard.getVisibility() == 0) {
                mainCardView.setPadding(padding, padding, padding, 0);
            } else {
                mainCardView.setPadding(padding, padding, padding, padding);
            }
        }

        private void handlePopoverAction(@NonNull PopoverAction action, @NonNull View v) {
            if (this.m_renderedAdaptiveCard == null || this.m_cardActionHandler == null || this.m_fragmentManager == null || this.m_hostConfig == null || this.m_renderArgs == null) {
                return;
            }
            PopoverBottomSheetDailogFragmentFactory factory = new PopoverBottomSheetDailogFragmentFactory(v.getContext(), action, this.m_renderedAdaptiveCard, this.m_cardActionHandler, this.m_hostConfig, this.m_renderArgs);
            this.m_fragmentManager.setFragmentFactory((FragmentFactory)factory);
            Fragment fragment = factory.instantiate(ClassLoader.getSystemClassLoader(), PopoverBottomSheetDailogFragment.class.getName());
            ((PopoverBottomSheetDailogFragment)fragment).show(this.m_fragmentManager, "popover_bottom_sheet");
        }

        private void handleToggleVisibilityAction(View v) {
            ToggleVisibilityTargetVector toggleVisibilityTargetVector = this.m_toggleVisibilityAction.GetTargetElements();
            if (this.m_viewDictionary == null) {
                this.populateViewsDictionary();
            }
            HashSet<ViewGroup> viewGroupsToUpdate = new HashSet<ViewGroup>();
            for (int i = 0; i < toggleVisibilityTargetVector.size(); ++i) {
                ToggleVisibilityTarget target = toggleVisibilityTargetVector.get(i);
                String elementId = target.GetElementId();
                if (!this.m_viewDictionary.containsKey(elementId)) continue;
                View foundView = this.m_viewDictionary.get(elementId);
                IsVisible isVisible = target.GetIsVisible();
                boolean elementWillBeVisible = true;
                if (isVisible == IsVisible.IsVisibleFalse || isVisible == IsVisible.IsVisibleToggle && foundView.getVisibility() == 0) {
                    elementWillBeVisible = false;
                }
                String newVisibilityText = elementWillBeVisible ? " Expanded" : " Collapsed";
                v.announceForAccessibility((CharSequence)(elementId + newVisibilityText));
                BaseCardElementRenderer.setVisibility(elementWillBeVisible, foundView, viewGroupsToUpdate);
            }
            for (ViewGroup container : viewGroupsToUpdate) {
                this.resetSeparatorVisibilities(container);
            }
        }

        private boolean areMenuActionsPresent(@NonNull BaseActionElement baseActionElement) {
            return !this.m_isMenuAction && ActionElementUtils.isSplitAction(baseActionElement);
        }

        protected boolean handleMenuActionsScenario(@NonNull View view, @NonNull BaseActionElement baseActionElement) {
            return false;
        }

        private boolean isShowCardAction(@NonNull BaseActionElement baseActionElement) {
            return baseActionElement.GetElementType() == ActionType.ShowCard;
        }

        protected boolean handleShowCardScenario(@NonNull View view, @NonNull BaseActionElement baseActionElement) {
            return false;
        }

        public void onClick(View view) {
            if (!this.isPopoverContent() && this.areMenuActionsPresent(this.m_action) && this.handleMenuActionsScenario(view, this.m_action)) {
                return;
            }
            if (this.isShowCardAction(this.m_action) && this.handleShowCardScenario(view, this.m_action)) {
                return;
            }
            this.m_renderedAdaptiveCard.clearValidatedInputs();
            if (this.m_isInlineShowCardAction) {
                this.handleInlineShowCardAction(view);
                view.requestFocus();
            } else if (this.m_action.GetElementType() == ActionType.ToggleVisibility) {
                this.handleToggleVisibilityAction(view);
            } else if (this.m_action.GetElementType() == ActionType.Popover) {
                PopoverAction action = Util.castTo(this.m_action, PopoverAction.class);
                this.handlePopoverAction(action, view);
            } else {
                if (this.m_action.GetElementType() == ActionType.Execute || this.m_action.GetElementType() == ActionType.Submit || this.m_renderedAdaptiveCard.isActionSubmitable(view)) {
                    this.dismissPopoverIfNeeded();
                    boolean gatherInputs = true;
                    try {
                        try {
                            gatherInputs = Util.castTo(this.m_action, ExecuteAction.class).GetAssociatedInputs() != AssociatedInputs.None;
                        }
                        catch (ClassCastException e) {
                            gatherInputs = Util.castTo(this.m_action, SubmitAction.class).GetAssociatedInputs() != AssociatedInputs.None;
                        }
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    if (gatherInputs && !this.m_renderedAdaptiveCard.areInputsValid(Util.getViewId(view), this.m_renderArgs)) {
                        return;
                    }
                }
                this.m_cardActionHandler.onAction(this.m_action, this.m_renderedAdaptiveCard);
            }
        }

        private boolean isPopoverContent() {
            return this.m_renderArgs != null && this.m_renderArgs.isPopoverContent();
        }

        private void dismissPopoverIfNeeded() {
            if (this.m_renderArgs != null && this.m_renderArgs.isPopoverContent() && this.m_renderedAdaptiveCard.getPopoverDialog() != null) {
                this.m_renderedAdaptiveCard.getPopoverDialog().dismiss();
                this.m_renderedAdaptiveCard.setPopoverDialog(null);
            }
        }
    }

    public static class SelectActionOnClickListener
    extends ActionOnClickListener {
        public SelectActionOnClickListener(RenderedAdaptiveCard renderedCard, BaseActionElement action, ICardActionHandler cardActionHandler, FragmentManager fragmentManager, HostConfig hostConfig, RenderArgs renderArgs) {
            super(renderedCard, action, cardActionHandler, fragmentManager, hostConfig, renderArgs, false);
            if (this.m_action.GetElementType() == ActionType.ShowCard) {
                renderedCard.addWarning(new AdaptiveWarning(6, "ShowCard not supported for SelectAction"));
            }
        }

        @Override
        public void onClick(View v) {
            if (this.m_action.GetElementType() != ActionType.ShowCard) {
                super.onClick(v);
            }
        }
    }
}

