/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.app.Dialog;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import com.google.android.material.R;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import io.adaptivecards.R;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.ForegroundColor;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.PopoverAction;
import io.adaptivecards.renderer.IconUtils;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.Utils;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.readonly.TextRendererUtil;
import io.adaptivecards.renderer.registration.CardRendererRegistration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u0001:\u0001,B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J$\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010 \u001a\u00020!H\u0016J \u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u0014H\u0002J\u0018\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006-"}, d2={"Lio/adaptivecards/renderer/PopoverBottomSheetDailogFragment;", "Lcom/google/android/material/bottomsheet/BottomSheetDialogFragment;", "context", "Landroid/content/Context;", "popoverAction", "Lio/adaptivecards/objectmodel/PopoverAction;", "renderedAdaptiveCard", "Lio/adaptivecards/renderer/RenderedAdaptiveCard;", "actionHandler", "Lio/adaptivecards/renderer/actionhandler/ICardActionHandler;", "hostConfig", "Lio/adaptivecards/objectmodel/HostConfig;", "renderArgs", "Lio/adaptivecards/renderer/RenderArgs;", "(Landroid/content/Context;Lio/adaptivecards/objectmodel/PopoverAction;Lio/adaptivecards/renderer/RenderedAdaptiveCard;Lio/adaptivecards/renderer/actionhandler/ICardActionHandler;Lio/adaptivecards/objectmodel/HostConfig;Lio/adaptivecards/renderer/RenderArgs;)V", "dpToPx", "", "getDpToPx", "(F)F", "getPeekHeight", "", "contentHeight", "onCreateDialog", "Landroid/app/Dialog;", "savedInstanceState", "Landroid/os/Bundle;", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onStart", "", "renderPopoverContent", "action", "viewGroup", "parentViewId", "setCloseButtomImage", "closeButton", "Landroid/widget/ImageButton;", "drawable", "Landroid/graphics/drawable/Drawable;", "setCloseButton", "Companion", "adaptivecards_release"})
@SourceDebugExtension(value={"SMAP\nPopoverBottomSheetDailogFragment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PopoverBottomSheetDailogFragment.kt\nio/adaptivecards/renderer/PopoverBottomSheetDailogFragment\n+ 2 Color.kt\nandroidx/core/graphics/ColorKt\n*L\n1#1,205:1\n470#2:206\n*S KotlinDebug\n*F\n+ 1 PopoverBottomSheetDailogFragment.kt\nio/adaptivecards/renderer/PopoverBottomSheetDailogFragment\n*L\n139#1:206\n*E\n"})
public final class PopoverBottomSheetDailogFragment
extends BottomSheetDialogFragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final PopoverAction popoverAction;
    @NotNull
    private final RenderedAdaptiveCard renderedAdaptiveCard;
    @NotNull
    private final ICardActionHandler actionHandler;
    @NotNull
    private final HostConfig hostConfig;
    @NotNull
    private final RenderArgs renderArgs;
    @NotNull
    private static final String CLOSE_ICON_URL = "icon:Dismiss";
    @NotNull
    private static final String TAG = "PopoverBottomSheetDailogFragment";

    public PopoverBottomSheetDailogFragment(@NotNull Context context, @NotNull PopoverAction popoverAction, @NotNull RenderedAdaptiveCard renderedAdaptiveCard, @NotNull ICardActionHandler actionHandler, @NotNull HostConfig hostConfig, @NotNull RenderArgs renderArgs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)popoverAction, (String)"popoverAction");
        Intrinsics.checkNotNullParameter((Object)renderedAdaptiveCard, (String)"renderedAdaptiveCard");
        Intrinsics.checkNotNullParameter((Object)actionHandler, (String)"actionHandler");
        Intrinsics.checkNotNullParameter((Object)hostConfig, (String)"hostConfig");
        Intrinsics.checkNotNullParameter((Object)renderArgs, (String)"renderArgs");
        this.context = context;
        this.popoverAction = popoverAction;
        this.renderedAdaptiveCard = renderedAdaptiveCard;
        this.actionHandler = actionHandler;
        this.hostConfig = hostConfig;
        this.renderArgs = renderArgs;
    }

    @NotNull
    public Dialog onCreateDialog(@Nullable Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        Intrinsics.checkNotNull((Object)dialog, (String)"null cannot be cast to non-null type com.google.android.material.bottomsheet.BottomSheetDialog");
        BottomSheetDialog dialog2 = (BottomSheetDialog)dialog;
        return (Dialog)dialog2;
    }

    @NotNull
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        View view = inflater.inflate(R.layout.popover_bottom_sheet_layout, container, false);
        ImageButton closeButton = (ImageButton)view.findViewById(R.id.popover_closeButton);
        Intrinsics.checkNotNull((Object)closeButton);
        this.setCloseButton(closeButton);
        LinearLayout contentLayout = (LinearLayout)view.findViewById(R.id.popover_contentLayout);
        int dialogContentViewId = (int)Util.getViewId(view);
        Intrinsics.checkNotNull((Object)contentLayout);
        this.renderPopoverContent(this.popoverAction, (ViewGroup)contentLayout, dialogContentViewId);
        Intrinsics.checkNotNull((Object)view);
        return view;
    }

    private final void setCloseButton(ImageButton closeButton) {
        IconUtils.INSTANCE.getIcon(this.context, CLOSE_ICON_URL, this.popoverAction.GetSVGPath(CLOSE_ICON_URL), TextRendererUtil.getTextColor(ForegroundColor.Default, this.hostConfig, false, ContainerStyle.Default), false, 24L, (Function1<? super Drawable, Unit>)((Function1)new Function1<Drawable, Unit>(this, closeButton){
            final /* synthetic */ PopoverBottomSheetDailogFragment this$0;
            final /* synthetic */ ImageButton $closeButton;
            {
                this.this$0 = $receiver;
                this.$closeButton = $closeButton;
                super(1);
            }

            public final void invoke(@Nullable Drawable drawable) {
                block0: {
                    Drawable drawable2 = drawable;
                    if (drawable2 == null) break block0;
                    Drawable drawable3 = drawable2;
                    PopoverBottomSheetDailogFragment popoverBottomSheetDailogFragment = this.this$0;
                    ImageButton imageButton = this.$closeButton;
                    Drawable it = drawable3;
                    boolean bl = false;
                    PopoverBottomSheetDailogFragment.access$setCloseButtomImage(popoverBottomSheetDailogFragment, imageButton, it);
                }
            }
        }));
        closeButton.setOnClickListener(arg_0 -> PopoverBottomSheetDailogFragment.setCloseButton$lambda$1(this, arg_0));
    }

    private final void setCloseButtomImage(ImageButton closeButton, Drawable drawable) {
        new Handler(Looper.getMainLooper()).post(() -> PopoverBottomSheetDailogFragment.setCloseButtomImage$lambda$2(closeButton, drawable));
    }

    private final void renderPopoverContent(PopoverAction action, ViewGroup viewGroup, int parentViewId) {
        try {
            CardRendererRegistration.getInstance().renderElementAndPerformFallback(this.renderedAdaptiveCard, viewGroup.getContext(), this.getFragmentManager(), action.GetContent(), viewGroup, this.actionHandler, this.hostConfig, new RenderArgs(this.renderArgs, parentViewId), CardRendererRegistration.getInstance().getFeatureRegistration());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onStart() {
        block1: {
            View view;
            View bottomSheet;
            super.onStart();
            Dialog dialog = this.getDialog();
            BottomSheetDialog dialog2 = dialog instanceof BottomSheetDialog ? (BottomSheetDialog)dialog : null;
            this.renderedAdaptiveCard.setPopoverDialog(dialog2);
            BottomSheetDialog bottomSheetDialog = dialog2;
            View view2 = bottomSheet = bottomSheetDialog != null ? bottomSheetDialog.findViewById(R.id.design_bottom_sheet) : null;
            if (view2 != null) {
                void $this$onStart_u24lambda_u243;
                MaterialShapeDrawable materialShapeDrawable;
                MaterialShapeDrawable materialShapeDrawable2 = materialShapeDrawable = new MaterialShapeDrawable();
                View view3 = view2;
                boolean bl = false;
                $this$onStart_u24lambda_u243.setShapeAppearanceModel(ShapeAppearanceModel.builder().setTopLeftCorner(0, this.getDpToPx(10.0f)).setTopRightCorner(0, this.getDpToPx(10.0f)).setBottomLeftCorner(0, 0.0f).setBottomRightCorner(0, 0.0f).build());
                String string2 = this.hostConfig.GetActions().getPopover().getBackgroundColor();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getBackgroundColor(...)");
                String $this$toColorInt$iv = string2;
                boolean $i$f$toColorInt = false;
                $this$onStart_u24lambda_u243.setFillColor(ColorStateList.valueOf((int)Color.parseColor((String)$this$toColorInt$iv)));
                view3.setBackground((Drawable)materialShapeDrawable);
            }
            if ((view = bottomSheet) == null || (view = view.getViewTreeObserver()) == null) break block1;
            view.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(bottomSheet, this){
                final /* synthetic */ View $bottomSheet;
                final /* synthetic */ PopoverBottomSheetDailogFragment this$0;
                {
                    this.$bottomSheet = $bottomSheet;
                    this.this$0 = $receiver;
                }

                public void onGlobalLayout() {
                    block0: {
                        this.$bottomSheet.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        int height = this.$bottomSheet.getHeight();
                        Log.d((String)PopoverBottomSheetDailogFragment.Companion.getTAG(), (String)("Bottom sheet height: " + height));
                        View view = this.$bottomSheet;
                        if (view == null) break block0;
                        View view2 = view;
                        PopoverBottomSheetDailogFragment popoverBottomSheetDailogFragment = this.this$0;
                        View it = view2;
                        boolean bl = false;
                        BottomSheetBehavior bottomSheetBehavior = BottomSheetBehavior.from((View)it);
                        Intrinsics.checkNotNullExpressionValue((Object)bottomSheetBehavior, (String)"from(...)");
                        BottomSheetBehavior behavior = bottomSheetBehavior;
                        it.getLayoutParams().height = PopoverBottomSheetDailogFragment.access$getPeekHeight(popoverBottomSheetDailogFragment, height);
                        it.requestLayout();
                        behavior.setState(4);
                        behavior.setPeekHeight(PopoverBottomSheetDailogFragment.access$getPeekHeight(popoverBottomSheetDailogFragment, height));
                        behavior.setDraggable(false);
                    }
                }
            });
        }
    }

    public final float getDpToPx(float $this$dpToPx) {
        return $this$dpToPx * Resources.getSystem().getDisplayMetrics().density;
    }

    private final int getPeekHeight(int contentHeight) {
        int screenHeight = Utils.INSTANCE.getScreenAvailableHeight(this.context);
        int minHeight = screenHeight / 5;
        int maxHeight = screenHeight * 2 / 3;
        return RangesKt.coerceIn((int)contentHeight, (int)minHeight, (int)maxHeight);
    }

    private static final void setCloseButton$lambda$1(PopoverBottomSheetDailogFragment this$0, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            BottomSheetDialog bottomSheetDialog = this$0.renderedAdaptiveCard.getPopoverDialog();
            if (bottomSheetDialog == null) break block0;
            BottomSheetDialog it2 = bottomSheetDialog;
            boolean bl = false;
            it2.dismiss();
            this$0.renderedAdaptiveCard.setPopoverDialog(null);
        }
    }

    private static final void setCloseButtomImage$lambda$2(ImageButton $closeButton, Drawable $drawable) {
        Intrinsics.checkNotNullParameter((Object)$closeButton, (String)"$closeButton");
        Intrinsics.checkNotNullParameter((Object)$drawable, (String)"$drawable");
        $closeButton.setImageDrawable($drawable);
    }

    public static final /* synthetic */ void access$setCloseButtomImage(PopoverBottomSheetDailogFragment $this, ImageButton closeButton, Drawable drawable) {
        $this.setCloseButtomImage(closeButton, drawable);
    }

    public static final /* synthetic */ int access$getPeekHeight(PopoverBottomSheetDailogFragment $this, int contentHeight) {
        return $this.getPeekHeight(contentHeight);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lio/adaptivecards/renderer/PopoverBottomSheetDailogFragment$Companion;", "", "()V", "CLOSE_ICON_URL", "", "getCLOSE_ICON_URL", "()Ljava/lang/String;", "TAG", "getTAG", "adaptivecards_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getCLOSE_ICON_URL() {
            return CLOSE_ICON_URL;
        }

        @NotNull
        public final String getTAG() {
            return TAG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

