/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.graphics.Insets;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowMetrics;
import io.adaptivecards.objectmodel.ACTheme;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\f\u0010\u0007\u001a\u00020\b*\u00020\u0006H\u0007J\f\u0010\t\u001a\u00020\n*\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lio/adaptivecards/renderer/Utils;", "", "()V", "getScreenAvailableHeight", "", "context", "Landroid/content/Context;", "getTheme", "Lio/adaptivecards/objectmodel/ACTheme;", "isDarkTheme", "", "adaptivecards_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    @JvmStatic
    @NotNull
    public static final ACTheme getTheme(@NotNull Context $this$getTheme) {
        Intrinsics.checkNotNullParameter((Object)$this$getTheme, (String)"<this>");
        return INSTANCE.isDarkTheme($this$getTheme) ? ACTheme.Dark : ACTheme.Light;
    }

    private final boolean isDarkTheme(Context $this$isDarkTheme) {
        int nightModeFlags = $this$isDarkTheme.getResources().getConfiguration().uiMode & 0x30;
        return nightModeFlags == 32;
    }

    public final int getScreenAvailableHeight(@NotNull Context context) {
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        WindowManager windowManager = (WindowManager)object;
        if (Build.VERSION.SDK_INT >= 30) {
            int height;
            WindowMetrics windowMetrics = windowManager.getCurrentWindowMetrics();
            Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"getCurrentWindowMetrics(...)");
            WindowMetrics windowMetrics2 = windowMetrics;
            WindowInsets windowInsets = windowMetrics2.getWindowInsets();
            Intrinsics.checkNotNullExpressionValue((Object)windowInsets, (String)"getWindowInsets(...)");
            WindowInsets insets = windowInsets;
            Insets insets2 = insets.getInsetsIgnoringVisibility(WindowInsets.Type.systemBars());
            Intrinsics.checkNotNullExpressionValue((Object)insets2, (String)"getInsetsIgnoringVisibility(...)");
            Insets insetsIgnoringVisibility = insets2;
            Rect rect = windowMetrics2.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"getBounds(...)");
            Rect bounds = rect;
            n = height = bounds.height() - insetsIgnoringVisibility.top - insetsIgnoringVisibility.bottom;
        } else {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
            n = displayMetrics.heightPixels;
        }
        return n;
    }
}

