/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.input;

import android.app.DatePickerDialog;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.widget.DatePicker;
import android.widget.EditText;
import androidx.fragment.app.DialogFragment;
import io.adaptivecards.objectmodel.DateInput;
import io.adaptivecards.renderer.readonly.RendererUtil;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DatePickerFragment
extends DialogFragment
implements DatePickerDialog.OnDateSetListener {
    private DateInput m_dateInput;
    private EditText m_editText;
    private Context m_context;

    public void initialize(DateInput dateInput, EditText editText, Context context) {
        this.m_dateInput = dateInput;
        this.m_editText = editText;
        this.m_context = context;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Calendar calendar;
        try {
            Date value = DateFormat.getDateInstance().parse(this.m_editText.getText().toString());
            calendar = new GregorianCalendar();
            calendar.setTime(value);
        }
        catch (Exception excep) {
            calendar = Calendar.getInstance();
        }
        DatePickerDialog datePickerDialog = new DatePickerDialog(this.m_context, (DatePickerDialog.OnDateSetListener)this, calendar.get(1), calendar.get(2), calendar.get(5));
        if (!this.m_dateInput.GetMin().isEmpty()) {
            datePickerDialog.getDatePicker().setMinDate(RendererUtil.getDate(this.m_dateInput.GetMin()).getTime().getTime());
        }
        if (!this.m_dateInput.GetMax().isEmpty()) {
            datePickerDialog.getDatePicker().setMaxDate(RendererUtil.getDate(this.m_dateInput.GetMax()).getTime().getTime());
        }
        return datePickerDialog;
    }

    public void onDateSet(DatePicker view, int year, int month, int dayOfMonth) {
        GregorianCalendar calendar = new GregorianCalendar(year, month, dayOfMonth);
        Date date = calendar.getTime();
        String value = DateFormat.getDateInstance().format(date);
        this.m_editText.setText((CharSequence)value);
    }
}

