/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.input;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentManager;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.ForegroundColor;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.ToggleInput;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.input.ChoiceSetInputRenderer;
import io.adaptivecards.renderer.input.customcontrols.ValidatedCheckBox;
import io.adaptivecards.renderer.inputhandler.InputUtils;
import io.adaptivecards.renderer.inputhandler.ToggleInputHandler;

public class ToggleInputRenderer
extends BaseCardElementRenderer {
    private static ToggleInputRenderer s_instance = null;

    protected ToggleInputRenderer() {
    }

    public static ToggleInputRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ToggleInputRenderer();
        }
        return s_instance;
    }

    @Override
    @Nullable
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) throws Exception {
        if (!hostConfig.GetSupportsInteractivity()) {
            renderedCard.addWarning(new AdaptiveWarning(3, "Input.Toggle is not allowed"));
            return null;
        }
        ToggleInput toggleInput = Util.castTo(baseCardElement, ToggleInput.class);
        ToggleInputHandler toggleInputHandler = new ToggleInputHandler(toggleInput, renderedCard, renderArgs);
        ValidatedCheckBox checkBox = new ValidatedCheckBox(context, ToggleInputRenderer.getColor(hostConfig.GetForegroundColor(ContainerStyle.Default, ForegroundColor.Attention, false)));
        if (!toggleInput.GetWrap()) {
            checkBox.setMaxLines(1);
            checkBox.setEllipsize(TextUtils.TruncateAt.END);
        }
        toggleInputHandler.setView((View)checkBox);
        TagContent tagContent = new TagContent((BaseCardElement)toggleInput, toggleInputHandler);
        checkBox.setText(toggleInput.GetTitle());
        renderedCard.registerInputHandler(toggleInputHandler, renderArgs.getContainerCardId());
        if (TextUtils.isEmpty((CharSequence)toggleInput.GetValueOn())) {
            throw new IllegalArgumentException("Toggle Input, " + toggleInput.GetId() + ", cannot contain empty/null 'On' value");
        }
        if (TextUtils.isEmpty((CharSequence)toggleInput.GetValueOff())) {
            throw new IllegalArgumentException("Toggle Input, " + toggleInput.GetId() + ", cannot contain empty/null 'Off' value");
        }
        if (!TextUtils.isEmpty((CharSequence)toggleInput.GetValue()) && toggleInput.GetValue().equals(toggleInput.GetValueOn())) {
            checkBox.setChecked(true);
        }
        checkBox.setOnTouchListener(new ChoiceSetInputRenderer.FocusableChoiceListener<ValidatedCheckBox>(checkBox));
        InputUtils.updateInputHandlerInputWatcher(toggleInputHandler);
        viewGroup.addView((View)checkBox);
        checkBox.setTag(tagContent);
        ToggleInputRenderer.setVisibility(baseCardElement.GetIsVisible(), (View)checkBox);
        return checkBox;
    }
}

