/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.inputhandler;

import android.view.View;
import android.widget.AdapterView;
import android.widget.Spinner;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.objectmodel.ChoiceInput;
import io.adaptivecards.objectmodel.ChoiceInputVector;
import io.adaptivecards.objectmodel.ChoiceSetInput;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.input.customcontrols.ValidatedSpinnerLayout;
import io.adaptivecards.renderer.inputhandler.BaseInputHandler;

public class ComboBoxInputHandler
extends BaseInputHandler {
    public ComboBoxInputHandler(BaseInputElement baseInputElement, RenderedAdaptiveCard renderedAdaptiveCard, RenderArgs renderArgs) {
        super(baseInputElement, renderedAdaptiveCard, renderArgs);
    }

    protected Spinner getSpinner() {
        if (this.m_view instanceof ValidatedSpinnerLayout) {
            return (Spinner)((ValidatedSpinnerLayout)this.m_view).getChildAt(0);
        }
        return (Spinner)this.m_view;
    }

    @Override
    public String getInput() {
        ChoiceSetInput choiceSetInput = (ChoiceSetInput)this.m_baseInputElement;
        int index = this.getSpinner().getSelectedItemPosition();
        String selectedItem = "";
        if (index >= 0 && index < choiceSetInput.GetChoices().size()) {
            selectedItem = choiceSetInput.GetChoices().get(index).GetValue();
        }
        return selectedItem;
    }

    @Override
    public void setInput(String value) {
        ChoiceSetInput choiceSetInput = (ChoiceSetInput)this.m_baseInputElement;
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        int selectedPosition = choiceSetInput.GetValue().isEmpty() ? choiceInputVector.size() : 0;
        for (int i = 0; i < choiceInputVector.size(); ++i) {
            ChoiceInput choiceInput = choiceInputVector.get(i);
            if (!value.equals(choiceInput.GetValue())) continue;
            selectedPosition = i;
            break;
        }
        this.getSpinner().setSelection(selectedPosition);
    }

    @Override
    public void registerInputObserver() {
        this.getSpinner().setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                ComboBoxInputHandler.this.notifyAllInputWatchers();
            }

            public void onNothingSelected(AdapterView<?> parent) {
                ComboBoxInputHandler.this.notifyAllInputWatchers();
            }
        });
        this.addValueChangedActionInputWatcher();
    }

    @Override
    public String getDefaultValue() {
        if (Util.isOfType(this.m_baseInputElement, ChoiceSetInput.class)) {
            return Util.castTo(this.m_baseInputElement, ChoiceSetInput.class).GetValue();
        }
        return super.getDefaultValue();
    }

    @Override
    public void setFocusToView() {
        Util.forceFocus(this.m_view);
        this.m_view.sendAccessibilityEvent(32768);
    }
}

