/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.AsyncTask;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.TooltipCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.fragment.app.FragmentManager;
import com.google.android.flexbox.FlexboxLayout;
import io.adaptivecards.objectmodel.ActionType;
import io.adaptivecards.objectmodel.BackgroundImage;
import io.adaptivecards.objectmodel.BaseActionElement;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.CardElementType;
import io.adaptivecards.objectmodel.Container;
import io.adaptivecards.objectmodel.ContainerBleedDirection;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.ExecuteAction;
import io.adaptivecards.objectmodel.FlowLayout;
import io.adaptivecards.objectmodel.HeightType;
import io.adaptivecards.objectmodel.HorizontalAlignment;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.ItemFit;
import io.adaptivecards.objectmodel.Layout;
import io.adaptivecards.objectmodel.LayoutContainerType;
import io.adaptivecards.objectmodel.StyledCollectionElement;
import io.adaptivecards.objectmodel.SubmitAction;
import io.adaptivecards.objectmodel.VerticalContentAlignment;
import io.adaptivecards.renderer.BackgroundImageLoaderAsync;
import io.adaptivecards.renderer.BaseActionElementRenderer;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.IOnlineImageLoader;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.layout.AreaGridLayoutView;
import io.adaptivecards.renderer.layout.StretchableElementLayout;
import io.adaptivecards.renderer.registration.CardRendererRegistration;

public class ContainerRenderer
extends BaseCardElementRenderer {
    private static ContainerRenderer s_instance = null;

    protected ContainerRenderer() {
    }

    public static ContainerRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ContainerRenderer();
        }
        return s_instance;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) throws Exception {
        Container container = Util.castTo(baseCardElement, Container.class);
        Layout layoutToApply = Util.getLayoutToApply(container.GetLayouts(), hostConfig);
        ViewGroup containerView = ContainerRenderer.getAppropriateContainerForLayout(context, layoutToApply, container);
        ContainerRenderer.setMinHeight(container.GetMinHeight(), (View)containerView, context);
        containerView.setClipChildren(false);
        containerView.setClipToPadding(false);
        ContainerRenderer.applyVerticalContentAlignment(containerView, container.GetVerticalContentAlignment(), layoutToApply);
        ContainerStyle containerStyle = renderArgs.getContainerStyle();
        ContainerStyle styleForThis = ContainerRenderer.getLocalContainerStyle(container, containerStyle);
        ContainerRenderer.applyPadding(styleForThis, containerStyle, containerView, hostConfig, container.GetShowBorder());
        ContainerRenderer.applyContainerStyle(styleForThis, containerStyle, containerView, hostConfig);
        ContainerRenderer.applyBleed(container, containerView, context, hostConfig);
        ContainerRenderer.applyBorder(styleForThis, containerView, hostConfig, container.GetElementType(), container.GetShowBorder());
        ContainerRenderer.applyRoundedCorners(containerView, hostConfig, container.GetElementType(), container.GetRoundedCorners());
        BaseCardElementRenderer.applyRtl(container.GetRtl(), containerView);
        RenderArgs containerRenderArgs = new RenderArgs(renderArgs);
        containerRenderArgs.setContainerStyle(styleForThis);
        containerRenderArgs.setHorizontalAlignment(HorizontalAlignment.Left);
        containerRenderArgs.setAncestorHasSelectAction(renderArgs.getAncestorHasSelectAction() || container.GetSelectAction() != null);
        if (!container.GetItems().isEmpty()) {
            CardRendererRegistration.getInstance().renderElements(renderedCard, context, fragmentManager, containerView, container.GetItems(), cardActionHandler, hostConfig, containerRenderArgs, layoutToApply);
            ContainerRenderer.applyItemFillForFlowLayout(layoutToApply, containerView);
        }
        ContainerRenderer.setBackgroundImage(renderedCard, context, container.GetBackgroundImage(), hostConfig, renderArgs, containerView);
        ContainerRenderer.setSelectAction(renderedCard, container.GetSelectAction(), (View)containerView, cardActionHandler, fragmentManager, hostConfig, renderArgs);
        viewGroup.addView((View)containerView);
        return containerView;
    }

    public static void applyVerticalContentAlignment(ViewGroup container, VerticalContentAlignment verticalContentAlignment, Layout layoutToApply) {
        if (layoutToApply.GetLayoutContainerType() == LayoutContainerType.Flow && container instanceof FlexboxLayout) {
            int alignContent = 0;
            if (verticalContentAlignment == VerticalContentAlignment.Center) {
                alignContent = 2;
            } else if (verticalContentAlignment == VerticalContentAlignment.Bottom) {
                alignContent = 1;
            }
            ((FlexboxLayout)container).setAlignContent(alignContent);
        } else if (layoutToApply.GetLayoutContainerType() == LayoutContainerType.AreaGrid && container instanceof AreaGridLayoutView) {
            int alignContent = 0;
            if (verticalContentAlignment == VerticalContentAlignment.Center) {
                alignContent = 2;
            } else if (verticalContentAlignment == VerticalContentAlignment.Bottom) {
                alignContent = 1;
            }
            ((AreaGridLayoutView)container).setAreaGridAlignContent(alignContent);
        } else {
            int gravity = 48;
            if (verticalContentAlignment == VerticalContentAlignment.Center) {
                gravity = 17;
            } else if (verticalContentAlignment == VerticalContentAlignment.Bottom) {
                gravity = 80;
            }
            ((LinearLayout)container).setGravity(gravity);
        }
    }

    public static void ApplyBleed(StyledCollectionElement collectionElement, ViewGroup collectionElementView, Context context, HostConfig hostConfig) {
        ContainerRenderer.applyBleed(collectionElement, collectionElementView, context, hostConfig);
    }

    public static void applyBleed(StyledCollectionElement collectionElement, ViewGroup collectionElementView, Context context, HostConfig hostConfig) {
        if (collectionElement.GetBleed() && collectionElement.GetCanBleed()) {
            int padding = Util.dpToPixels(context, hostConfig.GetSpacing().getPaddingSpacing());
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)collectionElementView.getLayoutParams();
            int marginLeft = layoutParams.leftMargin;
            int marginRight = layoutParams.rightMargin;
            int marginTop = layoutParams.topMargin;
            int marginBottom = layoutParams.bottomMargin;
            ContainerBleedDirection bleedDirection = collectionElement.GetBleedDirection();
            if ((bleedDirection.swigValue() & ContainerBleedDirection.BleedLeft.swigValue()) != ContainerBleedDirection.BleedRestricted.swigValue()) {
                marginLeft = -padding;
            }
            if ((bleedDirection.swigValue() & ContainerBleedDirection.BleedRight.swigValue()) != ContainerBleedDirection.BleedRestricted.swigValue()) {
                marginRight = -padding;
            }
            if ((bleedDirection.swigValue() & ContainerBleedDirection.BleedUp.swigValue()) != ContainerBleedDirection.BleedRestricted.swigValue()) {
                marginTop = -padding;
            }
            if ((bleedDirection.swigValue() & ContainerBleedDirection.BleedDown.swigValue()) != ContainerBleedDirection.BleedRestricted.swigValue()) {
                marginBottom = -padding;
            }
            layoutParams.setMargins(marginLeft, marginTop, marginRight, marginBottom);
            collectionElementView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public static void ApplyPadding(ContainerStyle computedContainerStyle, ContainerStyle parentContainerStyle, ViewGroup collectionElementView, HostConfig hostConfig) {
        ContainerRenderer.applyPadding(computedContainerStyle, parentContainerStyle, collectionElementView, hostConfig);
        ContainerRenderer.applyContainerStyle(computedContainerStyle, parentContainerStyle, collectionElementView, hostConfig);
    }

    public static void applyPadding(ContainerStyle computedContainerStyle, ContainerStyle parentContainerStyle, ViewGroup collectionElementView, HostConfig hostConfig) {
        ContainerRenderer.applyPadding(computedContainerStyle, parentContainerStyle, collectionElementView, hostConfig, false);
    }

    public static void applyPadding(ContainerStyle computedContainerStyle, ContainerStyle parentContainerStyle, ViewGroup collectionElementView, HostConfig hostConfig, boolean hasBorder) {
        if (hasBorder || computedContainerStyle != parentContainerStyle) {
            int padding = Util.dpToPixels(collectionElementView.getContext(), hostConfig.GetSpacing().getPaddingSpacing());
            collectionElementView.setPadding(padding, padding, padding, padding);
        }
    }

    public static void applyBorder(ContainerStyle containerStyle, ViewGroup collectionElementView, HostConfig hostConfig, CardElementType cardElementType, boolean showBorder) {
        if (showBorder) {
            float borderWidth = hostConfig.GetBorderWidth(cardElementType);
            int borderWidthInPixels = Util.dpToPixels(collectionElementView.getContext(), borderWidth);
            int borderColor = Color.parseColor((String)hostConfig.GetBorderColor(containerStyle));
            if (collectionElementView.getBackground() instanceof GradientDrawable) {
                ((GradientDrawable)collectionElementView.getBackground()).setStroke(borderWidthInPixels, borderColor);
            } else {
                GradientDrawable gradientDrawable = new GradientDrawable();
                gradientDrawable.setStroke(borderWidthInPixels, borderColor);
                collectionElementView.setBackground((Drawable)gradientDrawable);
            }
        }
    }

    public static void applyRoundedCorners(ViewGroup collectionElementView, HostConfig hostConfig, CardElementType cardElementType, boolean roundedCorners) {
        if (roundedCorners) {
            float cornerRadius = hostConfig.GetCornerRadius(cardElementType);
            float cornerRadiusInPixels = Util.dpToPixels(collectionElementView.getContext(), cornerRadius);
            if (collectionElementView.getBackground() instanceof GradientDrawable) {
                ((GradientDrawable)collectionElementView.getBackground()).setCornerRadius(cornerRadiusInPixels);
            } else {
                GradientDrawable gradientDrawable = new GradientDrawable();
                gradientDrawable.setCornerRadius(cornerRadiusInPixels);
                collectionElementView.setBackground((Drawable)gradientDrawable);
            }
        }
    }

    public static void applyItemFillForFlowLayout(Layout layoutToApply, ViewGroup flexboxLayout) {
        if (layoutToApply.GetLayoutContainerType() == LayoutContainerType.Flow) {
            for (int i = 0; i < flexboxLayout.getChildCount(); ++i) {
                FlowLayout flowLayout = Util.castTo(layoutToApply, FlowLayout.class);
                View child = flexboxLayout.getChildAt(i);
                FlexboxLayout.LayoutParams layoutParams = (FlexboxLayout.LayoutParams)child.getLayoutParams();
                if (flowLayout.GetItemFit() == ItemFit.Fill) {
                    layoutParams.setFlexGrow(1.0f);
                }
                child.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }
    }

    public static void applyContainerStyle(ContainerStyle computedContainerStyle, ContainerStyle parentContainerStyle, ViewGroup collectionElementView, HostConfig hostConfig) {
        if (computedContainerStyle != parentContainerStyle) {
            String backgroundColor = hostConfig.GetBackgroundColor(computedContainerStyle);
            int color2 = Color.parseColor((String)backgroundColor);
            if (collectionElementView.getBackground() instanceof GradientDrawable) {
                ((GradientDrawable)collectionElementView.getBackground()).setColor(color2);
            } else {
                GradientDrawable gradientDrawable = new GradientDrawable();
                gradientDrawable.setColor(color2);
                collectionElementView.setBackground((Drawable)gradientDrawable);
            }
        }
    }

    public static ContainerStyle GetLocalContainerStyle(StyledCollectionElement collectionElement, ContainerStyle parentContainerStyle) {
        return ContainerRenderer.getLocalContainerStyle(collectionElement, parentContainerStyle);
    }

    public static ContainerStyle getLocalContainerStyle(StyledCollectionElement collectionElement, ContainerStyle parentContainerStyle) {
        return ContainerRenderer.computeContainerStyle(collectionElement.GetStyle(), parentContainerStyle);
    }

    public static ContainerStyle computeContainerStyle(ContainerStyle declared, ContainerStyle inherited) {
        return declared == ContainerStyle.None ? inherited : declared;
    }

    public static void setBackgroundImage(RenderedAdaptiveCard renderedCard, Context context, BackgroundImage backgroundImage, HostConfig hostConfig, RenderArgs renderArgs, ViewGroup containerView) {
        String backgroundImageUrl;
        if (backgroundImage != null && !(backgroundImageUrl = backgroundImage.GetUrl(renderedCard.getTheme())).isEmpty()) {
            BackgroundImageLoaderAsync loaderAsync = new BackgroundImageLoaderAsync(renderedCard, context, containerView, hostConfig.GetImageBaseUrl(), context.getResources().getDisplayMetrics().widthPixels, backgroundImage);
            IOnlineImageLoader onlineImageLoader = CardRendererRegistration.getInstance().getOnlineImageLoader();
            if (onlineImageLoader != null) {
                loaderAsync.registerCustomOnlineImageLoader(onlineImageLoader);
            }
            loaderAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[]{backgroundImageUrl});
        }
    }

    public static void applyTitleAndTooltip(BaseActionElement selectAction, View view) {
        String tooltip;
        String contentDescription = !TextUtils.isEmpty((CharSequence)selectAction.GetTitle()) ? selectAction.GetTitle() : selectAction.GetTooltip();
        String string2 = tooltip = !TextUtils.isEmpty((CharSequence)selectAction.GetTooltip()) ? selectAction.GetTooltip() : selectAction.GetTitle();
        if (!TextUtils.isEmpty((CharSequence)contentDescription)) {
            view.setContentDescription((CharSequence)contentDescription);
        }
        if (!TextUtils.isEmpty((CharSequence)tooltip)) {
            TooltipCompat.setTooltipText((View)view, (CharSequence)tooltip);
        }
        if (selectAction.GetElementType() == ActionType.ToggleVisibility) {
            ContainerRenderer.setAccessibilityForView(view);
        }
    }

    private static void setAccessibilityForView(@NonNull View view) {
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            String description = "";
            if (group.getChildCount() > 0 && group.getChildAt(0) instanceof TextView) {
                description = ((TextView)group.getChildAt(0)).getText().toString();
            }
            final String finalDescription = description;
            ViewCompat.setAccessibilityDelegate((View)view, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

                public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
                    super.onInitializeAccessibilityNodeInfo(host, info);
                    info.setClassName((CharSequence)Button.class.getName());
                    info.addAction(16);
                    info.setContentDescription((CharSequence)finalDescription);
                }
            });
        }
    }

    public static void setSelectAction(RenderedAdaptiveCard renderedCard, BaseActionElement selectAction, View view, ICardActionHandler cardActionHandler, FragmentManager fragmentManager, HostConfig hostConfig, RenderArgs renderArgs) {
        if (selectAction != null) {
            View childView;
            ViewGroup group;
            view.setFocusable(true);
            view.setClickable(true);
            view.setEnabled(selectAction.GetIsEnabled());
            if (Util.isOfType(selectAction, ExecuteAction.class) || Util.isOfType(selectAction, SubmitAction.class) || selectAction.GetElementType() == ActionType.Custom) {
                renderedCard.registerSubmitableAction(view, renderArgs);
            }
            view.setOnClickListener((View.OnClickListener)new BaseActionElementRenderer.SelectActionOnClickListener(renderedCard, selectAction, cardActionHandler, fragmentManager, hostConfig, renderArgs));
            ContainerRenderer.applyTitleAndTooltip(selectAction, view);
            if (view instanceof ViewGroup && (group = (ViewGroup)view).getChildCount() == 1 && (childView = group.getChildAt(0)).isFocusable()) {
                childView.setFocusable(false);
                if (Build.VERSION.SDK_INT >= 28) {
                    childView.setScreenReaderFocusable(false);
                }
                childView.setImportantForAccessibility(2);
            }
        }
    }

    public static ViewGroup getAppropriateContainerForLayout(Context context, Layout layoutToApply, StyledCollectionElement container) {
        Object layoutContainer;
        if (layoutToApply.GetLayoutContainerType() == LayoutContainerType.Flow) {
            FlexboxLayout flexboxLayout = new FlexboxLayout(context);
            flexboxLayout.setFlexDirection(0);
            flexboxLayout.setFlexWrap(1);
            Util.setHorizontalAlignmentForFlowLayout(flexboxLayout, layoutToApply);
            flexboxLayout.setLayoutParams((ViewGroup.LayoutParams)new FlexboxLayout.LayoutParams(-1, -2));
            flexboxLayout.setTag((Object)new TagContent(container));
            layoutContainer = flexboxLayout;
        } else if (layoutToApply.GetLayoutContainerType() == LayoutContainerType.AreaGrid) {
            AreaGridLayoutView areaGridLayoutView = new AreaGridLayoutView(context);
            areaGridLayoutView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
            areaGridLayoutView.setTag(new TagContent(container));
            layoutContainer = areaGridLayoutView;
        } else {
            StretchableElementLayout stackLayout = new StretchableElementLayout(context, container.GetHeight() == HeightType.Stretch);
            stackLayout.setTag(new TagContent(container));
            stackLayout.setOrientation(1);
            layoutContainer = stackLayout;
        }
        return layoutContainer;
    }
}

