/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TableRow;
import androidx.fragment.app.FragmentManager;
import com.google.android.flexbox.FlexboxLayout;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.BaseCardElementVector;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HorizontalAlignment;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.Layout;
import io.adaptivecards.objectmodel.LayoutContainerType;
import io.adaptivecards.objectmodel.Table;
import io.adaptivecards.objectmodel.TableCell;
import io.adaptivecards.objectmodel.TableColumnDefinition;
import io.adaptivecards.objectmodel.TableRow;
import io.adaptivecards.objectmodel.VerticalContentAlignment;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.layout.AreaGridLayoutView;
import io.adaptivecards.renderer.readonly.ContainerRenderer;
import io.adaptivecards.renderer.readonly.TableCellRenderArgs;
import io.adaptivecards.renderer.registration.CardRendererRegistration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J*\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002JJ\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.H\u0016\u00a8\u0006/"}, d2={"Lio/adaptivecards/renderer/readonly/TableCellRenderer;", "Lio/adaptivecards/renderer/BaseCardElementRenderer;", "()V", "applyBorderOrSpacing", "", "cellLayout", "Landroid/view/View;", "showGridLines", "", "borderStyle", "Lio/adaptivecards/objectmodel/ContainerStyle;", "isFirst", "isLast", "bleed", "hostConfig", "Lio/adaptivecards/objectmodel/HostConfig;", "computeHorizontalAlignment", "Lio/adaptivecards/objectmodel/HorizontalAlignment;", "row", "Lio/adaptivecards/objectmodel/TableRow;", "col", "Lio/adaptivecards/objectmodel/TableColumnDefinition;", "table", "Lio/adaptivecards/objectmodel/Table;", "computeVerticalContentAlignment", "Lio/adaptivecards/objectmodel/VerticalContentAlignment;", "declaredAlignment", "getAppropriateContainerForLayout", "Landroid/view/ViewGroup;", "context", "Landroid/content/Context;", "layoutToApply", "Lio/adaptivecards/objectmodel/Layout;", "tableCell", "Lio/adaptivecards/objectmodel/TableCell;", "render", "renderedCard", "Lio/adaptivecards/renderer/RenderedAdaptiveCard;", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "viewGroup", "baseCardElement", "Lio/adaptivecards/objectmodel/BaseCardElement;", "cardActionHandler", "Lio/adaptivecards/renderer/actionhandler/ICardActionHandler;", "renderArgs", "Lio/adaptivecards/renderer/RenderArgs;", "adaptivecards_release"})
@SourceDebugExtension(value={"SMAP\nTableCellRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableCellRenderer.kt\nio/adaptivecards/renderer/readonly/TableCellRenderer\n+ 2 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,173:1\n326#2,4:174\n326#2,4:178\n326#2,4:182\n*S KotlinDebug\n*F\n+ 1 TableCellRenderer.kt\nio/adaptivecards/renderer/readonly/TableCellRenderer\n*L\n46#1:174,4\n49#1:178,4\n100#1:182,4\n*E\n"})
public final class TableCellRenderer
extends BaseCardElementRenderer {
    @NotNull
    public static final TableCellRenderer INSTANCE = new TableCellRenderer();

    private TableCellRenderer() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public View render(@NotNull RenderedAdaptiveCard renderedCard, @NotNull Context context, @NotNull FragmentManager fragmentManager, @NotNull ViewGroup viewGroup, @NotNull BaseCardElement baseCardElement, @Nullable ICardActionHandler cardActionHandler, @NotNull HostConfig hostConfig, @NotNull RenderArgs renderArgs) {
        void $this$render_u24lambda_u242;
        RenderArgs renderArgs2;
        Intrinsics.checkNotNullParameter((Object)renderedCard, (String)"renderedCard");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
        Intrinsics.checkNotNullParameter((Object)baseCardElement, (String)"baseCardElement");
        Intrinsics.checkNotNullParameter((Object)hostConfig, (String)"hostConfig");
        Intrinsics.checkNotNullParameter((Object)renderArgs, (String)"renderArgs");
        if (!(renderArgs instanceof TableCellRenderArgs)) {
            throw new IllegalArgumentException("renderArgs must be instance of TableCellRenderArgs");
        }
        TableRow row = ((TableCellRenderArgs)renderArgs).getTable().GetRows().get(((TableCellRenderArgs)renderArgs).getRowIndex());
        TableColumnDefinition col = ((TableCellRenderArgs)renderArgs).getTable().GetColumns().get(((TableCellRenderArgs)renderArgs).getColIndex());
        TableCell cell = Util.castTo(baseCardElement, TableCell.class);
        Layout layoutToApply = Util.getLayoutToApply(cell.GetLayouts(), hostConfig);
        Intrinsics.checkNotNull((Object)layoutToApply);
        Intrinsics.checkNotNull((Object)cell);
        ViewGroup cellLayout = this.getAppropriateContainerForLayout(context, layoutToApply, cell);
        boolean stretch = false;
        if (col.GetPixelWidth() != null) {
            $this$updateLayoutParams$iv = (View)cellLayout;
            $i$f$updateLayoutParamsTyped = false;
            ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
            if (layoutParams == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.TableRow.LayoutParams");
            }
            params$iv = (ViewGroup.LayoutParams)((TableRow.LayoutParams)layoutParams);
            TableRow.LayoutParams $this$render_u24lambda_u240 = (TableRow.LayoutParams)params$iv;
            boolean bl = false;
            Long l = col.GetPixelWidth();
            Intrinsics.checkNotNull((Object)l);
            $this$render_u24lambda_u240.width = Util.dpToPixels(context, l.longValue());
            $this$updateLayoutParams$iv.setLayoutParams(params$iv);
        } else if (col.GetWidth() != null) {
            $this$updateLayoutParams$iv = (View)cellLayout;
            $i$f$updateLayoutParamsTyped = false;
            ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
            if (layoutParams == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.TableRow.LayoutParams");
            }
            params$iv = (ViewGroup.LayoutParams)((TableRow.LayoutParams)layoutParams);
            TableRow.LayoutParams $this$render_u24lambda_u241 = (TableRow.LayoutParams)params$iv;
            boolean bl = false;
            Long l = col.GetWidth();
            $this$render_u24lambda_u241.weight = l != null ? (float)l.longValue() : 1.0f;
            $this$updateLayoutParams$iv.setLayoutParams(params$iv);
            stretch = true;
        }
        ((TableCellRenderArgs)renderArgs).getTableLayout().setColumnShrinkable(((TableCellRenderArgs)renderArgs).getColIndex(), stretch);
        ((TableCellRenderArgs)renderArgs).getTableLayout().setColumnStretchable(((TableCellRenderArgs)renderArgs).getColIndex(), stretch);
        boolean isFirst = ((TableCellRenderArgs)renderArgs).getColIndex() == 0;
        boolean isLast = ((TableCellRenderArgs)renderArgs).getColIndex() == ((TableCellRenderArgs)renderArgs).getTable().GetColumns().size() - 1;
        this.applyBorderOrSpacing((View)cellLayout, ((TableCellRenderArgs)renderArgs).getTable().GetShowGridLines(), ((TableCellRenderArgs)renderArgs).getGridStyle(), isFirst, isLast, cell.GetBleed(), hostConfig);
        BaseCardElementRenderer.applyRtl(cell.GetRtl(), cellLayout);
        BaseCardElementRenderer.setVisibility(cell.GetIsVisible(), (View)cellLayout);
        BaseCardElementRenderer.setMinHeight(cell.GetMinHeight(), (View)cellLayout, context);
        ContainerStyle computedStyle = ContainerRenderer.getLocalContainerStyle(cell, ((TableCellRenderArgs)renderArgs).getContainerStyle());
        ContainerRenderer.applyPadding(computedStyle, ((TableCellRenderArgs)renderArgs).getContainerStyle(), cellLayout, hostConfig, ((TableCellRenderArgs)renderArgs).getTable().GetShowGridLines());
        ContainerRenderer.applyContainerStyle(computedStyle, ((TableCellRenderArgs)renderArgs).getContainerStyle(), cellLayout, hostConfig);
        VerticalContentAlignment verticalContentAlignment = cell.GetVerticalContentAlignment();
        Intrinsics.checkNotNull((Object)row);
        Intrinsics.checkNotNull((Object)col);
        ContainerRenderer.applyVerticalContentAlignment(cellLayout, this.computeVerticalContentAlignment(verticalContentAlignment, row, col, ((TableCellRenderArgs)renderArgs).getTable()), layoutToApply);
        ContainerRenderer.setSelectAction(renderedCard, cell.GetSelectAction(), (View)cellLayout, cardActionHandler, fragmentManager, hostConfig, renderArgs);
        RenderArgs bl = renderArgs2 = new RenderArgs(renderArgs);
        HostConfig hostConfig2 = hostConfig;
        ICardActionHandler iCardActionHandler = cardActionHandler;
        BaseCardElementVector baseCardElementVector = cell.GetItems();
        ViewGroup viewGroup2 = cellLayout;
        FragmentManager fragmentManager2 = fragmentManager;
        Context context2 = context;
        RenderedAdaptiveCard renderedAdaptiveCard = renderedCard;
        CardRendererRegistration cardRendererRegistration = CardRendererRegistration.getInstance();
        boolean bl2 = false;
        $this$render_u24lambda_u242.setContainerStyle(computedStyle);
        $this$render_u24lambda_u242.setHorizontalAlignment(INSTANCE.computeHorizontalAlignment(row, col, ((TableCellRenderArgs)renderArgs).getTable()));
        Unit unit = Unit.INSTANCE;
        cardRendererRegistration.renderElements(renderedAdaptiveCard, context2, fragmentManager2, viewGroup2, baseCardElementVector, iCardActionHandler, hostConfig2, renderArgs2, layoutToApply);
        ContainerRenderer.applyItemFillForFlowLayout(layoutToApply, cellLayout);
        viewGroup.addView((View)cellLayout);
        return (View)cellLayout;
    }

    /*
     * WARNING - void declaration
     */
    private final void applyBorderOrSpacing(View cellLayout, boolean showGridLines, ContainerStyle borderStyle, boolean isFirst, boolean isLast, boolean bleed, HostConfig hostConfig) {
        View $this$updateLayoutParams$iv = cellLayout;
        boolean $i$f$updateLayoutParamsTyped = false;
        ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        }
        ViewGroup.LayoutParams params$iv = (ViewGroup.LayoutParams)((ViewGroup.MarginLayoutParams)layoutParams);
        ViewGroup.MarginLayoutParams $this$applyBorderOrSpacing_u24lambda_u244 = (ViewGroup.MarginLayoutParams)params$iv;
        boolean bl = false;
        if (showGridLines) {
            void $this$applyBorderOrSpacing_u24lambda_u244_u24lambda_u243;
            GradientDrawable gradientDrawable;
            GradientDrawable gradientDrawable2 = gradientDrawable = new GradientDrawable();
            View view = cellLayout;
            boolean bl2 = false;
            $this$applyBorderOrSpacing_u24lambda_u244_u24lambda_u243.setShape(0);
            $this$applyBorderOrSpacing_u24lambda_u244_u24lambda_u243.setColor(0);
            int color2 = Color.parseColor((String)hostConfig.GetBorderColor(borderStyle));
            $this$applyBorderOrSpacing_u24lambda_u244_u24lambda_u243.setStroke(Util.dpToPixels(cellLayout.getContext(), 1.0f), color2);
            view.setBackground((Drawable)gradientDrawable);
        } else if (bleed) {
            int padding = Util.dpToPixels(cellLayout.getContext(), hostConfig.GetSpacing().getPaddingSpacing());
            if (isFirst) {
                $this$applyBorderOrSpacing_u24lambda_u244.setMarginStart(-padding);
            }
            if (isLast) {
                $this$applyBorderOrSpacing_u24lambda_u244.setMarginEnd(-padding);
            }
        } else {
            int spacing = Util.dpToPixels(cellLayout.getContext(), hostConfig.GetTable().getCellSpacing());
            if (!isFirst) {
                $this$applyBorderOrSpacing_u24lambda_u244.setMarginStart(spacing / 2);
            }
            if (!isLast) {
                $this$applyBorderOrSpacing_u24lambda_u244.setMarginEnd(spacing / 2);
            }
        }
        $this$updateLayoutParams$iv.setLayoutParams(params$iv);
    }

    private final VerticalContentAlignment computeVerticalContentAlignment(VerticalContentAlignment declaredAlignment, TableRow row, TableColumnDefinition col, Table table) {
        VerticalContentAlignment verticalContentAlignment = declaredAlignment;
        if (verticalContentAlignment == null && (verticalContentAlignment = row.GetVerticalCellContentAlignment()) == null && (verticalContentAlignment = col.GetVerticalCellContentAlignment()) == null && (verticalContentAlignment = table.GetVerticalCellContentAlignment()) == null) {
            verticalContentAlignment = VerticalContentAlignment.Top;
        }
        return verticalContentAlignment;
    }

    private final HorizontalAlignment computeHorizontalAlignment(TableRow row, TableColumnDefinition col, Table table) {
        HorizontalAlignment horizontalAlignment;
        HorizontalAlignment horizontalAlignment2 = row.GetHorizontalCellContentAlignment();
        if (horizontalAlignment2 == null && (horizontalAlignment2 = col.GetHorizontalCellContentAlignment()) == null) {
            horizontalAlignment2 = table.GetHorizontalCellContentAlignment();
        }
        return (horizontalAlignment = horizontalAlignment2) == null ? HorizontalAlignment.Left : horizontalAlignment;
    }

    private final ViewGroup getAppropriateContainerForLayout(Context context, Layout layoutToApply, TableCell tableCell) {
        ViewGroup layoutContainer = null;
        if (layoutToApply.GetLayoutContainerType() == LayoutContainerType.Flow) {
            FlexboxLayout flexboxLayout;
            FlexboxLayout $this$getAppropriateContainerForLayout_u24lambda_u245 = flexboxLayout = new FlexboxLayout(context);
            boolean bl = false;
            $this$getAppropriateContainerForLayout_u24lambda_u245.setFlexDirection(0);
            $this$getAppropriateContainerForLayout_u24lambda_u245.setFlexWrap(1);
            $this$getAppropriateContainerForLayout_u24lambda_u245.setTag((Object)new TagContent(tableCell));
            $this$getAppropriateContainerForLayout_u24lambda_u245.setLayoutParams((ViewGroup.LayoutParams)new TableRow.LayoutParams(0, -1));
            FlexboxLayout flexboxLayout2 = flexboxLayout;
            Util.setHorizontalAlignmentForFlowLayout(flexboxLayout2, layoutToApply);
            layoutContainer = (ViewGroup)flexboxLayout2;
        } else if (layoutToApply.GetLayoutContainerType() == LayoutContainerType.AreaGrid) {
            AreaGridLayoutView areaGridLayoutView;
            AreaGridLayoutView $this$getAppropriateContainerForLayout_u24lambda_u246 = areaGridLayoutView = new AreaGridLayoutView(context);
            boolean bl = false;
            $this$getAppropriateContainerForLayout_u24lambda_u246.setTag(new TagContent(tableCell));
            $this$getAppropriateContainerForLayout_u24lambda_u246.setLayoutParams((ViewGroup.LayoutParams)new TableRow.LayoutParams(0, -1));
            AreaGridLayoutView areaGridLayout = areaGridLayoutView;
            layoutContainer = (ViewGroup)areaGridLayout;
        } else {
            LinearLayout linearLayout;
            LinearLayout $this$getAppropriateContainerForLayout_u24lambda_u247 = linearLayout = new LinearLayout(context);
            boolean bl = false;
            $this$getAppropriateContainerForLayout_u24lambda_u247.setOrientation(1);
            $this$getAppropriateContainerForLayout_u24lambda_u247.setTag((Object)new TagContent(tableCell));
            $this$getAppropriateContainerForLayout_u24lambda_u247.setLayoutParams((ViewGroup.LayoutParams)new TableRow.LayoutParams(0, -1));
            LinearLayout cellLayout = linearLayout;
            layoutContainer = (ViewGroup)cellLayout;
        }
        return layoutContainer;
    }
}

