/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TableLayout;
import androidx.fragment.app.FragmentManager;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.CardElementType;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.Table;
import io.adaptivecards.objectmodel.TableCell;
import io.adaptivecards.objectmodel.TableCellVector;
import io.adaptivecards.objectmodel.TableRow;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.IBaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.readonly.ContainerRenderer;
import io.adaptivecards.renderer.readonly.TableCellRenderArgs;
import io.adaptivecards.renderer.registration.CardRendererRegistration;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lio/adaptivecards/renderer/readonly/TableRenderer;", "Lio/adaptivecards/renderer/BaseCardElementRenderer;", "()V", "render", "Landroid/view/View;", "renderedCard", "Lio/adaptivecards/renderer/RenderedAdaptiveCard;", "context", "Landroid/content/Context;", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "viewGroup", "Landroid/view/ViewGroup;", "baseCardElement", "Lio/adaptivecards/objectmodel/BaseCardElement;", "cardActionHandler", "Lio/adaptivecards/renderer/actionhandler/ICardActionHandler;", "hostConfig", "Lio/adaptivecards/objectmodel/HostConfig;", "renderArgs", "Lio/adaptivecards/renderer/RenderArgs;", "adaptivecards_release"})
public final class TableRenderer
extends BaseCardElementRenderer {
    @NotNull
    public static final TableRenderer INSTANCE = new TableRenderer();

    private TableRenderer() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public View render(@NotNull RenderedAdaptiveCard renderedCard, @NotNull Context context, @NotNull FragmentManager fragmentManager, @NotNull ViewGroup viewGroup, @NotNull BaseCardElement baseCardElement, @Nullable ICardActionHandler cardActionHandler, @NotNull HostConfig hostConfig, @NotNull RenderArgs renderArgs) {
        android.widget.TableRow tableRow;
        TableLayout tableLayout;
        Intrinsics.checkNotNullParameter((Object)renderedCard, (String)"renderedCard");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
        Intrinsics.checkNotNullParameter((Object)baseCardElement, (String)"baseCardElement");
        Intrinsics.checkNotNullParameter((Object)hostConfig, (String)"hostConfig");
        Intrinsics.checkNotNullParameter((Object)renderArgs, (String)"renderArgs");
        Table table = Util.castTo(baseCardElement, Table.class);
        IBaseCardElementRenderer iBaseCardElementRenderer = CardRendererRegistration.getInstance().getRenderer(CardElementType.TableCell.toString());
        if (iBaseCardElementRenderer == null) {
            throw new IllegalStateException("No renderer registered for " + CardElementType.TableCell);
        }
        IBaseCardElementRenderer tableCellRenderer = iBaseCardElementRenderer;
        TableLayout $this$render_u24lambda_u240 = tableLayout = new TableLayout(context);
        boolean bl = false;
        $this$render_u24lambda_u240.setTag((Object)new TagContent(table));
        $this$render_u24lambda_u240.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        $this$render_u24lambda_u240.setClipChildren(false);
        $this$render_u24lambda_u240.setClipToPadding(false);
        TableLayout tableLayout2 = tableLayout;
        boolean isFirstRowHeader = table.GetFirstRowAsHeaders();
        ContainerStyle computedGridStyle = table.GetGridStyle() == ContainerStyle.None ? renderArgs.getContainerStyle() : table.GetGridStyle();
        int n = table.GetRows().size();
        for (int i = 0; i < n; ++i) {
            TableRow row = table.GetRows().get(i);
            android.widget.TableRow $this$render_u24lambda_u241 = tableRow = new android.widget.TableRow(context);
            int n2 = 0;
            $this$render_u24lambda_u241.setClipChildren(false);
            $this$render_u24lambda_u241.setClipToPadding(false);
            android.widget.TableRow rowLayout = tableRow;
            ContainerStyle rowStyle = ContainerRenderer.computeContainerStyle(row.GetStyle(), renderArgs.getContainerStyle());
            ContainerRenderer.applyContainerStyle(rowStyle, renderArgs.getContainerStyle(), (ViewGroup)rowLayout, hostConfig);
            n2 = table.GetColumns().size();
            for (int j = 0; j < n2; ++j) {
                TableCell cell;
                TableCellRenderArgs tableCellRenderArgs;
                TableCellVector tableCellVector = row.GetCells();
                Intrinsics.checkNotNullExpressionValue((Object)tableCellVector, (String)"GetCells(...)");
                if ((TableCell)CollectionsKt.getOrNull((List)tableCellVector, (int)j) == null) break;
                Intrinsics.checkNotNull((Object)table);
                Intrinsics.checkNotNull((Object)((Object)computedGridStyle));
                TableCellRenderArgs $this$render_u24lambda_u242 = tableCellRenderArgs = new TableCellRenderArgs(renderArgs, table, tableLayout2, i, j, computedGridStyle);
                boolean bl2 = false;
                $this$render_u24lambda_u242.setContainerStyle(rowStyle);
                $this$render_u24lambda_u242.setColumnHeader(i == 0 && isFirstRowHeader);
                TableCellRenderArgs cellArgs = tableCellRenderArgs;
                tableCellRenderer.render(renderedCard, context, fragmentManager, (ViewGroup)rowLayout, cell, cardActionHandler, hostConfig, cellArgs);
            }
            tableLayout2.addView((View)rowLayout);
        }
        if (table.GetRoundedCorners()) {
            if (table.GetShowGridLines()) {
                float cornerRadius = hostConfig.GetCornerRadius(table.GetElementType());
                float cornerRadiusInPixels = Util.dpToPixels(tableLayout2.getContext(), cornerRadius);
                float borderWidth = hostConfig.GetBorderWidth(table.GetElementType());
                int borderWidthInPixels = Util.dpToPixels(tableLayout2.getContext(), borderWidth);
                if (tableLayout2.getBackground() instanceof GradientDrawable) {
                    Drawable drawable2 = tableLayout2.getBackground();
                    Intrinsics.checkNotNull((Object)drawable2, (String)"null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
                    android.widget.TableRow $this$render_u24lambda_u243 = tableRow = (GradientDrawable)drawable2;
                    boolean bl3 = false;
                    $this$render_u24lambda_u243.setCornerRadius(cornerRadiusInPixels);
                    $this$render_u24lambda_u243.setStroke(borderWidthInPixels, Color.parseColor((String)hostConfig.GetBorderColor(computedGridStyle)));
                } else {
                    void $this$render_u24lambda_u244;
                    android.widget.TableRow $this$render_u24lambda_u243 = tableRow = new GradientDrawable();
                    TableLayout tableLayout3 = tableLayout2;
                    boolean bl4 = false;
                    $this$render_u24lambda_u244.setCornerRadius(cornerRadiusInPixels);
                    $this$render_u24lambda_u244.setStroke(borderWidthInPixels, Color.parseColor((String)hostConfig.GetBorderColor(computedGridStyle)));
                    tableLayout3.setBackground((Drawable)tableRow);
                }
            }
            tableLayout2.setClipToOutline(true);
        }
        viewGroup.addView((View)tableLayout2);
        return (View)tableLayout2;
    }
}

