/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.widget.Button;
import io.adaptivecards.renderer.FluentIconUtils;
import io.adaptivecards.renderer.GetImageAsync;
import io.adaptivecards.renderer.Util;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J_\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112#\u0010\u0012\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\b0\u0013J\u001e\u0010\u0018\u001a\u00020\b*\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00042\b\b\u0002\u0010\u001a\u001a\u00020\u0006H\u0007J\u001d\u0010\u0018\u001a\u00020\b*\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lio/adaptivecards/renderer/IconUtils;", "", "()V", "getHexColor", "", "currentTextColor", "", "getIcon", "", "context", "Landroid/content/Context;", "iconUrl", "svgPath", "iconHexColor", "isRTL", "", "iconSize", "", "callback", "Lkotlin/Function1;", "Landroid/graphics/drawable/Drawable;", "Lkotlin/ParameterName;", "name", "drawable", "applyIconColor", "hexIconColor", "defaultHexIconColor", "Landroid/widget/Button;", "iconColor", "(Landroid/widget/Button;Ljava/lang/Integer;)V", "adaptivecards_release"})
public final class IconUtils {
    @NotNull
    public static final IconUtils INSTANCE = new IconUtils();

    private IconUtils() {
    }

    public final void getIcon(@NotNull Context context, @NotNull String iconUrl, @Nullable String svgPath, @Nullable String iconHexColor, boolean isRTL, long iconSize, @NotNull Function1<? super Drawable, Unit> callback) {
        block3: {
            Unit unit;
            block2: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)iconUrl, (String)"iconUrl");
                Intrinsics.checkNotNullParameter(callback, (String)"callback");
                if (StringsKt.startsWith$default((String)iconUrl, (String)"icon:", (boolean)false, (int)2, null)) break block2;
                GetImageAsync getImage = new GetImageAsync(iconUrl, context, -1, iconSize, callback);
                Object[] objectArray = new String[]{iconUrl};
                getImage.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, objectArray);
                break block3;
            }
            String string2 = svgPath;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                boolean isFilledStyle = StringsKt.contains$default((CharSequence)iconUrl, (CharSequence)"filled", (boolean)false, (int)2, null);
                String svgInfoURL = Util.getSvgInfoUrl(it);
                AsyncTask.execute(() -> IconUtils.getIcon$lambda$1$lambda$0(context, svgInfoURL, iconHexColor, iconSize, isFilledStyle, isRTL, callback));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block3;
            IconUtils $this$getIcon_u24lambda_u242 = this;
            boolean bl = false;
            callback.invoke(null);
        }
    }

    @JvmStatic
    public static final void applyIconColor(@NotNull Button $this$applyIconColor, @Nullable Integer iconColor) {
        block3: {
            Drawable drawable;
            String string2;
            Intrinsics.checkNotNullParameter((Object)$this$applyIconColor, (String)"<this>");
            Integer n = iconColor;
            int color = n != null ? n.intValue() : $this$applyIconColor.getCurrentTextColor();
            String $this$applyIconColor_u24lambda_u243 = string2 = IconUtils.getHexColor(color);
            boolean bl = false;
            Drawable drawable2 = drawable = $this$applyIconColor.getCompoundDrawables()[0];
            if (drawable2 != null) {
                Intrinsics.checkNotNull((Object)drawable2);
                IconUtils.applyIconColor$default(drawable, $this$applyIconColor_u24lambda_u243, 0, 2, null);
            }
            Drawable drawable3 = drawable = $this$applyIconColor.getCompoundDrawables()[1];
            if (drawable3 != null) {
                Intrinsics.checkNotNull((Object)drawable3);
                IconUtils.applyIconColor$default(drawable, $this$applyIconColor_u24lambda_u243, 0, 2, null);
            }
            Drawable drawable4 = drawable = $this$applyIconColor.getCompoundDrawables()[2];
            if (drawable4 != null) {
                Intrinsics.checkNotNull((Object)drawable4);
                IconUtils.applyIconColor$default(drawable, $this$applyIconColor_u24lambda_u243, 0, 2, null);
            }
            Drawable drawable5 = drawable = $this$applyIconColor.getCompoundDrawables()[3];
            if (drawable5 == null) break block3;
            Intrinsics.checkNotNull((Object)drawable5);
            IconUtils.applyIconColor$default(drawable, $this$applyIconColor_u24lambda_u243, 0, 2, null);
        }
    }

    public static /* synthetic */ void applyIconColor$default(Button button, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        IconUtils.applyIconColor(button, n);
    }

    @JvmStatic
    public static final void applyIconColor(@NotNull Drawable $this$applyIconColor, @NotNull String hexIconColor, int defaultHexIconColor) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$applyIconColor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hexIconColor, (String)"hexIconColor");
        try {
            n = Color.parseColor((String)hexIconColor);
        }
        catch (IllegalArgumentException e) {
            n = defaultHexIconColor;
        }
        int color = n;
        $this$applyIconColor.setColorFilter(color, PorterDuff.Mode.SRC_IN);
    }

    public static /* synthetic */ void applyIconColor$default(Drawable drawable, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -16777216;
        }
        IconUtils.applyIconColor(drawable, string2, n);
    }

    @JvmStatic
    @NotNull
    public static final String getHexColor(int currentTextColor) {
        String string2 = "#%06X";
        Object[] objectArray = new Object[]{0xFFFFFF & currentTextColor};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    private static final void getIcon$lambda$1$lambda$0(Context $context, String $svgInfoURL, String $iconHexColor, long $iconSize, boolean $isFilledStyle, boolean $isRTL, Function1 $callback) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Intrinsics.checkNotNull((Object)$svgInfoURL);
        String string2 = $iconHexColor;
        if (string2 == null) {
            string2 = "#FFFFFF";
        }
        FluentIconUtils.INSTANCE.getFluentIcon($context, $svgInfoURL, string2, $iconSize, $isFilledStyle, $isRTL, (Function1<? super Drawable, Unit>)((Function1)new Function1<Drawable, Unit>((Function1<? super Drawable, Unit>)$callback){
            final /* synthetic */ Function1<Drawable, Unit> $callback;
            {
                this.$callback = $callback;
                super(1);
            }

            public final void invoke(@Nullable Drawable drawable) {
                this.$callback.invoke((Object)drawable);
            }
        }));
    }
}

