/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.layout;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.widget.TooltipCompat;
import com.google.android.flexbox.FlexboxLayout;
import io.adaptivecards.R;
import io.adaptivecards.objectmodel.Badge;
import io.adaptivecards.objectmodel.BadgeAppearance;
import io.adaptivecards.objectmodel.BadgeAppearanceDefinition;
import io.adaptivecards.objectmodel.BadgeSize;
import io.adaptivecards.objectmodel.BadgeStyle;
import io.adaptivecards.objectmodel.BadgeStyleDefinition;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.IconPosition;
import io.adaptivecards.objectmodel.Shape;
import io.adaptivecards.renderer.FluentIconImageLoaderAsync;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0005H\u0002J\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u0018\u001a\u00020\u000e*\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\n\u0010\u0019\u001a\u00020\u001a*\u00020\u0013J\f\u0010\u001b\u001a\u00020\u001c*\u00020\u0005H\u0002J\f\u0010\u001d\u001a\u00020\u001c*\u00020\u0005H\u0002J\f\u0010\u001e\u001a\u00020\u0015*\u00020\u0013H\u0002J,\u0010\u001f\u001a\u00020\f*\u00020 2\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006#"}, d2={"Lio/adaptivecards/renderer/layout/BadgeView;", "Lcom/google/android/flexbox/FlexboxLayout;", "context", "Landroid/content/Context;", "badge", "Lio/adaptivecards/objectmodel/Badge;", "renderedCard", "Lio/adaptivecards/renderer/RenderedAdaptiveCard;", "hostConfig", "Lio/adaptivecards/objectmodel/HostConfig;", "(Landroid/content/Context;Lio/adaptivecards/objectmodel/Badge;Lio/adaptivecards/renderer/RenderedAdaptiveCard;Lio/adaptivecards/objectmodel/HostConfig;)V", "addIconView", "", "badgeConfig", "Lio/adaptivecards/objectmodel/BadgeAppearanceDefinition;", "addTextView", "badgeText", "", "badgeSize", "Lio/adaptivecards/objectmodel/BadgeSize;", "getBackgroundCornerRadius", "", "getBackgroundDrawable", "Landroid/graphics/drawable/GradientDrawable;", "getBadgeConfig", "getIconSize", "", "getLeftPadding", "", "getRightPadding", "getTextSize", "loadIcon", "Landroid/widget/ImageView;", "icon", "Companion", "adaptivecards_release"})
@SourceDebugExtension(value={"SMAP\nBadgeView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BadgeView.kt\nio/adaptivecards/renderer/layout/BadgeView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1#2:219\n*E\n"})
public final class BadgeView
extends FlexboxLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final float ICON_PADDING = 8.0f;
    public static final float TEXT_PADDING = 6.0f;
    public static final float TEXT_MEDIUM = 12.0f;
    public static final float TEXT_LARGE = 14.0f;
    public static final float TEXT_XLARGE = 16.0f;
    public static final float CIRCULAR_RADIUS = 15.0f;
    public static final float ROUNDED_RADIUS = 4.0f;
    public static final long ICON_SIZE_M = 12L;
    public static final long ICON_SIZE_XL = 16L;

    /*
     * Unable to fully structure code
     */
    public BadgeView(@NotNull Context context, @NotNull Badge badge, @NotNull RenderedAdaptiveCard renderedCard, @NotNull HostConfig hostConfig) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)badge, (String)"badge");
        Intrinsics.checkNotNullParameter((Object)renderedCard, (String)"renderedCard");
        Intrinsics.checkNotNullParameter((Object)hostConfig, (String)"hostConfig");
        super(context);
        badgeConfig = this.getBadgeConfig(badge, hostConfig);
        this.setFlexDirection(0);
        this.setFlexWrap(0);
        this.setPadding(this.getLeftPadding(badge), context.getResources().getDimensionPixelOffset(R.dimen.badge_padding_top_bottom), this.getRightPadding(badge), context.getResources().getDimensionPixelOffset(R.dimen.badge_padding_top_bottom));
        this.setAlignItems(2);
        it = var7_6 = badge;
        $i$a$-takeIf-BadgeView$1 = false;
        v0 = it.GetBadgeIcon();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"GetBadgeIcon(...)");
        v1 = var6_10 = (StringsKt.isBlank((CharSequence)v0) == false != false && it.GetIconPosition() == IconPosition.Before) != false ? var7_6 : null;
        if (var6_10 != null) {
            it = var6_10;
            $i$a$-let-BadgeView$2 = false;
            this.addIconView(it, badgeConfig, renderedCard);
        }
        it = var7_6 = badge;
        $i$a$-takeIf-BadgeView$3 = false;
        v2 = it.GetText();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"GetText(...)");
        if (StringsKt.isBlank((CharSequence)v2) == false) ** GOTO lbl-1000
        v3 = it.GetBadgeIcon();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"GetBadgeIcon(...)");
        if (StringsKt.isBlank((CharSequence)v3)) lbl-1000:
        // 2 sources

        {
            v4 = true;
        } else {
            v4 = false;
        }
        v5 = v4 != false ? var7_6 : null;
        if (v5 != null) {
            it = v5;
            $i$a$-let-BadgeView$4 = false;
            v6 = badge.GetText();
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"GetText(...)");
            v7 = badge.GetBadgeSize();
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"GetBadgeSize(...)");
            this.addTextView(v6, v7, badgeConfig);
        }
        it = var7_6 = badge;
        $i$a$-takeIf-BadgeView$5 = false;
        v8 = it.GetBadgeIcon();
        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"GetBadgeIcon(...)");
        v9 = var6_10 = (StringsKt.isBlank((CharSequence)v8) == false != false && it.GetIconPosition() == IconPosition.After) != false ? var7_6 : null;
        if (var6_10 != null) {
            it = var6_10;
            $i$a$-let-BadgeView$6 = false;
            this.addIconView(it, badgeConfig, renderedCard);
        }
        if ((v10 = badge.GetTooltip()) != null) {
            it = var8_7 = v10;
            $i$a$-takeIf-BadgeView$7 = false;
            v10 = !StringsKt.isBlank((CharSequence)it) != false ? var8_7 : null;
            if (v10 != null) {
                it = v10;
                $i$a$-let-BadgeView$8 = false;
                TooltipCompat.setTooltipText((View)((View)this), (CharSequence)it);
            }
        }
        this.setBackground((Drawable)this.getBackgroundDrawable(badge, badgeConfig));
    }

    private final void addTextView(String badgeText, BadgeSize badgeSize, BadgeAppearanceDefinition badgeConfig) {
        TextView textView;
        TextView textView2 = new TextView(this.getContext());
        this.addView((View)textView2);
        TextView $this$addTextView_u24lambda_u248 = textView = textView2;
        boolean bl = false;
        $this$addTextView_u24lambda_u248.setText((CharSequence)badgeText);
        $this$addTextView_u24lambda_u248.setTextSize(2, this.getTextSize(badgeSize));
        $this$addTextView_u24lambda_u248.setTextColor(Color.parseColor((String)badgeConfig.getTextColor()));
        textView2.setPadding(Util.dpToPixels(this.getContext(), 6.0f), 0, Util.dpToPixels(this.getContext(), 6.0f), 0);
    }

    private final void addIconView(Badge badge, BadgeAppearanceDefinition badgeConfig, RenderedAdaptiveCard renderedCard) {
        ImageView iconView = new ImageView(this.getContext());
        this.addView((View)iconView);
        String string2 = badge.GetBadgeIcon();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GetBadgeIcon(...)");
        BadgeSize badgeSize = badge.GetBadgeSize();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)badgeSize), (String)"GetBadgeSize(...)");
        this.loadIcon(iconView, string2, badgeSize, badgeConfig, renderedCard);
    }

    private final void loadIcon(ImageView $this$loadIcon, String icon, BadgeSize badgeSize, BadgeAppearanceDefinition badgeConfig, RenderedAdaptiveCard renderedCard) {
        List iconInfo;
        String[] stringArray;
        Object iconName = icon;
        boolean isFilled = true;
        String[] it = stringArray = icon;
        boolean bl = false;
        Object object = StringsKt.contains$default((CharSequence)((CharSequence)it), (CharSequence)",", (boolean)false, (int)2, null) ? stringArray : null;
        if (object != null) {
            stringArray = new String[]{","};
            v1 = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        } else {
            v1 = iconInfo = null;
        }
        if (iconInfo != null && iconInfo.size() > 1) {
            iconName = (String)iconInfo.get(0);
            isFilled = Intrinsics.areEqual(iconInfo.get(1), (Object)"Filled");
        }
        String svgInfoURL = Util.getSvgInfoUrl((String)iconName + "/" + (String)iconName + ".json");
        String string2 = badgeConfig.getTextColor();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTextColor(...)");
        String foregroundColor = string2;
        long iconSize = this.getIconSize(badgeSize);
        FluentIconImageLoaderAsync fluentIconImageLoaderAsync = new FluentIconImageLoaderAsync(renderedCard, iconSize, foregroundColor, isFilled, (View)$this$loadIcon);
        Object[] objectArray = new String[]{svgInfoURL};
        fluentIconImageLoaderAsync.execute(objectArray);
    }

    private final int getLeftPadding(Badge $this$getLeftPadding) {
        String string2 = $this$getLeftPadding.GetBadgeIcon();
        if (string2 != null) {
            String string3;
            String string4;
            String it = string4 = string2;
            boolean bl = false;
            String string5 = string3 = !StringsKt.isBlank((CharSequence)it) ? string4 : null;
            if (string3 != null) {
                CharSequence charSequence;
                String it2 = string3;
                boolean bl2 = false;
                if ($this$getLeftPadding.GetIconPosition() == IconPosition.Before || (charSequence = (CharSequence)$this$getLeftPadding.GetText()) == null || charSequence.length() == 0) {
                    return Util.dpToPixels(this.getContext(), 8.0f);
                }
                return Util.dpToPixels(this.getContext(), 2.0f);
            }
        }
        return Util.dpToPixels(this.getContext(), 2.0f);
    }

    private final int getRightPadding(Badge $this$getRightPadding) {
        String string2 = $this$getRightPadding.GetBadgeIcon();
        if (string2 != null) {
            String string3;
            String string4;
            String it = string4 = string2;
            boolean bl = false;
            String string5 = string3 = !StringsKt.isBlank((CharSequence)it) ? string4 : null;
            if (string3 != null) {
                CharSequence charSequence;
                String it2 = string3;
                boolean bl2 = false;
                if ($this$getRightPadding.GetIconPosition() == IconPosition.After || (charSequence = (CharSequence)$this$getRightPadding.GetText()) == null || charSequence.length() == 0) {
                    return Util.dpToPixels(this.getContext(), 8.0f);
                }
                return Util.dpToPixels(this.getContext(), 2.0f);
            }
        }
        return Util.dpToPixels(this.getContext(), 2.0f);
    }

    private final float getTextSize(BadgeSize $this$getTextSize) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$getTextSize.ordinal()]) {
            case 1 -> 16.0f;
            case 2 -> 14.0f;
            default -> 12.0f;
        };
    }

    private final GradientDrawable getBackgroundDrawable(Badge $this$getBackgroundDrawable, BadgeAppearanceDefinition badgeConfig) {
        GradientDrawable gradientDrawable;
        GradientDrawable gradientDrawable2 = new GradientDrawable();
        int backgroundColor = Color.parseColor((String)badgeConfig.getBackgroundColor());
        GradientDrawable $this$getBackgroundDrawable_u24lambda_u2414 = gradientDrawable = gradientDrawable2;
        boolean bl = false;
        int[] nArray = new int[]{backgroundColor, backgroundColor};
        $this$getBackgroundDrawable_u24lambda_u2414.setColors(nArray);
        $this$getBackgroundDrawable_u24lambda_u2414.setCornerRadius((float)Util.dpToPixels(this.getContext(), this.getBackgroundCornerRadius($this$getBackgroundDrawable)));
        if ($this$getBackgroundDrawable.GetBadgeAppearance() == BadgeAppearance.Tint) {
            gradientDrawable2.setStroke(Util.dpToPixels(this.getContext(), 1.0f), Color.parseColor((String)badgeConfig.getStrokeColor()));
        }
        return gradientDrawable2;
    }

    private final float getBackgroundCornerRadius(Badge $this$getBackgroundCornerRadius) {
        Shape shape = $this$getBackgroundCornerRadius.GetShape();
        return switch (shape == null ? -1 : WhenMappings.$EnumSwitchMapping$1[shape.ordinal()]) {
            case 1 -> 0.0f;
            case 2 -> 4.0f;
            default -> 15.0f;
        };
    }

    private final BadgeAppearanceDefinition getBadgeConfig(Badge $this$getBadgeConfig, HostConfig hostConfig) {
        BadgeAppearanceDefinition badgeAppearanceDefinition;
        BadgeStyle badgeStyle = $this$getBadgeConfig.GetBadgeStyle();
        BadgeStyleDefinition badgePalette = switch (badgeStyle == null ? -1 : WhenMappings.$EnumSwitchMapping$2[badgeStyle.ordinal()]) {
            case 1 -> hostConfig.GetBadgeStyles().getAccentPalette();
            case 2 -> hostConfig.GetBadgeStyles().getAttentionPalette();
            case 3 -> hostConfig.GetBadgeStyles().getGoodPalette();
            case 4 -> hostConfig.GetBadgeStyles().getInformativePalette();
            case 5 -> hostConfig.GetBadgeStyles().getSubtlePalette();
            case 6 -> hostConfig.GetBadgeStyles().getWarningPalette();
            default -> hostConfig.GetBadgeStyles().getDefaultPalette();
        };
        BadgeAppearance badgeAppearance = $this$getBadgeConfig.GetBadgeAppearance();
        if ((badgeAppearance == null ? -1 : WhenMappings.$EnumSwitchMapping$3[badgeAppearance.ordinal()]) == 1) {
            BadgeAppearanceDefinition badgeAppearanceDefinition2 = badgePalette.getFilledStyle();
            badgeAppearanceDefinition = badgeAppearanceDefinition2;
            Intrinsics.checkNotNullExpressionValue((Object)badgeAppearanceDefinition2, (String)"getFilledStyle(...)");
        } else {
            BadgeAppearanceDefinition badgeAppearanceDefinition3 = badgePalette.getTintStyle();
            badgeAppearanceDefinition = badgeAppearanceDefinition3;
            Intrinsics.checkNotNullExpressionValue((Object)badgeAppearanceDefinition3, (String)"getTintStyle(...)");
        }
        return badgeAppearanceDefinition;
    }

    public final long getIconSize(@NotNull BadgeSize $this$getIconSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getIconSize), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$getIconSize.ordinal()]) {
            case 2, 3 -> 12L;
            default -> 16L;
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/adaptivecards/renderer/layout/BadgeView$Companion;", "", "()V", "CIRCULAR_RADIUS", "", "ICON_PADDING", "ICON_SIZE_M", "", "ICON_SIZE_XL", "ROUNDED_RADIUS", "TEXT_LARGE", "TEXT_MEDIUM", "TEXT_PADDING", "TEXT_XLARGE", "adaptivecards_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[BadgeSize.values().length];
            try {
                nArray[BadgeSize.ExtraLarge.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BadgeSize.Large.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BadgeSize.Medium.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Shape.values().length];
            try {
                nArray[Shape.Square.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Shape.Rounded.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[BadgeStyle.values().length];
            try {
                nArray[BadgeStyle.Accent.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BadgeStyle.Attention.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BadgeStyle.Good.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BadgeStyle.Informative.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BadgeStyle.Subtle.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BadgeStyle.Warning.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[BadgeAppearance.values().length];
            try {
                nArray[BadgeAppearance.Filled.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

