/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.layout.scrollingpage;

import android.animation.ArgbEvaluator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.viewpager2.widget.ViewPager2;
import io.adaptivecards.R;
import io.adaptivecards.renderer.layout.scrollingpage.IPagerAttacher;
import io.adaptivecards.renderer.layout.scrollingpage.ScrollingPageControlViewConfiguration;
import io.adaptivecards.renderer.layout.scrollingpage.ViewPager2Attacher;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020!2\u0006\u0010C\u001a\u00020\u0007H\u0002J)\u0010D\u001a\u00020A\"\u0004\b\u0000\u0010E2\u0006\u0010F\u001a\u0002HE2\f\u0010G\u001a\b\u0012\u0004\u0012\u0002HE0\u0010H\u0002\u00a2\u0006\u0002\u0010HJ\u000e\u0010D\u001a\u00020A2\u0006\u0010F\u001a\u00020IJ\u0010\u0010J\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020!H\u0003J\b\u0010K\u001a\u00020AH\u0002J\u0010\u0010L\u001a\u00020!2\u0006\u0010M\u001a\u00020\u0007H\u0002J\u0010\u0010N\u001a\u00020!2\u0006\u0010M\u001a\u00020\u0007H\u0002J\u0010\u0010O\u001a\u00020A2\u0006\u00101\u001a\u00020\u0007H\u0002J\u0010\u0010P\u001a\u00020A2\u0006\u0010Q\u001a\u00020RH\u0014J\u0018\u0010S\u001a\u00020A2\u0006\u0010T\u001a\u00020\u00072\u0006\u0010U\u001a\u00020\u0007H\u0014J\u0016\u0010V\u001a\u00020A2\u0006\u0010W\u001a\u00020\u00072\u0006\u0010B\u001a\u00020!J\u000e\u0010X\u001a\u00020A2\u0006\u0010Y\u001a\u00020\u0007J\u0006\u0010Z\u001a\u00020AJ\u0018\u0010[\u001a\u00020A2\u0006\u0010Y\u001a\u00020\u00072\u0006\u0010B\u001a\u00020!H\u0002J\u0018\u0010\\\u001a\u00020A2\u0006\u0010M\u001a\u00020\u00072\u0006\u0010]\u001a\u00020!H\u0002J\b\u0010^\u001a\u00020AH\u0003J\u000e\u0010_\u001a\u00020A2\u0006\u0010Y\u001a\u00020\u0007J\u0010\u0010`\u001a\u00020A2\u0006\u0010a\u001a\u00020\u0007H\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00078\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u0015\"\u0004\b\u001b\u0010\u0017R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\"\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b#\u0010\u0017R\u001e\u0010$\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b%\u0010\u0017R&\u0010&\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00078B@BX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0015\"\u0004\b(\u0010\u0017R\"\u0010*\u001a\u0004\u0018\u00010)2\b\u0010\u0012\u001a\u0004\u0018\u00010)@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u000e\u00101\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00102\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u001d@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b3\u00104R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u00107\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00078\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u0015\"\u0004\b9\u0010\u0017R\u001e\u0010:\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b;\u0010\u0017R\u001e\u0010<\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b=\u0010\u0017R\u000e\u0010>\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006b"}, d2={"Lio/adaptivecards/renderer/layout/scrollingpage/ScrollingPageControlView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "configuration", "Lio/adaptivecards/renderer/layout/scrollingpage/ScrollingPageControlViewConfiguration;", "(Landroid/content/Context;Landroid/util/AttributeSet;ILio/adaptivecards/renderer/layout/scrollingpage/ScrollingPageControlViewConfiguration;)V", "attachRunnable", "Ljava/lang/Runnable;", "colorEvaluator", "Landroid/animation/ArgbEvaluator;", "currentAttacher", "Lio/adaptivecards/renderer/layout/scrollingpage/IPagerAttacher;", "currentItemPosition", "value", "dotColor", "getDotColor", "()I", "setDotColor", "(I)V", "count", "dotCount", "getDotCount", "setDotCount", "dotCountInitialized", "", "dotMinimumSize", "dotScale", "Landroid/util/SparseArray;", "", "dotSelectedSize", "setDotSelectedSize", "dotSize", "setDotSize", "dotSpacing", "getDotSpacing", "setDotSpacing", "", "entityDescription", "setEntityDescription", "(Ljava/lang/String;)V", "firstDotOffset", "infiniteDotCount", "isRtl", "()Z", "itemCount", "looped", "setLooped", "(Z)V", "paint", "Landroid/graphics/Paint;", "selectedDotColor", "getSelectedDotColor", "setSelectedDotColor", "visibleDotCount", "setVisibleDotCount", "visibleDotThreshold", "setVisibleDotThreshold", "visibleFramePosition", "visibleFrameWidth", "adjustFramePosition", "", "offset", "pos", "attachToPager", "T", "pager", "attacher", "(Ljava/lang/Object;Lio/adaptivecards/renderer/layout/scrollingpage/IPagerAttacher;)V", "Landroidx/viewpager2/widget/ViewPager2;", "calculateDotColor", "detachFromPager", "getDotOffsetAt", "index", "getDotScaleAt", "initDots", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onPageScrolled", "page", "onPositionSelected", "position", "reattach", "scaleDotByOffset", "setDotScaleAt", "scale", "updateContentDescription", "updateIndicatorDotsAndPosition", "updateScaleInIdleState", "currentPos", "adaptivecards_release"})
@SourceDebugExtension(value={"SMAP\nScrollingPageControlView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrollingPageControlView.kt\nio/adaptivecards/renderer/layout/scrollingpage/ScrollingPageControlView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,417:1\n1#2:418\n*E\n"})
public final class ScrollingPageControlView
extends View {
    private int visibleDotCount;
    private int visibleDotThreshold;
    @ColorInt
    private int dotColor;
    @ColorInt
    private int selectedDotColor;
    private int dotMinimumSize;
    private int infiniteDotCount;
    private float visibleFramePosition;
    private float visibleFrameWidth;
    private float firstDotOffset;
    @NotNull
    private SparseArray<Float> dotScale;
    private int itemCount;
    private int currentItemPosition;
    @NotNull
    private final Paint paint;
    @NotNull
    private final ArgbEvaluator colorEvaluator;
    @Nullable
    private Runnable attachRunnable;
    @Nullable
    private IPagerAttacher<?> currentAttacher;
    private boolean dotCountInitialized;
    private boolean looped;
    private int dotSize;
    private int dotSelectedSize;
    private int dotSpacing;
    @Nullable
    private String entityDescription;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public ScrollingPageControlView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, @Nullable ScrollingPageControlViewConfiguration configuration) {
        void $this$paint_u24lambda_u241;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        Object object = configuration;
        this.visibleDotCount = object != null && (object = ((ScrollingPageControlViewConfiguration)object).getVisibleDotCount()) != null ? ((Integer)object).intValue() : this.getResources().getInteger(R.integer.scrollingpagecontrolview_visibleDotCount);
        Object object2 = configuration;
        this.visibleDotThreshold = object2 != null && (object2 = ((ScrollingPageControlViewConfiguration)object2).getVisibleDotThreshold()) != null ? ((Integer)object2).intValue() : this.getResources().getInteger(R.integer.scrollingpagecontrolview_visibleDotThreshold);
        ScrollingPageControlViewConfiguration scrollingPageControlViewConfiguration = configuration;
        this.dotColor = scrollingPageControlViewConfiguration != null ? scrollingPageControlViewConfiguration.getDotColor() : this.getResources().getColor(R.color.scrollingpagecontrolview_dotColor);
        ScrollingPageControlViewConfiguration scrollingPageControlViewConfiguration2 = configuration;
        this.selectedDotColor = scrollingPageControlViewConfiguration2 != null ? scrollingPageControlViewConfiguration2.getDotSelectedColor() : this.getResources().getColor(R.color.scrollingpagecontrolview_dotSelectedColor);
        Object object3 = configuration;
        this.dotMinimumSize = object3 != null && (object3 = ((ScrollingPageControlViewConfiguration)object3).getDotMinimumSize()) != null ? (Integer)object3 : -1;
        this.dotScale = new SparseArray();
        Paint paint2 = paint = new Paint();
        ScrollingPageControlView scrollingPageControlView = this;
        boolean bl = false;
        $this$paint_u24lambda_u241.setAntiAlias(true);
        scrollingPageControlView.paint = paint;
        this.colorEvaluator = new ArgbEvaluator();
        ScrollingPageControlViewConfiguration scrollingPageControlViewConfiguration3 = configuration;
        this.looped = scrollingPageControlViewConfiguration3 != null ? scrollingPageControlViewConfiguration3.getLooped() : false;
        Object object4 = configuration;
        this.dotSize = object4 != null && (object4 = ((ScrollingPageControlViewConfiguration)object4).getDotSize()) != null ? ((Integer)object4).intValue() : this.getResources().getDimensionPixelSize(R.dimen.scrollingpagecontrolview_diameter_unselected);
        Object object5 = configuration;
        this.dotSelectedSize = object5 != null && (object5 = ((ScrollingPageControlViewConfiguration)object5).getDotSelectedSize()) != null ? ((Integer)object5).intValue() : this.getResources().getDimensionPixelSize(R.dimen.scrollingpagecontrolview_diameter_selected);
        Object object6 = configuration;
        this.dotSpacing = object6 != null && (object6 = ((ScrollingPageControlViewConfiguration)object6).getDotSpacing()) != null ? ((Integer)object6).intValue() : this.getResources().getDimensionPixelSize(R.dimen.scrollingpagecontrolview_dotSpacing);
        ScrollingPageControlViewConfiguration scrollingPageControlViewConfiguration4 = configuration;
        this.entityDescription = scrollingPageControlViewConfiguration4 != null ? scrollingPageControlViewConfiguration4.getEntityDescription() : null;
    }

    public /* synthetic */ ScrollingPageControlView(Context context, AttributeSet attributeSet, int n, ScrollingPageControlViewConfiguration scrollingPageControlViewConfiguration, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            scrollingPageControlViewConfiguration = null;
        }
        this(context, attributeSet, n, scrollingPageControlViewConfiguration);
    }

    private final void setVisibleDotCount(int value) {
        if (!(value % 2 != 0)) {
            boolean bl = false;
            String string2 = "visibleDotCount must be odd";
            throw new IllegalArgumentException(string2.toString());
        }
        this.visibleDotCount = value;
        this.infiniteDotCount = this.visibleDotCount + 2;
        if (this.attachRunnable != null) {
            this.reattach();
        } else {
            this.requestLayout();
        }
    }

    private final void setVisibleDotThreshold(int value) {
        this.visibleDotThreshold = value;
        if (this.attachRunnable != null) {
            this.reattach();
        } else {
            this.requestLayout();
        }
    }

    public final int getDotColor() {
        return this.dotColor;
    }

    public final void setDotColor(int value) {
        this.dotColor = value;
        this.invalidate();
    }

    public final int getSelectedDotColor() {
        return this.selectedDotColor;
    }

    public final void setSelectedDotColor(int value) {
        this.selectedDotColor = value;
        this.invalidate();
    }

    private final boolean isRtl() {
        return this.getLayoutDirection() == 1;
    }

    private final void setLooped(boolean value) {
        this.looped = value;
        this.reattach();
        this.invalidate();
    }

    private final void setDotSize(int value) {
        this.dotSize = value;
        this.invalidate();
    }

    private final void setDotSelectedSize(int value) {
        this.dotSelectedSize = value;
        this.invalidate();
    }

    private final int getDotSpacing() {
        return this.dotSpacing + this.dotSize;
    }

    private final void setDotSpacing(int value) {
        this.dotSpacing = value;
        this.invalidate();
    }

    private final void setEntityDescription(String value) {
        this.entityDescription = value;
        this.updateContentDescription();
    }

    public final void attachToPager(@NotNull ViewPager2 pager) {
        Intrinsics.checkNotNullParameter((Object)pager, (String)"pager");
        this.attachToPager(pager, new ViewPager2Attacher());
    }

    private final <T> void attachToPager(T pager, IPagerAttacher<T> attacher) {
        this.detachFromPager();
        attacher.attachToPager(this, pager);
        this.currentAttacher = attacher;
        this.attachRunnable = () -> ScrollingPageControlView.attachToPager$lambda$2(this, pager, attacher);
    }

    private final void detachFromPager() {
        IPagerAttacher<?> iPagerAttacher = this.currentAttacher;
        if (iPagerAttacher != null) {
            iPagerAttacher.detachFromPager();
        }
        this.currentAttacher = null;
        this.attachRunnable = null;
        this.dotCountInitialized = false;
    }

    public final void reattach() {
        block0: {
            Runnable runnable = this.attachRunnable;
            if (runnable == null) break block0;
            Runnable it = runnable;
            boolean bl = false;
            it.run();
            this.invalidate();
        }
    }

    public final void onPageScrolled(int page, float offset) {
        int clampedPage;
        block8: {
            block7: {
                if (this.itemCount <= 0) {
                    return;
                }
                clampedPage = RangesKt.coerceIn((int)page, (int)0, (int)(this.itemCount - 1));
                if (!this.looped) break block7;
                int n = this.visibleDotCount;
                int n2 = this.itemCount;
                boolean bl = 2 <= n2 ? n2 <= n : false;
                if (!bl) break block8;
            }
            this.dotScale.clear();
            this.scaleDotByOffset(clampedPage, offset);
            if (clampedPage < this.itemCount - 1) {
                this.scaleDotByOffset(clampedPage + 1, 1.0f - offset);
            } else if (this.itemCount > 1) {
                this.scaleDotByOffset(0, 1.0f - offset);
            }
            this.invalidate();
        }
        this.adjustFramePosition(offset, clampedPage);
        this.invalidate();
    }

    public final void onPositionSelected(int position) {
        int clampedItemPosition;
        if (this.itemCount == 0) {
            return;
        }
        this.currentItemPosition = clampedItemPosition = RangesKt.coerceIn((int)position, (int)0, (int)(this.itemCount - 1));
        this.updateContentDescription();
    }

    public final void updateIndicatorDotsAndPosition(int position) {
        if (this.itemCount == 0) {
            return;
        }
        int clampedPosition = RangesKt.coerceIn((int)position, (int)0, (int)(this.itemCount - 1));
        this.adjustFramePosition(0.0f, clampedPosition);
        this.updateScaleInIdleState(clampedPosition);
    }

    @SuppressLint(value={"StringFormatMatches"})
    private final void updateContentDescription() {
        Object object;
        block3: {
            block2: {
                object = this.entityDescription;
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string2 = it + " ";
                object = string2;
                if (string2 != null) break block3;
            }
            object = "";
        }
        String prefix = object;
        Object[] objectArray = new Object[]{this.currentItemPosition + 1, this.itemCount};
        this.setContentDescription(prefix + this.getContext().getString(R.string.page_control_page_index, objectArray));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measuredWidth = this.itemCount >= this.visibleDotCount ? (int)this.visibleFrameWidth : (this.itemCount - 1) * this.getDotSpacing() + this.dotSelectedSize;
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int desiredHeight = this.dotSelectedSize;
        int measuredHeight = switch (heightMode) {
            case 0x40000000 -> heightSize;
            case Integer.MIN_VALUE -> RangesKt.coerceAtMost((int)desiredHeight, (int)heightSize);
            case 0 -> desiredHeight;
            default -> desiredHeight;
        };
        this.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        int n;
        int i;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Integer n2 = this.getDotCount();
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = !(it < this.visibleDotThreshold) ? n2 : null;
        if (n3 == null) {
            return;
        }
        int dotCount = n3;
        float scaleDistance = (float)(this.getDotSpacing() + (this.dotSelectedSize - this.dotSize) / 2) * 0.7f;
        float smallScaleDistance = this.dotSelectedSize / 2;
        float centerScaleDistance = 0.85714287f * (float)this.getDotSpacing();
        int firstVisibleDotPos = (int)(this.visibleFramePosition - this.firstDotOffset) / this.getDotSpacing();
        int lastVisibleDotPos = firstVisibleDotPos + (int)(this.visibleFramePosition + this.visibleFrameWidth - this.getDotOffsetAt(firstVisibleDotPos)) / this.getDotSpacing();
        if (firstVisibleDotPos == 0 && lastVisibleDotPos + 1 > dotCount) {
            lastVisibleDotPos = dotCount - 1;
        }
        if ((i = firstVisibleDotPos) <= (n = lastVisibleDotPos)) {
            while (true) {
                float dot;
                if ((dot = this.getDotOffsetAt(i)) >= this.visibleFramePosition && dot < this.visibleFramePosition + this.visibleFrameWidth) {
                    float frameCenter;
                    float diameter = 0.0f;
                    float scale = this.looped && this.itemCount > this.visibleDotCount ? (dot >= (frameCenter = this.visibleFramePosition + this.visibleFrameWidth / (float)2) - centerScaleDistance && dot <= frameCenter ? (dot - frameCenter + centerScaleDistance) / centerScaleDistance : (dot > frameCenter && dot < frameCenter + centerScaleDistance ? 1.0f - (dot - frameCenter) / centerScaleDistance : 0.0f)) : this.getDotScaleAt(i);
                    diameter = (float)this.dotSize + (float)(this.dotSelectedSize - this.dotSize) * scale;
                    if (this.itemCount > this.visibleDotCount) {
                        float currentScaleDistance = !this.looped && (i == 0 || i == dotCount - 1) ? smallScaleDistance : scaleDistance;
                        int size = this.getWidth();
                        if (dot - this.visibleFramePosition < currentScaleDistance) {
                            calculatedDiameter = diameter * (dot - this.visibleFramePosition) / currentScaleDistance;
                            if (calculatedDiameter <= (float)this.dotMinimumSize) {
                                diameter = this.dotMinimumSize;
                            } else if (calculatedDiameter < diameter) {
                                diameter = calculatedDiameter;
                            }
                        } else if (dot - this.visibleFramePosition > (float)size - currentScaleDistance) {
                            calculatedDiameter = diameter * (-dot + this.visibleFramePosition + (float)size) / currentScaleDistance;
                            if (calculatedDiameter <= (float)this.dotMinimumSize) {
                                diameter = this.dotMinimumSize;
                            } else if (calculatedDiameter < diameter) {
                                diameter = calculatedDiameter;
                            }
                        }
                    }
                    this.paint.setColor(this.calculateDotColor(scale));
                    float cx = dot - this.visibleFramePosition;
                    if (this.isRtl()) {
                        cx = (float)this.getWidth() - cx;
                    }
                    canvas.drawCircle(cx, (float)(this.getMeasuredHeight() / 2), diameter / (float)2, this.paint);
                }
                if (i == n) break;
                ++i;
            }
        }
    }

    @ColorInt
    private final int calculateDotColor(float dotScale) {
        Object object = this.colorEvaluator.evaluate(dotScale, (Object)this.dotColor, (Object)this.selectedDotColor);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        return (Integer)object;
    }

    private final void updateScaleInIdleState(int currentPos) {
        if (!this.looped || this.itemCount < this.visibleDotCount) {
            this.dotScale.clear();
            this.dotScale.put(currentPos, (Object)Float.valueOf(1.0f));
            this.invalidate();
        }
    }

    private final void initDots(int itemCount) {
        if (this.itemCount == itemCount && this.dotCountInitialized) {
            return;
        }
        this.itemCount = itemCount;
        this.updateContentDescription();
        this.dotCountInitialized = true;
        this.dotScale = new SparseArray();
        if (itemCount < this.visibleDotThreshold) {
            this.requestLayout();
            this.invalidate();
            return;
        }
        this.firstDotOffset = this.looped && this.itemCount > this.visibleDotCount ? 0.0f : (float)this.dotSelectedSize / 2.0f;
        this.visibleFrameWidth = (this.visibleDotCount - 1) * this.getDotSpacing() + this.dotSelectedSize;
        this.requestLayout();
        this.invalidate();
    }

    public final int getDotCount() {
        return this.looped && this.itemCount > this.visibleDotCount ? this.infiniteDotCount : this.itemCount;
    }

    public final void setDotCount(int count) {
        this.initDots(count);
    }

    private final void adjustFramePosition(float offset, int pos) {
        if (this.itemCount <= this.visibleDotCount) {
            this.visibleFramePosition = 0.0f;
        } else if (!this.looped && this.itemCount > this.visibleDotCount) {
            float center = this.getDotOffsetAt(pos) + (float)this.getDotSpacing() * offset;
            this.visibleFramePosition = center - this.visibleFrameWidth / (float)2;
            int firstCenteredDotIndex = this.visibleDotCount / 2;
            float lastCenteredDot = this.getDotOffsetAt(this.getDotCount() - 1 - firstCenteredDotIndex);
            if (this.visibleFramePosition + this.visibleFrameWidth / (float)2 < this.getDotOffsetAt(firstCenteredDotIndex)) {
                this.visibleFramePosition = this.getDotOffsetAt(firstCenteredDotIndex) - this.visibleFrameWidth / (float)2;
            } else if (this.visibleFramePosition + this.visibleFrameWidth / (float)2 > lastCenteredDot) {
                this.visibleFramePosition = lastCenteredDot - this.visibleFrameWidth / (float)2;
            }
        } else {
            float center = this.getDotOffsetAt(this.infiniteDotCount / 2) + (float)this.getDotSpacing() * offset;
            this.visibleFramePosition = center - this.visibleFrameWidth / (float)2;
        }
    }

    private final void scaleDotByOffset(int position, float offset) {
        if (this.getDotCount() == 0) {
            return;
        }
        this.setDotScaleAt(position, 1.0f - Math.abs(offset));
    }

    private final float getDotOffsetAt(int index) {
        return this.firstDotOffset + (float)(index * this.getDotSpacing());
    }

    private final float getDotScaleAt(int index) {
        Float f = (Float)this.dotScale.get(index);
        return f == null ? 0.0f : f.floatValue();
    }

    private final void setDotScaleAt(int index, float scale) {
        if (scale == 0.0f) {
            this.dotScale.remove(index);
        } else {
            this.dotScale.put(index, (Object)Float.valueOf(scale));
        }
    }

    @JvmOverloads
    public ScrollingPageControlView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, defStyleAttr, null, 8, null);
    }

    @JvmOverloads
    public ScrollingPageControlView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, null, 12, null);
    }

    @JvmOverloads
    public ScrollingPageControlView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, null, 14, null);
    }

    private static final void attachToPager$lambda$2(ScrollingPageControlView this$0, Object $pager, IPagerAttacher $attacher) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$attacher, (String)"$attacher");
        this$0.itemCount = -1;
        this$0.attachToPager($pager, $attacher);
    }
}

