/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import io.adaptivecards.objectmodel.DateTimePreparsedToken;
import io.adaptivecards.objectmodel.DateTimePreparsedTokenFormat;
import io.adaptivecards.objectmodel.DateTimePreparsedTokenVector;
import io.adaptivecards.objectmodel.DateTimePreparser;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateTimeParser {
    private Locale m_language;

    public DateTimeParser(String language) {
        this.m_language = new Locale(language);
    }

    public String GenerateString(DateTimePreparser text) {
        String parsedString = new String();
        DateTimePreparsedTokenVector textSections = text.GetTextTokens();
        long textSectionLength = textSections.size();
        int i = 0;
        while ((long)i < textSectionLength) {
            DateTimePreparsedToken ts = textSections.get(i);
            Date dateToParse = this.FormatDate(ts.GetYear(), ts.GetMonth(), ts.GetDay());
            if (ts.GetFormat() == DateTimePreparsedTokenFormat.DateCompact) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
                parsedString = parsedString + dateFormat.format(dateToParse);
            } else if (ts.GetFormat() == DateTimePreparsedTokenFormat.DateShort) {
                localizedFormat = new SimpleDateFormat("EEE, MMM dd, yyyy", this.m_language);
                parsedString = parsedString + localizedFormat.format(dateToParse);
            } else if (ts.GetFormat() == DateTimePreparsedTokenFormat.DateLong) {
                localizedFormat = new SimpleDateFormat("EEEE, MMMM dd, yyyy", this.m_language);
                parsedString = parsedString + localizedFormat.format(dateToParse);
            } else {
                parsedString = parsedString + ts.GetText();
            }
            ++i;
        }
        return parsedString;
    }

    private Date FormatDate(int year, int month, int day) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        try {
            String rawDate = month + 1 + "/" + day + "/" + year;
            return dateFormat.parse(rawDate, new ParsePosition(0));
        }
        catch (Exception e) {
            return new Date();
        }
    }
}

