/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import io.adaptivecards.objectmodel.HorizontalContentAlignment;
import io.adaptivecards.objectmodel.Image;
import io.adaptivecards.objectmodel.ImageFitMode;
import io.adaptivecards.objectmodel.VerticalContentAlignment;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lio/adaptivecards/renderer/readonly/ImageRendererKt;", "", "()V", "setImageFitMode", "", "image", "Lio/adaptivecards/objectmodel/Image;", "imageView", "Landroid/widget/ImageView;", "adaptivecards_release"})
public final class ImageRendererKt {
    @NotNull
    public static final ImageRendererKt INSTANCE = new ImageRendererKt();

    private ImageRendererKt() {
    }

    @JvmStatic
    public static final void setImageFitMode(@NotNull Image image, @NotNull ImageView imageView) {
        ImageFitMode imageFitMode;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        if (image.GetPixelWidth() <= 0L || image.GetPixelHeight() <= 0L) {
            return;
        }
        ImageFitMode imageFitMode2 = image.GetImageFitMode();
        if (imageFitMode2 == null) {
            imageFitMode2 = ImageFitMode.Fill;
        }
        if ((imageFitMode = imageFitMode2) == ImageFitMode.Fill) {
            imageView.setScaleType(ImageView.ScaleType.FIT_XY);
            return;
        }
        imageView.setScaleType(ImageView.ScaleType.MATRIX);
        imageView.getViewTreeObserver().addOnGlobalLayoutListener(() -> ImageRendererKt.setImageFitMode$lambda$0(imageView, image));
    }

    private static final void setImageFitMode$lambda$0(ImageView $imageView, Image $image) {
        float f;
        Intrinsics.checkNotNullParameter((Object)$imageView, (String)"$imageView");
        Intrinsics.checkNotNullParameter((Object)$image, (String)"$image");
        Drawable drawable2 = $imageView.getDrawable();
        if (drawable2 == null) {
            return;
        }
        Drawable drawable3 = drawable2;
        float viewWidth = $imageView.getWidth();
        float viewHeight = $imageView.getHeight();
        int dWidth = drawable3.getIntrinsicWidth();
        int dHeight = drawable3.getIntrinsicHeight();
        ImageFitMode imageFitMode = $image.GetImageFitMode();
        switch (imageFitMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[imageFitMode.ordinal()]) {
            case 1: {
                f = (float)Math.min((double)(viewWidth / (float)dWidth), (double)(viewHeight / (float)dHeight));
                break;
            }
            case 2: {
                f = (float)Math.max((double)(viewWidth / (float)dWidth), (double)(viewHeight / (float)dHeight));
                break;
            }
            default: {
                return;
            }
        }
        float scale = f;
        float scaledWidth = scale * (float)dWidth;
        float scaledHeight = scale * (float)dHeight;
        HorizontalContentAlignment horizontalContentAlignment = $image.GetHorizontalContentAlignment();
        if (horizontalContentAlignment == null) {
            horizontalContentAlignment = HorizontalContentAlignment.Left;
        }
        float dx = switch (WhenMappings.$EnumSwitchMapping$1[horizontalContentAlignment.ordinal()]) {
            case 1 -> 0.0f;
            case 2 -> (viewWidth - scaledWidth) / 2.0f;
            case 3 -> viewWidth - scaledWidth;
            default -> throw new NoWhenBranchMatchedException();
        };
        VerticalContentAlignment verticalContentAlignment = $image.GetVerticalContentAlignment();
        if (verticalContentAlignment == null) {
            verticalContentAlignment = VerticalContentAlignment.Top;
        }
        float dy = switch (WhenMappings.$EnumSwitchMapping$2[verticalContentAlignment.ordinal()]) {
            case 1 -> 0.0f;
            case 2 -> (viewHeight - scaledHeight) / 2.0f;
            case 3 -> viewHeight - scaledHeight;
            default -> throw new NoWhenBranchMatchedException();
        };
        Matrix matrix = new Matrix();
        matrix.setScale(scale, scale);
        matrix.postTranslate(dx, dy);
        $imageView.setImageMatrix(matrix);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[ImageFitMode.values().length];
            try {
                nArray[ImageFitMode.Contain.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageFitMode.Cover.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[HorizontalContentAlignment.values().length];
            try {
                nArray[HorizontalContentAlignment.Left.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HorizontalContentAlignment.Center.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HorizontalContentAlignment.Right.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[VerticalContentAlignment.values().length];
            try {
                nArray[VerticalContentAlignment.Top.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerticalContentAlignment.Center.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerticalContentAlignment.Bottom.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

