/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.graphics.Color;
import com.google.android.flexbox.FlexboxLayout;
import io.adaptivecards.objectmodel.HorizontalAlignment;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.RatingColor;
import io.adaptivecards.renderer.RenderArgs;
import java.text.NumberFormat;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fJ\u001e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u001a"}, d2={"Lio/adaptivecards/renderer/readonly/RatingElementRendererUtil;", "", "()V", "applyHorizontalAlignment", "", "view", "Lcom/google/android/flexbox/FlexboxLayout;", "horizontalAlignment", "Lio/adaptivecards/objectmodel/HorizontalAlignment;", "renderArgs", "Lio/adaptivecards/renderer/RenderArgs;", "formatNumberWithCommas", "", "number", "", "getColorFromHexCode", "", "hexcode", "getInputStarColor", "color", "Lio/adaptivecards/objectmodel/RatingColor;", "isActivated", "", "hostConfig", "Lio/adaptivecards/objectmodel/HostConfig;", "getReadOnlyStarColor", "adaptivecards_release"})
public final class RatingElementRendererUtil {
    @NotNull
    public static final RatingElementRendererUtil INSTANCE = new RatingElementRendererUtil();

    private RatingElementRendererUtil() {
    }

    public final int getInputStarColor(@NotNull RatingColor color2, boolean isActivated, @NotNull HostConfig hostConfig) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)color2), (String)"color");
        Intrinsics.checkNotNullParameter((Object)hostConfig, (String)"hostConfig");
        if (isActivated) {
            if (WhenMappings.$EnumSwitchMapping$0[color2.ordinal()] == 1) {
                String string2 = hostConfig.GetRatingInputConfig().getFilledStar().getMarigoldColor();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMarigoldColor(...)");
                n = this.getColorFromHexCode(string2);
            } else {
                String string3 = hostConfig.GetRatingInputConfig().getFilledStar().getNeutralColor();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getNeutralColor(...)");
                n = this.getColorFromHexCode(string3);
            }
        } else if (WhenMappings.$EnumSwitchMapping$0[color2.ordinal()] == 1) {
            String string4 = hostConfig.GetRatingInputConfig().getEmptyStar().getMarigoldColor();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getMarigoldColor(...)");
            n = this.getColorFromHexCode(string4);
        } else {
            String string5 = hostConfig.GetRatingInputConfig().getEmptyStar().getNeutralColor();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getNeutralColor(...)");
            n = this.getColorFromHexCode(string5);
        }
        return n;
    }

    public final int getReadOnlyStarColor(@NotNull RatingColor color2, boolean isActivated, @NotNull HostConfig hostConfig) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)color2), (String)"color");
        Intrinsics.checkNotNullParameter((Object)hostConfig, (String)"hostConfig");
        if (isActivated) {
            if (WhenMappings.$EnumSwitchMapping$0[color2.ordinal()] == 1) {
                String string2 = hostConfig.GetRatingLabelConfig().getFilledStar().getMarigoldColor();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMarigoldColor(...)");
                n = this.getColorFromHexCode(string2);
            } else {
                String string3 = hostConfig.GetRatingLabelConfig().getFilledStar().getNeutralColor();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getNeutralColor(...)");
                n = this.getColorFromHexCode(string3);
            }
        } else if (WhenMappings.$EnumSwitchMapping$0[color2.ordinal()] == 1) {
            String string4 = hostConfig.GetRatingLabelConfig().getEmptyStar().getMarigoldColor();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getMarigoldColor(...)");
            n = this.getColorFromHexCode(string4);
        } else {
            String string5 = hostConfig.GetRatingLabelConfig().getEmptyStar().getNeutralColor();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getNeutralColor(...)");
            n = this.getColorFromHexCode(string5);
        }
        return n;
    }

    @NotNull
    public final String formatNumberWithCommas(long number) {
        String string2 = NumberFormat.getNumberInstance(Locale.getDefault()).format(number);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public final int getColorFromHexCode(@NotNull String hexcode) {
        int n;
        Intrinsics.checkNotNullParameter((Object)hexcode, (String)"hexcode");
        try {
            n = Color.parseColor((String)hexcode);
        }
        catch (IllegalArgumentException e) {
            n = -16777216;
        }
        return n;
    }

    public final void applyHorizontalAlignment(@NotNull FlexboxLayout view, @Nullable HorizontalAlignment horizontalAlignment, @NotNull RenderArgs renderArgs) {
        HorizontalAlignment horizontalAlignment2;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)renderArgs, (String)"renderArgs");
        HorizontalAlignment horizontalAlignment3 = horizontalAlignment;
        if (horizontalAlignment3 == null) {
            horizontalAlignment3 = horizontalAlignment2 = renderArgs.getHorizontalAlignment();
        }
        if (horizontalAlignment3 == null) {
            horizontalAlignment2 = HorizontalAlignment.Left;
        }
        switch (WhenMappings.$EnumSwitchMapping$1[horizontalAlignment2.ordinal()]) {
            case 1: {
                view.setJustifyContent(2);
                break;
            }
            case 2: {
                view.setJustifyContent(1);
                break;
            }
            default: {
                view.setJustifyContent(0);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RatingColor.values().length];
            try {
                nArray[RatingColor.Marigold.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[HorizontalAlignment.values().length];
            try {
                nArray[HorizontalAlignment.Center.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HorizontalAlignment.Right.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

