/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk;

import io.adtrace.sdk.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import org.json.JSONObject;

public class AdTraceAttribution
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("trackerToken", String.class), new ObjectStreamField("trackerName", String.class), new ObjectStreamField("network", String.class), new ObjectStreamField("campaign", String.class), new ObjectStreamField("adgroup", String.class), new ObjectStreamField("creative", String.class), new ObjectStreamField("clickLabel", String.class), new ObjectStreamField("adid", String.class), new ObjectStreamField("costType", String.class), new ObjectStreamField("costAmount", Double.class), new ObjectStreamField("costCurrency", String.class)};
    public String trackerToken;
    public String trackerName;
    public String network;
    public String campaign;
    public String adgroup;
    public String creative;
    public String clickLabel;
    public String adid;
    public String costType;
    public Double costAmount;
    public String costCurrency;

    public static AdTraceAttribution fromJson(JSONObject jsonObject, String adid, String sdkPlatform) {
        if (jsonObject == null) {
            return null;
        }
        AdTraceAttribution attribution = new AdTraceAttribution();
        if ("unity".equals(sdkPlatform)) {
            attribution.trackerToken = jsonObject.optString("tracker_token", "");
            attribution.trackerName = jsonObject.optString("tracker_name", "");
            attribution.network = jsonObject.optString("network", "");
            attribution.campaign = jsonObject.optString("campaign", "");
            attribution.adgroup = jsonObject.optString("adgroup", "");
            attribution.creative = jsonObject.optString("creative", "");
            attribution.clickLabel = jsonObject.optString("click_label", "");
            attribution.adid = adid != null ? adid : "";
            attribution.costType = jsonObject.optString("cost_type", "");
            attribution.costAmount = jsonObject.optDouble("cost_amount", 0.0);
            attribution.costCurrency = jsonObject.optString("cost_currency", "");
        } else {
            attribution.trackerToken = jsonObject.optString("tracker_token");
            attribution.trackerName = jsonObject.optString("tracker_name");
            attribution.network = jsonObject.optString("network");
            attribution.campaign = jsonObject.optString("campaign");
            attribution.adgroup = jsonObject.optString("adgroup");
            attribution.creative = jsonObject.optString("creative");
            attribution.clickLabel = jsonObject.optString("click_label");
            attribution.adid = adid;
            attribution.costType = jsonObject.optString("cost_type");
            attribution.costAmount = jsonObject.optDouble("cost_amount");
            attribution.costCurrency = jsonObject.optString("cost_currency");
        }
        return attribution;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        AdTraceAttribution otherAttribution = (AdTraceAttribution)other;
        if (!Util.equalString(this.trackerToken, otherAttribution.trackerToken)) {
            return false;
        }
        if (!Util.equalString(this.trackerName, otherAttribution.trackerName)) {
            return false;
        }
        if (!Util.equalString(this.network, otherAttribution.network)) {
            return false;
        }
        if (!Util.equalString(this.campaign, otherAttribution.campaign)) {
            return false;
        }
        if (!Util.equalString(this.adgroup, otherAttribution.adgroup)) {
            return false;
        }
        if (!Util.equalString(this.creative, otherAttribution.creative)) {
            return false;
        }
        if (!Util.equalString(this.clickLabel, otherAttribution.clickLabel)) {
            return false;
        }
        if (!Util.equalString(this.adid, otherAttribution.adid)) {
            return false;
        }
        if (!Util.equalString(this.costType, otherAttribution.costType)) {
            return false;
        }
        if (!Util.equalsDouble(this.costAmount, otherAttribution.costAmount)) {
            return false;
        }
        return Util.equalString(this.costCurrency, otherAttribution.costCurrency);
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 37 * hashCode + Util.hashString(this.trackerToken);
        hashCode = 37 * hashCode + Util.hashString(this.trackerName);
        hashCode = 37 * hashCode + Util.hashString(this.network);
        hashCode = 37 * hashCode + Util.hashString(this.campaign);
        hashCode = 37 * hashCode + Util.hashString(this.adgroup);
        hashCode = 37 * hashCode + Util.hashString(this.creative);
        hashCode = 37 * hashCode + Util.hashString(this.clickLabel);
        hashCode = 37 * hashCode + Util.hashString(this.adid);
        hashCode = 37 * hashCode + Util.hashString(this.costType);
        hashCode = 37 * hashCode + Util.hashDouble(this.costAmount);
        hashCode = 37 * hashCode + Util.hashString(this.costCurrency);
        return hashCode;
    }

    public String toString() {
        return Util.formatString("tt:%s tn:%s net:%s cam:%s adg:%s cre:%s cl:%s adid:%s ct:%s ca:%.2f cc:%s", this.trackerToken, this.trackerName, this.network, this.campaign, this.adgroup, this.creative, this.clickLabel, this.adid, this.costType, this.costAmount, this.costCurrency);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        stream.defaultReadObject();
    }
}

