/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk;

import android.content.Context;
import android.net.Uri;
import io.adtrace.sdk.AdTraceAdRevenue;
import io.adtrace.sdk.AdTraceAttribution;
import io.adtrace.sdk.AdTraceConfig;
import io.adtrace.sdk.AdTraceEvent;
import io.adtrace.sdk.AdTraceFactory;
import io.adtrace.sdk.AdTraceInstance;
import io.adtrace.sdk.AdTracePlayStoreSubscription;
import io.adtrace.sdk.AdTraceTestOptions;
import io.adtrace.sdk.AdTraceThirdPartySharing;
import io.adtrace.sdk.OnDeviceIdsRead;
import io.adtrace.sdk.Util;
import org.json.JSONObject;

public class AdTrace {
    private static AdTraceInstance defaultInstance;

    private AdTrace() {
    }

    public static synchronized AdTraceInstance getDefaultInstance() {
        String VERSION2 = "!SDK-VERSION-STRING!:io.adtrace.sdk:AdTrace-android:2.2.0";
        if (defaultInstance == null) {
            defaultInstance = new AdTraceInstance();
        }
        return defaultInstance;
    }

    public static void onCreate(AdTraceConfig adTraceConfig) {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.onCreate(adTraceConfig);
    }

    public static void trackEvent(AdTraceEvent event) {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.trackEvent(event);
    }

    public static void onResume() {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.onResume();
    }

    public static void onPause() {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.onPause();
    }

    public static void setEnabled(boolean enabled) {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.setEnabled(enabled);
    }

    public static boolean isEnabled() {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        return adTraceInstance.isEnabled();
    }

    @Deprecated
    public static void appWillOpenUrl(Uri url) {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.appWillOpenUrl(url);
    }

    public static void appWillOpenUrl(Uri url, Context context) {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.appWillOpenUrl(url, context);
    }

    public static void setReferrer(String referrer, Context context) {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.sendReferrer(referrer, context);
    }

    public static void setOfflineMode(boolean enabled) {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.setOfflineMode(enabled);
    }

    public static void sendFirstPackages() {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.sendFirstPackages();
    }

    public static void addSessionCallbackParameter(String key, String value) {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.addSessionCallbackParameter(key, value);
    }

    public static void addSessionPartnerParameter(String key, String value) {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.addSessionPartnerParameter(key, value);
    }

    public static void removeSessionCallbackParameter(String key) {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.removeSessionCallbackParameter(key);
    }

    public static void removeSessionPartnerParameter(String key) {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.removeSessionPartnerParameter(key);
    }

    public static void resetSessionCallbackParameters() {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.resetSessionCallbackParameters();
    }

    public static void resetSessionPartnerParameters() {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.resetSessionPartnerParameters();
    }

    public static void setPushToken(String token) {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.setPushToken(token);
    }

    public static void setPushToken(String token, Context context) {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.setPushToken(token, context);
    }

    public static void gdprForgetMe(Context context) {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.gdprForgetMe(context);
    }

    public static void disableThirdPartySharing(Context context) {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.disableThirdPartySharing(context);
    }

    public static void trackThirdPartySharing(AdTraceThirdPartySharing adTraceThirdPartySharing) {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.trackThirdPartySharing(adTraceThirdPartySharing);
    }

    public static void trackMeasurementConsent(boolean consentMeasurement) {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.trackMeasurementConsent(consentMeasurement);
    }

    public static void trackAdRevenue(String source, JSONObject payload) {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.trackAdRevenue(source, payload);
    }

    public static void trackAdRevenue(AdTraceAdRevenue adtraceAdRevenue) {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.trackAdRevenue(adtraceAdRevenue);
    }

    public static void trackPlayStoreSubscription(AdTracePlayStoreSubscription subscription) {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.trackPlayStoreSubscription(subscription);
    }

    public static void getGoogleAdId(Context context, OnDeviceIdsRead onDeviceIdRead) {
        Context appContext = null;
        if (context != null) {
            appContext = context.getApplicationContext();
        }
        Util.getGoogleAdId(appContext, onDeviceIdRead);
    }

    public static String getAmazonAdId(Context context) {
        Context appContext = AdTrace.extractApplicationContext(context);
        if (appContext != null) {
            return Util.getFireAdvertisingId(appContext.getContentResolver());
        }
        return null;
    }

    public static String getAdid() {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        return adTraceInstance.getAdid();
    }

    public static AdTraceAttribution getAttribution() {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        return adTraceInstance.getAttribution();
    }

    public static String getSdkVersion() {
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        return adTraceInstance.getSdkVersion();
    }

    public static void setTestOptions(AdTraceTestOptions testOptions) {
        if (testOptions.teardown != null && testOptions.teardown.booleanValue()) {
            if (defaultInstance != null) {
                defaultInstance.teardown();
            }
            defaultInstance = null;
            AdTraceFactory.teardown(testOptions.context);
        }
        AdTraceInstance adTraceInstance = AdTrace.getDefaultInstance();
        adTraceInstance.setTestOptions(testOptions);
    }

    private static Context extractApplicationContext(Context context) {
        if (context == null) {
            return null;
        }
        return context.getApplicationContext();
    }
}

