/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk;

import android.content.Context;
import android.net.Uri;
import io.adtrace.sdk.ActivityHandler;
import io.adtrace.sdk.AdTraceAdRevenue;
import io.adtrace.sdk.AdTraceAttribution;
import io.adtrace.sdk.AdTraceConfig;
import io.adtrace.sdk.AdTraceEvent;
import io.adtrace.sdk.AdTraceFactory;
import io.adtrace.sdk.AdTracePlayStoreSubscription;
import io.adtrace.sdk.AdTraceTestOptions;
import io.adtrace.sdk.AdTraceThirdPartySharing;
import io.adtrace.sdk.BackoffStrategy;
import io.adtrace.sdk.IActivityHandler;
import io.adtrace.sdk.IRunActivityHandler;
import io.adtrace.sdk.SharedPreferencesManager;
import io.adtrace.sdk.Util;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class AdTraceInstance {
    private String pushToken;
    private Boolean startEnabled = null;
    private boolean startOffline = false;
    private IActivityHandler activityHandler;
    private PreLaunchActions preLaunchActions = new PreLaunchActions();
    private String basePath;
    private String gdprPath;
    private String subscriptionPath;

    public void onCreate(AdTraceConfig adTraceConfig) {
        if (adTraceConfig == null) {
            AdTraceFactory.getLogger().error("AdTraceConfig missing", new Object[0]);
            return;
        }
        if (!adTraceConfig.isValid()) {
            AdTraceFactory.getLogger().error("AdTraceConfig not initialized correctly", new Object[0]);
            return;
        }
        if (this.activityHandler != null) {
            AdTraceFactory.getLogger().error("AdTrace already initialized", new Object[0]);
            return;
        }
        adTraceConfig.preLaunchActions = this.preLaunchActions;
        adTraceConfig.pushToken = this.pushToken;
        adTraceConfig.startEnabled = this.startEnabled;
        adTraceConfig.startOffline = this.startOffline;
        adTraceConfig.basePath = this.basePath;
        adTraceConfig.gdprPath = this.gdprPath;
        adTraceConfig.subscriptionPath = this.subscriptionPath;
        this.activityHandler = AdTraceFactory.getActivityHandler(adTraceConfig);
        this.setSendingReferrersAsNotSent(adTraceConfig.context);
    }

    public void trackEvent(AdTraceEvent event) {
        if (!this.checkActivityHandler("trackEvent")) {
            return;
        }
        this.activityHandler.trackEvent(event);
    }

    public void onResume() {
        if (!this.checkActivityHandler("onResume")) {
            return;
        }
        this.activityHandler.onResume();
    }

    public void onPause() {
        if (!this.checkActivityHandler("onPause")) {
            return;
        }
        this.activityHandler.onPause();
    }

    public void setEnabled(boolean enabled) {
        this.startEnabled = enabled;
        if (this.checkActivityHandler(enabled, "enabled mode", "disabled mode")) {
            this.activityHandler.setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        if (!this.checkActivityHandler("isEnabled")) {
            return this.isInstanceEnabled();
        }
        return this.activityHandler.isEnabled();
    }

    public void appWillOpenUrl(Uri url) {
        if (!this.checkActivityHandler("appWillOpenUrl")) {
            return;
        }
        long clickTime = System.currentTimeMillis();
        this.activityHandler.readOpenUrl(url, clickTime);
    }

    public void appWillOpenUrl(Uri url, Context context) {
        if (url == null || url.toString().length() == 0) {
            AdTraceFactory.getLogger().warn("Skipping deep link processing (null or empty)", new Object[0]);
            return;
        }
        long clickTime = System.currentTimeMillis();
        if (!this.checkActivityHandler("appWillOpenUrl", true)) {
            this.saveDeeplink(url, clickTime, context);
            return;
        }
        this.activityHandler.readOpenUrl(url, clickTime);
    }

    public void sendReferrer(String rawReferrer, Context context) {
        long clickTime = System.currentTimeMillis();
        if (rawReferrer == null || rawReferrer.length() == 0) {
            AdTraceFactory.getLogger().warn("Skipping INSTALL_REFERRER intent referrer processing (null or empty)", new Object[0]);
            return;
        }
        this.saveRawReferrer(rawReferrer, clickTime, context);
        if (this.checkActivityHandler("referrer", true) && this.activityHandler.isEnabled()) {
            this.activityHandler.sendReftagReferrer();
        }
    }

    public void sendPreinstallReferrer(String referrer, Context context) {
        if (referrer == null || referrer.length() == 0) {
            AdTraceFactory.getLogger().warn("Skipping SYSTEM_INSTALLER_REFERRER preinstall referrer processing (null or empty)", new Object[0]);
            return;
        }
        this.savePreinstallReferrer(referrer, context);
        if (this.checkActivityHandler("preinstall referrer", true) && this.activityHandler.isEnabled()) {
            this.activityHandler.sendPreinstallReferrer();
        }
    }

    public void setOfflineMode(boolean enabled) {
        if (!this.checkActivityHandler(enabled, "offline mode", "online mode")) {
            this.startOffline = enabled;
        } else {
            this.activityHandler.setOfflineMode(enabled);
        }
    }

    public void sendFirstPackages() {
        if (!this.checkActivityHandler("sendFirstPackages")) {
            return;
        }
        this.activityHandler.sendFirstPackages();
    }

    public void addSessionCallbackParameter(final String key, final String value) {
        if (this.checkActivityHandler("adding session callback parameter", true)) {
            this.activityHandler.addSessionCallbackParameter(key, value);
            return;
        }
        this.preLaunchActions.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public void run(ActivityHandler activityHandler) {
                activityHandler.addSessionCallbackParameterI(key, value);
            }
        });
    }

    public void addSessionPartnerParameter(final String key, final String value) {
        if (this.checkActivityHandler("adding session partner parameter", true)) {
            this.activityHandler.addSessionPartnerParameter(key, value);
            return;
        }
        this.preLaunchActions.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public void run(ActivityHandler activityHandler) {
                activityHandler.addSessionPartnerParameterI(key, value);
            }
        });
    }

    public void removeSessionCallbackParameter(final String key) {
        if (this.checkActivityHandler("removing session callback parameter", true)) {
            this.activityHandler.removeSessionCallbackParameter(key);
            return;
        }
        this.preLaunchActions.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public void run(ActivityHandler activityHandler) {
                activityHandler.removeSessionCallbackParameterI(key);
            }
        });
    }

    public void removeSessionPartnerParameter(final String key) {
        if (this.checkActivityHandler("removing session partner parameter", true)) {
            this.activityHandler.removeSessionPartnerParameter(key);
            return;
        }
        this.preLaunchActions.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public void run(ActivityHandler activityHandler) {
                activityHandler.removeSessionPartnerParameterI(key);
            }
        });
    }

    public void resetSessionCallbackParameters() {
        if (this.checkActivityHandler("resetting session callback parameters", true)) {
            this.activityHandler.resetSessionCallbackParameters();
            return;
        }
        this.preLaunchActions.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public void run(ActivityHandler activityHandler) {
                activityHandler.resetSessionCallbackParametersI();
            }
        });
    }

    public void resetSessionPartnerParameters() {
        if (this.checkActivityHandler("resetting session partner parameters", true)) {
            this.activityHandler.resetSessionPartnerParameters();
            return;
        }
        this.preLaunchActions.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public void run(ActivityHandler activityHandler) {
                activityHandler.resetSessionPartnerParametersI();
            }
        });
    }

    public void teardown() {
        if (!this.checkActivityHandler("teardown")) {
            return;
        }
        this.activityHandler.teardown();
        this.activityHandler = null;
    }

    public void setPushToken(String token) {
        if (!this.checkActivityHandler("push token", true)) {
            this.pushToken = token;
        } else {
            this.activityHandler.setPushToken(token, false);
        }
    }

    public void setPushToken(String token, Context context) {
        this.savePushToken(token, context);
        if (this.checkActivityHandler("push token", true) && this.activityHandler.isEnabled()) {
            this.activityHandler.setPushToken(token, true);
        }
    }

    public void gdprForgetMe(Context context) {
        this.saveGdprForgetMe(context);
        if (this.checkActivityHandler("gdpr", true) && this.activityHandler.isEnabled()) {
            this.activityHandler.gdprForgetMe();
        }
    }

    public void disableThirdPartySharing(Context context) {
        if (!this.checkActivityHandler("disable third party sharing", true)) {
            this.saveDisableThirdPartySharing(context);
            return;
        }
        this.activityHandler.disableThirdPartySharing();
    }

    public void trackThirdPartySharing(AdTraceThirdPartySharing adTraceThirdPartySharing) {
        if (!this.checkActivityHandler("third party sharing", true)) {
            this.preLaunchActions.preLaunchAdTraceThirdPartySharingArray.add(adTraceThirdPartySharing);
            return;
        }
        this.activityHandler.trackThirdPartySharing(adTraceThirdPartySharing);
    }

    public void trackMeasurementConsent(boolean consentMeasurement) {
        if (!this.checkActivityHandler("measurement consent", true)) {
            this.preLaunchActions.lastMeasurementConsentTracked = consentMeasurement;
            return;
        }
        this.activityHandler.trackMeasurementConsent(consentMeasurement);
    }

    public void trackAdRevenue(String source, JSONObject adRevenueJson) {
        if (!this.checkActivityHandler("trackAdRevenue")) {
            return;
        }
        this.activityHandler.trackAdRevenue(source, adRevenueJson);
    }

    public void trackAdRevenue(AdTraceAdRevenue adTraceAdRevenue) {
        if (!this.checkActivityHandler("trackAdRevenue")) {
            return;
        }
        this.activityHandler.trackAdRevenue(adTraceAdRevenue);
    }

    public void trackPlayStoreSubscription(AdTracePlayStoreSubscription subscription) {
        if (!this.checkActivityHandler("trackPlayStoreSubscription")) {
            return;
        }
        this.activityHandler.trackPlayStoreSubscription(subscription);
    }

    public String getAdid() {
        if (!this.checkActivityHandler("getAdid")) {
            return null;
        }
        return this.activityHandler.getAdid();
    }

    public AdTraceAttribution getAttribution() {
        if (!this.checkActivityHandler("getAttribution")) {
            return null;
        }
        return this.activityHandler.getAttribution();
    }

    public String getSdkVersion() {
        return Util.getSdkVersion();
    }

    private boolean checkActivityHandler(String action) {
        return this.checkActivityHandler(action, false);
    }

    private boolean checkActivityHandler(boolean status, String trueMessage, String falseMessage) {
        if (status) {
            return this.checkActivityHandler(trueMessage, true);
        }
        return this.checkActivityHandler(falseMessage, true);
    }

    private boolean checkActivityHandler(String action, boolean actionSaved) {
        if (this.activityHandler != null) {
            return true;
        }
        if (action == null) {
            AdTraceFactory.getLogger().error("AdTrace not initialized correctly", new Object[0]);
            return false;
        }
        if (actionSaved) {
            AdTraceFactory.getLogger().warn("AdTrace not initialized, but %s saved for launch", action);
        } else {
            AdTraceFactory.getLogger().warn("AdTrace not initialized, can't perform %s", action);
        }
        return false;
    }

    private void saveRawReferrer(String rawReferrer, long clickTime, Context context) {
        SharedPreferencesManager.getDefaultInstance(context).saveRawReferrer(rawReferrer, clickTime);
    }

    private void savePreinstallReferrer(String referrer, Context context) {
        SharedPreferencesManager.getDefaultInstance(context).savePreinstallReferrer(referrer);
    }

    private void savePushToken(String pushToken, Context context) {
        SharedPreferencesManager.getDefaultInstance(context).savePushToken(pushToken);
    }

    private void saveGdprForgetMe(Context context) {
        SharedPreferencesManager.getDefaultInstance(context).setGdprForgetMe();
    }

    private void saveDisableThirdPartySharing(Context context) {
        SharedPreferencesManager.getDefaultInstance(context).setDisableThirdPartySharing();
    }

    private void saveDeeplink(Uri deeplink, long clickTime, Context context) {
        SharedPreferencesManager.getDefaultInstance(context).saveDeeplink(deeplink, clickTime);
    }

    private void setSendingReferrersAsNotSent(Context context) {
        SharedPreferencesManager.getDefaultInstance(context).setSendingReferrersAsNotSent();
    }

    private boolean isInstanceEnabled() {
        return this.startEnabled == null || this.startEnabled != false;
    }

    public void setTestOptions(AdTraceTestOptions testOptions) {
        if (testOptions.basePath != null) {
            this.basePath = testOptions.basePath;
        }
        if (testOptions.gdprPath != null) {
            this.gdprPath = testOptions.gdprPath;
        }
        if (testOptions.subscriptionPath != null) {
            this.subscriptionPath = testOptions.subscriptionPath;
        }
        if (testOptions.baseUrl != null) {
            AdTraceFactory.setBaseUrl(testOptions.baseUrl);
        }
        if (testOptions.gdprUrl != null) {
            AdTraceFactory.setGdprUrl(testOptions.gdprUrl);
        }
        if (testOptions.subscriptionUrl != null) {
            AdTraceFactory.setSubscriptionUrl(testOptions.subscriptionUrl);
        }
        if (testOptions.timerIntervalInMilliseconds != null) {
            AdTraceFactory.setTimerInterval(testOptions.timerIntervalInMilliseconds);
        }
        if (testOptions.timerStartInMilliseconds != null) {
            AdTraceFactory.setTimerStart(testOptions.timerIntervalInMilliseconds);
        }
        if (testOptions.sessionIntervalInMilliseconds != null) {
            AdTraceFactory.setSessionInterval(testOptions.sessionIntervalInMilliseconds);
        }
        if (testOptions.subsessionIntervalInMilliseconds != null) {
            AdTraceFactory.setSubsessionInterval(testOptions.subsessionIntervalInMilliseconds);
        }
        if (testOptions.tryInstallReferrer != null) {
            AdTraceFactory.setTryInstallReferrer(testOptions.tryInstallReferrer);
        }
        if (testOptions.noBackoffWait != null) {
            AdTraceFactory.setPackageHandlerBackoffStrategy(BackoffStrategy.NO_WAIT);
            AdTraceFactory.setSdkClickBackoffStrategy(BackoffStrategy.NO_WAIT);
        }
        if (testOptions.enableSigning != null && testOptions.enableSigning.booleanValue()) {
            AdTraceFactory.enableSigning();
        }
        if (testOptions.disableSigning != null && testOptions.disableSigning.booleanValue()) {
            AdTraceFactory.disableSigning();
        }
    }

    public static class PreLaunchActions {
        public List<IRunActivityHandler> preLaunchActionsArray = new ArrayList<IRunActivityHandler>();
        public List<AdTraceThirdPartySharing> preLaunchAdTraceThirdPartySharingArray = new ArrayList<AdTraceThirdPartySharing>();
        public Boolean lastMeasurementConsentTracked = null;
    }
}

