/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk;

import io.adtrace.sdk.AdTraceFactory;
import io.adtrace.sdk.ILogger;
import io.adtrace.sdk.Util;
import java.util.LinkedHashMap;
import java.util.Map;

public class AdTracePlayStoreSubscription {
    private long price;
    private String currency;
    private String sku;
    private String orderId;
    private String signature;
    private String purchaseToken;
    private String billingStore;
    private long purchaseTime;
    private Map<String, String> callbackParameters;
    private Map<String, String> partnerParameters;
    private static ILogger logger = AdTraceFactory.getLogger();

    public AdTracePlayStoreSubscription(long price, String currency, String sku, String orderId, String signature, String purchaseToken) {
        this.price = price;
        this.currency = currency;
        this.sku = sku;
        this.orderId = orderId;
        this.signature = signature;
        this.purchaseToken = purchaseToken;
        this.purchaseTime = -1L;
        this.billingStore = "GooglePlay";
    }

    long getPrice() {
        return this.price;
    }

    long getPurchaseTime() {
        return this.purchaseTime;
    }

    String getCurrency() {
        return this.currency;
    }

    String getSku() {
        return this.sku;
    }

    String getOrderId() {
        return this.orderId;
    }

    String getSignature() {
        return this.signature;
    }

    String getBillingStore() {
        return this.billingStore;
    }

    String getPurchaseToken() {
        return this.purchaseToken;
    }

    Map<String, String> getCallbackParameters() {
        return this.callbackParameters;
    }

    Map<String, String> getPartnerParameters() {
        return this.partnerParameters;
    }

    public void setPurchaseTime(long purchaseTime) {
        this.purchaseTime = purchaseTime;
    }

    public void addCallbackParameter(String key, String value) {
        String previousValue;
        if (!Util.isValidParameter(key, "key", "Callback")) {
            return;
        }
        if (!Util.isValidParameter(value, "value", "Callback")) {
            return;
        }
        if (this.callbackParameters == null) {
            this.callbackParameters = new LinkedHashMap<String, String>();
        }
        if ((previousValue = this.callbackParameters.put(key, value)) != null) {
            logger.warn("Key %s was overwritten", key);
        }
    }

    public void addPartnerParameter(String key, String value) {
        String previousValue;
        if (!Util.isValidParameter(key, "key", "Partner")) {
            return;
        }
        if (!Util.isValidParameter(value, "value", "Partner")) {
            return;
        }
        if (this.partnerParameters == null) {
            this.partnerParameters = new LinkedHashMap<String, String>();
        }
        if ((previousValue = this.partnerParameters.put(key, value)) != null) {
            logger.warn("Key %s was overwritten", key);
        }
    }
}

