/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk;

import io.adtrace.sdk.AdTraceFactory;
import io.adtrace.sdk.ILogger;
import io.adtrace.sdk.Util;
import java.util.LinkedHashMap;
import java.util.Map;

public class AdTraceAdRevenue {
    String source;
    Double revenue;
    String currency;
    Integer adImpressionsCount;
    String adRevenueNetwork;
    String adRevenueUnit;
    String adRevenuePlacement;
    Map<String, String> callbackParameters;
    Map<String, String> partnerParameters;
    private static final ILogger logger = AdTraceFactory.getLogger();

    public AdTraceAdRevenue(String source) {
        if (!this.isValidSource(source)) {
            return;
        }
        this.source = source;
    }

    public void setRevenue(Double revenue, String currency) {
        this.revenue = revenue;
        this.currency = currency;
    }

    public void setAdImpressionsCount(Integer adImpressionsCount) {
        this.adImpressionsCount = adImpressionsCount;
    }

    public void setAdRevenueNetwork(String adRevenueNetwork) {
        this.adRevenueNetwork = adRevenueNetwork;
    }

    public void setAdRevenueUnit(String adRevenueUnit) {
        this.adRevenueUnit = adRevenueUnit;
    }

    public void setAdRevenuePlacement(String adRevenuePlacement) {
        this.adRevenuePlacement = adRevenuePlacement;
    }

    public void addCallbackParameter(String key, String value) {
        String previousValue;
        if (!Util.isValidParameter(key, "key", "Callback")) {
            return;
        }
        if (!Util.isValidParameter(value, "value", "Callback")) {
            return;
        }
        if (this.callbackParameters == null) {
            this.callbackParameters = new LinkedHashMap<String, String>();
        }
        if ((previousValue = this.callbackParameters.put(key, value)) != null) {
            logger.warn("Key %s was overwritten", key);
        }
    }

    public void addPartnerParameter(String key, String value) {
        String previousValue;
        if (!Util.isValidParameter(key, "key", "Partner")) {
            return;
        }
        if (!Util.isValidParameter(value, "value", "Partner")) {
            return;
        }
        if (this.partnerParameters == null) {
            this.partnerParameters = new LinkedHashMap<String, String>();
        }
        if ((previousValue = this.partnerParameters.put(key, value)) != null) {
            logger.warn("Key %s was overwritten", key);
        }
    }

    public boolean isValid() {
        return this.isValidSource(this.source);
    }

    private boolean isValidSource(String param) {
        if (param == null) {
            logger.error("Missing source", new Object[0]);
            return false;
        }
        if (param.isEmpty()) {
            logger.error("Source can't be empty", new Object[0]);
            return false;
        }
        return true;
    }
}

