/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk;

import io.adtrace.sdk.AdTraceFactory;
import io.adtrace.sdk.ILogger;
import java.util.HashMap;
import java.util.Map;

public class AdTraceThirdPartySharing {
    Boolean isEnabled;
    Map<String, Map<String, String>> granularOptions;
    Map<String, Map<String, Boolean>> partnerSharingSettings;

    public AdTraceThirdPartySharing(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        this.granularOptions = new HashMap<String, Map<String, String>>();
        this.partnerSharingSettings = new HashMap<String, Map<String, Boolean>>();
    }

    public void addGranularOption(String partnerName, String key, String value) {
        if (partnerName == null || key == null || value == null) {
            ILogger logger = AdTraceFactory.getLogger();
            logger.error("Cannot add granular option with any null value", new Object[0]);
            return;
        }
        Map<String, String> partnerOptions = this.granularOptions.get(partnerName);
        if (partnerOptions == null) {
            partnerOptions = new HashMap<String, String>();
            this.granularOptions.put(partnerName, partnerOptions);
        }
        partnerOptions.put(key, value);
    }

    public void addPartnerSharingSetting(String partnerName, String key, boolean value) {
        if (partnerName == null || key == null) {
            ILogger logger = AdTraceFactory.getLogger();
            logger.error("Cannot add partner sharing setting with any null value", new Object[0]);
            return;
        }
        Map<String, Boolean> partnerSharingSetting = this.partnerSharingSettings.get(partnerName);
        if (partnerSharingSetting == null) {
            partnerSharingSetting = new HashMap<String, Boolean>();
            this.partnerSharingSettings.put(partnerName, partnerSharingSetting);
        }
        partnerSharingSetting.put(key, value);
    }
}

