/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk;

import android.content.Context;
import io.adtrace.sdk.ActivityHandler;
import io.adtrace.sdk.AdTraceConfig;
import io.adtrace.sdk.AdTraceSigner;
import io.adtrace.sdk.AttributionHandler;
import io.adtrace.sdk.BackoffStrategy;
import io.adtrace.sdk.IActivityHandler;
import io.adtrace.sdk.IAttributionHandler;
import io.adtrace.sdk.ILogger;
import io.adtrace.sdk.IPackageHandler;
import io.adtrace.sdk.ISdkClickHandler;
import io.adtrace.sdk.Logger;
import io.adtrace.sdk.PackageHandler;
import io.adtrace.sdk.SdkClickHandler;
import io.adtrace.sdk.network.IActivityPackageSender;
import io.adtrace.sdk.network.UtilNetworking;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

public class AdTraceFactory {
    private static IPackageHandler packageHandler = null;
    private static IAttributionHandler attributionHandler = null;
    private static IActivityHandler activityHandler = null;
    private static ILogger logger = null;
    private static ISdkClickHandler sdkClickHandler = null;
    private static long timerInterval = -1L;
    private static long timerStart = -1L;
    private static long sessionInterval = -1L;
    private static long subsessionInterval = -1L;
    private static BackoffStrategy sdkClickBackoffStrategy = null;
    private static BackoffStrategy packageHandlerBackoffStrategy = null;
    private static BackoffStrategy installSessionBackoffStrategy = null;
    private static long maxDelayStart = -1L;
    private static String baseUrl = null;
    private static String gdprUrl = null;
    private static String subscriptionUrl = null;
    private static UtilNetworking.IConnectionOptions connectionOptions = null;
    private static UtilNetworking.IHttpsURLConnectionProvider httpsURLConnectionProvider = null;
    private static boolean tryInstallReferrer = true;

    public static IPackageHandler getPackageHandler(IActivityHandler activityHandler, Context context, boolean startsSending, IActivityPackageSender packageHandlerActivityPackageSender) {
        if (packageHandler == null) {
            return new PackageHandler(activityHandler, context, startsSending, packageHandlerActivityPackageSender);
        }
        packageHandler.init(activityHandler, context, startsSending, packageHandlerActivityPackageSender);
        return packageHandler;
    }

    public static ILogger getLogger() {
        if (logger == null) {
            logger = new Logger();
        }
        return logger;
    }

    public static long getTimerInterval() {
        if (timerInterval == -1L) {
            return 60000L;
        }
        return timerInterval;
    }

    public static long getTimerStart() {
        if (timerStart == -1L) {
            return 60000L;
        }
        return timerStart;
    }

    public static long getSessionInterval() {
        if (sessionInterval == -1L) {
            return 1800000L;
        }
        return sessionInterval;
    }

    public static long getSubsessionInterval() {
        if (subsessionInterval == -1L) {
            return 1000L;
        }
        return subsessionInterval;
    }

    public static BackoffStrategy getSdkClickBackoffStrategy() {
        if (sdkClickBackoffStrategy == null) {
            return BackoffStrategy.SHORT_WAIT;
        }
        return sdkClickBackoffStrategy;
    }

    public static BackoffStrategy getPackageHandlerBackoffStrategy() {
        if (packageHandlerBackoffStrategy == null) {
            return BackoffStrategy.LONG_WAIT;
        }
        return packageHandlerBackoffStrategy;
    }

    public static BackoffStrategy getInstallSessionBackoffStrategy() {
        if (installSessionBackoffStrategy == null) {
            return BackoffStrategy.SHORT_WAIT;
        }
        return installSessionBackoffStrategy;
    }

    public static IActivityHandler getActivityHandler(AdTraceConfig config) {
        if (activityHandler == null) {
            return ActivityHandler.getInstance(config);
        }
        activityHandler.init(config);
        return activityHandler;
    }

    public static IAttributionHandler getAttributionHandler(IActivityHandler activityHandler, boolean startsSending, IActivityPackageSender packageHandlerActivityPackageSender) {
        if (attributionHandler == null) {
            return new AttributionHandler(activityHandler, startsSending, packageHandlerActivityPackageSender);
        }
        attributionHandler.init(activityHandler, startsSending, packageHandlerActivityPackageSender);
        return attributionHandler;
    }

    public static ISdkClickHandler getSdkClickHandler(IActivityHandler activityHandler, boolean startsSending, IActivityPackageSender packageHandlerActivityPackageSender) {
        if (sdkClickHandler == null) {
            return new SdkClickHandler(activityHandler, startsSending, packageHandlerActivityPackageSender);
        }
        sdkClickHandler.init(activityHandler, startsSending, packageHandlerActivityPackageSender);
        return sdkClickHandler;
    }

    public static long getMaxDelayStart() {
        if (maxDelayStart == -1L) {
            return 10000L;
        }
        return maxDelayStart;
    }

    public static String getBaseUrl() {
        return baseUrl;
    }

    public static String getGdprUrl() {
        return gdprUrl;
    }

    public static String getSubscriptionUrl() {
        return subscriptionUrl;
    }

    public static UtilNetworking.IConnectionOptions getConnectionOptions() {
        if (connectionOptions == null) {
            return UtilNetworking.createDefaultConnectionOptions();
        }
        return connectionOptions;
    }

    public static UtilNetworking.IHttpsURLConnectionProvider getHttpsURLConnectionProvider() {
        if (httpsURLConnectionProvider == null) {
            return UtilNetworking.createDefaultHttpsURLConnectionProvider();
        }
        return httpsURLConnectionProvider;
    }

    public static boolean getTryInstallReferrer() {
        return tryInstallReferrer;
    }

    public static void setPackageHandler(IPackageHandler packageHandler) {
        AdTraceFactory.packageHandler = packageHandler;
    }

    public static void setLogger(ILogger logger) {
        AdTraceFactory.logger = logger;
    }

    public static void setTimerInterval(long timerInterval) {
        AdTraceFactory.timerInterval = timerInterval;
    }

    public static void setTimerStart(long timerStart) {
        AdTraceFactory.timerStart = timerStart;
    }

    public static void setSessionInterval(long sessionInterval) {
        AdTraceFactory.sessionInterval = sessionInterval;
    }

    public static void setSubsessionInterval(long subsessionInterval) {
        AdTraceFactory.subsessionInterval = subsessionInterval;
    }

    public static void setSdkClickBackoffStrategy(BackoffStrategy sdkClickBackoffStrategy) {
        AdTraceFactory.sdkClickBackoffStrategy = sdkClickBackoffStrategy;
    }

    public static void setPackageHandlerBackoffStrategy(BackoffStrategy packageHandlerBackoffStrategy) {
        AdTraceFactory.packageHandlerBackoffStrategy = packageHandlerBackoffStrategy;
    }

    public static void setActivityHandler(IActivityHandler activityHandler) {
        AdTraceFactory.activityHandler = activityHandler;
    }

    public static void setAttributionHandler(IAttributionHandler attributionHandler) {
        AdTraceFactory.attributionHandler = attributionHandler;
    }

    public static void setSdkClickHandler(ISdkClickHandler sdkClickHandler) {
        AdTraceFactory.sdkClickHandler = sdkClickHandler;
    }

    public static void setBaseUrl(String baseUrl) {
        AdTraceFactory.baseUrl = baseUrl;
    }

    public static void setGdprUrl(String gdprUrl) {
        AdTraceFactory.gdprUrl = gdprUrl;
    }

    public static void setSubscriptionUrl(String subscriptionUrl) {
        AdTraceFactory.subscriptionUrl = subscriptionUrl;
    }

    public static void setConnectionOptions(UtilNetworking.IConnectionOptions connectionOptions) {
        AdTraceFactory.connectionOptions = connectionOptions;
    }

    public static void setHttpsURLConnectionProvider(UtilNetworking.IHttpsURLConnectionProvider httpsURLConnectionProvider) {
        AdTraceFactory.httpsURLConnectionProvider = httpsURLConnectionProvider;
    }

    public static void setTryInstallReferrer(boolean tryInstallReferrer) {
        AdTraceFactory.tryInstallReferrer = tryInstallReferrer;
    }

    public static void enableSigning() {
        AdTraceSigner.enableSigning(AdTraceFactory.getLogger());
    }

    public static void disableSigning() {
        AdTraceSigner.disableSigning(AdTraceFactory.getLogger());
    }

    private static String byte2HexFormatted(byte[] arr) {
        StringBuilder str = new StringBuilder(arr.length * 2);
        for (int i = 0; i < arr.length; ++i) {
            String h = Integer.toHexString(arr[i]);
            int l = h.length();
            if (l == 1) {
                h = "0" + h;
            }
            if (l > 2) {
                h = h.substring(l - 2, l);
            }
            str.append(h.toUpperCase());
        }
        return str.toString();
    }

    public static void teardown(Context context) {
        if (context != null) {
            ActivityHandler.deleteState(context);
            PackageHandler.deleteState(context);
        }
        packageHandler = null;
        attributionHandler = null;
        activityHandler = null;
        logger = null;
        sdkClickHandler = null;
        timerInterval = -1L;
        timerStart = -1L;
        sessionInterval = -1L;
        subsessionInterval = -1L;
        sdkClickBackoffStrategy = null;
        packageHandlerBackoffStrategy = null;
        maxDelayStart = -1L;
        baseUrl = "https://app.adtrace.io";
        gdprUrl = "https://gdpr.adtrace.io";
        subscriptionUrl = "https://subscription.adtrace.com";
        connectionOptions = null;
        httpsURLConnectionProvider = null;
        tryInstallReferrer = true;
    }

    public static class URLGetConnection {
        HttpsURLConnection httpsURLConnection;
        URL url;

        URLGetConnection(HttpsURLConnection httpsURLConnection, URL url) {
            this.httpsURLConnection = httpsURLConnection;
            this.url = url;
        }
    }
}

