/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk;

import android.net.Uri;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class AdTraceLinkResolution {
    private static volatile ExecutorService executor;
    private static final int maxRecursions = 10;
    private static final String[] expectedUrlHostSuffixArray;

    private AdTraceLinkResolution() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void resolveLink(String url, String[] resolveUrlSuffixArray, final AdTraceLinkResolutionCallback adTraceLinkResolutionCallback) {
        if (adTraceLinkResolutionCallback == null) {
            return;
        }
        if (url == null) {
            adTraceLinkResolutionCallback.resolvedLinkCallback(null);
            return;
        }
        URL originalURL = null;
        try {
            originalURL = new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (originalURL == null) {
            adTraceLinkResolutionCallback.resolvedLinkCallback(null);
            return;
        }
        if (!AdTraceLinkResolution.urlMatchesSuffix(originalURL.getHost(), resolveUrlSuffixArray)) {
            adTraceLinkResolutionCallback.resolvedLinkCallback(AdTraceLinkResolution.convertToUri(originalURL));
            return;
        }
        if (executor == null) {
            String[] stringArray = expectedUrlHostSuffixArray;
            // MONITORENTER : expectedUrlHostSuffixArray
            if (executor == null) {
                executor = Executors.newSingleThreadExecutor();
            }
            // MONITOREXIT : stringArray
        }
        final URL finalOriginalURL = originalURL;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                AdTraceLinkResolution.requestAndResolve(finalOriginalURL, 0, adTraceLinkResolutionCallback);
            }
        });
    }

    private static void resolveLink(URL responseUrl, URL previousUrl, int recursionNumber, AdTraceLinkResolutionCallback adTraceLinkResolutionCallback) {
        if (responseUrl == null) {
            adTraceLinkResolutionCallback.resolvedLinkCallback(AdTraceLinkResolution.convertToUri(previousUrl));
            return;
        }
        if (AdTraceLinkResolution.isTerminalUrl(responseUrl.getHost())) {
            adTraceLinkResolutionCallback.resolvedLinkCallback(AdTraceLinkResolution.convertToUri(responseUrl));
            return;
        }
        if (recursionNumber > 10) {
            adTraceLinkResolutionCallback.resolvedLinkCallback(AdTraceLinkResolution.convertToUri(responseUrl));
            return;
        }
        AdTraceLinkResolution.requestAndResolve(responseUrl, recursionNumber, adTraceLinkResolutionCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void requestAndResolve(URL urlToRequest, int recursionNumber, AdTraceLinkResolutionCallback adTraceLinkResolutionCallback) {
        URL resolvedURL;
        URL httpsUrl;
        block7: {
            httpsUrl = AdTraceLinkResolution.convertToHttps(urlToRequest);
            resolvedURL = null;
            HttpURLConnection ucon = null;
            try {
                ucon = (HttpURLConnection)httpsUrl.openConnection();
                ucon.setInstanceFollowRedirects(false);
                ucon.connect();
                String headerLocationField = ucon.getHeaderField("Location");
                if (headerLocationField != null) {
                    resolvedURL = new URL(headerLocationField);
                }
                if (ucon == null) break block7;
                ucon.disconnect();
            }
            catch (Throwable throwable) {
                if (ucon != null) {
                    ucon.disconnect();
                }
                AdTraceLinkResolution.resolveLink(resolvedURL, httpsUrl, recursionNumber + 1, adTraceLinkResolutionCallback);
                catch (Throwable throwable2) {
                    if (ucon != null) {
                        ucon.disconnect();
                    }
                    AdTraceLinkResolution.resolveLink(resolvedURL, httpsUrl, recursionNumber + 1, adTraceLinkResolutionCallback);
                    throw throwable2;
                }
            }
        }
        AdTraceLinkResolution.resolveLink(resolvedURL, httpsUrl, recursionNumber + 1, adTraceLinkResolutionCallback);
    }

    private static boolean isTerminalUrl(String urlHost) {
        return AdTraceLinkResolution.urlMatchesSuffix(urlHost, expectedUrlHostSuffixArray);
    }

    private static boolean urlMatchesSuffix(String urlHost, String[] suffixArray) {
        if (urlHost == null) {
            return false;
        }
        if (suffixArray == null) {
            return false;
        }
        for (String expectedUrlHostSuffix : suffixArray) {
            if (!urlHost.endsWith(expectedUrlHostSuffix)) continue;
            return true;
        }
        return false;
    }

    private static URL convertToHttps(URL urlToConvert) {
        if (urlToConvert == null) {
            return urlToConvert;
        }
        String stringUrlToConvert = urlToConvert.toExternalForm();
        if (stringUrlToConvert == null) {
            return urlToConvert;
        }
        if (!stringUrlToConvert.startsWith("http:")) {
            return urlToConvert;
        }
        URL convertedUrl = urlToConvert;
        try {
            convertedUrl = new URL("https:" + stringUrlToConvert.substring(5));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return convertedUrl;
    }

    private static Uri convertToUri(URL url) {
        if (url == null) {
            return null;
        }
        return Uri.parse((String)url.toString());
    }

    static {
        expectedUrlHostSuffixArray = new String[]{"adtrace.io", "adtrce.st", "go.link"};
    }

    public static interface AdTraceLinkResolutionCallback {
        public void resolvedLinkCallback(Uri var1);
    }
}

