/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk;

import android.text.TextUtils;
import io.adtrace.sdk.ActivityKind;
import io.adtrace.sdk.ActivityPackage;
import io.adtrace.sdk.ActivityState;
import io.adtrace.sdk.AdTraceAdRevenue;
import io.adtrace.sdk.AdTraceAttribution;
import io.adtrace.sdk.AdTraceConfig;
import io.adtrace.sdk.AdTraceEvent;
import io.adtrace.sdk.AdTraceFactory;
import io.adtrace.sdk.AdTracePlayStoreSubscription;
import io.adtrace.sdk.AdTracePurchase;
import io.adtrace.sdk.AdTraceSigner;
import io.adtrace.sdk.AdTraceThirdPartySharing;
import io.adtrace.sdk.DeviceInfo;
import io.adtrace.sdk.ILogger;
import io.adtrace.sdk.OnPurchaseVerificationFinishedListener;
import io.adtrace.sdk.SessionParameters;
import io.adtrace.sdk.Util;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class PackageBuilder {
    private static ILogger logger = AdTraceFactory.getLogger();
    private long createdAt;
    private DeviceInfo deviceInfo;
    private AdTraceConfig adtraceConfig;
    private ActivityStateCopy activityStateCopy;
    private SessionParameters sessionParameters;
    long clickTimeInSeconds = -1L;
    long clickTimeInMilliseconds = -1L;
    long installBeginTimeInSeconds = -1L;
    long clickTimeServerInSeconds = -1L;
    long installBeginTimeServerInSeconds = -1L;
    String reftag;
    String deeplink;
    String referrer;
    String installVersion;
    String rawReferrer;
    String referrerApi;
    String preinstallPayload;
    String preinstallLocation;
    Boolean googlePlayInstant;
    AdTraceAttribution attribution;
    Map<String, String> extraParameters;
    Boolean isClick;

    PackageBuilder(AdTraceConfig adtraceConfig, DeviceInfo deviceInfo, ActivityState activityState, SessionParameters sessionParameters, long createdAt) {
        this.createdAt = createdAt;
        this.deviceInfo = deviceInfo;
        this.adtraceConfig = adtraceConfig;
        this.activityStateCopy = new ActivityStateCopy(activityState);
        this.sessionParameters = sessionParameters;
    }

    ActivityPackage buildSessionPackage(boolean isInDelay) {
        Map<String, String> parameters = this.getSessionParameters(isInDelay);
        ActivityPackage sessionPackage = this.getDefaultActivityPackage(ActivityKind.SESSION);
        sessionPackage.setPath("/session");
        sessionPackage.setSuffix("");
        AdTraceSigner.sign(parameters, ActivityKind.SESSION.toString(), sessionPackage.getClientSdk(), this.adtraceConfig.context, this.adtraceConfig.logger);
        sessionPackage.setParameters(parameters);
        return sessionPackage;
    }

    ActivityPackage buildEventPackage(AdTraceEvent event, boolean isInDelay) {
        Map<String, String> parameters = this.getEventParameters(event, isInDelay);
        ActivityPackage eventPackage = this.getDefaultActivityPackage(ActivityKind.EVENT);
        eventPackage.setPath("/event");
        eventPackage.setSuffix(this.getEventSuffix(event));
        AdTraceSigner.sign(parameters, ActivityKind.EVENT.toString(), eventPackage.getClientSdk(), this.adtraceConfig.context, this.adtraceConfig.logger);
        eventPackage.setParameters(parameters);
        if (isInDelay) {
            eventPackage.setCallbackParameters(event.callbackParameters);
            eventPackage.setPartnerParameters(event.eventValueParameters);
            eventPackage.setPartnerParameters(event.partnerParameters);
        }
        return eventPackage;
    }

    ActivityPackage buildInfoPackage(String source) {
        Map<String, String> parameters = this.getInfoParameters(source);
        ActivityPackage infoPackage = this.getDefaultActivityPackage(ActivityKind.INFO);
        infoPackage.setPath("/sdk_info");
        infoPackage.setSuffix("");
        AdTraceSigner.sign(parameters, ActivityKind.INFO.toString(), infoPackage.getClientSdk(), this.adtraceConfig.context, this.adtraceConfig.logger);
        infoPackage.setParameters(parameters);
        return infoPackage;
    }

    ActivityPackage buildClickPackage(String source) {
        Map<String, String> parameters = this.getClickParameters(source);
        ActivityPackage clickPackage = this.getDefaultActivityPackage(ActivityKind.CLICK);
        clickPackage.setPath("/sdk_click");
        clickPackage.setSuffix("");
        clickPackage.setClickTimeInMilliseconds(this.clickTimeInMilliseconds);
        clickPackage.setClickTimeInSeconds(this.clickTimeInSeconds);
        clickPackage.setInstallBeginTimeInSeconds(this.installBeginTimeInSeconds);
        clickPackage.setClickTimeServerInSeconds(this.clickTimeServerInSeconds);
        clickPackage.setInstallBeginTimeServerInSeconds(this.installBeginTimeServerInSeconds);
        clickPackage.setInstallVersion(this.installVersion);
        clickPackage.setGooglePlayInstant(this.googlePlayInstant);
        clickPackage.setIsClick(this.isClick);
        AdTraceSigner.sign(parameters, ActivityKind.CLICK.toString(), clickPackage.getClientSdk(), this.adtraceConfig.context, this.adtraceConfig.logger);
        clickPackage.setParameters(parameters);
        return clickPackage;
    }

    ActivityPackage buildAttributionPackage(String initiatedByDescription) {
        Map<String, String> parameters = this.getAttributionParameters(initiatedByDescription);
        ActivityPackage attributionPackage = this.getDefaultActivityPackage(ActivityKind.ATTRIBUTION);
        attributionPackage.setPath("attribution");
        attributionPackage.setSuffix("");
        AdTraceSigner.sign(parameters, ActivityKind.ATTRIBUTION.toString(), attributionPackage.getClientSdk(), this.adtraceConfig.context, this.adtraceConfig.logger);
        attributionPackage.setParameters(parameters);
        return attributionPackage;
    }

    ActivityPackage buildGdprPackage() {
        Map<String, String> parameters = this.getGdprParameters();
        ActivityPackage gdprPackage = this.getDefaultActivityPackage(ActivityKind.GDPR);
        gdprPackage.setPath("/gdpr_forget_device");
        gdprPackage.setSuffix("");
        AdTraceSigner.sign(parameters, ActivityKind.GDPR.toString(), gdprPackage.getClientSdk(), this.adtraceConfig.context, this.adtraceConfig.logger);
        gdprPackage.setParameters(parameters);
        return gdprPackage;
    }

    ActivityPackage buildDisableThirdPartySharingPackage() {
        Map<String, String> parameters = this.getDisableThirdPartySharingParameters();
        ActivityPackage activityPackage = this.getDefaultActivityPackage(ActivityKind.DISABLE_THIRD_PARTY_SHARING);
        activityPackage.setPath("/disable_third_party_sharing");
        activityPackage.setSuffix("");
        AdTraceSigner.sign(parameters, ActivityKind.DISABLE_THIRD_PARTY_SHARING.toString(), activityPackage.getClientSdk(), this.adtraceConfig.context, this.adtraceConfig.logger);
        activityPackage.setParameters(parameters);
        return activityPackage;
    }

    ActivityPackage buildThirdPartySharingPackage(AdTraceThirdPartySharing adtraceThirdPartySharing) {
        Map<String, String> parameters = this.getThirdPartySharingParameters(adtraceThirdPartySharing);
        ActivityPackage activityPackage = this.getDefaultActivityPackage(ActivityKind.THIRD_PARTY_SHARING);
        activityPackage.setPath("/third_party_sharing");
        activityPackage.setSuffix("");
        AdTraceSigner.sign(parameters, ActivityKind.THIRD_PARTY_SHARING.toString(), activityPackage.getClientSdk(), this.adtraceConfig.context, this.adtraceConfig.logger);
        activityPackage.setParameters(parameters);
        return activityPackage;
    }

    ActivityPackage buildMeasurementConsentPackage(boolean consentMeasurement) {
        Map<String, String> parameters = this.getMeasurementConsentParameters(consentMeasurement);
        ActivityPackage activityPackage = this.getDefaultActivityPackage(ActivityKind.MEASUREMENT_CONSENT);
        activityPackage.setPath("/measurement_consent");
        activityPackage.setSuffix("");
        AdTraceSigner.sign(parameters, ActivityKind.MEASUREMENT_CONSENT.toString(), activityPackage.getClientSdk(), this.adtraceConfig.context, this.adtraceConfig.logger);
        activityPackage.setParameters(parameters);
        return activityPackage;
    }

    ActivityPackage buildAdRevenuePackage(String source, JSONObject adRevenueJson) {
        Map<String, String> parameters = this.getAdRevenueParameters(source, adRevenueJson);
        ActivityPackage adRevenuePackage = this.getDefaultActivityPackage(ActivityKind.AD_REVENUE);
        adRevenuePackage.setPath("/ad_revenue");
        adRevenuePackage.setSuffix("");
        AdTraceSigner.sign(parameters, ActivityKind.AD_REVENUE.toString(), adRevenuePackage.getClientSdk(), this.adtraceConfig.context, this.adtraceConfig.logger);
        adRevenuePackage.setParameters(parameters);
        return adRevenuePackage;
    }

    ActivityPackage buildAdRevenuePackage(AdTraceAdRevenue adtraceAdRevenue, boolean isInDelay) {
        Map<String, String> parameters = this.getAdRevenueParameters(adtraceAdRevenue, isInDelay);
        ActivityPackage adRevenuePackage = this.getDefaultActivityPackage(ActivityKind.AD_REVENUE);
        adRevenuePackage.setPath("/ad_revenue");
        adRevenuePackage.setSuffix("");
        AdTraceSigner.sign(parameters, ActivityKind.AD_REVENUE.toString(), adRevenuePackage.getClientSdk(), this.adtraceConfig.context, this.adtraceConfig.logger);
        adRevenuePackage.setParameters(parameters);
        if (isInDelay) {
            adRevenuePackage.setCallbackParameters(adtraceAdRevenue.callbackParameters);
            adRevenuePackage.setPartnerParameters(adtraceAdRevenue.partnerParameters);
        }
        return adRevenuePackage;
    }

    ActivityPackage buildSubscriptionPackage(AdTracePlayStoreSubscription subscription, boolean isInDelay) {
        Map<String, String> parameters = this.getSubscriptionParameters(subscription, isInDelay);
        ActivityPackage subscriptionPackage = this.getDefaultActivityPackage(ActivityKind.SUBSCRIPTION);
        subscriptionPackage.setPath("/v2/purchase");
        subscriptionPackage.setSuffix("");
        AdTraceSigner.sign(parameters, ActivityKind.SUBSCRIPTION.toString(), subscriptionPackage.getClientSdk(), this.adtraceConfig.context, this.adtraceConfig.logger);
        subscriptionPackage.setParameters(parameters);
        return subscriptionPackage;
    }

    ActivityPackage buildVerificationPackage(AdTracePurchase purchase, OnPurchaseVerificationFinishedListener callback) {
        Map<String, String> parameters = this.getVerificationParameters(purchase);
        ActivityPackage purchaseVerificationPackage = this.getDefaultActivityPackage(ActivityKind.PURCHASE_VERIFICATION);
        purchaseVerificationPackage.setPath("/verify");
        purchaseVerificationPackage.setSuffix("");
        purchaseVerificationPackage.setPurchaseVerificationCallback(callback);
        AdTraceSigner.sign(parameters, ActivityKind.PURCHASE_VERIFICATION.toString(), purchaseVerificationPackage.getClientSdk(), this.adtraceConfig.context, this.adtraceConfig.logger);
        purchaseVerificationPackage.setParameters(parameters);
        return purchaseVerificationPackage;
    }

    private Map<String, String> getSessionParameters(boolean isInDelay) {
        Map<String, String> oaidParameters;
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Util.getImeiParameters(this.adtraceConfig, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Util.getOaidParameters(this.adtraceConfig, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        if (!isInDelay) {
            PackageBuilder.addMapJson(parameters, "callback_params", this.sessionParameters.callbackParameters);
            PackageBuilder.addMapJson(parameters, "partner_params", this.sessionParameters.partnerParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adtraceConfig);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(this.adtraceConfig));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(this.adtraceConfig));
        PackageBuilder.addString(parameters, "google_app_set_id", this.deviceInfo.appSetId);
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adtraceConfig);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adtraceConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adtraceConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addLong(parameters, "connectivity_type", Util.getConnectivityType(this.adtraceConfig.context));
        PackageBuilder.addString(parameters, "country", this.deviceInfo.country);
        PackageBuilder.addString(parameters, "cpu_type", this.deviceInfo.abi);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addString(parameters, "default_tracker", this.adtraceConfig.defaultTracker);
        PackageBuilder.addBoolean(parameters, "device_known", this.adtraceConfig.deviceKnown);
        PackageBuilder.addBoolean(parameters, "needs_cost", this.adtraceConfig.needsCost);
        PackageBuilder.addString(parameters, "device_manufacturer", this.deviceInfo.deviceManufacturer);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addLong(parameters, "ui_mode", this.deviceInfo.uiMode);
        PackageBuilder.addString(parameters, "display_height", this.deviceInfo.displayHeight);
        PackageBuilder.addString(parameters, "display_width", this.deviceInfo.displayWidth);
        PackageBuilder.addString(parameters, "environment", this.adtraceConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adtraceConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adtraceConfig.externalDeviceId);
        PackageBuilder.addString(parameters, "fb_id", this.deviceInfo.fbAttributionId);
        PackageBuilder.addString(parameters, "hardware_name", this.deviceInfo.hardwareName);
        PackageBuilder.addString(parameters, "installed_at", this.deviceInfo.appInstallTime);
        PackageBuilder.addString(parameters, "language", this.deviceInfo.language);
        PackageBuilder.addDuration(parameters, "last_interval", this.activityStateCopy.lastInterval);
        PackageBuilder.addString(parameters, "mcc", Util.getMcc(this.adtraceConfig.context));
        PackageBuilder.addString(parameters, "mnc", Util.getMnc(this.adtraceConfig.context));
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "os_build", this.deviceInfo.buildName);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "screen_density", this.deviceInfo.screenDensity);
        PackageBuilder.addString(parameters, "screen_format", this.deviceInfo.screenFormat);
        PackageBuilder.addString(parameters, "screen_size", this.deviceInfo.screenSize);
        PackageBuilder.addString(parameters, "secret_id", this.adtraceConfig.secretId);
        PackageBuilder.addLong(parameters, "session_count", this.activityStateCopy.sessionCount);
        PackageBuilder.addDuration(parameters, "session_length", this.activityStateCopy.sessionLength);
        PackageBuilder.addLong(parameters, "subsession_count", this.activityStateCopy.subsessionCount);
        PackageBuilder.addDuration(parameters, "time_spent", this.activityStateCopy.timeSpent);
        PackageBuilder.addString(parameters, "updated_at", this.deviceInfo.appUpdateTime);
        PackageBuilder.addBoolean(parameters, "gpg_pc_enabled", this.deviceInfo.isGooglePlayGamesForPC ? Boolean.valueOf(true) : null);
        this.injectFeatureFlagsWithParameters(parameters);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    public Map<String, String> getEventParameters(AdTraceEvent event, boolean isInDelay) {
        Map<String, String> oaidParameters;
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Util.getImeiParameters(this.adtraceConfig, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Util.getOaidParameters(this.adtraceConfig, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        if (!isInDelay) {
            PackageBuilder.addMapJson(parameters, "callback_params", Util.mergeParameters(this.sessionParameters.callbackParameters, event.callbackParameters, "Callback"));
            PackageBuilder.addMapJson(parameters, "event_value_params", Util.mergeParameters(this.sessionParameters.partnerParameters, event.eventValueParameters, "EventValueParams"));
            PackageBuilder.addMapJson(parameters, "partner_params", Util.mergeParameters(this.sessionParameters.partnerParameters, event.partnerParameters, "Partner"));
        }
        this.deviceInfo.reloadPlayIds(this.adtraceConfig);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(this.adtraceConfig));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(this.adtraceConfig));
        PackageBuilder.addString(parameters, "google_app_set_id", this.deviceInfo.appSetId);
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adtraceConfig);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adtraceConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adtraceConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addLong(parameters, "connectivity_type", Util.getConnectivityType(this.adtraceConfig.context));
        PackageBuilder.addString(parameters, "country", this.deviceInfo.country);
        PackageBuilder.addString(parameters, "cpu_type", this.deviceInfo.abi);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addString(parameters, "currency", event.currency);
        PackageBuilder.addBoolean(parameters, "device_known", this.adtraceConfig.deviceKnown);
        PackageBuilder.addBoolean(parameters, "needs_cost", this.adtraceConfig.needsCost);
        PackageBuilder.addString(parameters, "device_manufacturer", this.deviceInfo.deviceManufacturer);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addLong(parameters, "ui_mode", this.deviceInfo.uiMode);
        PackageBuilder.addString(parameters, "display_height", this.deviceInfo.displayHeight);
        PackageBuilder.addString(parameters, "display_width", this.deviceInfo.displayWidth);
        PackageBuilder.addString(parameters, "environment", this.adtraceConfig.environment);
        PackageBuilder.addString(parameters, "event_callback_id", event.callbackId);
        PackageBuilder.addLong(parameters, "event_count", this.activityStateCopy.eventCount);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adtraceConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "event_token", event.eventToken);
        PackageBuilder.addString(parameters, "external_device_id", this.adtraceConfig.externalDeviceId);
        PackageBuilder.addString(parameters, "fb_id", this.deviceInfo.fbAttributionId);
        PackageBuilder.addString(parameters, "hardware_name", this.deviceInfo.hardwareName);
        PackageBuilder.addString(parameters, "language", this.deviceInfo.language);
        PackageBuilder.addDuration(parameters, "last_interval", this.activityStateCopy.lastIntervalHardReset);
        PackageBuilder.addString(parameters, "mcc", Util.getMcc(this.adtraceConfig.context));
        PackageBuilder.addString(parameters, "mnc", Util.getMnc(this.adtraceConfig.context));
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "os_build", this.deviceInfo.buildName);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "product_id", event.productId);
        PackageBuilder.addString(parameters, "purchase_token", event.purchaseToken);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addDouble(parameters, "revenue", event.revenue);
        PackageBuilder.addString(parameters, "deduplication_id", event.orderId);
        PackageBuilder.addString(parameters, "screen_density", this.deviceInfo.screenDensity);
        PackageBuilder.addString(parameters, "screen_format", this.deviceInfo.screenFormat);
        PackageBuilder.addString(parameters, "screen_size", this.deviceInfo.screenSize);
        PackageBuilder.addString(parameters, "secret_id", this.adtraceConfig.secretId);
        PackageBuilder.addLong(parameters, "session_count", this.activityStateCopy.sessionCount);
        PackageBuilder.addDuration(parameters, "session_length", this.activityStateCopy.sessionLength);
        PackageBuilder.addLong(parameters, "subsession_count", this.activityStateCopy.subsessionCount);
        PackageBuilder.addDuration(parameters, "time_spent", this.activityStateCopy.timeSpent);
        PackageBuilder.addBoolean(parameters, "gpg_pc_enabled", this.deviceInfo.isGooglePlayGamesForPC ? Boolean.valueOf(true) : null);
        this.injectFeatureFlagsWithParameters(parameters);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getInfoParameters(String source) {
        Map<String, String> oaidParameters;
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Util.getImeiParameters(this.adtraceConfig, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Util.getOaidParameters(this.adtraceConfig, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adtraceConfig);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(this.adtraceConfig));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(this.adtraceConfig));
        PackageBuilder.addString(parameters, "google_app_set_id", this.deviceInfo.appSetId);
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adtraceConfig);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
        }
        PackageBuilder.addString(parameters, "app_secret", this.adtraceConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adtraceConfig.appToken);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addBoolean(parameters, "device_known", this.adtraceConfig.deviceKnown);
        PackageBuilder.addBoolean(parameters, "needs_cost", this.adtraceConfig.needsCost);
        PackageBuilder.addString(parameters, "environment", this.adtraceConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adtraceConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adtraceConfig.externalDeviceId);
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "secret_id", this.adtraceConfig.secretId);
        PackageBuilder.addString(parameters, "source", source);
        PackageBuilder.addBoolean(parameters, "gpg_pc_enabled", this.deviceInfo.isGooglePlayGamesForPC ? Boolean.valueOf(true) : null);
        this.injectFeatureFlagsWithParameters(parameters);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getClickParameters(String source) {
        Map<String, String> oaidParameters;
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Util.getImeiParameters(this.adtraceConfig, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Util.getOaidParameters(this.adtraceConfig, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adtraceConfig);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(this.adtraceConfig));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(this.adtraceConfig));
        PackageBuilder.addString(parameters, "google_app_set_id", this.deviceInfo.appSetId);
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adtraceConfig);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
        }
        if (this.attribution != null) {
            PackageBuilder.addString(parameters, "tracker", this.attribution.trackerName);
            PackageBuilder.addString(parameters, "campaign", this.attribution.campaign);
            PackageBuilder.addString(parameters, "adgroup", this.attribution.adgroup);
            PackageBuilder.addString(parameters, "creative", this.attribution.creative);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adtraceConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adtraceConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addMapJson(parameters, "callback_params", this.sessionParameters.callbackParameters);
        PackageBuilder.addDateInMilliseconds(parameters, "click_time", this.clickTimeInMilliseconds);
        PackageBuilder.addDateInSeconds(parameters, "click_time", this.clickTimeInSeconds);
        PackageBuilder.addDateInSeconds(parameters, "click_time_server", this.clickTimeServerInSeconds);
        PackageBuilder.addLong(parameters, "connectivity_type", Util.getConnectivityType(this.adtraceConfig.context));
        PackageBuilder.addString(parameters, "country", this.deviceInfo.country);
        PackageBuilder.addString(parameters, "cpu_type", this.deviceInfo.abi);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addString(parameters, "deeplink", this.deeplink);
        PackageBuilder.addString(parameters, "default_tracker", this.adtraceConfig.defaultTracker);
        PackageBuilder.addBoolean(parameters, "device_known", this.adtraceConfig.deviceKnown);
        PackageBuilder.addBoolean(parameters, "needs_cost", this.adtraceConfig.needsCost);
        PackageBuilder.addString(parameters, "device_manufacturer", this.deviceInfo.deviceManufacturer);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addLong(parameters, "ui_mode", this.deviceInfo.uiMode);
        PackageBuilder.addString(parameters, "display_height", this.deviceInfo.displayHeight);
        PackageBuilder.addString(parameters, "display_width", this.deviceInfo.displayWidth);
        PackageBuilder.addString(parameters, "environment", this.adtraceConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adtraceConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adtraceConfig.externalDeviceId);
        PackageBuilder.addString(parameters, "fb_id", this.deviceInfo.fbAttributionId);
        PackageBuilder.addBoolean(parameters, "google_play_instant", this.googlePlayInstant);
        PackageBuilder.addBoolean(parameters, "is_click", this.isClick);
        PackageBuilder.addString(parameters, "hardware_name", this.deviceInfo.hardwareName);
        PackageBuilder.addDateInSeconds(parameters, "install_begin_time", this.installBeginTimeInSeconds);
        PackageBuilder.addDateInSeconds(parameters, "install_begin_time_server", this.installBeginTimeServerInSeconds);
        PackageBuilder.addString(parameters, "install_version", this.installVersion);
        PackageBuilder.addString(parameters, "installed_at", this.deviceInfo.appInstallTime);
        PackageBuilder.addString(parameters, "language", this.deviceInfo.language);
        PackageBuilder.addDuration(parameters, "last_interval", this.activityStateCopy.lastIntervalHardReset);
        PackageBuilder.addString(parameters, "mcc", Util.getMcc(this.adtraceConfig.context));
        PackageBuilder.addString(parameters, "mnc", Util.getMnc(this.adtraceConfig.context));
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "os_build", this.deviceInfo.buildName);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addMapJson(parameters, "params", this.extraParameters);
        PackageBuilder.addMapJson(parameters, "partner_params", this.sessionParameters.partnerParameters);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "raw_referrer", this.rawReferrer);
        PackageBuilder.addString(parameters, "referrer", this.referrer);
        PackageBuilder.addString(parameters, "referrer_api", this.referrerApi);
        PackageBuilder.addString(parameters, "reftag", this.reftag);
        PackageBuilder.addString(parameters, "screen_density", this.deviceInfo.screenDensity);
        PackageBuilder.addString(parameters, "screen_format", this.deviceInfo.screenFormat);
        PackageBuilder.addString(parameters, "screen_size", this.deviceInfo.screenSize);
        PackageBuilder.addString(parameters, "secret_id", this.adtraceConfig.secretId);
        PackageBuilder.addLong(parameters, "session_count", this.activityStateCopy.sessionCount);
        PackageBuilder.addDuration(parameters, "session_length", this.activityStateCopy.sessionLength);
        PackageBuilder.addString(parameters, "source", source);
        PackageBuilder.addLong(parameters, "subsession_count", this.activityStateCopy.subsessionCount);
        PackageBuilder.addDuration(parameters, "time_spent", this.activityStateCopy.timeSpent);
        PackageBuilder.addString(parameters, "updated_at", this.deviceInfo.appUpdateTime);
        PackageBuilder.addString(parameters, "payload", this.preinstallPayload);
        PackageBuilder.addString(parameters, "found_location", this.preinstallLocation);
        PackageBuilder.addBoolean(parameters, "gpg_pc_enabled", this.deviceInfo.isGooglePlayGamesForPC ? Boolean.valueOf(true) : null);
        this.injectFeatureFlagsWithParameters(parameters);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getAttributionParameters(String initiatedBy) {
        Map<String, String> oaidParameters;
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Util.getImeiParameters(this.adtraceConfig, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Util.getOaidParameters(this.adtraceConfig, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adtraceConfig);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(this.adtraceConfig));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(this.adtraceConfig));
        PackageBuilder.addString(parameters, "google_app_set_id", this.deviceInfo.appSetId);
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adtraceConfig);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adtraceConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adtraceConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addBoolean(parameters, "device_known", this.adtraceConfig.deviceKnown);
        PackageBuilder.addBoolean(parameters, "needs_cost", this.adtraceConfig.needsCost);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addLong(parameters, "ui_mode", this.deviceInfo.uiMode);
        PackageBuilder.addString(parameters, "environment", this.adtraceConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adtraceConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adtraceConfig.externalDeviceId);
        PackageBuilder.addString(parameters, "initiated_by", initiatedBy);
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "secret_id", this.adtraceConfig.secretId);
        PackageBuilder.addBoolean(parameters, "gpg_pc_enabled", this.deviceInfo.isGooglePlayGamesForPC ? Boolean.valueOf(true) : null);
        this.injectFeatureFlagsWithParameters(parameters);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getGdprParameters() {
        Map<String, String> oaidParameters;
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Util.getImeiParameters(this.adtraceConfig, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Util.getOaidParameters(this.adtraceConfig, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adtraceConfig);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(this.adtraceConfig));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(this.adtraceConfig));
        PackageBuilder.addString(parameters, "google_app_set_id", this.deviceInfo.appSetId);
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adtraceConfig);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adtraceConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adtraceConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addBoolean(parameters, "device_known", this.adtraceConfig.deviceKnown);
        PackageBuilder.addBoolean(parameters, "needs_cost", this.adtraceConfig.needsCost);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addLong(parameters, "ui_mode", this.deviceInfo.uiMode);
        PackageBuilder.addString(parameters, "environment", this.adtraceConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adtraceConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adtraceConfig.externalDeviceId);
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "secret_id", this.adtraceConfig.secretId);
        PackageBuilder.addBoolean(parameters, "gpg_pc_enabled", this.deviceInfo.isGooglePlayGamesForPC ? Boolean.valueOf(true) : null);
        this.injectFeatureFlagsWithParameters(parameters);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getDisableThirdPartySharingParameters() {
        Map<String, String> oaidParameters;
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Util.getImeiParameters(this.adtraceConfig, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Util.getOaidParameters(this.adtraceConfig, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adtraceConfig);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(this.adtraceConfig));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(this.adtraceConfig));
        PackageBuilder.addString(parameters, "google_app_set_id", this.deviceInfo.appSetId);
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adtraceConfig);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adtraceConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adtraceConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addBoolean(parameters, "device_known", this.adtraceConfig.deviceKnown);
        PackageBuilder.addBoolean(parameters, "needs_cost", this.adtraceConfig.needsCost);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addLong(parameters, "ui_mode", this.deviceInfo.uiMode);
        PackageBuilder.addString(parameters, "environment", this.adtraceConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adtraceConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adtraceConfig.externalDeviceId);
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "secret_id", this.adtraceConfig.secretId);
        PackageBuilder.addBoolean(parameters, "gpg_pc_enabled", this.deviceInfo.isGooglePlayGamesForPC ? Boolean.valueOf(true) : null);
        this.injectFeatureFlagsWithParameters(parameters);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getThirdPartySharingParameters(AdTraceThirdPartySharing adtraceThirdPartySharing) {
        Map<String, String> oaidParameters;
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Util.getImeiParameters(this.adtraceConfig, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Util.getOaidParameters(this.adtraceConfig, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        if (adtraceThirdPartySharing.isEnabled != null) {
            PackageBuilder.addString(parameters, "sharing", adtraceThirdPartySharing.isEnabled != false ? "enable" : "disable");
        }
        PackageBuilder.addMapJson(parameters, "granular_third_party_sharing_options", adtraceThirdPartySharing.granularOptions);
        PackageBuilder.addMapJson(parameters, "partner_sharing_settings", adtraceThirdPartySharing.partnerSharingSettings);
        this.deviceInfo.reloadPlayIds(this.adtraceConfig);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(this.adtraceConfig));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(this.adtraceConfig));
        PackageBuilder.addString(parameters, "google_app_set_id", this.deviceInfo.appSetId);
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adtraceConfig);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adtraceConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adtraceConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addBoolean(parameters, "device_known", this.adtraceConfig.deviceKnown);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addLong(parameters, "ui_mode", this.deviceInfo.uiMode);
        PackageBuilder.addString(parameters, "environment", this.adtraceConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adtraceConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adtraceConfig.externalDeviceId);
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "secret_id", this.adtraceConfig.secretId);
        PackageBuilder.addBoolean(parameters, "gpg_pc_enabled", this.deviceInfo.isGooglePlayGamesForPC ? Boolean.valueOf(true) : null);
        this.injectFeatureFlagsWithParameters(parameters);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getMeasurementConsentParameters(boolean consentMeasurement) {
        Map<String, String> oaidParameters;
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Util.getImeiParameters(this.adtraceConfig, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Util.getOaidParameters(this.adtraceConfig, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        PackageBuilder.addString(parameters, "measurement", consentMeasurement ? "enable" : "disable");
        this.deviceInfo.reloadPlayIds(this.adtraceConfig);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(this.adtraceConfig));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(this.adtraceConfig));
        PackageBuilder.addString(parameters, "google_app_set_id", this.deviceInfo.appSetId);
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adtraceConfig);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adtraceConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adtraceConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addBoolean(parameters, "device_known", this.adtraceConfig.deviceKnown);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addLong(parameters, "ui_mode", this.deviceInfo.uiMode);
        PackageBuilder.addString(parameters, "environment", this.adtraceConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adtraceConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adtraceConfig.externalDeviceId);
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "secret_id", this.adtraceConfig.secretId);
        PackageBuilder.addBoolean(parameters, "gpg_pc_enabled", this.deviceInfo.isGooglePlayGamesForPC ? Boolean.valueOf(true) : null);
        this.injectFeatureFlagsWithParameters(parameters);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getAdRevenueParameters(String source, JSONObject adRevenueJson) {
        Map<String, String> oaidParameters;
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Util.getImeiParameters(this.adtraceConfig, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Util.getOaidParameters(this.adtraceConfig, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adtraceConfig);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(this.adtraceConfig));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(this.adtraceConfig));
        PackageBuilder.addString(parameters, "google_app_set_id", this.deviceInfo.appSetId);
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adtraceConfig);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adtraceConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adtraceConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addLong(parameters, "connectivity_type", Util.getConnectivityType(this.adtraceConfig.context));
        PackageBuilder.addString(parameters, "country", this.deviceInfo.country);
        PackageBuilder.addString(parameters, "cpu_type", this.deviceInfo.abi);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addString(parameters, "default_tracker", this.adtraceConfig.defaultTracker);
        PackageBuilder.addBoolean(parameters, "device_known", this.adtraceConfig.deviceKnown);
        PackageBuilder.addBoolean(parameters, "needs_cost", this.adtraceConfig.needsCost);
        PackageBuilder.addString(parameters, "device_manufacturer", this.deviceInfo.deviceManufacturer);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addLong(parameters, "ui_mode", this.deviceInfo.uiMode);
        PackageBuilder.addString(parameters, "display_height", this.deviceInfo.displayHeight);
        PackageBuilder.addString(parameters, "display_width", this.deviceInfo.displayWidth);
        PackageBuilder.addString(parameters, "environment", this.adtraceConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adtraceConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adtraceConfig.externalDeviceId);
        PackageBuilder.addString(parameters, "fb_id", this.deviceInfo.fbAttributionId);
        PackageBuilder.addString(parameters, "hardware_name", this.deviceInfo.hardwareName);
        PackageBuilder.addString(parameters, "installed_at", this.deviceInfo.appInstallTime);
        PackageBuilder.addString(parameters, "language", this.deviceInfo.language);
        PackageBuilder.addDuration(parameters, "last_interval", this.activityStateCopy.lastInterval);
        PackageBuilder.addString(parameters, "mcc", Util.getMcc(this.adtraceConfig.context));
        PackageBuilder.addString(parameters, "mnc", Util.getMnc(this.adtraceConfig.context));
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "os_build", this.deviceInfo.buildName);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "screen_density", this.deviceInfo.screenDensity);
        PackageBuilder.addString(parameters, "screen_format", this.deviceInfo.screenFormat);
        PackageBuilder.addString(parameters, "screen_size", this.deviceInfo.screenSize);
        PackageBuilder.addString(parameters, "secret_id", this.adtraceConfig.secretId);
        PackageBuilder.addString(parameters, "source", source);
        PackageBuilder.addJsonObject(parameters, "payload", adRevenueJson);
        PackageBuilder.addLong(parameters, "session_count", this.activityStateCopy.sessionCount);
        PackageBuilder.addDuration(parameters, "session_length", this.activityStateCopy.sessionLength);
        PackageBuilder.addLong(parameters, "subsession_count", this.activityStateCopy.subsessionCount);
        PackageBuilder.addDuration(parameters, "time_spent", this.activityStateCopy.timeSpent);
        PackageBuilder.addString(parameters, "updated_at", this.deviceInfo.appUpdateTime);
        PackageBuilder.addBoolean(parameters, "gpg_pc_enabled", this.deviceInfo.isGooglePlayGamesForPC ? Boolean.valueOf(true) : null);
        this.injectFeatureFlagsWithParameters(parameters);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getAdRevenueParameters(AdTraceAdRevenue adtraceAdRevenue, boolean isInDelay) {
        Map<String, String> oaidParameters;
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Util.getImeiParameters(this.adtraceConfig, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Util.getOaidParameters(this.adtraceConfig, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        if (!isInDelay) {
            PackageBuilder.addMapJson(parameters, "callback_params", Util.mergeParameters(this.sessionParameters.callbackParameters, adtraceAdRevenue.callbackParameters, "Callback"));
            PackageBuilder.addMapJson(parameters, "partner_params", Util.mergeParameters(this.sessionParameters.partnerParameters, adtraceAdRevenue.partnerParameters, "Partner"));
        }
        this.deviceInfo.reloadPlayIds(this.adtraceConfig);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(this.adtraceConfig));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(this.adtraceConfig));
        PackageBuilder.addString(parameters, "google_app_set_id", this.deviceInfo.appSetId);
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adtraceConfig);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adtraceConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adtraceConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addLong(parameters, "connectivity_type", Util.getConnectivityType(this.adtraceConfig.context));
        PackageBuilder.addString(parameters, "country", this.deviceInfo.country);
        PackageBuilder.addString(parameters, "cpu_type", this.deviceInfo.abi);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addString(parameters, "default_tracker", this.adtraceConfig.defaultTracker);
        PackageBuilder.addBoolean(parameters, "device_known", this.adtraceConfig.deviceKnown);
        PackageBuilder.addBoolean(parameters, "needs_cost", this.adtraceConfig.needsCost);
        PackageBuilder.addString(parameters, "device_manufacturer", this.deviceInfo.deviceManufacturer);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addLong(parameters, "ui_mode", this.deviceInfo.uiMode);
        PackageBuilder.addString(parameters, "display_height", this.deviceInfo.displayHeight);
        PackageBuilder.addString(parameters, "display_width", this.deviceInfo.displayWidth);
        PackageBuilder.addString(parameters, "environment", this.adtraceConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adtraceConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adtraceConfig.externalDeviceId);
        PackageBuilder.addString(parameters, "fb_id", this.deviceInfo.fbAttributionId);
        PackageBuilder.addString(parameters, "hardware_name", this.deviceInfo.hardwareName);
        PackageBuilder.addString(parameters, "installed_at", this.deviceInfo.appInstallTime);
        PackageBuilder.addString(parameters, "language", this.deviceInfo.language);
        PackageBuilder.addDuration(parameters, "last_interval", this.activityStateCopy.lastInterval);
        PackageBuilder.addString(parameters, "mcc", Util.getMcc(this.adtraceConfig.context));
        PackageBuilder.addString(parameters, "mnc", Util.getMnc(this.adtraceConfig.context));
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "os_build", this.deviceInfo.buildName);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "screen_density", this.deviceInfo.screenDensity);
        PackageBuilder.addString(parameters, "screen_format", this.deviceInfo.screenFormat);
        PackageBuilder.addString(parameters, "screen_size", this.deviceInfo.screenSize);
        PackageBuilder.addString(parameters, "secret_id", this.adtraceConfig.secretId);
        PackageBuilder.addString(parameters, "source", adtraceAdRevenue.source);
        PackageBuilder.addDoubleWithoutRounding(parameters, "revenue", adtraceAdRevenue.revenue);
        PackageBuilder.addString(parameters, "currency", adtraceAdRevenue.currency);
        PackageBuilder.addInteger(parameters, "ad_impressions_count", adtraceAdRevenue.adImpressionsCount);
        PackageBuilder.addString(parameters, "ad_revenue_network", adtraceAdRevenue.adRevenueNetwork);
        PackageBuilder.addString(parameters, "ad_revenue_unit", adtraceAdRevenue.adRevenueUnit);
        PackageBuilder.addString(parameters, "ad_revenue_placement", adtraceAdRevenue.adRevenuePlacement);
        PackageBuilder.addLong(parameters, "session_count", this.activityStateCopy.sessionCount);
        PackageBuilder.addDuration(parameters, "session_length", this.activityStateCopy.sessionLength);
        PackageBuilder.addLong(parameters, "subsession_count", this.activityStateCopy.subsessionCount);
        PackageBuilder.addDuration(parameters, "time_spent", this.activityStateCopy.timeSpent);
        PackageBuilder.addString(parameters, "updated_at", this.deviceInfo.appUpdateTime);
        PackageBuilder.addBoolean(parameters, "gpg_pc_enabled", this.deviceInfo.isGooglePlayGamesForPC ? Boolean.valueOf(true) : null);
        this.injectFeatureFlagsWithParameters(parameters);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getSubscriptionParameters(AdTracePlayStoreSubscription subscription, boolean isInDelay) {
        Map<String, String> oaidParameters;
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Util.getImeiParameters(this.adtraceConfig, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Util.getOaidParameters(this.adtraceConfig, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adtraceConfig);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(this.adtraceConfig));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(this.adtraceConfig));
        PackageBuilder.addString(parameters, "google_app_set_id", this.deviceInfo.appSetId);
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adtraceConfig);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
        }
        if (!isInDelay) {
            PackageBuilder.addMapJson(parameters, "callback_params", Util.mergeParameters(this.sessionParameters.callbackParameters, subscription.getCallbackParameters(), "Callback"));
            PackageBuilder.addMapJson(parameters, "partner_params", Util.mergeParameters(this.sessionParameters.partnerParameters, subscription.getPartnerParameters(), "Partner"));
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adtraceConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adtraceConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addLong(parameters, "connectivity_type", Util.getConnectivityType(this.adtraceConfig.context));
        PackageBuilder.addString(parameters, "country", this.deviceInfo.country);
        PackageBuilder.addString(parameters, "cpu_type", this.deviceInfo.abi);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addString(parameters, "default_tracker", this.adtraceConfig.defaultTracker);
        PackageBuilder.addBoolean(parameters, "device_known", this.adtraceConfig.deviceKnown);
        PackageBuilder.addBoolean(parameters, "needs_cost", this.adtraceConfig.needsCost);
        PackageBuilder.addString(parameters, "device_manufacturer", this.deviceInfo.deviceManufacturer);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addLong(parameters, "ui_mode", this.deviceInfo.uiMode);
        PackageBuilder.addString(parameters, "display_height", this.deviceInfo.displayHeight);
        PackageBuilder.addString(parameters, "display_width", this.deviceInfo.displayWidth);
        PackageBuilder.addString(parameters, "environment", this.adtraceConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adtraceConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adtraceConfig.externalDeviceId);
        PackageBuilder.addString(parameters, "fb_id", this.deviceInfo.fbAttributionId);
        PackageBuilder.addString(parameters, "hardware_name", this.deviceInfo.hardwareName);
        PackageBuilder.addString(parameters, "installed_at", this.deviceInfo.appInstallTime);
        PackageBuilder.addString(parameters, "language", this.deviceInfo.language);
        PackageBuilder.addDuration(parameters, "last_interval", this.activityStateCopy.lastInterval);
        PackageBuilder.addString(parameters, "mcc", Util.getMcc(this.adtraceConfig.context));
        PackageBuilder.addString(parameters, "mnc", Util.getMnc(this.adtraceConfig.context));
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "os_build", this.deviceInfo.buildName);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "screen_density", this.deviceInfo.screenDensity);
        PackageBuilder.addString(parameters, "screen_format", this.deviceInfo.screenFormat);
        PackageBuilder.addString(parameters, "screen_size", this.deviceInfo.screenSize);
        PackageBuilder.addString(parameters, "secret_id", this.adtraceConfig.secretId);
        PackageBuilder.addLong(parameters, "session_count", this.activityStateCopy.sessionCount);
        PackageBuilder.addDuration(parameters, "session_length", this.activityStateCopy.sessionLength);
        PackageBuilder.addLong(parameters, "subsession_count", this.activityStateCopy.subsessionCount);
        PackageBuilder.addDuration(parameters, "time_spent", this.activityStateCopy.timeSpent);
        PackageBuilder.addString(parameters, "updated_at", this.deviceInfo.appUpdateTime);
        PackageBuilder.addString(parameters, "billing_store", subscription.getBillingStore());
        PackageBuilder.addString(parameters, "currency", subscription.getCurrency());
        PackageBuilder.addString(parameters, "product_id", subscription.getSku());
        PackageBuilder.addString(parameters, "purchase_token", subscription.getPurchaseToken());
        PackageBuilder.addString(parameters, "receipt", subscription.getSignature());
        PackageBuilder.addLong(parameters, "revenue", subscription.getPrice());
        PackageBuilder.addDateInMilliseconds(parameters, "transaction_date", subscription.getPurchaseTime());
        PackageBuilder.addString(parameters, "transaction_id", subscription.getOrderId());
        PackageBuilder.addBoolean(parameters, "gpg_pc_enabled", this.deviceInfo.isGooglePlayGamesForPC ? Boolean.valueOf(true) : null);
        this.injectFeatureFlagsWithParameters(parameters);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getVerificationParameters(AdTracePurchase purchase) {
        Map<String, String> oaidParameters;
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Util.getImeiParameters(this.adtraceConfig, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Util.getOaidParameters(this.adtraceConfig, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adtraceConfig);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(this.adtraceConfig));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(this.adtraceConfig));
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adtraceConfig);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adtraceConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adtraceConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addLong(parameters, "connectivity_type", Util.getConnectivityType(this.adtraceConfig.context));
        PackageBuilder.addString(parameters, "country", this.deviceInfo.country);
        PackageBuilder.addString(parameters, "cpu_type", this.deviceInfo.abi);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addString(parameters, "default_tracker", this.adtraceConfig.defaultTracker);
        PackageBuilder.addBoolean(parameters, "device_known", this.adtraceConfig.deviceKnown);
        PackageBuilder.addBoolean(parameters, "needs_cost", this.adtraceConfig.needsCost);
        PackageBuilder.addString(parameters, "device_manufacturer", this.deviceInfo.deviceManufacturer);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addLong(parameters, "ui_mode", this.deviceInfo.uiMode);
        PackageBuilder.addString(parameters, "display_height", this.deviceInfo.displayHeight);
        PackageBuilder.addString(parameters, "display_width", this.deviceInfo.displayWidth);
        PackageBuilder.addString(parameters, "environment", this.adtraceConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adtraceConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adtraceConfig.externalDeviceId);
        PackageBuilder.addString(parameters, "fb_id", this.deviceInfo.fbAttributionId);
        PackageBuilder.addString(parameters, "hardware_name", this.deviceInfo.hardwareName);
        PackageBuilder.addString(parameters, "installed_at", this.deviceInfo.appInstallTime);
        PackageBuilder.addString(parameters, "language", this.deviceInfo.language);
        PackageBuilder.addDuration(parameters, "last_interval", this.activityStateCopy.lastInterval);
        PackageBuilder.addString(parameters, "mcc", Util.getMcc(this.adtraceConfig.context));
        PackageBuilder.addString(parameters, "mnc", Util.getMnc(this.adtraceConfig.context));
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "os_build", this.deviceInfo.buildName);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "screen_density", this.deviceInfo.screenDensity);
        PackageBuilder.addString(parameters, "screen_format", this.deviceInfo.screenFormat);
        PackageBuilder.addString(parameters, "screen_size", this.deviceInfo.screenSize);
        PackageBuilder.addString(parameters, "secret_id", this.adtraceConfig.secretId);
        PackageBuilder.addLong(parameters, "session_count", this.activityStateCopy.sessionCount);
        PackageBuilder.addDuration(parameters, "session_length", this.activityStateCopy.sessionLength);
        PackageBuilder.addLong(parameters, "subsession_count", this.activityStateCopy.subsessionCount);
        PackageBuilder.addDuration(parameters, "time_spent", this.activityStateCopy.timeSpent);
        PackageBuilder.addString(parameters, "updated_at", this.deviceInfo.appUpdateTime);
        PackageBuilder.addString(parameters, "product_id", purchase.getProductId());
        PackageBuilder.addString(parameters, "purchase_token", purchase.getPurchaseToken());
        PackageBuilder.addBoolean(parameters, "gpg_pc_enabled", this.deviceInfo.isGooglePlayGamesForPC ? Boolean.valueOf(true) : null);
        this.injectFeatureFlagsWithParameters(parameters);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private ActivityPackage getDefaultActivityPackage(ActivityKind activityKind) {
        ActivityPackage activityPackage = new ActivityPackage(activityKind);
        activityPackage.setClientSdk(this.deviceInfo.clientSdk);
        return activityPackage;
    }

    private void injectFeatureFlagsWithParameters(Map<String, String> parameters) {
        if (this.adtraceConfig.coppaCompliantEnabled) {
            PackageBuilder.addLong(parameters, "ff_coppa", 1L);
        }
        if (this.adtraceConfig.playStoreKidsAppEnabled) {
            PackageBuilder.addLong(parameters, "ff_play_store_kids_app", 1L);
        }
    }

    public static void addString(Map<String, String> parameters, String key, String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        parameters.put(key, value);
    }

    public static void addBoolean(Map<String, String> parameters, String key, Boolean value) {
        if (value == null) {
            return;
        }
        int intValue = value != false ? 1 : 0;
        PackageBuilder.addLong(parameters, key, intValue);
    }

    static void addJsonObject(Map<String, String> parameters, String key, JSONObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        PackageBuilder.addString(parameters, key, jsonObject.toString());
    }

    static void addMapJson(Map<String, String> parameters, String key, Map map) {
        if (map == null) {
            return;
        }
        if (map.size() == 0) {
            return;
        }
        JSONObject jsonObject = new JSONObject(map);
        String jsonString = jsonObject.toString();
        PackageBuilder.addString(parameters, key, jsonString);
    }

    public static void addLong(Map<String, String> parameters, String key, long value) {
        if (value < 0L) {
            return;
        }
        String valueString = Long.toString(value);
        PackageBuilder.addString(parameters, key, valueString);
    }

    private static void addDateInMilliseconds(Map<String, String> parameters, String key, long value) {
        if (value <= 0L) {
            return;
        }
        Date date = new Date(value);
        PackageBuilder.addDate(parameters, key, date);
    }

    private static void addDateInSeconds(Map<String, String> parameters, String key, long value) {
        if (value <= 0L) {
            return;
        }
        Date date = new Date(value * 1000L);
        PackageBuilder.addDate(parameters, key, date);
    }

    private static void addDate(Map<String, String> parameters, String key, Date value) {
        if (value == null) {
            return;
        }
        String dateString = Util.dateFormatter.format(value);
        PackageBuilder.addString(parameters, key, dateString);
    }

    private static void addDuration(Map<String, String> parameters, String key, long durationInMilliSeconds) {
        if (durationInMilliSeconds < 0L) {
            return;
        }
        long durationInSeconds = (durationInMilliSeconds + 500L) / 1000L;
        PackageBuilder.addLong(parameters, key, durationInSeconds);
    }

    private static void addDouble(Map<String, String> parameters, String key, Double value) {
        if (value == null) {
            return;
        }
        String doubleString = Util.formatString("%.5f", value);
        PackageBuilder.addString(parameters, key, doubleString);
    }

    private static void addDoubleWithoutRounding(Map<String, String> parameters, String key, Double value) {
        if (value == null) {
            return;
        }
        String doubleString = Double.toString(value);
        PackageBuilder.addString(parameters, key, doubleString);
    }

    private static void addInteger(Map<String, String> parameters, String key, Integer value) {
        if (value == null) {
            return;
        }
        String intString = Integer.toString(value);
        PackageBuilder.addString(parameters, key, intString);
    }

    private boolean containsPlayIds(Map<String, String> parameters) {
        if (parameters == null) {
            return false;
        }
        return parameters.containsKey("gps_adid");
    }

    private boolean containsFireIds(Map<String, String> parameters) {
        if (parameters == null) {
            return false;
        }
        return parameters.containsKey("fire_adid");
    }

    private void checkDeviceIds(Map<String, String> parameters) {
        if (!(parameters == null || parameters.containsKey("android_id") || parameters.containsKey("gps_adid") || parameters.containsKey("fire_adid") || parameters.containsKey("oaid") || parameters.containsKey("imei") || parameters.containsKey("meid") || parameters.containsKey("device_id") || parameters.containsKey("imeis") || parameters.containsKey("meids") || parameters.containsKey("device_ids"))) {
            if (this.adtraceConfig.coppaCompliantEnabled) {
                logger.info("Missing Device IDs. COPPA enabled.", new Object[0]);
            } else {
                logger.error("Missing Device IDs. Please check if Proguard is correctly set with AdTrace SDK", new Object[0]);
            }
        }
    }

    private String getEventSuffix(AdTraceEvent event) {
        if (event.revenue == null) {
            return Util.formatString("'%s'", event.eventToken);
        }
        return Util.formatString("(%.5f %s, '%s')", event.revenue, event.currency, event.eventToken);
    }

    private class ActivityStateCopy {
        int eventCount = -1;
        int sessionCount = -1;
        int subsessionCount = -1;
        long timeSpent = -1L;
        long lastInterval = -1L;
        long lastIntervalHardReset = -1L;
        long sessionLength = -1L;
        String uuid = null;
        String pushToken = null;

        ActivityStateCopy(ActivityState activityState) {
            if (activityState == null) {
                return;
            }
            this.eventCount = activityState.eventCount;
            this.sessionCount = activityState.sessionCount;
            this.subsessionCount = activityState.subsessionCount;
            this.timeSpent = activityState.timeSpent;
            this.lastInterval = activityState.lastInterval;
            this.lastIntervalHardReset = activityState.lastIntervalHardReset;
            this.sessionLength = activityState.sessionLength;
            this.uuid = activityState.uuid;
            this.pushToken = activityState.pushToken;
        }
    }
}

