/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk;

import io.adtrace.sdk.ActivityPackage;
import io.adtrace.sdk.AdTraceFactory;
import io.adtrace.sdk.BackoffStrategy;
import io.adtrace.sdk.IActivityHandler;
import io.adtrace.sdk.ILogger;
import io.adtrace.sdk.ISdkClickHandler;
import io.adtrace.sdk.PackageBuilder;
import io.adtrace.sdk.PackageFactory;
import io.adtrace.sdk.PreinstallUtil;
import io.adtrace.sdk.ResponseData;
import io.adtrace.sdk.SdkClickResponseData;
import io.adtrace.sdk.SharedPreferencesManager;
import io.adtrace.sdk.TrackingState;
import io.adtrace.sdk.Util;
import io.adtrace.sdk.network.IActivityPackageSender;
import io.adtrace.sdk.scheduler.SingleThreadCachedScheduler;
import io.adtrace.sdk.scheduler.ThreadScheduler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;

public class SdkClickHandler
implements ISdkClickHandler {
    private static final double MILLISECONDS_TO_SECONDS_DIVISOR = 1000.0;
    private static final String SCHEDULED_EXECUTOR_SOURCE = "SdkClickHandler";
    private static final String SOURCE_REFTAG = "reftag";
    private static final String SOURCE_INSTALL_REFERRER = "install_referrer";
    private boolean paused;
    private ILogger logger;
    private BackoffStrategy backoffStrategy;
    private List<ActivityPackage> packageQueue;
    private ThreadScheduler scheduler;
    private WeakReference<IActivityHandler> activityHandlerWeakRef;
    private IActivityPackageSender activityPackageSender;

    public SdkClickHandler(IActivityHandler activityHandler, boolean startsSending, IActivityPackageSender sdkClickHandlerActivityPackageSender) {
        this.init(activityHandler, startsSending, sdkClickHandlerActivityPackageSender);
        this.logger = AdTraceFactory.getLogger();
        this.backoffStrategy = AdTraceFactory.getSdkClickBackoffStrategy();
        this.scheduler = new SingleThreadCachedScheduler(SCHEDULED_EXECUTOR_SOURCE);
    }

    @Override
    public void init(IActivityHandler activityHandler, boolean startsSending, IActivityPackageSender sdkClickHandlerActivityPackageSender) {
        this.paused = !startsSending;
        this.packageQueue = new ArrayList<ActivityPackage>();
        this.activityHandlerWeakRef = new WeakReference<IActivityHandler>(activityHandler);
        this.activityPackageSender = sdkClickHandlerActivityPackageSender;
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
        this.sendNextSdkClick();
    }

    @Override
    public void sendSdkClick(final ActivityPackage sdkClick) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                SdkClickHandler.this.packageQueue.add(sdkClick);
                SdkClickHandler.this.logger.debug("Added sdk_click %d", SdkClickHandler.this.packageQueue.size());
                SdkClickHandler.this.logger.verbose("%s", sdkClick.getExtendedString());
                SdkClickHandler.this.sendNextSdkClick();
            }
        });
    }

    @Override
    public void sendReftagReferrers() {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                IActivityHandler activityHandler = (IActivityHandler)SdkClickHandler.this.activityHandlerWeakRef.get();
                SharedPreferencesManager sharedPreferencesManager = SharedPreferencesManager.getDefaultInstance(activityHandler.getContext());
                try {
                    JSONArray rawReferrerArray = sharedPreferencesManager.getRawReferrerArray();
                    boolean hasRawReferrersBeenChanged = false;
                    for (int i = 0; i < rawReferrerArray.length(); ++i) {
                        JSONArray savedRawReferrer = rawReferrerArray.getJSONArray(i);
                        int savedRawReferrerState = savedRawReferrer.optInt(2, -1);
                        if (savedRawReferrerState != 0) continue;
                        String savedRawReferrerString = savedRawReferrer.optString(0, null);
                        long savedClickTime = savedRawReferrer.optLong(1, -1L);
                        savedRawReferrer.put(2, 1);
                        hasRawReferrersBeenChanged = true;
                        ActivityPackage sdkClickPackage = PackageFactory.buildReftagSdkClickPackage(savedRawReferrerString, savedClickTime, activityHandler.getActivityState(), activityHandler.getAdTraceConfig(), activityHandler.getDeviceInfo(), activityHandler.getSessionParameters());
                        SdkClickHandler.this.sendSdkClick(sdkClickPackage);
                    }
                    if (hasRawReferrersBeenChanged) {
                        sharedPreferencesManager.saveRawReferrerArray(rawReferrerArray);
                    }
                }
                catch (JSONException e) {
                    SdkClickHandler.this.logger.error("Send saved raw referrers error (%s)", e.getMessage());
                }
            }
        });
    }

    @Override
    public void sendPreinstallPayload(final String preinstallPayload, final String preinstallLocation) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                IActivityHandler activityHandler = (IActivityHandler)SdkClickHandler.this.activityHandlerWeakRef.get();
                if (activityHandler == null) {
                    return;
                }
                ActivityPackage sdkClickPackage = PackageFactory.buildPreinstallSdkClickPackage(preinstallPayload, preinstallLocation, activityHandler.getActivityState(), activityHandler.getAdTraceConfig(), activityHandler.getDeviceInfo(), activityHandler.getSessionParameters());
                SdkClickHandler.this.sendSdkClick(sdkClickPackage);
            }
        });
    }

    @Override
    public void teardown() {
        this.logger.verbose("SdkClickHandler teardown", new Object[0]);
        if (this.scheduler != null) {
            this.scheduler.teardown();
        }
        if (this.packageQueue != null) {
            this.packageQueue.clear();
        }
        if (this.activityHandlerWeakRef != null) {
            this.activityHandlerWeakRef.clear();
        }
        this.logger = null;
        this.packageQueue = null;
        this.backoffStrategy = null;
        this.scheduler = null;
    }

    private void sendNextSdkClick() {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                SdkClickHandler.this.sendNextSdkClickI();
            }
        });
    }

    private void sendNextSdkClickI() {
        IActivityHandler activityHandler = (IActivityHandler)this.activityHandlerWeakRef.get();
        if (activityHandler.getActivityState() == null) {
            return;
        }
        if (activityHandler.getActivityState().isGdprForgotten) {
            return;
        }
        if (this.paused) {
            return;
        }
        if (this.packageQueue.isEmpty()) {
            return;
        }
        final ActivityPackage sdkClickPackage = this.packageQueue.remove(0);
        int retries = sdkClickPackage.getRetries();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SdkClickHandler.this.sendSdkClickI(sdkClickPackage);
                SdkClickHandler.this.sendNextSdkClick();
            }
        };
        if (retries <= 0) {
            runnable.run();
            return;
        }
        long waitTimeMilliSeconds = Util.getWaitingTime(retries, this.backoffStrategy);
        double waitTimeSeconds = (double)waitTimeMilliSeconds / 1000.0;
        String secondsString = Util.SecondsDisplayFormat.format(waitTimeSeconds);
        this.logger.verbose("Waiting for %s seconds before retrying sdk_click for the %d time", secondsString, retries);
        this.scheduler.schedule(runnable, waitTimeMilliSeconds);
    }

    private void sendSdkClickI(ActivityPackage sdkClickPackage) {
        String payloadLocation;
        JSONArray rawReferrer;
        IActivityHandler activityHandler = (IActivityHandler)this.activityHandlerWeakRef.get();
        String source = sdkClickPackage.getParameters().get("source");
        boolean isReftag = source != null && source.equals(SOURCE_REFTAG);
        String rawReferrerString = sdkClickPackage.getParameters().get("raw_referrer");
        if (isReftag && (rawReferrer = SharedPreferencesManager.getDefaultInstance(activityHandler.getContext()).getRawReferrer(rawReferrerString, sdkClickPackage.getClickTimeInMilliseconds())) == null) {
            return;
        }
        boolean isInstallReferrer = source != null && source.equals(SOURCE_INSTALL_REFERRER);
        long clickTime = -1L;
        long installBegin = -1L;
        String installReferrer = null;
        long clickTimeServer = -1L;
        long installBeginServer = -1L;
        String installVersion = null;
        Boolean googlePlayInstant = null;
        Boolean isClick = null;
        String referrerApi = null;
        if (isInstallReferrer) {
            clickTime = sdkClickPackage.getClickTimeInSeconds();
            installBegin = sdkClickPackage.getInstallBeginTimeInSeconds();
            installReferrer = sdkClickPackage.getParameters().get("referrer");
            clickTimeServer = sdkClickPackage.getClickTimeServerInSeconds();
            installBeginServer = sdkClickPackage.getInstallBeginTimeServerInSeconds();
            installVersion = sdkClickPackage.getInstallVersion();
            googlePlayInstant = sdkClickPackage.getGooglePlayInstant();
            isClick = sdkClickPackage.getIsClick();
            referrerApi = sdkClickPackage.getParameters().get("referrer_api");
        }
        boolean isPreinstall = source != null && source.equals("preinstall");
        Map<String, String> sendingParameters = this.generateSendingParametersI();
        ResponseData responseData = this.activityPackageSender.sendActivityPackageSync(sdkClickPackage, sendingParameters);
        if (!(responseData instanceof SdkClickResponseData)) {
            return;
        }
        SdkClickResponseData sdkClickResponseData = (SdkClickResponseData)responseData;
        if (sdkClickResponseData.willRetry) {
            this.retrySendingI(sdkClickPackage);
            return;
        }
        if (activityHandler == null) {
            return;
        }
        if (sdkClickResponseData.trackingState == TrackingState.OPTED_OUT) {
            activityHandler.gotOptOutResponse();
            return;
        }
        if (isReftag) {
            SharedPreferencesManager.getDefaultInstance(activityHandler.getContext()).removeRawReferrer(rawReferrerString, sdkClickPackage.getClickTimeInMilliseconds());
        }
        if (isInstallReferrer) {
            sdkClickResponseData.clickTime = clickTime;
            sdkClickResponseData.installBegin = installBegin;
            sdkClickResponseData.installReferrer = installReferrer;
            sdkClickResponseData.clickTimeServer = clickTimeServer;
            sdkClickResponseData.installBeginServer = installBeginServer;
            sdkClickResponseData.installVersion = installVersion;
            sdkClickResponseData.googlePlayInstant = googlePlayInstant;
            sdkClickResponseData.isClick = isClick;
            sdkClickResponseData.referrerApi = referrerApi;
            sdkClickResponseData.isInstallReferrer = true;
        }
        if (isPreinstall && (payloadLocation = sdkClickPackage.getParameters().get("found_location")) != null && !payloadLocation.isEmpty()) {
            SharedPreferencesManager sharedPreferencesManager = SharedPreferencesManager.getDefaultInstance(activityHandler.getContext());
            if ("system_installer_referrer".equalsIgnoreCase(payloadLocation)) {
                sharedPreferencesManager.removePreinstallReferrer();
            } else {
                long currentStatus = sharedPreferencesManager.getPreinstallPayloadReadStatus();
                long updatedStatus = PreinstallUtil.markAsRead(payloadLocation, currentStatus);
                sharedPreferencesManager.setPreinstallPayloadReadStatus(updatedStatus);
            }
        }
        activityHandler.finishedTrackingActivity(sdkClickResponseData);
    }

    private Map<String, String> generateSendingParametersI() {
        HashMap<String, String> sendingParameters = new HashMap<String, String>();
        long now = System.currentTimeMillis();
        String dateString = Util.dateFormatter.format(now);
        PackageBuilder.addString(sendingParameters, "sent_at", dateString);
        int queueSize = this.packageQueue.size() - 1;
        if (queueSize > 0) {
            PackageBuilder.addLong(sendingParameters, "queue_size", queueSize);
        }
        return sendingParameters;
    }

    private void retrySendingI(ActivityPackage sdkClickPackage) {
        int retries = sdkClickPackage.increaseRetries();
        this.logger.error("Retrying sdk_click package for the %d time", retries);
        this.sendSdkClick(sdkClickPackage);
    }

    private void logErrorMessageI(ActivityPackage sdkClickPackage, String message, Throwable throwable) {
        String packageMessage = sdkClickPackage.getFailureMessage();
        String reasonString = Util.getReasonString(message, throwable);
        String finalMessage = Util.formatString("%s. (%s)", packageMessage, reasonString);
        this.logger.error(finalMessage, new Object[0]);
    }
}

