/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk;

import android.net.Uri;
import android.net.UrlQuerySanitizer;
import io.adtrace.sdk.ActivityPackage;
import io.adtrace.sdk.ActivityState;
import io.adtrace.sdk.AdTraceAttribution;
import io.adtrace.sdk.AdTraceConfig;
import io.adtrace.sdk.AdTraceFactory;
import io.adtrace.sdk.DeviceInfo;
import io.adtrace.sdk.PackageBuilder;
import io.adtrace.sdk.ReferrerDetails;
import io.adtrace.sdk.SessionParameters;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PackageFactory {
    private static final String ADTRACE_PREFIX = "adtrace_";

    public static ActivityPackage buildReftagSdkClickPackage(String rawReferrer, long clickTime, ActivityState activityState, AdTraceConfig adtraceConfig, DeviceInfo deviceInfo, SessionParameters sessionParameters) {
        String referrer;
        if (rawReferrer == null || rawReferrer.length() == 0) {
            return null;
        }
        try {
            referrer = URLDecoder.decode(rawReferrer, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            referrer = "malformed";
            AdTraceFactory.getLogger().error("Referrer decoding failed due to UnsupportedEncodingException. Message: (%s)", e.getMessage());
        }
        catch (IllegalArgumentException e) {
            referrer = "malformed";
            AdTraceFactory.getLogger().error("Referrer decoding failed due to IllegalArgumentException. Message: (%s)", e.getMessage());
        }
        catch (Exception e) {
            referrer = "malformed";
            AdTraceFactory.getLogger().error("Referrer decoding failed. Message: (%s)", e.getMessage());
        }
        AdTraceFactory.getLogger().verbose("Referrer to parse (%s)", referrer);
        UrlQuerySanitizer querySanitizer = new UrlQuerySanitizer();
        querySanitizer.setUnregisteredParameterValueSanitizer(UrlQuerySanitizer.getAllButNulLegal());
        querySanitizer.setAllowUnregisteredParamaters(true);
        querySanitizer.parseQuery(referrer);
        PackageBuilder clickPackageBuilder = PackageFactory.queryStringClickPackageBuilder(querySanitizer.getParameterList(), activityState, adtraceConfig, deviceInfo, sessionParameters);
        if (clickPackageBuilder == null) {
            return null;
        }
        clickPackageBuilder.referrer = referrer;
        clickPackageBuilder.clickTimeInMilliseconds = clickTime;
        clickPackageBuilder.rawReferrer = rawReferrer;
        ActivityPackage clickPackage = clickPackageBuilder.buildClickPackage("reftag");
        return clickPackage;
    }

    public static ActivityPackage buildDeeplinkSdkClickPackage(Uri url, long clickTime, ActivityState activityState, AdTraceConfig adtraceConfig, DeviceInfo deviceInfo, SessionParameters sessionParameters) {
        String urlStringDecoded;
        if (url == null) {
            return null;
        }
        String urlString = url.toString();
        if (urlString == null || urlString.length() == 0) {
            return null;
        }
        try {
            urlStringDecoded = URLDecoder.decode(urlString, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            urlStringDecoded = urlString;
            AdTraceFactory.getLogger().error("Deeplink url decoding failed due to UnsupportedEncodingException. Message: (%s)", e.getMessage());
        }
        catch (IllegalArgumentException e) {
            urlStringDecoded = urlString;
            AdTraceFactory.getLogger().error("Deeplink url decoding failed due to IllegalArgumentException. Message: (%s)", e.getMessage());
        }
        catch (Exception e) {
            urlStringDecoded = urlString;
            AdTraceFactory.getLogger().error("Deeplink url decoding failed. Message: (%s)", e.getMessage());
        }
        AdTraceFactory.getLogger().verbose("Url to parse (%s)", urlStringDecoded);
        UrlQuerySanitizer querySanitizer = new UrlQuerySanitizer();
        querySanitizer.setUnregisteredParameterValueSanitizer(UrlQuerySanitizer.getAllButNulLegal());
        querySanitizer.setAllowUnregisteredParamaters(true);
        querySanitizer.parseUrl(urlStringDecoded);
        PackageBuilder clickPackageBuilder = PackageFactory.queryStringClickPackageBuilder(querySanitizer.getParameterList(), activityState, adtraceConfig, deviceInfo, sessionParameters);
        if (clickPackageBuilder == null) {
            return null;
        }
        clickPackageBuilder.deeplink = url.toString();
        clickPackageBuilder.clickTimeInMilliseconds = clickTime;
        ActivityPackage clickPackage = clickPackageBuilder.buildClickPackage("deeplink");
        return clickPackage;
    }

    public static ActivityPackage buildInstallReferrerSdkClickPackage(ReferrerDetails referrerDetails, String referrerApi, ActivityState activityState, AdTraceConfig adtraceConfig, DeviceInfo deviceInfo, SessionParameters sessionParameters) {
        long now = System.currentTimeMillis();
        PackageBuilder clickPackageBuilder = new PackageBuilder(adtraceConfig, deviceInfo, activityState, sessionParameters, now);
        clickPackageBuilder.referrer = referrerDetails.installReferrer;
        clickPackageBuilder.clickTimeInSeconds = referrerDetails.referrerClickTimestampSeconds;
        clickPackageBuilder.installBeginTimeInSeconds = referrerDetails.installBeginTimestampSeconds;
        clickPackageBuilder.clickTimeServerInSeconds = referrerDetails.referrerClickTimestampServerSeconds;
        clickPackageBuilder.installBeginTimeServerInSeconds = referrerDetails.installBeginTimestampServerSeconds;
        clickPackageBuilder.installVersion = referrerDetails.installVersion;
        clickPackageBuilder.googlePlayInstant = referrerDetails.googlePlayInstant;
        clickPackageBuilder.isClick = referrerDetails.isClick;
        clickPackageBuilder.referrerApi = referrerApi;
        ActivityPackage clickPackage = clickPackageBuilder.buildClickPackage("install_referrer");
        return clickPackage;
    }

    public static ActivityPackage buildPreinstallSdkClickPackage(String preinstallPayload, String preinstallLocation, ActivityState activityState, AdTraceConfig adtraceConfig, DeviceInfo deviceInfo, SessionParameters sessionParameters) {
        if (preinstallPayload == null || preinstallPayload.length() == 0) {
            return null;
        }
        long now = System.currentTimeMillis();
        PackageBuilder clickPackageBuilder = new PackageBuilder(adtraceConfig, deviceInfo, activityState, sessionParameters, now);
        clickPackageBuilder.preinstallPayload = preinstallPayload;
        clickPackageBuilder.preinstallLocation = preinstallLocation;
        ActivityPackage clickPackage = clickPackageBuilder.buildClickPackage("preinstall");
        return clickPackage;
    }

    private static PackageBuilder queryStringClickPackageBuilder(List<UrlQuerySanitizer.ParameterValuePair> queryList, ActivityState activityState, AdTraceConfig adtraceConfig, DeviceInfo deviceInfo, SessionParameters sessionParameters) {
        if (queryList == null) {
            return null;
        }
        LinkedHashMap<String, String> queryStringParameters = new LinkedHashMap<String, String>();
        AdTraceAttribution queryStringAttribution = new AdTraceAttribution();
        for (UrlQuerySanitizer.ParameterValuePair parameterValuePair : queryList) {
            PackageFactory.readQueryString(parameterValuePair.mParameter, parameterValuePair.mValue, queryStringParameters, queryStringAttribution);
        }
        long now = System.currentTimeMillis();
        String reftag = (String)queryStringParameters.remove("reftag");
        if (activityState != null) {
            long lastInterval;
            activityState.lastInterval = lastInterval = now - activityState.lastActivity;
            if (lastInterval > 5000L) {
                activityState.lastIntervalHardReset = lastInterval;
            }
        }
        PackageBuilder builder = new PackageBuilder(adtraceConfig, deviceInfo, activityState, sessionParameters, now);
        builder.extraParameters = queryStringParameters;
        builder.attribution = queryStringAttribution;
        builder.reftag = reftag;
        return builder;
    }

    private static boolean readQueryString(String key, String value, Map<String, String> extraParameters, AdTraceAttribution queryStringAttribution) {
        if (key == null || value == null) {
            return false;
        }
        if (!key.startsWith(ADTRACE_PREFIX)) {
            return false;
        }
        String keyWOutPrefix = key.substring(ADTRACE_PREFIX.length());
        if (keyWOutPrefix.length() == 0) {
            return false;
        }
        if (value.length() == 0) {
            return false;
        }
        if (!PackageFactory.tryToSetAttribution(queryStringAttribution, keyWOutPrefix, value)) {
            extraParameters.put(keyWOutPrefix, value);
        }
        return true;
    }

    private static boolean tryToSetAttribution(AdTraceAttribution queryStringAttribution, String key, String value) {
        if (key.equals("tracker")) {
            queryStringAttribution.trackerName = value;
            return true;
        }
        if (key.equals("campaign")) {
            queryStringAttribution.campaign = value;
            return true;
        }
        if (key.equals("adgroup")) {
            queryStringAttribution.adgroup = value;
            return true;
        }
        if (key.equals("creative")) {
            queryStringAttribution.creative = value;
            return true;
        }
        return false;
    }
}

