/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk;

import io.adtrace.sdk.ActivityPackage;
import io.adtrace.sdk.AdTraceFactory;
import io.adtrace.sdk.BackoffStrategy;
import io.adtrace.sdk.IActivityHandler;
import io.adtrace.sdk.ILogger;
import io.adtrace.sdk.IPurchaseVerificationHandler;
import io.adtrace.sdk.PackageBuilder;
import io.adtrace.sdk.PurchaseVerificationResponseData;
import io.adtrace.sdk.ResponseData;
import io.adtrace.sdk.TrackingState;
import io.adtrace.sdk.Util;
import io.adtrace.sdk.network.IActivityPackageSender;
import io.adtrace.sdk.scheduler.SingleThreadCachedScheduler;
import io.adtrace.sdk.scheduler.ThreadScheduler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PurchaseVerificationHandler
implements IPurchaseVerificationHandler {
    private static final double MILLISECONDS_TO_SECONDS_DIVISOR = 1000.0;
    private static final String SCHEDULED_EXECUTOR_SOURCE = "PurchaseVerificationHandler";
    private boolean paused;
    private ILogger logger;
    private BackoffStrategy backoffStrategy;
    private List<ActivityPackage> packageQueue;
    private ThreadScheduler scheduler;
    private WeakReference<IActivityHandler> activityHandlerWeakRef;
    private IActivityPackageSender activityPackageSender;

    public PurchaseVerificationHandler(IActivityHandler activityHandler, boolean startsSending, IActivityPackageSender purchaseVerificationHandlerActivityPackageSender) {
        this.init(activityHandler, startsSending, purchaseVerificationHandlerActivityPackageSender);
        this.logger = AdTraceFactory.getLogger();
        this.backoffStrategy = AdTraceFactory.getSdkClickBackoffStrategy();
        this.scheduler = new SingleThreadCachedScheduler(SCHEDULED_EXECUTOR_SOURCE);
    }

    @Override
    public void init(IActivityHandler activityHandler, boolean startsSending, IActivityPackageSender purchaseVerificationHandlerActivityPackageSender) {
        this.paused = !startsSending;
        this.packageQueue = new ArrayList<ActivityPackage>();
        this.activityHandlerWeakRef = new WeakReference<IActivityHandler>(activityHandler);
        this.activityPackageSender = purchaseVerificationHandlerActivityPackageSender;
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
        this.sendNextPurchaseVerificationPackage();
    }

    @Override
    public void sendPurchaseVerificationPackage(final ActivityPackage purchaseVerification) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                PurchaseVerificationHandler.this.packageQueue.add(purchaseVerification);
                PurchaseVerificationHandler.this.logger.debug("Added purchase_verification %d", PurchaseVerificationHandler.this.packageQueue.size());
                PurchaseVerificationHandler.this.logger.verbose("%s", purchaseVerification.getExtendedString());
                PurchaseVerificationHandler.this.sendNextPurchaseVerificationPackage();
            }
        });
    }

    @Override
    public void teardown() {
        this.logger.verbose("PurchaseVerificationHandler teardown", new Object[0]);
        if (this.scheduler != null) {
            this.scheduler.teardown();
        }
        if (this.packageQueue != null) {
            this.packageQueue.clear();
        }
        if (this.activityHandlerWeakRef != null) {
            this.activityHandlerWeakRef.clear();
        }
        this.logger = null;
        this.packageQueue = null;
        this.backoffStrategy = null;
        this.scheduler = null;
    }

    private void sendNextPurchaseVerificationPackage() {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                PurchaseVerificationHandler.this.sendNextPurchaseVerificationPackageI();
            }
        });
    }

    private void sendNextPurchaseVerificationPackageI() {
        IActivityHandler activityHandler = (IActivityHandler)this.activityHandlerWeakRef.get();
        if (activityHandler.getActivityState() == null) {
            return;
        }
        if (activityHandler.getActivityState().isGdprForgotten) {
            return;
        }
        if (this.paused) {
            return;
        }
        if (this.packageQueue.isEmpty()) {
            return;
        }
        final ActivityPackage purchaseVerificationPackage = this.packageQueue.remove(0);
        int retries = purchaseVerificationPackage.getRetries();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PurchaseVerificationHandler.this.sendPurchaseVerificationPackageI(purchaseVerificationPackage);
                PurchaseVerificationHandler.this.sendNextPurchaseVerificationPackage();
            }
        };
        if (retries <= 0) {
            runnable.run();
            return;
        }
        long waitTimeMilliSeconds = Util.getWaitingTime(retries, this.backoffStrategy);
        double waitTimeSeconds = (double)waitTimeMilliSeconds / 1000.0;
        String secondsString = Util.SecondsDisplayFormat.format(waitTimeSeconds);
        this.logger.verbose("Waiting for %s seconds before retrying purchase_verification for the %d time", secondsString, retries);
        this.scheduler.schedule(runnable, waitTimeMilliSeconds);
    }

    private void sendPurchaseVerificationPackageI(ActivityPackage purchaseVerificationPackage) {
        IActivityHandler activityHandler = (IActivityHandler)this.activityHandlerWeakRef.get();
        Map<String, String> sendingParameters = this.generateSendingParametersI();
        ResponseData responseData = this.activityPackageSender.sendActivityPackageSync(purchaseVerificationPackage, sendingParameters);
        if (!(responseData instanceof PurchaseVerificationResponseData)) {
            return;
        }
        PurchaseVerificationResponseData purchaseVerificationResponseData = (PurchaseVerificationResponseData)responseData;
        if (purchaseVerificationResponseData.willRetry) {
            this.retrySendingI(purchaseVerificationPackage);
            return;
        }
        if (activityHandler == null) {
            return;
        }
        if (purchaseVerificationResponseData.trackingState == TrackingState.OPTED_OUT) {
            activityHandler.gotOptOutResponse();
            return;
        }
        activityHandler.finishedTrackingActivity(purchaseVerificationResponseData);
    }

    private Map<String, String> generateSendingParametersI() {
        HashMap<String, String> sendingParameters = new HashMap<String, String>();
        long now = System.currentTimeMillis();
        String dateString = Util.dateFormatter.format(now);
        PackageBuilder.addString(sendingParameters, "sent_at", dateString);
        int queueSize = this.packageQueue.size() - 1;
        if (queueSize > 0) {
            PackageBuilder.addLong(sendingParameters, "queue_size", queueSize);
        }
        return sendingParameters;
    }

    private void retrySendingI(ActivityPackage purchaseVerificationPackage) {
        int retries = purchaseVerificationPackage.increaseRetries();
        this.logger.error("Retrying purchase_verification package for the %d time", retries);
        this.sendPurchaseVerificationPackage(purchaseVerificationPackage);
    }
}

