/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk.network;

import io.adtrace.sdk.ActivityKind;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class UrlStrategy {
    private static final String BASE_URL_INDIA = "https://app.adtrace.net.in";
    private static final String GDPR_URL_INDIA = "https://gdpr.adtrace.net.in";
    private static final String SUBSCRIPTION_URL_INDIA = "https://subscription.adtrace.net.in";
    private static final String PURCHASE_VERIFICATION_URL_INDIA = "https://ssrv.adtrace.net.in";
    private static final String BASE_URL_CHINA = "https://app.adtrace.world";
    private static final String GDPR_URL_CHINA = "https://gdpr.adtrace.world";
    private static final String SUBSCRIPTION_URL_CHINA = "https://subscription.adtrace.world";
    private static final String PURCHASE_VERIFICATION_URL_CHINA = "https://ssrv.adtrace.world";
    private static final String BASE_URL_CN = "https://app.adtrace.cn";
    private static final String GDPR_URL_CN = "https://gdpr.adtrace.com";
    private static final String SUBSCRIPTION_URL_CN = "https://subscription.adtrace.com";
    private static final String PURCHASE_VERIFICATION_URL_CN = "https://ssrv.adtrace.cn";
    private static final String BASE_URL_EU = "https://app.eu.adtrace.com";
    private static final String GDPR_URL_EU = "https://gdpr.eu.adtrace.com";
    private static final String SUBSCRIPTION_URL_EU = "https://subscription.eu.adtrace.com";
    private static final String PURCHASE_VERIFICATION_URL_EU = "https://ssrv.eu.adtrace.com";
    private static final String BASE_URL_TR = "https://app.tr.adtrace.com";
    private static final String GDPR_URL_TR = "https://gdpr.tr.adtrace.com";
    private static final String SUBSCRIPTION_URL_TR = "https://subscription.tr.adtrace.com";
    private static final String PURCHASE_VERIFICATION_URL_TR = "https://ssrv.tr.adtrace.com";
    private static final String BASE_URL_US = "https://app.us.adtrace.com";
    private static final String GDPR_URL_US = "https://gdpr.us.adtrace.com";
    private static final String SUBSCRIPTION_URL_US = "https://subscription.us.adtrace.com";
    private static final String PURCHASE_VERIFICATION_URL_US = "https://ssrv.us.adtrace.com";
    private final String baseUrlOverwrite;
    private final String gdprUrlOverwrite;
    private final String subscriptionUrlOverwrite;
    private final String purchaseVerificationUrlOverwrite;
    final List<String> baseUrlChoicesList;
    final List<String> gdprUrlChoicesList;
    final List<String> subscriptionUrlChoicesList;
    final List<String> purchaseVerificationUrlChoicesList;
    boolean wasLastAttemptSuccess;
    int choiceIndex;
    int startingChoiceIndex;
    boolean wasLastAttemptWithOverwrittenUrl;

    public UrlStrategy(String baseUrlOverwrite, String gdprUrlOverwrite, String subscriptionUrlOverwrite, String purchaseVerificationUrlOverwrite, String adtraceUrlStrategy) {
        this.baseUrlOverwrite = baseUrlOverwrite;
        this.gdprUrlOverwrite = gdprUrlOverwrite;
        this.subscriptionUrlOverwrite = subscriptionUrlOverwrite;
        this.purchaseVerificationUrlOverwrite = purchaseVerificationUrlOverwrite;
        this.baseUrlChoicesList = UrlStrategy.baseUrlChoices(adtraceUrlStrategy);
        this.gdprUrlChoicesList = UrlStrategy.gdprUrlChoices(adtraceUrlStrategy);
        this.subscriptionUrlChoicesList = UrlStrategy.subscriptionUrlChoices(adtraceUrlStrategy);
        this.purchaseVerificationUrlChoicesList = UrlStrategy.purchaseVerificationUrlChoices(adtraceUrlStrategy);
        this.wasLastAttemptSuccess = false;
        this.choiceIndex = 0;
        this.startingChoiceIndex = 0;
        this.wasLastAttemptWithOverwrittenUrl = false;
    }

    public void resetAfterSuccess() {
        this.startingChoiceIndex = this.choiceIndex;
        this.wasLastAttemptSuccess = true;
    }

    public boolean shouldRetryAfterFailure(ActivityKind activityKind) {
        int nextChoiceIndex;
        this.wasLastAttemptSuccess = false;
        if (this.wasLastAttemptWithOverwrittenUrl) {
            return false;
        }
        int choiceListSize = activityKind == ActivityKind.GDPR ? this.gdprUrlChoicesList.size() : (activityKind == ActivityKind.SUBSCRIPTION ? this.subscriptionUrlChoicesList.size() : (activityKind == ActivityKind.PURCHASE_VERIFICATION ? this.purchaseVerificationUrlChoicesList.size() : this.baseUrlChoicesList.size()));
        this.choiceIndex = nextChoiceIndex = (this.choiceIndex + 1) % choiceListSize;
        boolean nextChoiceHasNotReturnedToStartingChoice = this.choiceIndex != this.startingChoiceIndex;
        return nextChoiceHasNotReturnedToStartingChoice;
    }

    public String targetUrlByActivityKind(ActivityKind activityKind) {
        if (activityKind == ActivityKind.GDPR) {
            if (this.gdprUrlOverwrite != null) {
                this.wasLastAttemptWithOverwrittenUrl = true;
                return this.gdprUrlOverwrite;
            }
            this.wasLastAttemptWithOverwrittenUrl = false;
            return this.gdprUrlChoicesList.get(this.choiceIndex);
        }
        if (activityKind == ActivityKind.SUBSCRIPTION) {
            if (this.subscriptionUrlOverwrite != null) {
                this.wasLastAttemptWithOverwrittenUrl = true;
                return this.subscriptionUrlOverwrite;
            }
            this.wasLastAttemptWithOverwrittenUrl = false;
            return this.subscriptionUrlChoicesList.get(this.choiceIndex);
        }
        if (activityKind == ActivityKind.PURCHASE_VERIFICATION) {
            if (this.purchaseVerificationUrlOverwrite != null) {
                this.wasLastAttemptWithOverwrittenUrl = true;
                return this.purchaseVerificationUrlOverwrite;
            }
            this.wasLastAttemptWithOverwrittenUrl = false;
            return this.purchaseVerificationUrlChoicesList.get(this.choiceIndex);
        }
        if (this.baseUrlOverwrite != null) {
            this.wasLastAttemptWithOverwrittenUrl = true;
            return this.baseUrlOverwrite;
        }
        this.wasLastAttemptWithOverwrittenUrl = false;
        return this.baseUrlChoicesList.get(this.choiceIndex);
    }

    private static List<String> baseUrlChoices(String urlStrategy) {
        if ("url_strategy_india".equals(urlStrategy)) {
            return Arrays.asList(BASE_URL_INDIA, "https://app.adtrace.io");
        }
        if ("url_strategy_china".equals(urlStrategy)) {
            return Arrays.asList(BASE_URL_CHINA, "https://app.adtrace.io");
        }
        if ("url_strategy_cn".equals(urlStrategy)) {
            return Arrays.asList(BASE_URL_CN, "https://app.adtrace.io");
        }
        if ("url_strategy_cn_only".equals(urlStrategy)) {
            return Arrays.asList(BASE_URL_CN);
        }
        if ("data_residency_eu".equals(urlStrategy)) {
            return Collections.singletonList(BASE_URL_EU);
        }
        if ("data_residency_tr".equals(urlStrategy)) {
            return Collections.singletonList(BASE_URL_TR);
        }
        if ("data_residency_us".equals(urlStrategy)) {
            return Collections.singletonList(BASE_URL_US);
        }
        return Arrays.asList("https://app.adtrace.io", BASE_URL_INDIA, BASE_URL_CHINA);
    }

    private static List<String> gdprUrlChoices(String urlStrategy) {
        if ("url_strategy_india".equals(urlStrategy)) {
            return Arrays.asList(GDPR_URL_INDIA, "https://gdpr.adtrace.io");
        }
        if ("url_strategy_china".equals(urlStrategy)) {
            return Arrays.asList(GDPR_URL_CHINA, "https://gdpr.adtrace.io");
        }
        if ("url_strategy_cn".equals(urlStrategy)) {
            return Arrays.asList(GDPR_URL_CN, "https://gdpr.adtrace.io");
        }
        if ("url_strategy_cn_only".equals(urlStrategy)) {
            return Arrays.asList(GDPR_URL_CN);
        }
        if ("data_residency_eu".equals(urlStrategy)) {
            return Collections.singletonList(GDPR_URL_EU);
        }
        if ("data_residency_tr".equals(urlStrategy)) {
            return Collections.singletonList(GDPR_URL_TR);
        }
        if ("data_residency_us".equals(urlStrategy)) {
            return Collections.singletonList(GDPR_URL_US);
        }
        return Arrays.asList("https://gdpr.adtrace.io", GDPR_URL_INDIA, GDPR_URL_CHINA);
    }

    private static List<String> subscriptionUrlChoices(String urlStrategy) {
        if ("url_strategy_india".equals(urlStrategy)) {
            return Arrays.asList(SUBSCRIPTION_URL_INDIA, SUBSCRIPTION_URL_CN);
        }
        if ("url_strategy_china".equals(urlStrategy)) {
            return Arrays.asList(SUBSCRIPTION_URL_CHINA, SUBSCRIPTION_URL_CN);
        }
        if ("url_strategy_cn".equals(urlStrategy)) {
            return Arrays.asList(SUBSCRIPTION_URL_CN, SUBSCRIPTION_URL_CN);
        }
        if ("url_strategy_cn_only".equals(urlStrategy)) {
            return Arrays.asList(SUBSCRIPTION_URL_CN);
        }
        if ("data_residency_eu".equals(urlStrategy)) {
            return Collections.singletonList(SUBSCRIPTION_URL_EU);
        }
        if ("data_residency_tr".equals(urlStrategy)) {
            return Collections.singletonList(SUBSCRIPTION_URL_TR);
        }
        if ("data_residency_us".equals(urlStrategy)) {
            return Collections.singletonList(SUBSCRIPTION_URL_US);
        }
        return Arrays.asList(SUBSCRIPTION_URL_CN, SUBSCRIPTION_URL_INDIA, SUBSCRIPTION_URL_CHINA);
    }

    private static List<String> purchaseVerificationUrlChoices(String urlStrategy) {
        if ("url_strategy_india".equals(urlStrategy)) {
            return Arrays.asList(PURCHASE_VERIFICATION_URL_INDIA, "https://ssrv.adtrace.io");
        }
        if ("url_strategy_china".equals(urlStrategy)) {
            return Arrays.asList(PURCHASE_VERIFICATION_URL_CHINA, "https://ssrv.adtrace.io");
        }
        if ("url_strategy_cn".equals(urlStrategy)) {
            return Arrays.asList(PURCHASE_VERIFICATION_URL_CN, "https://ssrv.adtrace.io");
        }
        if ("url_strategy_cn_only".equals(urlStrategy)) {
            return Arrays.asList(PURCHASE_VERIFICATION_URL_CN);
        }
        if ("data_residency_eu".equals(urlStrategy)) {
            return Collections.singletonList(PURCHASE_VERIFICATION_URL_EU);
        }
        if ("data_residency_tr".equals(urlStrategy)) {
            return Collections.singletonList(PURCHASE_VERIFICATION_URL_TR);
        }
        if ("data_residency_us".equals(urlStrategy)) {
            return Collections.singletonList(PURCHASE_VERIFICATION_URL_US);
        }
        return Arrays.asList("https://ssrv.adtrace.io", PURCHASE_VERIFICATION_URL_INDIA, PURCHASE_VERIFICATION_URL_CHINA);
    }
}

