/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk.network;

import io.adtrace.sdk.AdTraceFactory;
import io.adtrace.sdk.ILogger;
import java.io.IOException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

public class UtilNetworking {
    private static String userAgent;

    private static ILogger getLogger() {
        return AdTraceFactory.getLogger();
    }

    public static void setUserAgent(String userAgent) {
        UtilNetworking.userAgent = userAgent;
    }

    public static IConnectionOptions createDefaultConnectionOptions() {
        return new IConnectionOptions(){

            @Override
            public void applyConnectionOptions(HttpsURLConnection connection, String clientSdk) {
                connection.setRequestProperty("Client-SDK", clientSdk);
                connection.setConnectTimeout(60000);
                connection.setReadTimeout(60000);
                if (userAgent != null) {
                    connection.setRequestProperty("User-Agent", userAgent);
                }
            }
        };
    }

    public static IHttpsURLConnectionProvider createDefaultHttpsURLConnectionProvider() {
        return new IHttpsURLConnectionProvider(){

            @Override
            public HttpsURLConnection generateHttpsURLConnection(URL url) throws IOException {
                return (HttpsURLConnection)url.openConnection();
            }
        };
    }

    public static String extractJsonString(JSONObject jsonObject, String name) {
        Object object = jsonObject.opt(name);
        if (object instanceof String) {
            return (String)object;
        }
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public static Long extractJsonLong(JSONObject jsonObject, String name) {
        Object object = jsonObject.opt(name);
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            try {
                return (long)Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static int extractJsonInt(JSONObject jsonObject, String name) {
        Object object = jsonObject.opt(name);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return -1;
    }

    public static interface IHttpsURLConnectionProvider {
        public HttpsURLConnection generateHttpsURLConnection(URL var1) throws IOException;
    }

    public static interface IConnectionOptions {
        public void applyConnectionOptions(HttpsURLConnection var1, String var2);
    }
}

