/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk;

import android.content.Context;
import io.adtrace.sdk.AdTraceFactory;
import io.adtrace.sdk.AdTraceInstance;
import io.adtrace.sdk.ILogger;
import io.adtrace.sdk.LogLevel;
import io.adtrace.sdk.OnAttributionChangedListener;
import io.adtrace.sdk.OnDeeplinkResponseListener;
import io.adtrace.sdk.OnEventTrackingFailedListener;
import io.adtrace.sdk.OnEventTrackingSucceededListener;
import io.adtrace.sdk.OnSessionTrackingFailedListener;
import io.adtrace.sdk.OnSessionTrackingSucceededListener;
import io.adtrace.sdk.Util;

public class AdTraceConfig {
    String basePath;
    String gdprPath;
    String subscriptionPath;
    String purchaseVerificationPath;
    Context context;
    String appToken;
    String environment;
    String processName;
    String sdkPrefix;
    boolean eventBufferingEnabled;
    String defaultTracker;
    OnAttributionChangedListener onAttributionChangedListener;
    Boolean deviceKnown;
    Class deepLinkComponent;
    OnEventTrackingSucceededListener onEventTrackingSucceededListener;
    OnEventTrackingFailedListener onEventTrackingFailedListener;
    OnSessionTrackingSucceededListener onSessionTrackingSucceededListener;
    OnSessionTrackingFailedListener onSessionTrackingFailedListener;
    OnDeeplinkResponseListener onDeeplinkResponseListener;
    boolean sendInBackground;
    Double delayStart;
    AdTraceInstance.PreLaunchActions preLaunchActions;
    ILogger logger;
    String userAgent;
    String pushToken;
    Boolean startEnabled;
    boolean startOffline;
    String secretId;
    String appSecret;
    String externalDeviceId;
    boolean preinstallTrackingEnabled;
    Boolean needsCost;
    String urlStrategy;
    String preinstallFilePath;
    boolean playStoreKidsAppEnabled;
    boolean coppaCompliantEnabled;
    boolean finalAttributionEnabled;
    String fbAppId;
    boolean readDeviceInfoOnceEnabled;
    String appVersionAppTokenChanged;
    private boolean isSdkReset4AppTokenChange;
    public static final String ENVIRONMENT_SANDBOX = "sandbox";
    public static final String ENVIRONMENT_PRODUCTION = "production";
    public static final String URL_STRATEGY_INDIA = "url_strategy_india";
    public static final String URL_STRATEGY_CHINA = "url_strategy_china";
    public static final String URL_STRATEGY_CN = "url_strategy_cn";
    public static final String URL_STRATEGY_CN_ONLY = "url_strategy_cn_only";
    public static final String DATA_RESIDENCY_EU = "data_residency_eu";
    public static final String DATA_RESIDENCY_TR = "data_residency_tr";
    public static final String DATA_RESIDENCY_US = "data_residency_us";
    public static final String AD_REVENUE_APPLOVIN_MAX = "applovin_max_sdk";
    public static final String AD_REVENUE_MOPUB = "mopub";
    public static final String AD_REVENUE_ADMOB = "admob_sdk";
    public static final String AD_REVENUE_IRONSOURCE = "ironsource_sdk";
    public static final String AD_REVENUE_ADMOST = "admost_sdk";
    public static final String AD_REVENUE_UNITY = "unity_sdk";
    public static final String AD_REVENUE_HELIUM_CHARTBOOST = "helium_chartboost_sdk";
    public static final String AD_REVENUE_SOURCE_PUBLISHER = "publisher_sdk";
    public static final String AD_REVENUE_TOPON = "topon_sdk";
    public static final String AD_REVENUE_ADX = "adx_sdk";

    public AdTraceConfig(Context context, String appToken, String environment) {
        this.init(context, appToken, environment, false);
    }

    public AdTraceConfig(Context context, String appToken, String environment, boolean allowSuppressLogLevel) {
        this.init(context, appToken, environment, allowSuppressLogLevel);
    }

    private void init(Context context, String appToken, String environment, boolean allowSuppressLogLevel) {
        this.logger = AdTraceFactory.getLogger();
        if (allowSuppressLogLevel && ENVIRONMENT_PRODUCTION.equals(environment)) {
            this.setLogLevel(LogLevel.SUPRESS, environment);
        } else {
            this.setLogLevel(LogLevel.INFO, environment);
        }
        if (context != null) {
            context = context.getApplicationContext();
        }
        this.context = context;
        this.appToken = appToken;
        this.environment = environment;
        this.eventBufferingEnabled = false;
        this.sendInBackground = false;
        this.preinstallTrackingEnabled = false;
    }

    public void setEventBufferingEnabled(Boolean eventBufferingEnabled) {
        if (eventBufferingEnabled == null) {
            this.eventBufferingEnabled = false;
            return;
        }
        this.eventBufferingEnabled = eventBufferingEnabled;
    }

    public void setSendInBackground(boolean sendInBackground) {
        this.sendInBackground = sendInBackground;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.setLogLevel(logLevel, this.environment);
    }

    public void setSdkPrefix(String sdkPrefix) {
        this.sdkPrefix = sdkPrefix;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public void setDefaultTracker(String defaultTracker) {
        this.defaultTracker = defaultTracker;
    }

    public void setOnAttributionChangedListener(OnAttributionChangedListener onAttributionChangedListener) {
        this.onAttributionChangedListener = onAttributionChangedListener;
    }

    public void setDeviceKnown(boolean deviceKnown) {
        this.deviceKnown = deviceKnown;
    }

    public void setDeepLinkComponent(Class deepLinkComponent) {
        this.deepLinkComponent = deepLinkComponent;
    }

    public void setOnEventTrackingSucceededListener(OnEventTrackingSucceededListener onEventTrackingSucceededListener) {
        this.onEventTrackingSucceededListener = onEventTrackingSucceededListener;
    }

    public void setOnEventTrackingFailedListener(OnEventTrackingFailedListener onEventTrackingFailedListener) {
        this.onEventTrackingFailedListener = onEventTrackingFailedListener;
    }

    public void setOnSessionTrackingSucceededListener(OnSessionTrackingSucceededListener onSessionTrackingSucceededListener) {
        this.onSessionTrackingSucceededListener = onSessionTrackingSucceededListener;
    }

    public void setOnSessionTrackingFailedListener(OnSessionTrackingFailedListener onSessionTrackingFailedListener) {
        this.onSessionTrackingFailedListener = onSessionTrackingFailedListener;
    }

    public void setOnDeeplinkResponseListener(OnDeeplinkResponseListener onDeeplinkResponseListener) {
        this.onDeeplinkResponseListener = onDeeplinkResponseListener;
    }

    public void setDelayStart(double delayStart) {
        this.delayStart = delayStart;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setAppSecret(long secretId, long info1, long info2, long info3, long info4) {
        this.secretId = Util.formatString("%d", secretId);
        this.appSecret = Util.formatString("%d%d%d%d", info1, info2, info3, info4);
    }

    public void setAppVersionAppTokenChanged(String appVersionAppTokenChanged) {
        this.appVersionAppTokenChanged = appVersionAppTokenChanged;
    }

    @Deprecated
    public void setReadMobileEquipmentIdentity(boolean readMobileEquipmentIdentity) {
        this.logger.warn("This method has been deprecated and shouldn't be used anymore", new Object[0]);
    }

    public void setExternalDeviceId(String externalDeviceId) {
        this.externalDeviceId = externalDeviceId;
    }

    public void setPreinstallTrackingEnabled(boolean preinstallTrackingEnabled) {
        this.preinstallTrackingEnabled = preinstallTrackingEnabled;
    }

    public void setPreinstallFilePath(String preinstallFilePath) {
        this.preinstallFilePath = preinstallFilePath;
    }

    public void setNeedsCost(boolean needsCost) {
        this.needsCost = needsCost;
    }

    public void setPlayStoreKidsAppEnabled(boolean playStoreKidsAppEnabled) {
        this.playStoreKidsAppEnabled = playStoreKidsAppEnabled;
    }

    public void setCoppaCompliantEnabled(boolean coppaCompliantEnabled) {
        this.coppaCompliantEnabled = coppaCompliantEnabled;
    }

    public void setFinalAttributionEnabled(boolean finalAttributionEnabled) {
        this.finalAttributionEnabled = finalAttributionEnabled;
    }

    public void setFbAppId(String fbAppId) {
        this.fbAppId = fbAppId;
    }

    public boolean isValid() {
        if (!this.checkAppToken(this.appToken)) {
            return false;
        }
        if (!this.checkEnvironment(this.environment)) {
            return false;
        }
        return this.checkContext(this.context);
    }

    public void setUrlStrategy(String urlStrategy) {
        if (urlStrategy == null || urlStrategy.isEmpty()) {
            this.logger.error("Invalid url strategy", new Object[0]);
            return;
        }
        if (!(urlStrategy.equals(URL_STRATEGY_INDIA) || urlStrategy.equals(URL_STRATEGY_CHINA) || urlStrategy.equals(URL_STRATEGY_CN) || urlStrategy.equals(URL_STRATEGY_CN_ONLY) || urlStrategy.equals(DATA_RESIDENCY_EU) || urlStrategy.equals(DATA_RESIDENCY_TR) || urlStrategy.equals(DATA_RESIDENCY_US))) {
            this.logger.warn("Unrecognised url strategy %s", urlStrategy);
        }
        this.urlStrategy = urlStrategy;
    }

    public void setReadDeviceInfoOnceEnabled(boolean readDeviceInfoOnceEnabled) {
        this.readDeviceInfoOnceEnabled = readDeviceInfoOnceEnabled;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getGdprPath() {
        return this.gdprPath;
    }

    public String getSubscriptionPath() {
        return this.subscriptionPath;
    }

    public String getPurchaseVerificationPath() {
        return this.purchaseVerificationPath;
    }

    public Context getContext() {
        return this.context;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getSdkPrefix() {
        return this.sdkPrefix;
    }

    public boolean isEventBufferingEnabled() {
        return this.eventBufferingEnabled;
    }

    public String getDefaultTracker() {
        return this.defaultTracker;
    }

    public OnAttributionChangedListener getOnAttributionChangedListener() {
        return this.onAttributionChangedListener;
    }

    public Boolean getDeviceKnown() {
        return this.deviceKnown;
    }

    public Class getDeepLinkComponent() {
        return this.deepLinkComponent;
    }

    public OnEventTrackingSucceededListener getOnEventTrackingSucceededListener() {
        return this.onEventTrackingSucceededListener;
    }

    public OnEventTrackingFailedListener getOnEventTrackingFailedListener() {
        return this.onEventTrackingFailedListener;
    }

    public OnSessionTrackingSucceededListener getOnSessionTrackingSucceededListener() {
        return this.onSessionTrackingSucceededListener;
    }

    public OnSessionTrackingFailedListener getOnSessionTrackingFailedListener() {
        return this.onSessionTrackingFailedListener;
    }

    public OnDeeplinkResponseListener getOnDeeplinkResponseListener() {
        return this.onDeeplinkResponseListener;
    }

    public boolean isSendInBackground() {
        return this.sendInBackground;
    }

    public Double getDelayStart() {
        return this.delayStart;
    }

    public AdTraceInstance.PreLaunchActions getPreLaunchActions() {
        return this.preLaunchActions;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getPushToken() {
        return this.pushToken;
    }

    public Boolean getStartEnabled() {
        return this.startEnabled;
    }

    public boolean isStartOffline() {
        return this.startOffline;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getExternalDeviceId() {
        return this.externalDeviceId;
    }

    public boolean isPreinstallTrackingEnabled() {
        return this.preinstallTrackingEnabled;
    }

    public Boolean getNeedsCost() {
        return this.needsCost;
    }

    public String getUrlStrategy() {
        return this.urlStrategy;
    }

    public String getPreinstallFilePath() {
        return this.preinstallFilePath;
    }

    public boolean isPlayStoreKidsAppEnabled() {
        return this.playStoreKidsAppEnabled;
    }

    public boolean isCoppaCompliantEnabled() {
        return this.coppaCompliantEnabled;
    }

    public boolean isFinalAttributionEnabled() {
        return this.finalAttributionEnabled;
    }

    public String getFbAppId() {
        return this.fbAppId;
    }

    public boolean isReadDeviceInfoOnceEnabled() {
        return this.readDeviceInfoOnceEnabled;
    }

    private void setLogLevel(LogLevel logLevel, String environment) {
        this.logger.setLogLevel(logLevel, ENVIRONMENT_PRODUCTION.equals(environment));
    }

    private boolean checkContext(Context context) {
        if (context == null) {
            this.logger.error("Missing context", new Object[0]);
            return false;
        }
        if (!Util.checkPermission(context, "android.permission.INTERNET")) {
            this.logger.error("Missing permission: INTERNET", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean checkAppToken(String appToken) {
        if (appToken == null) {
            this.logger.error("Missing App Token", new Object[0]);
            return false;
        }
        if (appToken.length() != 12) {
            this.logger.error("Malformed App Token '%s'", appToken);
            return false;
        }
        return true;
    }

    private boolean checkEnvironment(String environment) {
        if (environment == null) {
            this.logger.error("Missing environment", new Object[0]);
            return false;
        }
        if (environment.equals(ENVIRONMENT_SANDBOX)) {
            this.logger.warnInProduction("SANDBOX: AdTrace is running in Sandbox mode. Use this setting for testing. Don't forget to set the environment to `production` before publishing!", new Object[0]);
            return true;
        }
        if (environment.equals(ENVIRONMENT_PRODUCTION)) {
            this.logger.warnInProduction("PRODUCTION: AdTrace is running in Production mode. Use this setting only for the build that you want to publish. Set the environment to `sandbox` if you want to test your app!", new Object[0]);
            return true;
        }
        this.logger.error("Unknown environment '%s'", environment);
        return false;
    }
}

