/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk;

import io.adtrace.sdk.AdTraceFactory;
import io.adtrace.sdk.ILogger;
import io.adtrace.sdk.Util;
import java.util.LinkedHashMap;
import java.util.Map;

public class AdTraceEvent {
    String eventToken;
    Double revenue;
    String currency;
    Map<String, String> callbackParameters;
    Map<String, String> eventValueParameters;
    Map<String, String> partnerParameters;
    String orderId;
    String callbackId;
    String productId;
    String purchaseToken;
    private static ILogger logger = AdTraceFactory.getLogger();

    public AdTraceEvent(String eventToken) {
        if (!AdTraceEvent.checkEventToken(eventToken, logger)) {
            return;
        }
        this.eventToken = eventToken;
    }

    public void setRevenue(double revenue, String currency) {
        if (!this.checkRevenue(revenue, currency)) {
            return;
        }
        this.revenue = revenue;
        this.currency = currency;
    }

    public void addCallbackParameter(String key, String value) {
        String previousValue;
        if (!Util.isValidParameter(key, "key", "Callback")) {
            return;
        }
        if (!Util.isValidParameter(value, "value", "Callback")) {
            return;
        }
        if (this.callbackParameters == null) {
            this.callbackParameters = new LinkedHashMap<String, String>();
        }
        if ((previousValue = this.callbackParameters.put(key, value)) != null) {
            logger.warn("Key %s was overwritten", key);
        }
    }

    public void addEventParameter(String key, String value) {
        String previousValue;
        if (!Util.isValidParameter(key, "key", "EventValueParams")) {
            return;
        }
        if (!Util.isValidParameter(value, "value", "EventValueParams")) {
            return;
        }
        if (this.eventValueParameters == null) {
            this.eventValueParameters = new LinkedHashMap<String, String>();
        }
        if ((previousValue = this.eventValueParameters.put(key, value)) != null) {
            logger.warn("Key %s was overwritten", key);
        }
    }

    public void addPartnerParameter(String key, String value) {
        String previousValue;
        if (!Util.isValidParameter(key, "key", "Partner")) {
            return;
        }
        if (!Util.isValidParameter(value, "value", "Partner")) {
            return;
        }
        if (this.partnerParameters == null) {
            this.partnerParameters = new LinkedHashMap<String, String>();
        }
        if ((previousValue = this.partnerParameters.put(key, value)) != null) {
            logger.warn("Key %s was overwritten", key);
        }
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public void setCallbackId(String callbackId) {
        this.callbackId = callbackId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public void setPurchaseToken(String purchaseToken) {
        this.purchaseToken = purchaseToken;
    }

    public boolean isValid() {
        return this.eventToken != null;
    }

    public String getEventToken() {
        return this.eventToken;
    }

    public Double getRevenue() {
        return this.revenue;
    }

    public String getCurrency() {
        return this.currency;
    }

    public Map<String, String> getCallbackParameters() {
        return this.callbackParameters;
    }

    public Map<String, String> getPartnerParameters() {
        return this.partnerParameters;
    }

    public Map<String, String> getEventValueParameters() {
        return this.eventValueParameters;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getCallbackId() {
        return this.callbackId;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getPurchaseToken() {
        return this.purchaseToken;
    }

    private static boolean checkEventToken(String eventToken, ILogger logger) {
        if (eventToken == null) {
            logger.error("Missing Event Token", new Object[0]);
            return false;
        }
        if (eventToken.length() <= 0) {
            logger.error("Event Token can't be empty", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean checkRevenue(Double revenue, String currency) {
        if (revenue != null) {
            if (revenue < 0.0) {
                logger.error("Invalid amount %.5f", revenue);
                return false;
            }
            if (currency == null) {
                logger.error("Currency must be set with revenue", new Object[0]);
                return false;
            }
            if (currency.equals("")) {
                logger.error("Currency is empty", new Object[0]);
                return false;
            }
        } else if (currency != null) {
            logger.error("Revenue must be set with currency", new Object[0]);
            return false;
        }
        return true;
    }
}

