/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk;

import android.content.Context;
import io.adtrace.sdk.ILogger;
import io.adtrace.sdk.Reflection;
import java.util.Map;

public class AdTraceSigner {
    private static volatile Object signerInstance = null;

    private AdTraceSigner() {
    }

    public static void enableSigning(ILogger logger) {
        AdTraceSigner.getSignerInstance();
        if (signerInstance == null) {
            return;
        }
        try {
            Reflection.invokeInstanceMethod(signerInstance, "enableSigning", null, new Object[0]);
        }
        catch (Exception e) {
            logger.warn("Invoking Signer enableSigning() received an error [%s]", e.getMessage());
        }
    }

    public static void disableSigning(ILogger logger) {
        AdTraceSigner.getSignerInstance();
        if (signerInstance == null) {
            return;
        }
        try {
            Reflection.invokeInstanceMethod(signerInstance, "disableSigning", null, new Object[0]);
        }
        catch (Exception e) {
            logger.warn("Invoking Signer disableSigning() received an error [%s]", e.getMessage());
        }
    }

    public static void onResume(ILogger logger) {
        AdTraceSigner.getSignerInstance();
        if (signerInstance == null) {
            return;
        }
        try {
            Reflection.invokeInstanceMethod(signerInstance, "onResume", null, new Object[0]);
        }
        catch (Exception e) {
            logger.warn("Invoking Signer onResume() received an error [%s]", e.getMessage());
        }
    }

    public static void sign(Map<String, String> parameters, String activityKind, String clientSdk, Context context, ILogger logger) {
        AdTraceSigner.getSignerInstance();
        if (signerInstance == null) {
            return;
        }
        try {
            Reflection.invokeInstanceMethod(signerInstance, "sign", new Class[]{Context.class, Map.class, String.class, String.class}, context, parameters, activityKind, clientSdk);
        }
        catch (Exception e) {
            logger.warn("Invoking Signer sign() for %s received an error [%s]", activityKind, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void getSignerInstance() {
        if (signerInstance != null) return;
        Class<AdTraceSigner> clazz = AdTraceSigner.class;
        synchronized (AdTraceSigner.class) {
            if (signerInstance != null) return;
            signerInstance = Reflection.createDefaultInstance("io.adtrace.sdk.sig.Signer");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

