/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk;

import android.net.Uri;
import io.adtrace.sdk.ActivityPackage;
import io.adtrace.sdk.AdTraceFactory;
import io.adtrace.sdk.AttributionResponseData;
import io.adtrace.sdk.IActivityHandler;
import io.adtrace.sdk.IAttributionHandler;
import io.adtrace.sdk.ILogger;
import io.adtrace.sdk.PackageBuilder;
import io.adtrace.sdk.ResponseData;
import io.adtrace.sdk.SdkClickResponseData;
import io.adtrace.sdk.SessionResponseData;
import io.adtrace.sdk.TrackingState;
import io.adtrace.sdk.Util;
import io.adtrace.sdk.network.IActivityPackageSender;
import io.adtrace.sdk.scheduler.SingleThreadCachedScheduler;
import io.adtrace.sdk.scheduler.ThreadScheduler;
import io.adtrace.sdk.scheduler.TimerOnce;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class AttributionHandler
implements IAttributionHandler,
IActivityPackageSender.ResponseDataCallbackSubscriber {
    private static final String ATTRIBUTION_TIMER_NAME = "Attribution timer";
    private boolean paused;
    private String lastInitiatedBy;
    private IActivityPackageSender activityPackageSender;
    private ILogger logger = AdTraceFactory.getLogger();
    private TimerOnce timer;
    private ThreadScheduler scheduler = new SingleThreadCachedScheduler("AttributionHandler");
    private WeakReference<IActivityHandler> activityHandlerWeakRef;

    @Override
    public void teardown() {
        this.logger.verbose("AttributionHandler teardown", new Object[0]);
        if (this.timer != null) {
            this.timer.teardown();
        }
        if (this.scheduler != null) {
            this.scheduler.teardown();
        }
        if (this.activityHandlerWeakRef != null) {
            this.activityHandlerWeakRef.clear();
        }
        this.timer = null;
        this.logger = null;
        this.scheduler = null;
        this.activityHandlerWeakRef = null;
    }

    public AttributionHandler(IActivityHandler activityHandler, boolean startsSending, IActivityPackageSender attributionHandlerActivityPackageSender) {
        this.timer = new TimerOnce(new Runnable(){

            @Override
            public void run() {
                AttributionHandler.this.sendAttributionRequest();
            }
        }, ATTRIBUTION_TIMER_NAME);
        this.init(activityHandler, startsSending, attributionHandlerActivityPackageSender);
    }

    @Override
    public void init(IActivityHandler activityHandler, boolean startsSending, IActivityPackageSender attributionHandlerActivityPackageSender) {
        this.activityHandlerWeakRef = new WeakReference<IActivityHandler>(activityHandler);
        this.paused = !startsSending;
        this.activityPackageSender = attributionHandlerActivityPackageSender;
    }

    @Override
    public void getAttribution() {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                AttributionHandler.this.lastInitiatedBy = "sdk";
                AttributionHandler.this.getAttributionI(0L);
            }
        });
    }

    @Override
    public void checkSessionResponse(final SessionResponseData sessionResponseData) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                IActivityHandler activityHandler = (IActivityHandler)AttributionHandler.this.activityHandlerWeakRef.get();
                if (activityHandler == null) {
                    return;
                }
                AttributionHandler.this.checkSessionResponseI(activityHandler, sessionResponseData);
            }
        });
    }

    @Override
    public void checkSdkClickResponse(final SdkClickResponseData sdkClickResponseData) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                IActivityHandler activityHandler = (IActivityHandler)AttributionHandler.this.activityHandlerWeakRef.get();
                if (activityHandler == null) {
                    return;
                }
                AttributionHandler.this.checkSdkClickResponseI(activityHandler, sdkClickResponseData);
            }
        });
    }

    public void checkAttributionResponse(final AttributionResponseData attributionResponseData) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                IActivityHandler activityHandler = (IActivityHandler)AttributionHandler.this.activityHandlerWeakRef.get();
                if (activityHandler == null) {
                    return;
                }
                AttributionHandler.this.checkAttributionResponseI(activityHandler, attributionResponseData);
            }
        });
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
    }

    private void sendAttributionRequest() {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                AttributionHandler.this.sendAttributionRequestI();
            }
        });
    }

    private void getAttributionI(long delayInMilliseconds) {
        if (this.timer.getFireIn() > delayInMilliseconds) {
            return;
        }
        if (delayInMilliseconds != 0L) {
            double waitTimeSeconds = (double)delayInMilliseconds / 1000.0;
            String secondsString = Util.SecondsDisplayFormat.format(waitTimeSeconds);
            this.logger.debug("Waiting to query attribution in %s seconds", secondsString);
        }
        this.timer.startIn(delayInMilliseconds);
    }

    private void checkAttributionI(IActivityHandler activityHandler, ResponseData responseData) {
        if (responseData.jsonResponse == null) {
            return;
        }
        Long timerMilliseconds = responseData.askIn;
        if (timerMilliseconds != null && timerMilliseconds >= 0L) {
            activityHandler.setAskingAttribution(true);
            this.lastInitiatedBy = "backend";
            this.getAttributionI(timerMilliseconds);
            return;
        }
        activityHandler.setAskingAttribution(false);
    }

    private void checkSessionResponseI(IActivityHandler activityHandler, SessionResponseData sessionResponseData) {
        this.checkAttributionI(activityHandler, sessionResponseData);
        activityHandler.launchSessionResponseTasks(sessionResponseData);
    }

    private void checkSdkClickResponseI(IActivityHandler activityHandler, SdkClickResponseData sdkClickResponseData) {
        this.checkAttributionI(activityHandler, sdkClickResponseData);
        activityHandler.launchSdkClickResponseTasks(sdkClickResponseData);
    }

    private void checkAttributionResponseI(IActivityHandler activityHandler, AttributionResponseData attributionResponseData) {
        this.checkAttributionI(activityHandler, attributionResponseData);
        this.checkDeeplinkI(attributionResponseData);
        activityHandler.launchAttributionResponseTasks(attributionResponseData);
    }

    private void checkDeeplinkI(AttributionResponseData attributionResponseData) {
        if (attributionResponseData.jsonResponse == null) {
            return;
        }
        JSONObject attributionJson = attributionResponseData.jsonResponse.optJSONObject("attribution");
        if (attributionJson == null) {
            return;
        }
        String deeplinkString = attributionJson.optString("deeplink", null);
        if (deeplinkString == null) {
            return;
        }
        attributionResponseData.deeplink = Uri.parse((String)deeplinkString);
    }

    private void sendAttributionRequestI() {
        if (((IActivityHandler)this.activityHandlerWeakRef.get()).getActivityState().isGdprForgotten) {
            return;
        }
        if (this.paused) {
            this.logger.debug("Attribution handler is paused", new Object[0]);
            return;
        }
        ActivityPackage attributionPackage = this.buildAndGetAttributionPackage();
        this.logger.verbose("%s", attributionPackage.getExtendedString());
        Map<String, String> sendingParameters = this.generateSendingParametersI();
        this.activityPackageSender.sendActivityPackage(attributionPackage, sendingParameters, this);
    }

    private Map<String, String> generateSendingParametersI() {
        HashMap<String, String> sendingParameters = new HashMap<String, String>();
        long now = System.currentTimeMillis();
        String dateString = Util.dateFormatter.format(now);
        PackageBuilder.addString(sendingParameters, "sent_at", dateString);
        return sendingParameters;
    }

    private ActivityPackage buildAndGetAttributionPackage() {
        long now = System.currentTimeMillis();
        IActivityHandler activityHandler = (IActivityHandler)this.activityHandlerWeakRef.get();
        PackageBuilder packageBuilder = new PackageBuilder(activityHandler.getAdTraceConfig(), activityHandler.getDeviceInfo(), activityHandler.getActivityState(), activityHandler.getSessionParameters(), now);
        ActivityPackage activityPackage = packageBuilder.buildAttributionPackage(this.lastInitiatedBy);
        this.lastInitiatedBy = null;
        return activityPackage;
    }

    @Override
    public void onResponseDataCallback(final ResponseData responseData) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                IActivityHandler activityHandler = (IActivityHandler)AttributionHandler.this.activityHandlerWeakRef.get();
                if (activityHandler == null) {
                    return;
                }
                if (responseData.trackingState == TrackingState.OPTED_OUT) {
                    activityHandler.gotOptOutResponse();
                    return;
                }
                if (!(responseData instanceof AttributionResponseData)) {
                    return;
                }
                AttributionHandler.this.checkAttributionResponseI(activityHandler, (AttributionResponseData)responseData);
            }
        });
    }
}

