/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import io.adtrace.sdk.AdTraceConfig;
import io.adtrace.sdk.AdTraceFactory;
import io.adtrace.sdk.GooglePlayServicesClient;
import io.adtrace.sdk.ILogger;
import io.adtrace.sdk.Reflection;
import io.adtrace.sdk.Util;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

class DeviceInfo {
    private static final String OFFICIAL_FACEBOOK_SIGNATURE = "30820268308201d102044a9c4610300d06092a864886f70d0101040500307a310b3009060355040613025553310b3009060355040813024341311230100603550407130950616c6f20416c746f31183016060355040a130f46616365626f6f6b204d6f62696c653111300f060355040b130846616365626f6f6b311d301b0603550403131446616365626f6f6b20436f72706f726174696f6e3020170d3039303833313231353231365a180f32303530303932353231353231365a307a310b3009060355040613025553310b3009060355040813024341311230100603550407130950616c6f20416c746f31183016060355040a130f46616365626f6f6b204d6f62696c653111300f060355040b130846616365626f6f6b311d301b0603550403131446616365626f6f6b20436f72706f726174696f6e30819f300d06092a864886f70d010101050003818d0030818902818100c207d51df8eb8c97d93ba0c8c1002c928fab00dc1b42fca5e66e99cc3023ed2d214d822bc59e8e35ddcf5f44c7ae8ade50d7e0c434f500e6c131f4a2834f987fc46406115de2018ebbb0d5a3c261bd97581ccfef76afc7135a6d59e8855ecd7eacc8f8737e794c60a761c536b72b11fac8e603f5da1a2d54aa103b8a13c0dbc10203010001300d06092a864886f70d0101040500038181005ee9be8bcbb250648d3b741290a82a1c9dc2e76a0af2f2228f1d9f9c4007529c446a70175c5a900d5141812866db46be6559e2141616483998211f4a673149fb2232a10d247663b26a9031e15f84bc1c74d141ff98a02d76f85b2c8ab2571b6469b232d8e768a7f7ca04f7abe4a775615916c07940656b58717457b42bd928a2";
    String playAdId;
    String playAdIdSource;
    int playAdIdAttempt = -1;
    Boolean isTrackingEnabled;
    private boolean nonGoogleIdsReadOnce = false;
    private boolean playIdsReadOnce = false;
    private boolean otherDeviceInfoParamsReadOnce = false;
    String androidId;
    String fbAttributionId;
    String clientSdk;
    String packageName;
    String appVersion;
    String deviceType;
    String deviceName;
    String deviceManufacturer;
    String osName;
    String osVersion;
    String apiLevel;
    String language;
    String country;
    String screenSize;
    String screenFormat;
    String screenDensity;
    String displayWidth;
    String displayHeight;
    String hardwareName;
    String abi;
    String buildName;
    String appInstallTime;
    String appUpdateTime;
    int uiMode;
    String appSetId;
    boolean isGooglePlayGamesForPC;
    Map<String, String> imeiParameters;
    Map<String, String> oaidParameters;
    String fireAdId;
    Boolean fireTrackingEnabled;
    int connectivityType;
    String mcc;
    String mnc;

    DeviceInfo(AdTraceConfig adtraceConfig) {
        Context context = adtraceConfig.context;
        Resources resources = context.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        Configuration configuration = resources.getConfiguration();
        Locale locale = Util.getLocale(configuration);
        PackageInfo packageInfo = this.getPackageInfo(context);
        int screenLayout = configuration.screenLayout;
        this.isGooglePlayGamesForPC = Util.isGooglePlayGamesForPC(context);
        this.packageName = this.getPackageName(context);
        this.appVersion = this.getAppVersion(packageInfo);
        this.deviceType = this.getDeviceType(configuration);
        this.deviceName = this.getDeviceName();
        this.deviceManufacturer = this.getDeviceManufacturer();
        this.osName = this.getOsName();
        this.osVersion = this.getOsVersion();
        this.apiLevel = this.getApiLevel();
        this.language = this.getLanguage(locale);
        this.country = this.getCountry(locale);
        this.screenSize = this.getScreenSize(screenLayout);
        this.screenFormat = this.getScreenFormat(screenLayout);
        this.screenDensity = this.getScreenDensity(displayMetrics);
        this.displayWidth = this.getDisplayWidth(displayMetrics);
        this.displayHeight = this.getDisplayHeight(displayMetrics);
        this.clientSdk = this.getClientSdk(adtraceConfig.sdkPrefix);
        this.fbAttributionId = this.getFacebookAttributionId(context);
        this.hardwareName = this.getHardwareName();
        this.abi = this.getABI();
        this.buildName = this.getBuildName();
        this.appInstallTime = this.getAppInstallTime(packageInfo);
        this.appUpdateTime = this.getAppUpdateTime(packageInfo);
        this.uiMode = this.getDeviceUiMode(configuration);
        if (Util.canReadPlayIds(adtraceConfig)) {
            this.appSetId = Reflection.getAppSetId(context);
        }
    }

    void reloadPlayIds(AdTraceConfig adtraceConfig) {
        if (!Util.canReadPlayIds(adtraceConfig)) {
            return;
        }
        if (this.playIdsReadOnce && adtraceConfig.readDeviceInfoOnceEnabled) {
            return;
        }
        Context context = adtraceConfig.context;
        String previousPlayAdId = this.playAdId;
        Boolean previousIsTrackingEnabled = this.isTrackingEnabled;
        this.playAdId = null;
        this.isTrackingEnabled = null;
        this.playAdIdSource = null;
        this.playAdIdAttempt = -1;
        for (int serviceAttempt = 1; serviceAttempt <= 3; ++serviceAttempt) {
            try {
                long timeoutServiceMilli = 3000 * serviceAttempt;
                GooglePlayServicesClient.GooglePlayServicesInfo gpsInfo = GooglePlayServicesClient.getGooglePlayServicesInfo(context, timeoutServiceMilli);
                if (this.playAdId == null) {
                    this.playAdId = gpsInfo.getGpsAdid();
                    this.playIdsReadOnce = true;
                }
                if (this.isTrackingEnabled == null) {
                    this.isTrackingEnabled = gpsInfo.isTrackingEnabled();
                }
                if (this.playAdId == null || this.isTrackingEnabled == null) continue;
                this.playAdIdSource = "service";
                this.playAdIdAttempt = serviceAttempt;
                return;
            }
            catch (Exception timeoutServiceMilli) {
                // empty catch block
            }
        }
        for (int libAttempt = 1; libAttempt <= 3; ++libAttempt) {
            Object advertisingInfoObject = Util.getAdvertisingInfoObject(context, 11000L);
            if (advertisingInfoObject == null) continue;
            if (this.playAdId == null) {
                this.playAdId = Util.getPlayAdId(context, advertisingInfoObject, 1000L);
                this.playIdsReadOnce = true;
            }
            if (this.isTrackingEnabled == null) {
                this.isTrackingEnabled = Util.isPlayTrackingEnabled(context, advertisingInfoObject, 1000L);
            }
            if (this.playAdId == null || this.isTrackingEnabled == null) continue;
            this.playAdIdSource = "library";
            this.playAdIdAttempt = libAttempt;
            return;
        }
        if (this.playAdId == null) {
            this.playAdId = previousPlayAdId;
            this.playIdsReadOnce = true;
        }
        if (this.isTrackingEnabled == null) {
            this.isTrackingEnabled = previousIsTrackingEnabled;
        }
    }

    void reloadNonPlayIds(AdTraceConfig adtraceConfig) {
        if (!Util.canReadNonPlayIds(adtraceConfig)) {
            return;
        }
        if (this.nonGoogleIdsReadOnce) {
            return;
        }
        this.androidId = Util.getAndroidId(adtraceConfig.context);
        this.nonGoogleIdsReadOnce = true;
    }

    void reloadOtherDeviceInfoParams(AdTraceConfig adtraceConfig, ILogger logger) {
        if (adtraceConfig.readDeviceInfoOnceEnabled && this.otherDeviceInfoParamsReadOnce) {
            return;
        }
        this.imeiParameters = UtilDeviceIds.getImeiParameters(adtraceConfig, logger);
        this.oaidParameters = UtilDeviceIds.getOaidParameters(adtraceConfig, logger);
        this.fireAdId = UtilDeviceIds.getFireAdvertisingId(adtraceConfig);
        this.fireTrackingEnabled = UtilDeviceIds.getFireTrackingEnabled(adtraceConfig);
        this.connectivityType = UtilDeviceIds.getConnectivityType(adtraceConfig.context, logger);
        this.mcc = UtilDeviceIds.getMcc(adtraceConfig.context, logger);
        this.mnc = UtilDeviceIds.getMnc(adtraceConfig.context, logger);
        this.otherDeviceInfoParamsReadOnce = true;
    }

    public static String getFireAdvertisingIdBypassConditions(ContentResolver contentResolver) {
        return UtilDeviceIds.getFireAdvertisingId(contentResolver);
    }

    private String getPackageName(Context context) {
        return context.getPackageName();
    }

    private PackageInfo getPackageInfo(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            String name = context.getPackageName();
            return packageManager.getPackageInfo(name, 4096);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getAppVersion(PackageInfo packageInfo) {
        try {
            return packageInfo.versionName;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getDeviceType(Configuration configuration) {
        if (this.isGooglePlayGamesForPC) {
            return "pc";
        }
        int uiMode = configuration.uiMode & 0xF;
        if (uiMode == 4) {
            return "tv";
        }
        int screenSize = configuration.screenLayout & 0xF;
        switch (screenSize) {
            case 1: 
            case 2: {
                return "phone";
            }
            case 3: 
            case 4: {
                return "tablet";
            }
        }
        return null;
    }

    private int getDeviceUiMode(Configuration configuration) {
        return configuration.uiMode & 0xF;
    }

    private String getDeviceName() {
        if (this.isGooglePlayGamesForPC) {
            return null;
        }
        return Build.MODEL;
    }

    private String getDeviceManufacturer() {
        return Build.MANUFACTURER;
    }

    private String getOsName() {
        if (this.isGooglePlayGamesForPC) {
            return "windows";
        }
        return "android";
    }

    private String getOsVersion() {
        if (this.isGooglePlayGamesForPC) {
            return null;
        }
        return Build.VERSION.RELEASE;
    }

    private String getApiLevel() {
        return "" + Build.VERSION.SDK_INT;
    }

    private String getLanguage(Locale locale) {
        return locale.getLanguage();
    }

    private String getCountry(Locale locale) {
        return locale.getCountry();
    }

    private String getBuildName() {
        return Build.ID;
    }

    private String getHardwareName() {
        return Build.DISPLAY;
    }

    private String getScreenSize(int screenLayout) {
        int screenSize = screenLayout & 0xF;
        switch (screenSize) {
            case 1: {
                return "small";
            }
            case 2: {
                return "normal";
            }
            case 3: {
                return "large";
            }
            case 4: {
                return "xlarge";
            }
        }
        return null;
    }

    private String getScreenFormat(int screenLayout) {
        int screenFormat = screenLayout & 0x30;
        switch (screenFormat) {
            case 32: {
                return "long";
            }
            case 16: {
                return "normal";
            }
        }
        return null;
    }

    private String getScreenDensity(DisplayMetrics displayMetrics) {
        int density = displayMetrics.densityDpi;
        int low = 140;
        int high = 200;
        if (density == 0) {
            return null;
        }
        if (density < low) {
            return "low";
        }
        if (density > high) {
            return "high";
        }
        return "medium";
    }

    private String getDisplayWidth(DisplayMetrics displayMetrics) {
        return String.valueOf(displayMetrics.widthPixels);
    }

    private String getDisplayHeight(DisplayMetrics displayMetrics) {
        return String.valueOf(displayMetrics.heightPixels);
    }

    private String getClientSdk(String sdkPrefix) {
        if (sdkPrefix == null) {
            return "android2.6.0";
        }
        return Util.formatString("%s@%s", sdkPrefix, "android2.6.0");
    }

    private String getFacebookAttributionId(Context context) {
        try {
            Signature[] signatures = context.getPackageManager().getPackageInfo((String)"com.facebook.katana", (int)64).signatures;
            if (signatures == null || signatures.length != 1) {
                return null;
            }
            Signature facebookApkSignature = signatures[0];
            if (!OFFICIAL_FACEBOOK_SIGNATURE.equals(facebookApkSignature.toCharsString())) {
                return null;
            }
            ContentResolver contentResolver = context.getContentResolver();
            Uri uri = Uri.parse((String)"content://com.facebook.katana.provider.AttributionIdProvider");
            String columnName = "aid";
            String[] projection = new String[]{"aid"};
            Cursor cursor = contentResolver.query(uri, projection, null, null, null);
            if (cursor == null) {
                return null;
            }
            if (!cursor.moveToFirst()) {
                cursor.close();
                return null;
            }
            String attributionId = cursor.getString(cursor.getColumnIndex("aid"));
            cursor.close();
            return attributionId;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getABI() {
        String[] SupportedABIS = Util.getSupportedAbis();
        if (SupportedABIS == null || SupportedABIS.length == 0) {
            return Util.getCpuAbi();
        }
        return SupportedABIS[0];
    }

    private String getAppInstallTime(PackageInfo packageInfo) {
        try {
            return Util.dateFormatter.format(new Date(packageInfo.firstInstallTime));
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String getAppUpdateTime(PackageInfo packageInfo) {
        try {
            return Util.dateFormatter.format(new Date(packageInfo.lastUpdateTime));
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static class UtilDeviceIds {
        private UtilDeviceIds() {
        }

        private static Map<String, String> getImeiParameters(AdTraceConfig adtraceConfig, ILogger logger) {
            if (adtraceConfig.coppaCompliantEnabled) {
                return null;
            }
            return Reflection.getImeiParameters(adtraceConfig.context, logger);
        }

        private static Map<String, String> getOaidParameters(AdTraceConfig adtraceConfig, ILogger logger) {
            if (adtraceConfig.coppaCompliantEnabled) {
                return null;
            }
            return Reflection.getOaidParameters(adtraceConfig.context, logger);
        }

        private static String getFireAdvertisingId(AdTraceConfig adtraceConfig) {
            if (adtraceConfig.coppaCompliantEnabled) {
                return null;
            }
            return UtilDeviceIds.getFireAdvertisingId(adtraceConfig.context.getContentResolver());
        }

        private static String getFireAdvertisingId(ContentResolver contentResolver) {
            if (contentResolver == null) {
                return null;
            }
            try {
                return Settings.Secure.getString((ContentResolver)contentResolver, (String)"advertising_id");
            }
            catch (Exception exception) {
                return null;
            }
        }

        private static Boolean getFireTrackingEnabled(AdTraceConfig adtraceConfig) {
            if (adtraceConfig.coppaCompliantEnabled) {
                return null;
            }
            return UtilDeviceIds.getFireTrackingEnabled(adtraceConfig.context.getContentResolver());
        }

        private static Boolean getFireTrackingEnabled(ContentResolver contentResolver) {
            try {
                return Settings.Secure.getInt((ContentResolver)contentResolver, (String)"limit_ad_tracking") == 0;
            }
            catch (Exception exception) {
                return null;
            }
        }

        private static int getConnectivityType(Context context, ILogger logger) {
            try {
                ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
                if (cm == null) {
                    return -1;
                }
                if (Build.VERSION.SDK_INT < 23) {
                    NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
                    return activeNetwork.getType();
                }
                Network activeNetwork = cm.getActiveNetwork();
                if (activeNetwork == null) {
                    return -1;
                }
                NetworkCapabilities activeNetworkCapabilities = cm.getNetworkCapabilities(activeNetwork);
                if (activeNetworkCapabilities == null) {
                    return -1;
                }
                if (activeNetworkCapabilities.hasTransport(1)) {
                    return 1;
                }
                if (activeNetworkCapabilities.hasTransport(0)) {
                    return 0;
                }
                if (activeNetworkCapabilities.hasTransport(3)) {
                    return 3;
                }
                if (activeNetworkCapabilities.hasTransport(4)) {
                    return 4;
                }
                if (activeNetworkCapabilities.hasTransport(2)) {
                    return 2;
                }
                if (Build.VERSION.SDK_INT < 26) {
                    return -1;
                }
                if (activeNetworkCapabilities.hasTransport(5)) {
                    return 5;
                }
                if (Build.VERSION.SDK_INT < 27) {
                    return -1;
                }
                if (activeNetworkCapabilities.hasTransport(6)) {
                    return 6;
                }
            }
            catch (Exception e) {
                logger.warn("Couldn't read connectivity type (%s)", e.getMessage());
            }
            return -1;
        }

        public static String getMcc(Context context, ILogger logger) {
            try {
                TelephonyManager tel = (TelephonyManager)context.getSystemService("phone");
                String networkOperator = tel.getNetworkOperator();
                if (TextUtils.isEmpty((CharSequence)networkOperator)) {
                    AdTraceFactory.getLogger().warn("Couldn't receive networkOperator string to read MCC", new Object[0]);
                    return null;
                }
                return networkOperator.substring(0, 3);
            }
            catch (Exception ex) {
                AdTraceFactory.getLogger().warn("Couldn't return mcc", new Object[0]);
                return null;
            }
        }

        private static String getMnc(Context context, ILogger logger) {
            try {
                TelephonyManager tel = (TelephonyManager)context.getSystemService("phone");
                String networkOperator = tel.getNetworkOperator();
                if (TextUtils.isEmpty((CharSequence)networkOperator)) {
                    AdTraceFactory.getLogger().warn("Couldn't receive networkOperator string to read MNC", new Object[0]);
                    return null;
                }
                return networkOperator.substring(3);
            }
            catch (Exception ex) {
                logger.warn("Couldn't return mnc", new Object[0]);
                return null;
            }
        }
    }
}

