/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk;

import io.adtrace.sdk.ActivityPackage;
import io.adtrace.sdk.AdTraceEventFailure;
import io.adtrace.sdk.AdTraceEventSuccess;
import io.adtrace.sdk.ResponseData;
import io.adtrace.sdk.Util;
import org.json.JSONObject;

public class EventResponseData
extends ResponseData {
    private String eventToken;
    private String callbackId;
    private String sdkPlatform;

    public EventResponseData(ActivityPackage activityPackage) {
        this.eventToken = activityPackage.getParameters().get("event_token");
        this.callbackId = activityPackage.getParameters().get("event_callback_id");
        this.sdkPlatform = Util.getSdkPrefixPlatform(activityPackage.getClientSdk());
    }

    public AdTraceEventSuccess getSuccessResponseData() {
        if (!this.success) {
            return null;
        }
        AdTraceEventSuccess successResponseData = new AdTraceEventSuccess();
        if ("unity".equals(this.sdkPlatform)) {
            successResponseData.eventToken = this.eventToken != null ? this.eventToken : "";
            successResponseData.message = this.message != null ? this.message : "";
            successResponseData.timestamp = this.timestamp != null ? this.timestamp : "";
            successResponseData.adid = this.adid != null ? this.adid : "";
            successResponseData.callbackId = this.callbackId != null ? this.callbackId : "";
            successResponseData.jsonResponse = this.jsonResponse != null ? this.jsonResponse : new JSONObject();
        } else {
            successResponseData.eventToken = this.eventToken;
            successResponseData.message = this.message;
            successResponseData.timestamp = this.timestamp;
            successResponseData.adid = this.adid;
            successResponseData.callbackId = this.callbackId;
            successResponseData.jsonResponse = this.jsonResponse;
        }
        return successResponseData;
    }

    public AdTraceEventFailure getFailureResponseData() {
        if (this.success) {
            return null;
        }
        AdTraceEventFailure failureResponseData = new AdTraceEventFailure();
        if ("unity".equals(this.sdkPlatform)) {
            failureResponseData.eventToken = this.eventToken != null ? this.eventToken : "";
            failureResponseData.message = this.message != null ? this.message : "";
            failureResponseData.timestamp = this.timestamp != null ? this.timestamp : "";
            failureResponseData.adid = this.adid != null ? this.adid : "";
            failureResponseData.callbackId = this.callbackId != null ? this.callbackId : "";
            failureResponseData.willRetry = this.willRetry;
            failureResponseData.jsonResponse = this.jsonResponse != null ? this.jsonResponse : new JSONObject();
        } else {
            failureResponseData.eventToken = this.eventToken;
            failureResponseData.message = this.message;
            failureResponseData.timestamp = this.timestamp;
            failureResponseData.adid = this.adid;
            failureResponseData.callbackId = this.callbackId;
            failureResponseData.willRetry = this.willRetry;
            failureResponseData.jsonResponse = this.jsonResponse;
        }
        return failureResponseData;
    }
}

