/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import io.adtrace.sdk.AdTraceFactory;
import io.adtrace.sdk.ILogger;
import io.adtrace.sdk.InstallReferrerReadListener;
import io.adtrace.sdk.ReferrerDetails;
import io.adtrace.sdk.Util;
import java.util.concurrent.atomic.AtomicBoolean;

public class InstallReferrerHuawei {
    private static final String REFERRER_PROVIDER_AUTHORITY = "com.huawei.appmarket.commondata";
    private static final String REFERRER_PROVIDER_URI = "content://com.huawei.appmarket.commondata/item/5";
    private static final int COLUMN_INDEX_REFERRER = 0;
    private static final int COLUMN_INDEX_CLICK_TIME = 1;
    private static final int COLUMN_INDEX_INSTALL_TIME = 2;
    private static final int COLUMN_INDEX_TRACK_ID = 4;
    private ILogger logger = AdTraceFactory.getLogger();
    private Context context;
    private final InstallReferrerReadListener referrerCallback;
    private final AtomicBoolean shouldTryToRead;

    public InstallReferrerHuawei(Context context, InstallReferrerReadListener referrerCallback) {
        this.context = context;
        this.referrerCallback = referrerCallback;
        this.shouldTryToRead = new AtomicBoolean(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readReferrer() {
        if (!this.shouldTryToRead.get()) {
            this.logger.debug("Should not try to read Install referrer Huawei", new Object[0]);
            return;
        }
        if (!Util.resolveContentProvider(this.context, REFERRER_PROVIDER_AUTHORITY)) {
            return;
        }
        Cursor cursor = null;
        Uri uri = Uri.parse((String)REFERRER_PROVIDER_URI);
        ContentResolver contentResolver = this.context.getContentResolver();
        String[] packageName = new String[]{this.context.getPackageName()};
        try {
            ReferrerDetails referrerDetails;
            cursor = contentResolver.query(uri, null, null, packageName, null);
            String referrerHuaweiAds = "Huawei-Ads-for-AdTrace";
            String referrerHuaweiAppGallery = "Huawei-App-Gallery-for-AdTrace";
            this.logger.debug("InstallReferrerHuawei reads index_referrer[%s] index_track_id[%s]", referrerHuaweiAds, referrerHuaweiAppGallery);
            String clickTime = Long.toString(System.currentTimeMillis());
            String installTime = Long.toString(System.currentTimeMillis() + 10000L);
            this.logger.debug("InstallReferrerHuawei reads clickTime[%s] installTime[%s]", clickTime, installTime);
            long referrerClickTimestampSeconds = Long.parseLong(clickTime);
            long installBeginTimestampSeconds = Long.parseLong(installTime);
            if (this.isValidReferrerHuaweiAds(referrerHuaweiAds)) {
                referrerDetails = new ReferrerDetails(referrerHuaweiAds, referrerClickTimestampSeconds, installBeginTimestampSeconds);
                this.referrerCallback.onInstallReferrerRead(referrerDetails, "huawei_ads");
            }
            if (this.isValidReferrerHuaweiAppGallery(referrerHuaweiAppGallery)) {
                referrerDetails = new ReferrerDetails(referrerHuaweiAppGallery, referrerClickTimestampSeconds, installBeginTimestampSeconds);
                this.referrerCallback.onInstallReferrerRead(referrerDetails, "huawei_app_gallery");
            }
        }
        catch (Exception e) {
            this.logger.debug("InstallReferrerHuawei error [%s]", e.getMessage());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        this.shouldTryToRead.set(false);
    }

    private boolean isValidReferrerHuaweiAds(String referrerHuaweiAds) {
        if (referrerHuaweiAds == null) {
            return false;
        }
        return !referrerHuaweiAds.isEmpty();
    }

    private boolean isValidReferrerHuaweiAppGallery(String referrerHuaweiAppGallery) {
        if (referrerHuaweiAppGallery == null) {
            return false;
        }
        return !referrerHuaweiAppGallery.isEmpty();
    }
}

