/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import io.adtrace.sdk.AdTraceFactory;
import io.adtrace.sdk.ILogger;
import io.adtrace.sdk.InstallReferrerReadListener;
import io.adtrace.sdk.ReferrerDetails;
import io.adtrace.sdk.Util;
import java.util.concurrent.atomic.AtomicBoolean;

public class InstallReferrerMeta {
    private static final String FACEBOOK_REFERRER_PROVIDER_AUTHORITY = "com.facebook.katana.provider.InstallReferrerProvider";
    private static final String INSTAGRAM_REFERRER_PROVIDER_AUTHORITY = "com.instagram.contentprovider.InstallReferrerProvider";
    private static final String COLUMN_INSTALL_REFERRER = "install_referrer";
    private static final String COLUMN_ACTUAL_TIMESTAMP = "actual_timestamp";
    private static final String COLUMN_IS_CT = "is_ct";
    private ILogger logger = AdTraceFactory.getLogger();
    private Context context;
    private String fbAppId;
    private final InstallReferrerReadListener referrerCallback;
    private final AtomicBoolean shouldTryToRead;

    public InstallReferrerMeta(Context context, String fbAppId, InstallReferrerReadListener referrerCallback) {
        this.context = context;
        this.fbAppId = fbAppId;
        this.referrerCallback = referrerCallback;
        this.shouldTryToRead = new AtomicBoolean(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readReferrer() {
        if (!this.shouldTryToRead.get()) {
            this.logger.debug("Should not retry to read Install referrer Meta", new Object[0]);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.fbAppId)) {
            this.logger.debug("Can't read Install referrer Meta with null or empty FB app ID", new Object[0]);
            return;
        }
        try (Cursor cursor = null;){
            Uri providerUri = null;
            if (Util.resolveContentProvider(this.context, FACEBOOK_REFERRER_PROVIDER_AUTHORITY)) {
                providerUri = Uri.parse((String)("content://com.facebook.katana.provider.InstallReferrerProvider/" + this.fbAppId));
            } else if (Util.resolveContentProvider(this.context, INSTAGRAM_REFERRER_PROVIDER_AUTHORITY)) {
                providerUri = Uri.parse((String)("content://com.instagram.contentprovider.InstallReferrerProvider/" + this.fbAppId));
            } else {
                return;
            }
            ContentResolver contentResolver = this.context.getContentResolver();
            String[] projection = new String[]{COLUMN_INSTALL_REFERRER, COLUMN_IS_CT, COLUMN_ACTUAL_TIMESTAMP};
            cursor = contentResolver.query(providerUri, projection, null, null, null);
            if (cursor == null || !cursor.moveToFirst()) {
                return;
            }
            int installReferrerIndex = cursor.getColumnIndex(COLUMN_INSTALL_REFERRER);
            int timestampIndex = cursor.getColumnIndex(COLUMN_ACTUAL_TIMESTAMP);
            int isCTIndex = cursor.getColumnIndex(COLUMN_IS_CT);
            String installReferrer = cursor.getString(installReferrerIndex);
            long actualTimestampInSec = cursor.getLong(timestampIndex);
            int ctValue = cursor.getInt(isCTIndex);
            boolean isClick = ctValue == 1;
            this.logger.debug("InstallReferrerMeta reads installReferrer[%s] actualTimestampInSec[%d] isClick[%b]", installReferrer, actualTimestampInSec, ctValue);
            if (this.isValidReferrer(installReferrer)) {
                ReferrerDetails referrerDetails = new ReferrerDetails(installReferrer, actualTimestampInSec, isClick);
                this.referrerCallback.onInstallReferrerRead(referrerDetails, "meta");
            } else {
                this.logger.debug("InstallReferrerMeta invalid installReferrer", new Object[0]);
            }
        }
        this.shouldTryToRead.set(false);
    }

    private boolean isValidReferrer(String installReferrer) {
        if (installReferrer == null) {
            return false;
        }
        return !installReferrer.isEmpty();
    }
}

