/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk;

import android.content.Context;
import io.adtrace.sdk.ActivityKind;
import io.adtrace.sdk.ActivityPackage;
import io.adtrace.sdk.AdTraceFactory;
import io.adtrace.sdk.BackoffStrategy;
import io.adtrace.sdk.IActivityHandler;
import io.adtrace.sdk.ILogger;
import io.adtrace.sdk.IPackageHandler;
import io.adtrace.sdk.PackageBuilder;
import io.adtrace.sdk.ResponseData;
import io.adtrace.sdk.SessionParameters;
import io.adtrace.sdk.SharedPreferencesManager;
import io.adtrace.sdk.TrackingState;
import io.adtrace.sdk.Util;
import io.adtrace.sdk.network.IActivityPackageSender;
import io.adtrace.sdk.scheduler.SingleThreadCachedScheduler;
import io.adtrace.sdk.scheduler.ThreadScheduler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class PackageHandler
implements IPackageHandler,
IActivityPackageSender.ResponseDataCallbackSubscriber {
    private static final String PACKAGE_QUEUE_FILENAME = "AdTraceIoPackageQueue";
    private static final String PACKAGE_QUEUE_NAME = "Package queue";
    private ThreadScheduler scheduler = new SingleThreadCachedScheduler("PackageHandler");
    private IActivityPackageSender activityPackageSender;
    private WeakReference<IActivityHandler> activityHandlerWeakRef;
    private List<ActivityPackage> packageQueue;
    private AtomicBoolean isSending;
    private boolean paused;
    private Context context;
    private ILogger logger = AdTraceFactory.getLogger();
    private BackoffStrategy backoffStrategy = AdTraceFactory.getPackageHandlerBackoffStrategy();
    private BackoffStrategy backoffStrategyForInstallSession = AdTraceFactory.getInstallSessionBackoffStrategy();

    @Override
    public void teardown() {
        this.logger.verbose("PackageHandler teardown", new Object[0]);
        if (this.scheduler != null) {
            this.scheduler.teardown();
        }
        if (this.activityHandlerWeakRef != null) {
            this.activityHandlerWeakRef.clear();
        }
        if (this.packageQueue != null) {
            this.packageQueue.clear();
        }
        this.scheduler = null;
        this.activityHandlerWeakRef = null;
        this.packageQueue = null;
        this.isSending = null;
        this.context = null;
        this.logger = null;
        this.backoffStrategy = null;
    }

    static void deleteState(Context context) {
        PackageHandler.deletePackageQueue(context);
    }

    public PackageHandler(IActivityHandler activityHandler, Context context, boolean startsSending, IActivityPackageSender packageHandlerActivityPackageSender) {
        this.init(activityHandler, context, startsSending, packageHandlerActivityPackageSender);
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                PackageHandler.this.initI();
            }
        });
    }

    @Override
    public void init(IActivityHandler activityHandler, Context context, boolean startsSending, IActivityPackageSender packageHandlerActivityPackageSender) {
        this.activityHandlerWeakRef = new WeakReference<IActivityHandler>(activityHandler);
        this.context = context;
        this.paused = !startsSending;
        this.activityPackageSender = packageHandlerActivityPackageSender;
    }

    @Override
    public void addPackage(final ActivityPackage activityPackage) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                PackageHandler.this.addI(activityPackage);
            }
        });
    }

    @Override
    public void sendFirstPackage() {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                PackageHandler.this.sendFirstI();
            }
        });
    }

    @Override
    public void onResponseDataCallback(ResponseData responseData) {
        this.logger.debug("Got response in PackageHandler", new Object[0]);
        IActivityHandler activityHandler = (IActivityHandler)this.activityHandlerWeakRef.get();
        if (activityHandler != null && responseData.trackingState == TrackingState.OPTED_OUT) {
            activityHandler.gotOptOutResponse();
        }
        if (!responseData.willRetry) {
            this.scheduler.submit(new Runnable(){

                @Override
                public void run() {
                    PackageHandler.this.sendNextI();
                }
            });
            if (activityHandler != null) {
                activityHandler.finishedTrackingActivity(responseData);
            }
            return;
        }
        if (activityHandler != null) {
            activityHandler.finishedTrackingActivity(responseData);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PackageHandler.this.logger.verbose("Package handler can send", new Object[0]);
                PackageHandler.this.isSending.set(false);
                PackageHandler.this.sendFirstPackage();
            }
        };
        if (responseData.activityPackage == null) {
            runnable.run();
            return;
        }
        int retries = responseData.activityPackage.increaseRetries();
        SharedPreferencesManager sharedPreferencesManager = SharedPreferencesManager.getDefaultInstance(this.context);
        long waitTimeMilliSeconds = responseData.activityPackage.getActivityKind() == ActivityKind.SESSION && !sharedPreferencesManager.getInstallTracked() ? Util.getWaitingTime(retries, this.backoffStrategyForInstallSession) : Util.getWaitingTime(retries, this.backoffStrategy);
        double waitTimeSeconds = (double)waitTimeMilliSeconds / 1000.0;
        String secondsString = Util.SecondsDisplayFormat.format(waitTimeSeconds);
        this.logger.verbose("Waiting for %s seconds before retrying the %d time", secondsString, retries);
        this.scheduler.schedule(runnable, waitTimeMilliSeconds);
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
    }

    @Override
    public void updatePackages(SessionParameters sessionParameters) {
        final SessionParameters sessionParametersCopy = sessionParameters != null ? sessionParameters.deepCopy() : null;
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                PackageHandler.this.updatePackagesI(sessionParametersCopy);
            }
        });
    }

    @Override
    public void flush() {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                PackageHandler.this.flushI();
            }
        });
    }

    private void initI() {
        this.isSending = new AtomicBoolean();
        this.readPackageQueueI();
    }

    private void addI(ActivityPackage newPackage) {
        this.packageQueue.add(newPackage);
        this.logger.debug("Added package %d (%s)", this.packageQueue.size(), newPackage);
        this.logger.verbose("%s", newPackage.getExtendedString());
        this.writePackageQueueI();
    }

    private void sendFirstI() {
        if (this.packageQueue.isEmpty()) {
            return;
        }
        if (this.paused) {
            this.logger.debug("Package handler is paused", new Object[0]);
            return;
        }
        if (this.isSending.getAndSet(true)) {
            this.logger.verbose("Package handler is already sending", new Object[0]);
            return;
        }
        Map<String, String> sendingParameters = this.generateSendingParametersI();
        ActivityPackage firstPackage = this.packageQueue.get(0);
        this.activityPackageSender.sendActivityPackage(firstPackage, sendingParameters, this);
    }

    private Map<String, String> generateSendingParametersI() {
        HashMap<String, String> sendingParameters = new HashMap<String, String>();
        long now = System.currentTimeMillis();
        String dateString = Util.dateFormatter.format(now);
        PackageBuilder.addString(sendingParameters, "sent_at", dateString);
        int queueSize = this.packageQueue.size() - 1;
        if (queueSize > 0) {
            PackageBuilder.addLong(sendingParameters, "queue_size", queueSize);
        }
        return sendingParameters;
    }

    private void sendNextI() {
        if (this.packageQueue.isEmpty()) {
            return;
        }
        this.packageQueue.remove(0);
        this.writePackageQueueI();
        this.isSending.set(false);
        this.logger.verbose("Package handler can send", new Object[0]);
        this.sendFirstI();
    }

    public void updatePackagesI(SessionParameters sessionParameters) {
        if (sessionParameters == null) {
            return;
        }
        this.logger.debug("Updating package handler queue", new Object[0]);
        this.logger.verbose("Session callback parameters: %s", sessionParameters.callbackParameters);
        this.logger.verbose("Session partner parameters: %s", sessionParameters.partnerParameters);
        for (ActivityPackage activityPackage : this.packageQueue) {
            Map<String, String> parameters = activityPackage.getParameters();
            Map<String, String> mergedCallbackParameters = Util.mergeParameters(sessionParameters.callbackParameters, activityPackage.getCallbackParameters(), "Callback");
            PackageBuilder.addMapJson(parameters, "callback_params", mergedCallbackParameters);
            Map<String, String> mergedPartnerParameters = Util.mergeParameters(sessionParameters.partnerParameters, activityPackage.getPartnerParameters(), "Partner");
            PackageBuilder.addMapJson(parameters, "partner_params", mergedPartnerParameters);
        }
        this.writePackageQueueI();
    }

    private void flushI() {
        this.packageQueue.clear();
        this.writePackageQueueI();
    }

    private void readPackageQueueI() {
        try {
            this.packageQueue = Util.readObject(this.context, PACKAGE_QUEUE_FILENAME, PACKAGE_QUEUE_NAME, List.class);
        }
        catch (Exception e) {
            this.logger.error("Failed to read %s file (%s)", PACKAGE_QUEUE_NAME, e.getMessage());
            this.packageQueue = null;
        }
        if (this.packageQueue != null) {
            this.logger.debug("Package handler read %d packages", this.packageQueue.size());
        } else {
            this.packageQueue = new ArrayList<ActivityPackage>();
        }
    }

    private void writePackageQueueI() {
        Util.writeObject(this.packageQueue, this.context, PACKAGE_QUEUE_FILENAME, PACKAGE_QUEUE_NAME);
        this.logger.debug("Package handler wrote %d packages", this.packageQueue.size());
    }

    public static Boolean deletePackageQueue(Context context) {
        return context.deleteFile(PACKAGE_QUEUE_FILENAME);
    }
}

