/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import io.adtrace.sdk.AdTraceFactory;
import org.json.JSONArray;
import org.json.JSONException;

public class SharedPreferencesManager {
    private static final String PREFS_NAME = "adtrace_preferences";
    private static final String PREFS_KEY_RAW_REFERRERS = "raw_referrers";
    private static final String PREFS_KEY_PUSH_TOKEN = "push_token";
    private static final String PREFS_KEY_INSTALL_TRACKED = "install_tracked";
    private static final String PREFS_KEY_GDPR_FORGET_ME = "gdpr_forget_me";
    private static final String PREFS_KEY_DISABLE_THIRD_PARTY_SHARING = "disable_third_party_sharing";
    private static final String PREFS_KEY_DEEPLINK_URL = "deeplink_url";
    private static final String PREFS_KEY_DEEPLINK_CLICK_TIME = "deeplink_click_time";
    private static final String PREFS_KEY_PREINSTALL_PAYLOAD_READ_STATUS = "preinstall_payload_read_status";
    private static final String PREFS_KEY_PREINSTALL_SYSTEM_INSTALLER_REFERRER = "preinstall_system_installer_referrer";
    private static final String PREF_KEY_IS_SDK_RESET_4_APP_TOKEN_CHANGED = "isSdkReset4AppTokenChange";
    private static final int INDEX_RAW_REFERRER = 0;
    private static final int INDEX_CLICK_TIME = 1;
    private static final int INDEX_IS_SENDING = 2;
    private static final int REFERRERS_COUNT = 10;
    private static SharedPreferences sharedPreferences;
    private static SharedPreferences.Editor sharedPreferencesEditor;
    private static SharedPreferencesManager defaultInstance;

    private SharedPreferencesManager(Context context) {
        try {
            sharedPreferences = context.getSharedPreferences(PREFS_NAME, 0);
            sharedPreferencesEditor = sharedPreferences.edit();
        }
        catch (Exception exception) {
            AdTraceFactory.getLogger().error("Cannot access to SharedPreferences", exception.getMessage());
            sharedPreferences = null;
            sharedPreferencesEditor = null;
        }
    }

    public static synchronized SharedPreferencesManager getDefaultInstance(Context context) {
        if (defaultInstance == null) {
            defaultInstance = new SharedPreferencesManager(context);
        }
        return defaultInstance;
    }

    public synchronized void saveRawReferrer(String rawReferrer, long clickTime) {
        try {
            if (this.getRawReferrer(rawReferrer, clickTime) != null) {
                return;
            }
            JSONArray rawReferrerArray = this.getRawReferrerArray();
            if (rawReferrerArray.length() == 10) {
                return;
            }
            JSONArray newRawReferrer = new JSONArray();
            newRawReferrer.put(0, (Object)rawReferrer);
            newRawReferrer.put(1, clickTime);
            newRawReferrer.put(2, 0);
            rawReferrerArray.put((Object)newRawReferrer);
            this.saveRawReferrerArray(rawReferrerArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public synchronized void saveRawReferrerArray(JSONArray rawReferrerArray) {
        try {
            this.saveString(PREFS_KEY_RAW_REFERRERS, rawReferrerArray.toString());
        }
        catch (Throwable t) {
            this.remove(PREFS_KEY_RAW_REFERRERS);
        }
    }

    public synchronized void removeRawReferrer(String rawReferrer, long clickTime) {
        if (rawReferrer == null || rawReferrer.length() == 0) {
            return;
        }
        int rawReferrerIndex = this.getRawReferrerIndex(rawReferrer, clickTime);
        if (rawReferrerIndex < 0) {
            return;
        }
        JSONArray rawReferrerArray = this.getRawReferrerArray();
        JSONArray updatedReferrers = new JSONArray();
        for (int i = 0; i < rawReferrerArray.length(); ++i) {
            if (i == rawReferrerIndex) continue;
            try {
                updatedReferrers.put((Object)rawReferrerArray.getJSONArray(i));
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        this.saveString(PREFS_KEY_RAW_REFERRERS, updatedReferrers.toString());
    }

    public synchronized JSONArray getRawReferrer(String rawReferrer, long clickTime) {
        int rawReferrerIndex = this.getRawReferrerIndex(rawReferrer, clickTime);
        if (rawReferrerIndex >= 0) {
            try {
                return this.getRawReferrerArray().getJSONArray(rawReferrerIndex);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }

    public synchronized JSONArray getRawReferrerArray() {
        String referrerQueueString = this.getString(PREFS_KEY_RAW_REFERRERS);
        if (referrerQueueString != null) {
            try {
                JSONArray rawReferrerArray = new JSONArray(referrerQueueString);
                if (rawReferrerArray.length() > 10) {
                    JSONArray tempReferrerArray = new JSONArray();
                    for (int i = 0; i < 10; ++i) {
                        tempReferrerArray.put(rawReferrerArray.get(i));
                    }
                    this.saveRawReferrerArray(tempReferrerArray);
                    return tempReferrerArray;
                }
                return new JSONArray(referrerQueueString);
            }
            catch (JSONException jSONException) {
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new JSONArray();
    }

    public synchronized void savePreinstallReferrer(String referrer) {
        this.saveString(PREFS_KEY_PREINSTALL_SYSTEM_INSTALLER_REFERRER, referrer);
    }

    public synchronized String getPreinstallReferrer() {
        return this.getString(PREFS_KEY_PREINSTALL_SYSTEM_INSTALLER_REFERRER);
    }

    public synchronized void removePreinstallReferrer() {
        this.remove(PREFS_KEY_PREINSTALL_SYSTEM_INSTALLER_REFERRER);
    }

    public synchronized void setSendingReferrersAsNotSent() {
        try {
            JSONArray rawReferrerArray = this.getRawReferrerArray();
            boolean hasRawReferrersBeenChanged = false;
            for (int i = 0; i < rawReferrerArray.length(); ++i) {
                JSONArray rawReferrer = rawReferrerArray.getJSONArray(i);
                int sendingStatus = rawReferrer.optInt(2, -1);
                if (sendingStatus != 1) continue;
                rawReferrer.put(2, 0);
                hasRawReferrersBeenChanged = true;
            }
            if (hasRawReferrersBeenChanged) {
                this.saveRawReferrerArray(rawReferrerArray);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private synchronized int getRawReferrerIndex(String rawReferrer, long clickTime) {
        try {
            JSONArray rawReferrers = this.getRawReferrerArray();
            for (int i = 0; i < rawReferrers.length(); ++i) {
                long savedClickTime;
                JSONArray savedRawReferrer = rawReferrers.getJSONArray(i);
                String savedRawReferrerString = savedRawReferrer.optString(0, null);
                if (savedRawReferrerString == null || !savedRawReferrerString.equals(rawReferrer) || (savedClickTime = savedRawReferrer.optLong(1, -1L)) != clickTime) continue;
                return i;
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return -1;
    }

    public synchronized void savePushToken(String pushToken) {
        this.saveString(PREFS_KEY_PUSH_TOKEN, pushToken);
    }

    public synchronized String getPushToken() {
        return this.getString(PREFS_KEY_PUSH_TOKEN);
    }

    public synchronized void removePushToken() {
        this.remove(PREFS_KEY_PUSH_TOKEN);
    }

    public synchronized void setInstallTracked() {
        this.saveBoolean(PREFS_KEY_INSTALL_TRACKED, true);
    }

    public synchronized boolean getInstallTracked() {
        return this.getBoolean(PREFS_KEY_INSTALL_TRACKED, false);
    }

    public synchronized void setGdprForgetMe() {
        this.saveBoolean(PREFS_KEY_GDPR_FORGET_ME, true);
    }

    public synchronized boolean getGdprForgetMe() {
        return this.getBoolean(PREFS_KEY_GDPR_FORGET_ME, false);
    }

    public synchronized void removeGdprForgetMe() {
        this.remove(PREFS_KEY_GDPR_FORGET_ME);
    }

    public synchronized void setDisableThirdPartySharing() {
        this.saveBoolean(PREFS_KEY_DISABLE_THIRD_PARTY_SHARING, true);
    }

    public synchronized boolean getDisableThirdPartySharing() {
        return this.getBoolean(PREFS_KEY_DISABLE_THIRD_PARTY_SHARING, false);
    }

    public synchronized void removeDisableThirdPartySharing() {
        this.remove(PREFS_KEY_DISABLE_THIRD_PARTY_SHARING);
    }

    public synchronized void saveDeeplink(Uri deeplink, long clickTime) {
        if (deeplink == null) {
            return;
        }
        this.saveString(PREFS_KEY_DEEPLINK_URL, deeplink.toString());
        this.saveLong(PREFS_KEY_DEEPLINK_CLICK_TIME, clickTime);
    }

    public synchronized String getDeeplinkUrl() {
        return this.getString(PREFS_KEY_DEEPLINK_URL);
    }

    public synchronized long getDeeplinkClickTime() {
        return this.getLong(PREFS_KEY_DEEPLINK_CLICK_TIME, -1L);
    }

    public synchronized void removeDeeplink() {
        this.remove(PREFS_KEY_DEEPLINK_URL);
        this.remove(PREFS_KEY_DEEPLINK_CLICK_TIME);
    }

    public synchronized void setPreinstallPayloadReadStatus(long status) {
        this.saveLong(PREFS_KEY_PREINSTALL_PAYLOAD_READ_STATUS, status);
    }

    public synchronized long getPreinstallPayloadReadStatus() {
        return this.getLong(PREFS_KEY_PREINSTALL_PAYLOAD_READ_STATUS, 0L);
    }

    public synchronized void setSdkReset4AppTokenChange(boolean isSdkReset4AppTokenChange) {
        this.saveBoolean(PREF_KEY_IS_SDK_RESET_4_APP_TOKEN_CHANGED, isSdkReset4AppTokenChange);
    }

    public synchronized boolean getSdkReset4AppTokenChange() {
        return this.getBoolean(PREF_KEY_IS_SDK_RESET_4_APP_TOKEN_CHANGED, false);
    }

    public synchronized void clear() {
        if (sharedPreferencesEditor != null) {
            sharedPreferencesEditor.clear().apply();
        }
    }

    private synchronized void saveString(String key, String value) {
        if (sharedPreferencesEditor != null) {
            sharedPreferencesEditor.putString(key, value).apply();
        }
    }

    private synchronized void saveBoolean(String key, boolean value) {
        if (sharedPreferencesEditor != null) {
            sharedPreferencesEditor.putBoolean(key, value).apply();
        }
    }

    private synchronized void saveLong(String key, long value) {
        if (sharedPreferencesEditor != null) {
            sharedPreferencesEditor.putLong(key, value).apply();
        }
    }

    private synchronized void saveInteger(String key, int value) {
        if (sharedPreferencesEditor != null) {
            sharedPreferencesEditor.putInt(key, value).apply();
        }
    }

    private synchronized String getString(String key) {
        if (sharedPreferences != null) {
            try {
                return sharedPreferences.getString(key, null);
            }
            catch (ClassCastException e) {
                return null;
            }
            catch (Throwable t) {
                if (key.equals(PREFS_KEY_RAW_REFERRERS)) {
                    this.remove(PREFS_KEY_RAW_REFERRERS);
                }
                return null;
            }
        }
        return null;
    }

    private synchronized boolean getBoolean(String key, boolean defaultValue) {
        if (sharedPreferences != null) {
            try {
                return sharedPreferences.getBoolean(key, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private synchronized long getLong(String key, long defaultValue) {
        if (sharedPreferences != null) {
            try {
                return sharedPreferences.getLong(key, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private synchronized void remove(String key) {
        if (sharedPreferencesEditor != null) {
            sharedPreferencesEditor.remove(key).apply();
        }
    }
}

