/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk.network;

import io.adtrace.sdk.ActivityKind;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class UrlStrategy {
    private static final String BASE_URL_IR = "https://app.adtrace.ir";
    private static final String GDPR_URL_IR = "https://gdpr.adtrace.ir";
    private static final String SUBSCRIPTION_URL_IR = "https://subscription.adtrace.ir";
    private static final String PURCHASE_VERIFICATION_URL_IR = "https://ssrv.adtrace.ir";
    private static final String BASE_URL_MOBI = "https://app.adtrace.mobi";
    private static final String GDPR_URL_MOBI = "https://gdpr.adtrace.mobi";
    private static final String SUBSCRIPTION_URL_MOBI = "https://subscription.adtrace.mobi";
    private static final String PURCHASE_VERIFICATION_URL_MOBI = "https://ssrv.adtrace.mobi";
    private final String baseUrlOverwrite;
    private final String gdprUrlOverwrite;
    private final String subscriptionUrlOverwrite;
    private final String purchaseVerificationUrlOverwrite;
    final List<String> baseUrlChoicesList;
    final List<String> gdprUrlChoicesList;
    final List<String> subscriptionUrlChoicesList;
    final List<String> purchaseVerificationUrlChoicesList;
    boolean wasLastAttemptSuccess;
    int choiceIndex;
    int startingChoiceIndex;
    boolean wasLastAttemptWithOverwrittenUrl;

    public UrlStrategy(String baseUrlOverwrite, String gdprUrlOverwrite, String subscriptionUrlOverwrite, String purchaseVerificationUrlOverwrite, String adtraceUrlStrategy) {
        this.baseUrlOverwrite = baseUrlOverwrite;
        this.gdprUrlOverwrite = gdprUrlOverwrite;
        this.subscriptionUrlOverwrite = subscriptionUrlOverwrite;
        this.purchaseVerificationUrlOverwrite = purchaseVerificationUrlOverwrite;
        this.baseUrlChoicesList = UrlStrategy.baseUrlChoices(adtraceUrlStrategy);
        this.gdprUrlChoicesList = UrlStrategy.gdprUrlChoices(adtraceUrlStrategy);
        this.subscriptionUrlChoicesList = UrlStrategy.subscriptionUrlChoices(adtraceUrlStrategy);
        this.purchaseVerificationUrlChoicesList = UrlStrategy.purchaseVerificationUrlChoices(adtraceUrlStrategy);
        this.wasLastAttemptSuccess = false;
        this.choiceIndex = 0;
        this.startingChoiceIndex = 0;
        this.wasLastAttemptWithOverwrittenUrl = false;
    }

    public void resetAfterSuccess() {
        this.startingChoiceIndex = this.choiceIndex;
        this.wasLastAttemptSuccess = true;
    }

    public boolean shouldRetryAfterFailure(ActivityKind activityKind) {
        int nextChoiceIndex;
        this.wasLastAttemptSuccess = false;
        if (this.wasLastAttemptWithOverwrittenUrl) {
            return false;
        }
        int choiceListSize = activityKind == ActivityKind.GDPR ? this.gdprUrlChoicesList.size() : (activityKind == ActivityKind.SUBSCRIPTION ? this.subscriptionUrlChoicesList.size() : (activityKind == ActivityKind.PURCHASE_VERIFICATION ? this.purchaseVerificationUrlChoicesList.size() : this.baseUrlChoicesList.size()));
        this.choiceIndex = nextChoiceIndex = (this.choiceIndex + 1) % choiceListSize;
        boolean nextChoiceHasNotReturnedToStartingChoice = this.choiceIndex != this.startingChoiceIndex;
        return nextChoiceHasNotReturnedToStartingChoice;
    }

    public String targetUrlByActivityKind(ActivityKind activityKind) {
        if (activityKind == ActivityKind.GDPR) {
            if (this.gdprUrlOverwrite != null) {
                this.wasLastAttemptWithOverwrittenUrl = true;
                return this.gdprUrlOverwrite;
            }
            this.wasLastAttemptWithOverwrittenUrl = false;
            return this.gdprUrlChoicesList.get(this.choiceIndex);
        }
        if (activityKind == ActivityKind.SUBSCRIPTION) {
            if (this.subscriptionUrlOverwrite != null) {
                this.wasLastAttemptWithOverwrittenUrl = true;
                return this.subscriptionUrlOverwrite;
            }
            this.wasLastAttemptWithOverwrittenUrl = false;
            return this.subscriptionUrlChoicesList.get(this.choiceIndex);
        }
        if (activityKind == ActivityKind.PURCHASE_VERIFICATION) {
            if (this.purchaseVerificationUrlOverwrite != null) {
                this.wasLastAttemptWithOverwrittenUrl = true;
                return this.purchaseVerificationUrlOverwrite;
            }
            this.wasLastAttemptWithOverwrittenUrl = false;
            return this.purchaseVerificationUrlChoicesList.get(this.choiceIndex);
        }
        if (this.baseUrlOverwrite != null) {
            this.wasLastAttemptWithOverwrittenUrl = true;
            return this.baseUrlOverwrite;
        }
        this.wasLastAttemptWithOverwrittenUrl = false;
        return this.baseUrlChoicesList.get(this.choiceIndex);
    }

    private static List<String> baseUrlChoices(String urlStrategy) {
        if ("url_strategy_ir".equals(urlStrategy)) {
            return Arrays.asList(BASE_URL_IR, "https://app.adtrace.io");
        }
        if ("url_strategy_mobi".equals(urlStrategy)) {
            return Arrays.asList(BASE_URL_MOBI, "https://app.adtrace.io");
        }
        if ("data_residency_ir".equals(urlStrategy)) {
            return Collections.singletonList("https://app.adtrace.io");
        }
        return Arrays.asList("https://app.adtrace.io", BASE_URL_IR, BASE_URL_MOBI);
    }

    private static List<String> gdprUrlChoices(String urlStrategy) {
        if ("url_strategy_ir".equals(urlStrategy)) {
            return Arrays.asList(GDPR_URL_IR, "https://gdpr.adtrace.io");
        }
        if ("url_strategy_mobi".equals(urlStrategy)) {
            return Arrays.asList(GDPR_URL_MOBI, "https://gdpr.adtrace.io");
        }
        if ("data_residency_ir".equals(urlStrategy)) {
            return Collections.singletonList("https://gdpr.adtrace.io");
        }
        return Arrays.asList("https://gdpr.adtrace.io", GDPR_URL_IR, GDPR_URL_MOBI);
    }

    private static List<String> subscriptionUrlChoices(String urlStrategy) {
        if ("url_strategy_ir".equals(urlStrategy)) {
            return Arrays.asList(SUBSCRIPTION_URL_IR, "https://subscription.adtrace.io");
        }
        if ("url_strategy_mobi".equals(urlStrategy)) {
            return Arrays.asList(SUBSCRIPTION_URL_MOBI, "https://subscription.adtrace.io");
        }
        if ("data_residency_ir".equals(urlStrategy)) {
            return Collections.singletonList("https://subscription.adtrace.io");
        }
        return Arrays.asList("https://subscription.adtrace.io", SUBSCRIPTION_URL_IR, SUBSCRIPTION_URL_MOBI);
    }

    private static List<String> purchaseVerificationUrlChoices(String urlStrategy) {
        if ("url_strategy_ir".equals(urlStrategy)) {
            return Arrays.asList(PURCHASE_VERIFICATION_URL_IR, "https://ssrv.adtrace.io");
        }
        if ("url_strategy_mobi".equals(urlStrategy)) {
            return Arrays.asList(PURCHASE_VERIFICATION_URL_MOBI, "https://ssrv.adtrace.io");
        }
        if ("data_residency_ir".equals(urlStrategy)) {
            return Collections.singletonList("https://ssrv.adtrace.io");
        }
        return Arrays.asList("https://ssrv.adtrace.io", PURCHASE_VERIFICATION_URL_IR, PURCHASE_VERIFICATION_URL_MOBI);
    }
}

